/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleOrderService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_AUTO_DISPATCH")
public class OrderAutoDispatchProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderAutoDispatchProcessor.class);
    @Resource
    private OrderCenterSaleOrderService orderCenterSaleOrderService;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("\u5185\u90e8\u8ba2\u5355\u81ea\u52a8\u914d\u8d27\u903b\u8f91{}", (Object)JSON.toJSONString((Object)message.getData()));
        this.autoDispatch((Long)message.getData());
        return MessageResponse.SUCCESS;
    }

    private void autoDispatch(Long orderId) {
        try {
            this.orderCenterSaleOrderService.autoDisPatch(orderId);
        }
        catch (Exception e) {
            LOGGER.error("[\u5185\u90e8\u8ba2\u5355\u81ea\u52a8\u914d\u8d27]\u5f02\u5e38", (Throwable)e);
        }
    }
}

