/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.service.helper.WmsAble;
import com.dtyunxi.cube.center.track.api.dto.request.PcpSystemApiLogReqDto;
import com.dtyunxi.cube.center.track.api.query.IPcpOpenapiLogQueryApi;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.tcbj.center.openapi.common.wms.response.WmsBaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseTaskApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseTaskItemApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseTaskItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleaseTaskItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.OutNoticeOrderDetailRespVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INSPECTION_RELEASE_BUSINESS_TOPIC", tag="DO_INSPECTION_RELEASE_TASK_ITEM")
public class InspectionReleaseDoTaskItemProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(InspectionReleaseDoTaskItemProcess.class);
    @Value(value="${pms.transit.enableWms:false}")
    boolean enableWms;
    @Autowired
    ILockService lockService;
    @Autowired
    IInspectionReleaseTaskApi inspectionReleaseTaskApi;
    @Autowired
    IInspectionReleaseTaskItemApi iInspectionReleaseTaskItemApi;
    @Autowired
    ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Autowired
    ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Autowired
    WmsAble wmsAble;
    @Autowired
    IPcpOpenapiLogQueryApi pcpOpenapiLogQueryApi;
    @Autowired
    ICacheService cacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageResponse process(MessageVo message) {
        log.info("InspectionReleaseDoTaskItemProcess\uff1a{}", (Object)JSON.toJSONString((Object)message));
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        Mutex lock = null;
        try {
            InspectionReleaseTaskItemRespDto respDto = (InspectionReleaseTaskItemRespDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)message.getData()), InspectionReleaseTaskItemRespDto.class);
            log.info("InspectionReleaseDoTaskItemProcess respDto: {}", (Object)LogUtils.buildLogContent((Object)respDto));
            lock = "intransit_inspection".equals(respDto.getTaskType()) && StringUtils.isNotBlank((CharSequence)respDto.getNoticeNo()) ? this.lockService.lock("mq_do_inspection_release_task_item", respDto.getNoticeNo(), 60, 65, TimeUnit.SECONDS) : this.lockService.lock("mq_do_inspection_release_task_item", respDto.getInspectionReleaseNo(), 60, 65, TimeUnit.SECONDS);
            if ("cancel_wms_notice".equals(respDto.getStep())) {
                MessageResponse messageResponse = this.doCancelWms(respDto);
                this.lockService.unlock(lock);
                return messageResponse;
            }
            this.inspectionReleaseTaskApi.doTaskItem(respDto.getTaskItemNo(), (List)Lists.newArrayList());
            this.lockService.unlock(lock);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.info("\u6267\u884c\u653e\u884c\u4efb\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
            return MessageResponse.SUCCESS;
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    private void doItemError(InspectionReleaseTaskItemRespDto respDto, String errorMsg) {
        InspectionReleaseTaskItemReqDto inspectionReleaseTaskItemReqDto = new InspectionReleaseTaskItemReqDto();
        inspectionReleaseTaskItemReqDto.setId(respDto.getId());
        inspectionReleaseTaskItemReqDto.setStatus("error");
        inspectionReleaseTaskItemReqDto.setRemark(errorMsg);
        this.iInspectionReleaseTaskItemApi.modifyInspectionReleaseTaskItem(inspectionReleaseTaskItemReqDto);
    }

    private void modifyNoticeNo(InspectionReleaseTaskItemRespDto respDto, String noticeNo) {
        log.info("modifyNoticeNo: {}", (Object)noticeNo);
        InspectionReleaseTaskItemReqDto inspectionReleaseTaskItemReqDto = new InspectionReleaseTaskItemReqDto();
        inspectionReleaseTaskItemReqDto.setId(respDto.getId());
        inspectionReleaseTaskItemReqDto.setNoticeNo(noticeNo);
        this.iInspectionReleaseTaskItemApi.modifyInspectionReleaseTaskItem(inspectionReleaseTaskItemReqDto);
    }

    private MessageResponse doCancelWms(InspectionReleaseTaskItemRespDto respDto) {
        try {
            List inNoticeOrderRespDtoList;
            List noticeOrderRespDtoList;
            String noticeNo = respDto.getNoticeNo();
            CsOutNoticeOrderRespDto csOutNoticeOrderRespDto = null;
            if (StringUtils.isNotBlank((CharSequence)noticeNo)) {
                csOutNoticeOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(noticeNo));
            } else if (StringUtils.isNotBlank((CharSequence)respDto.getIntransitTransferNo()) && StringUtils.equals((CharSequence)respDto.getTaskType(), (CharSequence)"intransit_inspection") && CollectionUtils.isNotEmpty((Collection)(noticeOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByRelevanceNoList((List)Lists.newArrayList((Object[])new String[]{respDto.getIntransitTransferNo()}))))) && (inNoticeOrderRespDtoList = noticeOrderRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getOrderType(), (CharSequence)"in")).collect(Collectors.toList())).size() == 1) {
                csOutNoticeOrderRespDto = (CsOutNoticeOrderRespDto)inNoticeOrderRespDtoList.get(0);
                if (BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(csOutNoticeOrderRespDto.getOrderStatus())) {
                    log.info("\u539f\u4efb\u52a1\u5931\u8d25 \u751f\u6210\u5f85\u68c0\u65b0\u7684\u5f85\u68c0\u653e\u884c\u4efb\u52a1 BaseOrderStatusEnum.INO_TOTAL_IN: {}", (Object)respDto.getTaskItemNo());
                    this.inspectionReleaseTaskApi.changeIntransitTaskItem(respDto.getTaskItemNo());
                    return MessageResponse.SUCCESS;
                }
            }
            if (null == csOutNoticeOrderRespDto) {
                this.doItemError(respDto, "\u901a\u77e5\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
                return MessageResponse.SUCCESS;
            }
            if (BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(csOutNoticeOrderRespDto.getOrderStatus())) {
                log.info("\u539f\u4efb\u52a1\u5931\u8d25 \u751f\u6210\u5f85\u68c0\u65b0\u7684\u5f85\u68c0\u653e\u884c\u4efb\u52a1 BaseOrderStatusEnum.INO_TOTAL_IN: {}", (Object)respDto.getTaskItemNo());
                this.inspectionReleaseTaskApi.changeIntransitTaskItem(respDto.getTaskItemNo());
                return MessageResponse.SUCCESS;
            }
            List respVoList = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryTransferInNoticeDetails(respDto.getSkuCode(), respDto.getBatch()));
            log.info("respVoList: {}", (Object)LogUtils.buildLogContent((Collection)respVoList));
            if (CollectionUtils.isEmpty((Collection)respVoList)) {
                return this.checkTaskItemNotice(respDto, csOutNoticeOrderRespDto);
            }
            List transferDetailVoList = respVoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getRelevanceNo(), (CharSequence)respDto.getPreOrderNo())).collect(Collectors.toList());
            log.info("transferDetailVoList: {}", (Object)LogUtils.buildLogContent(transferDetailVoList));
            if (CollectionUtils.isEmpty(transferDetailVoList)) {
                return this.checkTaskItemNotice(respDto, csOutNoticeOrderRespDto);
            }
            OutNoticeOrderDetailRespVo detailRespVo = (OutNoticeOrderDetailRespVo)transferDetailVoList.get(0);
            log.info("detailRespVo: {}", (Object)LogUtils.buildLogContent((Object)detailRespVo));
            if (!StringUtils.equals((CharSequence)detailRespVo.getDocumentNo(), (CharSequence)noticeNo)) {
                this.modifyNoticeNo(respDto, detailRespVo.getDocumentNo());
                log.info("modifyNoticeNo: {} successful", (Object)detailRespVo.getDocumentNo());
                return MessageResponse.SUCCESS;
            }
            if (this.hasCancelWms(noticeNo)) {
                log.info("\u5df2\u5b58\u5728\u901a\u77e5\u5355\u53d6\u6d88\u8bb0\u5f55 : {}", (Object)LogUtils.buildLogContent((Object)respDto));
                return MessageResponse.SUCCESS;
            }
            CsOutNoticeOrderQueryDto noticeOrderQueryDto = new CsOutNoticeOrderQueryDto();
            noticeOrderQueryDto.setDocumentNo(detailRespVo.getDocumentNo());
            noticeOrderQueryDto.setPageNum(Integer.valueOf(1));
            noticeOrderQueryDto.setPageSize(Integer.valueOf(200));
            PageInfo orderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryDetailByPage(noticeOrderQueryDto));
            ArrayList orderDetailVoList = Lists.newArrayList();
            for (CsOutNoticeOrderDetailRespDto csOutNoticeOrderDetailRespDto : orderDetailRespDtoPageInfo.getList()) {
                OutNoticeOrderDetailRespVo respVo = new OutNoticeOrderDetailRespVo();
                BeanUtils.copyProperties((Object)csOutNoticeOrderDetailRespDto, (Object)respVo);
                respVo.setReceiveWarehouseCode(detailRespVo.getReceiveWarehouseCode());
                respVo.setReceiveWarehouseName(detailRespVo.getReceiveWarehouseName());
                respVo.setBusinessType(detailRespVo.getBusinessType());
                orderDetailVoList.add(respVo);
            }
            if (this.hasPushWms(detailRespVo.getDocumentNo()) && !this.hasCancelWms(detailRespVo.getDocumentNo())) {
                WmsBaseRespDto wmsBaseRespDto = this.cancelWmsOrder(detailRespVo);
                log.info("doCancelWms cancelWmsResult: {}", (Object)LogUtils.buildLogContent((Object)wmsBaseRespDto));
                if (wmsBaseRespDto.isSuccess()) {
                    this.cacheService.setCache("cancel_notice_no_" + detailRespVo.getDocumentNo(), (Object)true, 3600);
                }
                for (OutNoticeOrderDetailRespVo outNoticeOrderDetailRespVo : orderDetailVoList) {
                    outNoticeOrderDetailRespVo.setCancelResult(Boolean.valueOf(wmsBaseRespDto.isSuccess()));
                    outNoticeOrderDetailRespVo.setRemark(wmsBaseRespDto.getContent());
                }
                log.info("doCancelWms doTaskItem: {}", (Object)JSON.toJSONString((Object)orderDetailVoList));
                this.inspectionReleaseTaskApi.doTaskItem(respDto.getTaskItemNo(), (List)orderDetailVoList);
            }
        }
        catch (Exception e) {
            log.error("\u5728\u9014\u653e\u884c\u5b50\u4efb\u52a1\uff0c\u53d6\u6d88WMS\u5165\u5e93\u901a\u77e5\u5355\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return MessageResponse.SUCCESS;
    }

    public WmsBaseRespDto cancelWmsOrder(OutNoticeOrderDetailRespVo outNoticeOrderDetailRespVo) {
        if (!this.enableWms) {
            WmsBaseRespDto wmsBaseRespDto = new WmsBaseRespDto();
            wmsBaseRespDto.setSuccess(true);
            return wmsBaseRespDto;
        }
        WmsBaseRespDto wmsBaseRespDto = null;
        try {
            wmsBaseRespDto = this.wmsAble.cancelWmsOrderResp(outNoticeOrderDetailRespVo);
        }
        catch (Exception e) {
            log.error("WMS\u53d6\u6d88\u5f02\u5e38: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (null == wmsBaseRespDto) {
            wmsBaseRespDto = new WmsBaseRespDto();
            wmsBaseRespDto.setSuccess(false);
            wmsBaseRespDto.setContent("WMS \u53d6\u6d88\u8c03\u7528\u5931\u8d25");
        }
        return wmsBaseRespDto;
    }

    public MessageResponse checkTaskItemNotice(InspectionReleaseTaskItemRespDto respDto, CsOutNoticeOrderRespDto csOutNoticeOrderRespDto) {
        log.info("InspectionReleaseDoTaskItemProcess checkTaskItemNotice: {}", (Object)LogUtils.buildLogContent((Object)csOutNoticeOrderRespDto));
        if (BaseOrderStatusEnum.INO_CANCEL.getCode().equals(csOutNoticeOrderRespDto.getOrderStatus())) {
            this.doItemError(respDto, "\u901a\u77e5\u5355\u5df2\u53d6\u6d88");
            return MessageResponse.SUCCESS;
        }
        if (!BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(csOutNoticeOrderRespDto.getOrderStatus())) {
            this.doItemError(respDto, "\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u6b63\u786e");
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }

    private boolean hasPushWms(String documentNo) {
        PcpSystemApiLogReqDto logReqDto = new PcpSystemApiLogReqDto();
        logReqDto.setApiCode("WMS004");
        logReqDto.setApiBizNo(documentNo);
        logReqDto.setApiStatus(Integer.valueOf(1));
        try {
            PageInfo pcpSystemApiLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOpenapiLogQueryApi.queryPcpSystemApiLogPage(JSON.toJSONString((Object)logReqDto), Integer.valueOf(1), Integer.valueOf(10)));
            log.info("hasPushWms \u67e5\u8be2\u901a\u77e5\u5355\u63a8\u9001\u65e5\u5fd7: {}", (Object)LogUtils.buildLogContent((Object)pcpSystemApiLogRespDtoPageInfo));
            return CollectionUtils.isNotEmpty((Collection)pcpSystemApiLogRespDtoPageInfo.getList());
        }
        catch (Exception e) {
            log.error("hasPushWms \u67e5\u8be2\u901a\u77e5\u5355\u63a8\u9001\u65e5\u5fd7\u5931\u8d25: {}", (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean hasCancelWms(String documentNo) {
        Boolean cancelFlag = (Boolean)this.cacheService.getCache("cancel_notice_no_" + documentNo, Boolean.class);
        if (null != cancelFlag) {
            return true;
        }
        PcpSystemApiLogReqDto logReqDto = new PcpSystemApiLogReqDto();
        logReqDto.setApiCode("WMS006");
        logReqDto.setApiBizNo(documentNo);
        logReqDto.setApiStatus(Integer.valueOf(1));
        try {
            PageInfo pcpSystemApiLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOpenapiLogQueryApi.queryPcpSystemApiLogPage(JSON.toJSONString((Object)logReqDto), Integer.valueOf(1), Integer.valueOf(10)));
            log.info("hasCancelWms \u67e5\u8be2\u901a\u77e5\u5355\u63a8\u9001\u65e5\u5fd7: {}", (Object)LogUtils.buildLogContent((Object)pcpSystemApiLogRespDtoPageInfo));
            return CollectionUtils.isNotEmpty((Collection)pcpSystemApiLogRespDtoPageInfo.getList());
        }
        catch (Exception e) {
            log.error("hasCancelWms \u67e5\u8be2\u901a\u77e5\u5355\u63a8\u9001\u65e5\u5fd7\u5931\u8d25: {}", (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

