/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms.ICsWmsApi;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="SYNC_STOCK_IN_INFO")
public class SyncStockInInfoProcessor
implements IMessageProcessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(SyncStockInInfoProcessor.class);
    @Autowired
    ExternalService externalService;
    @Autowired
    ICsWmsApi wmsApi;
    @Autowired
    ICacheService cacheService;
    public static final String IN_SEND_BACK_RETRY_CACHE_KEY = "in_send_back_retry";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(Map<String, Object> message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u63a5\u6536WMS\u5165\u5e93\u4fe1\u606f\u56de\u4f20\u540c\u6b65\uff1a{}", (Object)JSON.toJSONString(message));
        String resultCode = "0";
        String resultMsg = "success";
        try {
            RestResponse response = this.externalService.inSendBack(message);
            resultCode = response.getResultCode();
            resultMsg = response.getResultMsg();
        }
        catch (Exception e) {
            log.error("WMS\u5165\u5e93\u4fe1\u606f\u56de\u4f20\u540c\u6b65\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            resultCode = "100000";
            resultMsg = e.getMessage();
        }
        finally {
            String sendLogId = this.externalService.getSendLogId(message);
            if ("0952777".equals(resultCode)) {
                log.info("wms\u5165\u5e93\u56de\u4f20 \u4e50\u89c2\u9501\u5f02\u5e38\uff0c\u51c6\u5907\u5b58\u5165Redis");
                HashMap map = Maps.newHashMap();
                map.put(sendLogId, JSON.toJSONString(message));
                this.cacheService.hmset(IN_SEND_BACK_RETRY_CACHE_KEY, (Map)map);
            }
            this.externalService.backMsg(sendLogId, resultCode, resultMsg);
        }
        return MessageResponse.SUCCESS;
    }
}

