/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionDataReqDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInspectionDataRespDto;
import com.dtyunxi.tcbj.api.query.IQualityInspectionDataQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseOrderReqDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INSPECTION_RELEASE_BUSINESS_TOPIC", tag="RECEIVE_INSPECTION")
public class ReceiveInspectionProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(ReceiveInspectionProcess.class);
    @Autowired
    IInspectionReleaseOrderApi inspectionReleaseOrderApi;
    @Autowired
    IQualityInspectionDataQueryApi qualityInspectionDataQueryApi;

    public MessageResponse process(MessageVo message) {
        log.info("ReceiveInspectionProcess\uff1a{}", (Object)JSON.toJSONString((Object)message));
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        try {
            List reqDtoList = JSONArray.parseArray((String)String.valueOf(message.getData()), InspectionReleaseOrderReqDto.class);
            ArrayList queryDtoList = Lists.newArrayList();
            for (InspectionReleaseOrderReqDto reqDto : reqDtoList) {
                QualityInspectionDataReqDto queryDto = new QualityInspectionDataReqDto();
                queryDto.setLongCode(reqDto.getSkuCode());
                queryDto.setBatch(reqDto.getBatch());
                queryDtoList.add(queryDto);
            }
            List qualityInspectionDataRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.qualityInspectionDataQueryApi.queryByList((List)queryDtoList));
            ArrayList inspectionReleaseOrderReqDtoList = Lists.newArrayList();
            for (QualityInspectionDataRespDto qualityInspectionDataRespDto : qualityInspectionDataRespDtoList) {
                InspectionReleaseOrderReqDto inspectionReleaseOrderReqDto = new InspectionReleaseOrderReqDto();
                inspectionReleaseOrderReqDto.setSkuCode(qualityInspectionDataRespDto.getLongCode());
                inspectionReleaseOrderReqDto.setBatch(qualityInspectionDataRespDto.getBatch());
                inspectionReleaseOrderReqDto.setReportResult(qualityInspectionDataRespDto.getReportResult());
                inspectionReleaseOrderReqDto.setQualityInspectionNo(qualityInspectionDataRespDto.getExternalId());
                inspectionReleaseOrderReqDto.setQualityInspectionDate((Date)DateUtil.parse((CharSequence)qualityInspectionDataRespDto.getReportTime()));
                inspectionReleaseOrderReqDtoList.add(inspectionReleaseOrderReqDto);
            }
            RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderApi.receiveInspectionReport((List)inspectionReleaseOrderReqDtoList));
        }
        catch (Exception e) {
            log.info("ReceiveInspectionProcess\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
        return MessageResponse.SUCCESS;
    }
}

