/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.DistributionItemService;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseTaskApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="PUBLIC_SEND_RESULT_DETAIL")
public class ReceiveDeliveryResultProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(ReceiveDeliveryResultProcessor.class);
    @Resource
    private ExternalPointService externalPointService;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private DistributionItemService distributionItemService;
    @Autowired
    private IInspectionReleaseTaskApi inspectionReleaseTaskApi;

    public boolean isDuplicationMessage(String msgId, MessageVo message) {
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    public MessageResponse process(MessageVo messageVo) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u76d1\u542c\u6536\u53d1\u7ed3\u679c\u751f\u6210\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        CsDeliveryReceiveResultRespDto dto = (CsDeliveryReceiveResultRespDto)JSON.parseObject((String)messageVo.getData().toString(), CsDeliveryReceiveResultRespDto.class);
        BizSaleOrderRespDto saleOrder = null;
        if (StringUtils.isNotBlank((CharSequence)dto.getRelevanceTableName()) && dto.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode())) {
            logger.info("\u539f\u5355\u636e\u4e3a\u9500\u552e\u5355\uff0c\u67e5\u8be2\u5355\u636e\u4fe1\u606f");
            saleOrder = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(dto.getRelevanceNo()));
        }
        try {
            this.externalPointService.receiveDeliveryResultToEasPoint(dto);
        }
        catch (Exception e) {
            logger.error("\u901a\u77e5EAS\uff08\u5e93\u5b58\u5355\uff09\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.saleOrderReceiveDeliveryResultToEasOtherPoint(dto, saleOrder);
        }
        catch (Exception e) {
            logger.error("\u901a\u77e5EAS\uff08\u9500\u552e\u5355\uff09\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.transferOrderReceiveDeliveryResultToFinanceZT(dto);
        }
        catch (Exception e) {
            logger.error("\u901a\u77e5\u8d22\u52a1\u4e2d\u53f0\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.transferOrderReceiveDeliveryResultToBSE3(dto);
        }
        catch (Exception e) {
            logger.error("\u901a\u77e5\u767e\u80dcE3\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.receiveDeliveryResultToYYJPoint(dto);
        }
        catch (Exception e) {
            logger.error("\u901a\u77e5\u8425\u517b\u5bb6\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.receiveDeliveryResultToCspPoint(saleOrder, dto);
        }
        catch (Exception e) {
            logger.error("\u901a\u77e5CSP\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.distributionItemService.distributionItemForDeliveryReceiveResult(dto);
        }
        catch (Exception e) {
            logger.error("\u5206\u8d27\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            RestResponseHelper.extractData((RestResponse)this.inspectionReleaseTaskApi.outStockCall(dto));
        }
        catch (Exception e) {
            logger.error("\u653e\u884c\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.saleOrderResultApportion(dto);
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u5355\u660e\u7ec6\u5206\u644a\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.transferOrderReceiveDeliveryResultToFinanceZTBA(dto);
        }
        catch (Exception e) {
            logger.error("\u5185\u90e8\u4ea4\u6613\u5355(\u4f70\u50b2)\u63a8\u9001\u8d22\u52a1\u4e2d\u53f0\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

