/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ConsignmentOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.CsLogisticsInfoRespDto;
import com.dtyunxi.tcbj.api.query.IConsignmentOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IConsignmentOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ConsignmentSignDto;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@MQDesc(topic="${dtyunxi.cube.mq.topic.registryvo.publishTopic:PUBLISH_TOPIC}", tag="LOGISTICS_SIGN_EVENT")
public class TmsReceiptProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(TmsReceiptProcessor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(TmsReceiptProcessor.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Autowired
    IOutResultOrderQueryApi outResultOrderQueryApi;
    @Autowired
    IConsignmentOrderApi consignmentOrderApi;
    @Autowired
    IConsignmentOrderQueryApi consignmentOrderQueryApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("\u63a5\u6536\u7269\u6d41\u7b7e\u6536\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        if (Objects.isNull(message)) {
            LOGGER.info("\u63a5\u6536\u7269\u6d41\u7b7e\u6536\u6d88\u606f\u4fe1\u606f\u4f53\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        try {
            CsLogisticsInfoRespDto logisticsInfoRespDto = (CsLogisticsInfoRespDto)JSON.parseObject((String)messageData.toString(), CsLogisticsInfoRespDto.class);
            this.signConsignment(logisticsInfoRespDto);
            this.signSaleOrder(logisticsInfoRespDto);
        }
        catch (Exception e) {
            LOGGER.info("\u7269\u6d41\u7b7e\u6536\u6d88\u606f\u4fe1\u606f\u5904\u7406\u5f02\u5e38:{}", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }

    private void signConsignment(CsLogisticsInfoRespDto logisticsInfoRespDto) {
        try {
            ConsignmentSignDto signDto = new ConsignmentSignDto();
            signDto.setWmsConsignmentNo(logisticsInfoRespDto.getConsignmentNo());
            signDto.setSignTime(logisticsInfoRespDto.getActualArrivalTime());
            this.consignmentOrderApi.sign(signDto);
        }
        catch (Exception e) {
            log.error("\u8fd0\u5355\u7b7e\u6536\u5931\u8d25, \u539f\u56e0: {}", (Object)e.getMessage());
        }
    }

    private void signSaleOrder(CsLogisticsInfoRespDto logisticsInfoRespDto) {
        try {
            ConsignmentOrderReqDto consignmentOrderReqDto = new ConsignmentOrderReqDto();
            consignmentOrderReqDto.setWmsConsignmentNo(logisticsInfoRespDto.getConsignmentNo());
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.consignmentOrderQueryApi.queryByPage(JSON.toJSONString((Object)consignmentOrderReqDto), Integer.valueOf(1), Integer.valueOf(2000)));
            if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                log.info("\u7269\u6d41\u7b7e\u6536\u7269\u6d41\u5355\u53f7\u5bf9\u5e94\u7684\u7269\u6d41\u4fe1\u606f\u4e0d\u5b58\u5728");
                return;
            }
            Set businessNoSet = pageInfo.getList().stream().filter(dto -> StringUtil.isNotBlank((CharSequence)dto.getBusinessNo())).map(ConsignmentOrderRespDto::getBusinessNo).distinct().collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(businessNoSet)) {
                log.info("\u7269\u6d41\u7b7e\u6536\u7269\u6d41\u5355\u53f7\u5bf9\u5e94\u7684\u9500\u552e\u5355\u53f7\u4e0d\u5b58\u5728");
                return;
            }
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setSaleOrderNoList((List)Lists.newArrayList(businessNoSet));
            saleOrderQueryReqDto.setOrderStatus(SaleOrderStatusEnum.COMPLETE.getCode());
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isEmpty((Collection)saleOrderRespDtos)) {
                log.info("\u7269\u6d41\u7b7e\u6536\u5355\u636e\u672a\u67e5\u8be2\u5230\u5df2\u5b8c\u6210\u8ba2\u5355");
                return;
            }
            for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
                try {
                    log.info("\u7269\u6d41\u7b7e\u6536\u9500\u552e\u5355[{}]\u7b7e\u6536\u5355\u53f7", (Object)saleOrderRespDto.getSaleOrderNo());
                    RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.confirmReceiptGoods(saleOrderRespDto.getId()));
                }
                catch (Exception e) {
                    log.info("\u7269\u6d41\u7b7e\u6536\u9500\u552e\u5355[{}]\u7b7e\u6536\u5f02\u5e38", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u7b7e\u6536\u5931\u8d25, \u539f\u56e0: {}", (Object)e.getMessage());
        }
    }
}

