/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleTransferReportRespDto;
import com.dtyunxi.tcbj.api.query.ISaleTransferReportApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsAdjustmentOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleTransferOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="IN_TRANSIT_ADJUSTMENT_COMPLETE")
public class InventoryAdjustOrderCreateProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(InventoryAdjustOrderCreateProcessor.class);
    private static final Logger logger = LoggerFactory.getLogger(InventoryAdjustOrderCreateProcessor.class);
    @Resource
    private IAdjustmentInventoryApi adjustmentInventoryQueryApi;
    @Resource
    private ExternalPointService externalPointService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ISaleTransferOrderQueryApi saleTransferOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleOrderItemQueryApi saleOrderItemQueryApi;
    @Resource
    private ISaleTransferReportApi saleTransferReportApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Autowired
    ICsTransferOrderApi csTransferOrderQueryApi;

    public boolean isDuplicationMessage(String msgId, MessageVo message) {
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u5e93\u5b58\u8c03\u6574\u5355\u521b\u5efa\u76d1\u542c\uff1a{}", (Object)JSON.toJSONString((Object)message));
        String adjustmentNo = (String)JSON.parseObject((String)message.getData().toString(), String.class);
        AdjustmentInventoryRespDto adjustmentInventoryRespDto = (AdjustmentInventoryRespDto)RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryQueryApi.queryByAdjustmentNo(adjustmentNo));
        logger.info("\u67e5\u8be2\u5728\u9014\u8c03\u6574\u5355: {}", (Object)JSON.toJSONString((Object)adjustmentInventoryRespDto));
        if (ObjectUtil.isEmpty((Object)adjustmentInventoryRespDto)) {
            logger.error("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u6574\u5355\u4fe1\u606f");
            return MessageResponse.SUCCESS;
        }
        if (!CsAdjustmentOrderTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode().equals(adjustmentInventoryRespDto.getAdjustmentType())) {
            logger.info("\u975e\u5728\u9014\u8c03\u6574\u5355\uff0c\u65e0\u9700\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        try {
            this.externalPointService.adjustmentInventoryToSapPoint(adjustmentInventoryRespDto);
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001EAS\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!"in_transit_adjustment_in".equals(adjustmentInventoryRespDto.getBusinessType())) {
            logger.info("\u975e\u5728\u9014\u5e93\u5b58\u5165\u5e93\uff0c\u65e0\u9700\u53cd\u5411\u9884\u5360\u4f9b\u8d27\u4ed3\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        try {
            this.sendUpdateInventoryStock(adjustmentInventoryRespDto.getRelevanceNo());
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u53cd\u5411\u9884\u5360\u5e93\u5b58mq\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }

    private void sendUpdateInventoryStock(String relevanceNo) {
        SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
        saleTransferOrderReqDto.setTransferOrderNo(relevanceNo);
        logger.info("\u6839\u636e\u8c03\u62e8\u5355\u67e5\u8be2\u9500\u552e\u8c03\u62e8\u5355\u5173\u8054\u5173\u7cfb:{}", (Object)relevanceNo);
        List saleTransferOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderQueryApi.queryByParam(saleTransferOrderReqDto));
        List<Object> saleOrderList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)saleTransferOrderRespDtos)) {
            CsTransferOrderRespDto csTransferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(relevanceNo));
            logger.info("\u67e5\u8be2\u8c03\u62e8\u5355\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)csTransferOrderRespDto));
            if (null != csTransferOrderRespDto && StringUtils.isNotBlank((CharSequence)csTransferOrderRespDto.getSaleOrderNo())) {
                saleOrderList.add(csTransferOrderRespDto.getSaleOrderNo());
            }
        } else {
            saleOrderList = saleTransferOrderRespDtos.stream().map(SaleTransferOrderRespDto::getSaleOrderNo).distinct().collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)saleOrderList)) {
            logger.info("\u8c03\u62e8\u5355\u5173\u8054\u7684\u9500\u552e\u8c03\u62e8\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        String saleOrderNos = StringUtils.join((Iterable)saleOrderList, (String)",");
        SaleTransferReportReqDto saleTransferReportReqDto = new SaleTransferReportReqDto();
        saleTransferReportReqDto.setOrderNo(saleOrderNos);
        saleTransferReportReqDto.setPageNum(Integer.valueOf(1));
        saleTransferReportReqDto.setPageSize(Integer.valueOf(300));
        logger.info("\u67e5\u8be2\u62a5\u8868\u4e2d\u5fc3\u9500\u552e\u8c03\u62e8\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)saleTransferReportReqDto));
        PageInfo saleTransferReportRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.saleTransferReportApi.queryByPage(saleTransferReportReqDto));
        if (CollectionUtils.isEmpty((Collection)saleTransferReportRespDtoPageInfo.getList())) {
            logger.info("\u67e5\u8be2\u62a5\u8868\u4e2d\u5fc3\u9500\u552e\u8c03\u62e8\u5355\u5173\u8054\u5173\u7cfb\u4e3a\u7a7a");
            return;
        }
        List saleOrderNoList = saleTransferReportRespDtoPageInfo.getList().stream().map(SaleTransferReportRespDto::getSaleOrderNo).distinct().collect(Collectors.toList());
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setSaleOrderNoList(saleOrderNoList);
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)saleOrderRespDtos)) {
            logger.info("\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u672a\u7a7a:{}", (Object)JSON.toJSONString(saleOrderNoList));
            return;
        }
        List orderIdList = saleOrderRespDtos.stream().map(SaleOrderRespDto::getId).collect(Collectors.toList());
        List saleOrderItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryNormalItemsByOrderIds(orderIdList));
        if (CollectionUtils.isEmpty((Collection)saleOrderItemRespDtos)) {
            logger.info("\u67e5\u8be2\u9500\u552e\u5355\u5546\u54c1\u4fe1\u606f\u672a\u7a7a:{}", (Object)JSON.toJSONString(saleOrderNoList));
            return;
        }
        Map saleOrderInfoMap = saleOrderRespDtos.stream().collect(Collectors.toMap(SaleOrderRespDto::getSaleOrderNo, Function.identity(), (k1, k2) -> k1));
        Map<Long, List<SaleOrderItemRespDto>> saleOrderItemInfoMap = saleOrderItemRespDtos.stream().collect(Collectors.groupingBy(SaleOrderItemRespDto::getOrderId));
        Map<String, List<SaleTransferReportRespDto>> saleTransferMap = saleTransferReportRespDtoPageInfo.getList().stream().collect(Collectors.groupingBy(SaleTransferReportRespDto::getSaleOrderNo));
        for (String saleOrderNo : saleTransferMap.keySet()) {
            Boolean flag;
            if (!saleOrderInfoMap.containsKey(saleOrderNo)) {
                logger.info("\u9500\u552e\u5355\u4fe1\u606f\u4e0d\u5b58\u5728:{}", (Object)saleOrderNo);
                continue;
            }
            SaleOrderRespDto saleOrderRespDto = (SaleOrderRespDto)saleOrderInfoMap.get(saleOrderNo);
            if (!saleOrderItemInfoMap.containsKey(saleOrderRespDto.getId())) {
                logger.info("\u9500\u552e\u5355\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728:{}", (Object)saleOrderNo);
                continue;
            }
            List<SaleOrderItemRespDto> saleOrderItemList = saleOrderItemInfoMap.get(saleOrderRespDto.getId());
            List<SaleTransferReportRespDto> saleTransferReportRespDtos = saleTransferMap.get(saleOrderNo);
            ArrayList transferOrderNoList = Lists.newArrayList();
            saleTransferReportRespDtos.stream().forEach(dto -> {
                if (!Objects.equals(dto.getDisposeStatus(), "2")) {
                    logger.info("\u9500\u552e\u5355\u5bf9\u5e94\u7684\u8c03\u62e8\u5355\u5904\u7406\u72b6\u6001\u4e0d\u662f\u5168\u90e8\u8c03\u62e8:{},{}", (Object)dto.getSaleOrderNo(), (Object)dto.getTransferOrderNos());
                    return;
                }
                if (StringUtils.isNotEmpty((CharSequence)dto.getTransferOrderNos())) {
                    String[] split = dto.getTransferOrderNos().split(",");
                    transferOrderNoList.addAll(Arrays.asList(split));
                }
            });
            if (CollectionUtils.isEmpty((Collection)transferOrderNoList)) {
                logger.info("\u9500\u552e\u5355\u672a\u5173\u8054\u8c03\u62e8\u5355\u53f7:{}", (Object)saleOrderNo);
                continue;
            }
            if (transferOrderNoList.size() > 1 && !(flag = (Boolean)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.hasAllDelivery((List)transferOrderNoList))).booleanValue()) {
                logger.info("\u8c03\u62e8\u5355\u5df2\u5168\u90e8\u53d1\u8d27\u4e0d\u518d\u53cd\u5411\u9884\u5360:{}", (Object)JSON.toJSONString((Object)transferOrderNoList));
                continue;
            }
            this.sendInventoryOrderPreemptMq(saleOrderRespDto, saleOrderItemList);
        }
    }

    private void sendInventoryOrderPreemptMq(SaleOrderRespDto saleOrderRespDto, List<SaleOrderItemRespDto> saleOrderItemList) {
        MessageVo messageVo = new MessageVo();
        OperationDto shPreemptParam = new OperationDto();
        shPreemptParam.setSourceType(saleOrderRespDto.getOrderType());
        shPreemptParam.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        shPreemptParam.setExternalOrderNo(saleOrderRespDto.getPlatformOrderNo());
        ArrayList detailParams = Lists.newArrayList();
        for (SaleOrderItemRespDto saleOrderItemExtRespDto : saleOrderItemList) {
            OperationDetailDto itemDetail = new OperationDetailDto();
            itemDetail.setSkuCode(saleOrderItemExtRespDto.getSkuCode());
            itemDetail.setNum(saleOrderItemExtRespDto.getItemNum());
            itemDetail.setWarehouseCode(saleOrderItemExtRespDto.getLogicalWarehouseCode());
            detailParams.add(itemDetail);
        }
        shPreemptParam.setDetails((List)detailParams);
        messageVo.setData((Object)JSON.toJSONString((Object)shPreemptParam));
        logger.info("\u8c03\u6574\u5355\u521b\u5efa\u6210\u529f\u53d1\u9001mq\u53cd\u5411\u9884\u5360\u5e93\u5b58:{}", (Object)JSON.toJSONString((Object)shPreemptParam));
        this.commonsMqService.publishMessage("INVENTORY_ORDER_PREEMPT_LOGIC_TAG", (Object)messageVo);
    }
}

