/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICsLogisticsInfoApi;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="LOGISTICS_TRAJECTORY")
public class LogisticsTrajectoryProcessor
implements IMessageProcessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(LogisticsTrajectoryProcessor.class);
    @Resource
    private ICsLogisticsInfoApi csLogisticsInfoApi;
    @Resource
    private ExternalService externalService;
    @Resource
    private ExternalPointService externalPointService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(Map<String, Object> message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        String msgStr = JSON.toJSONString(message);
        log.info("\u540c\u6b65\u7269\u6d41\u8f68\u8ff9\uff1a{}", (Object)msgStr);
        String resultCode = "0";
        String resultMsg = "success";
        try {
            RestResponse response = this.csLogisticsInfoApi.logisticsInfoSync(JSONObject.toJSONString(message));
            resultCode = response.getResultCode();
            resultMsg = response.getResultMsg();
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7269\u6d41\u8f68\u8ff9\u5931\u8d25", (Throwable)e);
            resultCode = "100000";
            resultMsg = e.getMessage();
        }
        finally {
            String sendLogId = this.externalService.getSendLogId(message);
            this.externalService.backMsg(sendLogId, resultCode, resultMsg);
        }
        return MessageResponse.SUCCESS;
    }
}

