/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.IApiLogApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.RouteMultiAllotNodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleTransferOrderQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="TRANSFER_COMPLETE")
public class TransferOrderFinishProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderFinishProcessor.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ISaleTransferOrderQueryApi saleTransferOrderQueryApi;
    @Resource
    private ExternalPointService externalPointService;
    @Resource
    private IApiLogApi apiLogApi;
    @Resource
    private ICsOutNoticeOrderApi csOutNoticeOrderApi;
    public static final List<String> allotTypeList = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.ALLOT_SALE.getCode()});
    public static final List<String> maiyouAllotTypeList = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.CC_ALLOT.getCode(), CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode()});

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u8c03\u62e8\u5355\u5b8c\u6210\u901a\u77e5\uff1a{}", (Object)JSON.toJSONString((Object)message));
        String transferOrderNo = (String)JSON.parseObject((String)message.getData().toString(), String.class);
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(transferOrderNo));
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)transferOrder), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
        logger.info("\u8c03\u62e8\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)transferOrder));
        try {
            logger.info("\u8c03\u62e8\u5355\u5b8c\u6210\u901a\u77e5\uff0c\u9500\u552e\u5355\u81ea\u52a8\u89e3\u6302\uff1a{}", (Object)transferOrderNo);
            if (allotTypeList.contains(transferOrder.getType()) && StringUtils.isNotBlank((CharSequence)transferOrder.getSaleOrderNo())) {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusUnLockAndSystem(transferOrder.getSaleOrderNo()));
            } else {
                logger.info("\u975e\u9500\u552e\u8c03\u62e8\u4e0d\u505a\u5904\u7406");
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u62e8\u5355\u5b8c\u6210\u901a\u77e5\uff0c\u9500\u552e\u5355\u81ea\u52a8\u89e3\u6302\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (maiyouAllotTypeList.contains(transferOrder.getType()) && StringUtils.isNotBlank((CharSequence)transferOrder.getSaleOrderNo())) {
                logger.info("bc/cc\u8c03\u62e8\u5355\u5b8c\u6210\u901a\u77e5\uff0c\u9500\u552e\u5355\u81ea\u52a8\u7b7e\u6536\uff1a{}", (Object)transferOrderNo);
                SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
                saleOrderQueryReqDto.setSaleOrderNo(transferOrder.getSaleOrderNo());
                List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
                if (CollectionUtil.isNotEmpty((Collection)saleOrderRespDtos)) {
                    RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.confirmReceiptGoods(((SaleOrderRespDto)saleOrderRespDtos.get(0)).getId()));
                }
            }
        }
        catch (Exception e) {
            logger.error("bc/cc\u8c03\u62e8\u5355\u5b8c\u6210\u901a\u77e5\uff0c\u9500\u552e\u5355\u81ea\u52a8\u7b7e\u6536");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode().equals(transferOrder.getType()) && StringUtils.isNotBlank((CharSequence)transferOrder.getSaleOrderNo())) {
                logger.info("\u9ea6\u4f18\u666e\u901a\u8c03\u62e8\u5355\u5b8c\u6210\u901a\u77e5\u751f\u6210bc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u5355\uff1a{}", (Object)transferOrderNo);
                RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderApi.doNextSaleTransferOrder(transferOrderNo));
            }
        }
        catch (Exception e) {
            logger.error("\u9ea6\u4f18\u666e\u901a\u8c03\u62e8\u5355\u5b8c\u6210\u901a\u77e5\u751f\u6210bc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u5355");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            logger.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u5b8c\u6210\uff0c\u5904\u7406\u540e\u7eed\u6d41\u7a0b\uff1a{}", (Object)transferOrderNo);
            if (transferOrder.getType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode()) || transferOrder.getType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode())) {
                this.externalPointService.routeInternalDealFinish(transferOrder);
                this.apiLogApi.addRouteInternalDeal(transferOrder.getTransferOrderNo(), RouteMultiAllotNodeEnum.COMPLETE_EX.getCode(), true, "\u6d41\u8f6c\u5b8c\u6210");
            } else {
                logger.info("\u975e\u5728\u9014\u5185\u90e8\u4ea4\u6613\u4e0d\u505a\u5904\u7406");
            }
        }
        catch (Exception e) {
            this.apiLogApi.addRouteInternalDeal(transferOrder.getTransferOrderNo(), RouteMultiAllotNodeEnum.COMPLETE_EX.getCode(), false, e.getMessage());
            logger.error("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u5b8c\u6210\uff0c\u5904\u7406\u540e\u7eed\u6d41\u7a0b\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

