/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.request.GetSaleOrderListPageEsParams;
import com.dtyunxi.cis.search.api.dto.request.SaleOrderContrastPageParams;
import com.dtyunxi.cis.search.api.dto.response.SaleOrderCountVo;
import com.dtyunxi.cis.search.api.dto.response.SaleOrderItemRespVo;
import com.dtyunxi.cis.search.api.dto.response.SaleOrderRespEsVo;
import com.dtyunxi.cis.search.api.query.trade.EsSaleOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.util.AddressResolutionUtil;
import com.dtyunxi.cis.search.biz.util.SaleOrderContrastRowMapper;
import com.dtyunxi.cis.search.biz.util.SaleOrderRowMapper;
import com.dtyunxi.cis.search.biz.util.SaleOrderStatusEnum;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.AggFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.AggResult;
import com.dtyunxi.huieryun.opensearch.vo.AggResultItem;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsSaleOrderQueryServiceImpl
extends BaseEsService
implements EsSaleOrderQueryApi {
    private static final Logger log = LoggerFactory.getLogger(EsSaleOrderQueryServiceImpl.class);
    String indexName = "tr_sale_order";
    String saleOrderItemIndexName = "tr_sale_order_item";
    private static final String[] ORDER_NOS = new String[]{"platformOrderNo", "saleOrderNo", "easOrderNo", "easOutOrderNo", "platformParentOrderNo"};
    private static final String[] LOGICAL_WAREHOUSE = new String[]{"logicalWarehouseCode", "logicalWarehouseName"};
    private static final String[] EAS_ORDER_NOS = new String[]{"easOrderNo", "easOutOrderNo"};
    private static final String[] ORDER_DETAIL_NOS = new String[]{"platformOrderNo", "saleOrderNo", "easOrderNo", "easOutOrderNo", "platformParentOrderNo", "outNoticeOrderNo"};

    @PostConstruct
    private void init() {
        this.indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.indexName;
        this.saleOrderItemIndexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.saleOrderItemIndexName;
    }

    private OSSearchVo initSearchVo(GetSaleOrderListPageEsParams reqDto) {
        FilterFieldVo filter;
        FilterFieldVo filter2;
        String[] orderNos;
        String orderNo;
        OSSearchVo queryVo = new OSSearchVo();
        queryVo.setPage(reqDto.getPageNum().intValue());
        queryVo.setPageSize(reqDto.getPageSize().intValue());
        queryVo.addEqualFilter("dr", "0");
        if (Objects.nonNull(reqDto.getOrderNo())) {
            orderNo = reqDto.getOrderNo();
            orderNos = RptUtil.regExSplit((String)orderNo);
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            String[] stringArray = orderNos;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String o = stringArray[i];
                this.addWildcardFilter(filter2, ORDER_NOS, this.wildcard(o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getShopName())) {
            queryVo.addWildcardFilter("shopName", "*" + reqDto.getShopName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderRemark())) {
            queryVo.addWildcardFilter("orderRemark", "*" + reqDto.getOrderRemark() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getLogicalWarehouseName())) {
            queryVo.addWildcardFilter("logicalWarehouseName", "*" + reqDto.getLogicalWarehouseName() + "*");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderSource())) {
            String[] split = RptUtil.regExSplit((String)reqDto.getOrderSource());
            queryVo.addInFilter("orderSource", split);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSellerName())) {
            queryVo.addWildcardFilter("sellerName", "*" + reqDto.getSellerName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSellerCode())) {
            queryVo.addWildcardFilter("sellerCode", "*" + reqDto.getSellerCode() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDetailAddress())) {
            queryVo.addWildcardFilter("detailAddress", "*" + reqDto.getDetailAddress() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderCreateTimeStart())) {
            reqDto.setSaleOrderCreateTimeStartDate(DateUtil.parse((String)(reqDto.getSaleOrderCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderCreateTimeEnd())) {
            reqDto.setSaleOrderCreateTimeEndDate(DateUtil.parse((String)(reqDto.getSaleOrderCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryTimeStart())) {
            reqDto.setDeliveryTimeStartDate(DateUtil.parse((String)(reqDto.getDeliveryTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryTimeEnd())) {
            reqDto.setDeliveryTimeEndDate(DateUtil.parse((String)(reqDto.getDeliveryTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdateTimeStart())) {
            reqDto.setUpdateTimeStartDate(DateUtil.parse((String)(reqDto.getUpdateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdateTimeEnd())) {
            reqDto.setUpdateTimeEndDate(DateUtil.parse((String)(reqDto.getUpdateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (Objects.nonNull(reqDto.getSaleOrderCreateTimeStartDate()) && Objects.nonNull(reqDto.getSaleOrderCreateTimeEndDate())) {
            queryVo.addRangeFilter("saleOrderCreateTime", String.valueOf(reqDto.getSaleOrderCreateTimeStartDate().getTime()), String.valueOf(reqDto.getSaleOrderCreateTimeEndDate().getTime()));
        }
        if (Objects.nonNull(reqDto.getDeliveryTimeStartDate()) && Objects.nonNull(reqDto.getDeliveryTimeEndDate())) {
            queryVo.addRangeFilter("deliveryTime", String.valueOf(reqDto.getDeliveryTimeStartDate().getTime()), String.valueOf(reqDto.getDeliveryTimeEndDate().getTime()));
        }
        if (Objects.nonNull(reqDto.getUpdateTimeStartDate()) && Objects.nonNull(reqDto.getUpdateTimeEndDate())) {
            queryVo.addRangeFilter("updateTime", String.valueOf(reqDto.getUpdateTimeStartDate().getTime()), String.valueOf(reqDto.getUpdateTimeEndDate().getTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerCode())) {
            queryVo.addWildcardFilter("customerCode", "*" + reqDto.getCustomerCode() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName())) {
            queryVo.addWildcardFilter("customerName", "*" + reqDto.getCustomerName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryName())) {
            queryVo.addWildcardFilter("deliveryName", "*" + reqDto.getDeliveryName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryPhone())) {
            queryVo.addWildcardFilter("deliveryPhone", "*" + reqDto.getDeliveryPhone() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getLogisticsCompany())) {
            queryVo.addWildcardFilter("logisticsCompany", "*" + reqDto.getLogisticsCompany() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getInterceptInfoFlag())) {
            queryVo.addEqualFilter("interceptInfoFlag", reqDto.getInterceptInfoFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getInterceptInfo())) {
            queryVo.addWildcardFilter("interceptInfo", "*" + reqDto.getInterceptInfo() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCreatePerson())) {
            queryVo.addWildcardFilter("createPerson", "*" + reqDto.getCreatePerson() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderStatus())) {
            FilterFieldVo statuses = RptUtil.regExSplit((String)reqDto.getSaleOrderStatus());
            FilterFieldVo filter3 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : statuses) {
                this.addWildcardFilter(filter3, new String[]{"saleOrderStatus"}, this.wildcard(o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter3});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOriginalOrderNo())) {
            queryVo.addWildcardFilter("originalOrderNo", "*" + reqDto.getOriginalOrderNo() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSplitStatus())) {
            queryVo.addEqualFilter("splitStatus", reqDto.getSplitStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSplitLevel())) {
            queryVo.addWildcardFilter("splitLevel", "*" + reqDto.getSplitLevel() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCityCode())) {
            queryVo.addEqualFilter("cityCode", reqDto.getCityCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getProvinceCode())) {
            queryVo.addEqualFilter("provinceCode", reqDto.getProvinceCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDistrictCode())) {
            queryVo.addEqualFilter("countyCode", reqDto.getDistrictCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformParentOrderNo())) {
            queryVo.addWildcardFilter("platformParentOrderNo", "*" + reqDto.getPlatformParentOrderNo() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderType())) {
            queryVo.addEqualFilter("orderType", reqDto.getOrderType());
        }
        if (Objects.nonNull(reqDto.getIfButtThirdParty())) {
            queryVo.addEqualFilter("ifButtThirdParty", reqDto.getIfButtThirdParty() + "");
        }
        if (Objects.nonNull(reqDto.getOrderBizType())) {
            queryVo.addEqualFilter("orderBizType", reqDto.getOrderBizType() + "");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getStoragePlace())) {
            queryVo.addEqualFilter("storagePlace", "*" + reqDto.getStoragePlace() + "*");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getPhysicsWarehouseCode())) {
            queryVo.addEqualFilter("physicsWarehouseCode", "*" + reqDto.getPhysicsWarehouseCode() + "*");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getStringCodeResult())) {
            queryVo.addEqualFilter("stringCodeResult", reqDto.getStringCodeResult());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSplitPlatformNo())) {
            queryVo.addEqualFilter("splitPlatformNo", "*" + reqDto.getSplitPlatformNo() + "*");
        }
        if (Objects.nonNull(reqDto.getAllowSplitFlag())) {
            queryVo.addEqualFilter("allowSplitFlag", reqDto.getAllowSplitFlag() + "");
        }
        if (Objects.nonNull(reqDto.getEasVerifyStatus())) {
            queryVo.addEqualFilter("easVerifyStatus", reqDto.getEasVerifyStatus() + "");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getEasOrderNo())) {
            orderNo = reqDto.getEasOrderNo();
            orderNos = RptUtil.regExSplit((String)orderNo);
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : orderNos) {
                this.addWildcardFilter(filter2, EAS_ORDER_NOS, this.wildcard(o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderTypeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getOrderTypeList()) {
                this.addWildcardFilter(filter, new String[]{"orderType"}, this.wildcard((String)o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderLevelList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getOrderLevelList()) {
                FilterFieldVo aFilter = FilterFieldVo.equal((String)"orderLevel", (String)((Integer)o).toString(), (LogicalSymbol)LogicalSymbol.OR);
                filter.addSubFilterFieldVos(new FilterFieldVo[]{aFilter});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAssignStatus())) {
            queryVo.addEqualFilter("assignStatus", reqDto.getAssignStatus());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getStringCodeResultList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getStringCodeResultList()) {
                this.addWildcardFilter(filter, new String[]{"stringCodeResult"}, this.wildcard((String)o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRegionName())) {
            queryVo.addFilters(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"regionName", (String)this.wildcard(reqDto.getRegionName()))});
        }
        queryVo.addSort("id", SortOrder.DESC);
        return queryVo;
    }

    public RestResponse<PageInfo<SaleOrderRespEsVo>> querySaleOrderListPage(GetSaleOrderListPageEsParams dto) {
        dto.setDetailAddress(AddressResolutionUtil.extractDetailAddress(dto.getDetailAddress()));
        OSSearchVo queryVo = this.initSearchVo(dto);
        queryVo.setPage(dto.getPageNum().intValue());
        queryVo.setPageSize(dto.getPageSize().intValue());
        SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new PageInfo());
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        List dtoList = searchResultVo.getDocValues((RowMapper)new SaleOrderRowMapper());
        pageInfo.setList(dtoList);
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<SaleOrderCountVo> querySaleOrderByCount(GetSaleOrderListPageEsParams filter) {
        List aggResults;
        filter.setDetailAddress(AddressResolutionUtil.extractDetailAddress(filter.getDetailAddress()));
        SaleOrderCountVo data = new SaleOrderCountVo();
        OSSearchVo queryVo = this.initSearchVo(filter);
        ArrayList<AggFieldVo> aggFieldVoList = new ArrayList<AggFieldVo>();
        AggFieldVo saleOrderStatus = AggFieldVo.terms((String)"saleOrderStatus");
        aggFieldVoList.add(saleOrderStatus);
        queryVo.setAggFields(aggFieldVoList);
        SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
        log.info("querySaleOrderByCount-searchResultVo:{}", (Object)JSON.toJSONString((Object)searchResultVo));
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new SaleOrderCountVo());
        }
        if (searchResultVo != null && CollectionUtils.isNotEmpty((Collection)(aggResults = searchResultVo.getAggResults()))) {
            for (AggResult aggResult : aggResults) {
                List aggResultItems = aggResult.getAggResultItems();
                log.info("aggResultItems:{}", (Object)JSON.toJSONString((Object)aggResultItems));
                if (!Objects.equals("saleOrderStatus", aggResult.getFieldName()) || !CollectionUtils.isNotEmpty((Collection)aggResultItems)) continue;
                BigDecimal allCount = BigDecimal.ZERO;
                for (AggResultItem aggResultItem : aggResultItems) {
                    String fieldValue = aggResultItem.getFieldValue();
                    if (Objects.equals(SaleOrderStatusEnum.WAIT_CHECK.getCode(), fieldValue)) {
                        data.setWaitCheckCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.WAIT_CHECK.getCode(), fieldValue)) {
                        data.setWaitCheckCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.WAIT_DELIVERY.getCode(), fieldValue)) {
                        data.setWaitDeliveryCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.COMPLETE.getCode(), fieldValue)) {
                        data.setCompleteCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.CANCEL.getCode(), fieldValue)) {
                        data.setCancelCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.FINISH.getCode(), fieldValue)) {
                        data.setFinishCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.SPLIT.getCode(), fieldValue)) {
                        data.setSplitCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.CANCELING.getCode(), fieldValue)) {
                        data.setCancelingCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    }
                    allCount = allCount.add(BigDecimal.valueOf(aggResultItem.getDocCount()));
                }
                data.setAllCount(allCount);
            }
        }
        return new RestResponse((Object)data);
    }

    public RestResponse<PageInfo<SaleOrderItemRespVo>> querySaleOrderContrast(SaleOrderContrastPageParams dto) {
        OSSearchVo queryVo = this.initSearchVo(dto);
        log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2ES\u5165\u53c2,\u7d22\u5f15\u540d\u79f0:{},\u641c\u7d22\u53c2\u6570:{}", (Object)this.saleOrderItemIndexName, (Object)JSON.toJSONString((Object)queryVo));
        SearchResultVo searchResultVo = this.searchData(this.saleOrderItemIndexName, queryVo);
        log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2ES\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)queryVo));
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new PageInfo());
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        List dtoList = searchResultVo.getDocValues((RowMapper)new SaleOrderContrastRowMapper());
        pageInfo.setList(dtoList);
        return new RestResponse((Object)pageInfo);
    }

    private OSSearchVo initSearchVo(SaleOrderContrastPageParams reqDto) {
        FilterFieldVo filter;
        String logicalWarehouse;
        FilterFieldVo filter2;
        OSSearchVo queryVo = new OSSearchVo();
        queryVo.setPage(reqDto.getPageNum().intValue());
        queryVo.setPageSize(reqDto.getPageSize().intValue());
        queryVo.addEqualFilter("dr", "0");
        if (Objects.nonNull(reqDto.getOrderNo())) {
            String orderNo = reqDto.getOrderNo();
            String[] orderNos = RptUtil.regExSplit((String)orderNo);
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : orderNos) {
                this.addWildcardFilter(filter2, ORDER_DETAIL_NOS, this.wildcard(o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (StringUtils.isNotBlank((CharSequence)(logicalWarehouse = reqDto.getLogicalWarehouse()))) {
            String[] logicalWarehouses = RptUtil.regExSplit((String)logicalWarehouse);
            if (logicalWarehouses.length > 1) {
                queryVo.addInFilter(LOGICAL_WAREHOUSE[0], logicalWarehouses, LogicalSymbol.OR);
                queryVo.addInFilter(LOGICAL_WAREHOUSE[1], logicalWarehouses, LogicalSymbol.OR);
            } else {
                queryVo.addWildcardFilter(LOGICAL_WAREHOUSE, this.wildcard(logicalWarehouse), LogicalSymbol.OR);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderType())) {
            queryVo.addEqualFilter("orderType", reqDto.getOrderType());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderStatus())) {
            String[] statuses = RptUtil.regExSplit((String)reqDto.getOrderStatus());
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : statuses) {
                this.addWildcardFilter(filter2, new String[]{"orderStatus"}, this.wildcard(o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemCode())) {
            queryVo.addWildcardFilter("skuCode", this.wildcard(reqDto.getItemCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemName())) {
            queryVo.addWildcardFilter("itemName", this.wildcard(reqDto.getItemName()));
        }
        BigDecimal startOutItemNum = reqDto.getStartOutItemNum();
        BigDecimal endOutItemNum = reqDto.getEndOutItemNum();
        if (Objects.nonNull(startOutItemNum) && Objects.nonNull(endOutItemNum)) {
            queryVo.addRangeFilter("outItemNum", String.valueOf(startOutItemNum), String.valueOf(endOutItemNum));
        }
        BigDecimal startItemNum = reqDto.getStartItemNum();
        BigDecimal endItemNum = reqDto.getEndItemNum();
        if (Objects.nonNull(startItemNum) && Objects.nonNull(endItemNum)) {
            queryVo.addRangeFilter("itemNum", String.valueOf(startItemNum), String.valueOf(endItemNum));
        }
        BigDecimal startDifferenceNum = reqDto.getStartDifferenceNum();
        BigDecimal endDifferenceNum = reqDto.getEndDifferenceNum();
        if (Objects.nonNull(startDifferenceNum) && Objects.nonNull(endDifferenceNum)) {
            queryVo.addRangeFilter("differenceNum", String.valueOf(startDifferenceNum), String.valueOf(endDifferenceNum));
        }
        String startTime = reqDto.getStartTime();
        String endTime = reqDto.getEndTime();
        if (StringUtils.isNotBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            queryVo.addRangeFilter("createTime", this.beginTimeLong(startTime), this.endTimeLong(endTime));
        }
        BigDecimal startVolumeSum = reqDto.getStartVolumeSum();
        BigDecimal endVolumeSum = reqDto.getEndVolumeSum();
        if (Objects.nonNull(startVolumeSum) && Objects.nonNull(endVolumeSum)) {
            queryVo.addRangeFilter("volume", String.valueOf(startVolumeSum), String.valueOf(endVolumeSum));
        }
        BigDecimal startSalePrice = reqDto.getStartSalePrice();
        BigDecimal endSalePrice = reqDto.getEndSalePrice();
        if (Objects.nonNull(startSalePrice) && Objects.nonNull(endSalePrice)) {
            queryVo.addRangeFilter("salePrice", String.valueOf(startSalePrice), String.valueOf(endSalePrice));
        }
        BigDecimal startLineAmount = reqDto.getStartLineAmount();
        BigDecimal endLineAmount = reqDto.getEndLineAmount();
        if (Objects.nonNull(startLineAmount) && Objects.nonNull(endLineAmount)) {
            queryVo.addRangeFilter("lineAmount", String.valueOf(startLineAmount), String.valueOf(endLineAmount));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdatePerson())) {
            queryVo.addWildcardFilter("updatePerson", this.wildcard(reqDto.getUpdatePerson()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBatchNo())) {
            queryVo.addWildcardFilter("batchNo", this.wildcard(reqDto.getBatchNo()));
        }
        if (Objects.nonNull(reqDto.getIsOnline())) {
            queryVo.addEqualFilter("isOnline", String.valueOf(reqDto.getIsOnline()));
        }
        if (Objects.nonNull(reqDto.getOrderSource())) {
            queryVo.addEqualFilter("orderSource", String.valueOf(reqDto.getOrderSource()));
        }
        if (Objects.nonNull(reqDto.getIntegral())) {
            queryVo.addEqualFilter("integral", String.valueOf(reqDto.getIntegral()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrganizationCode())) {
            queryVo.addWildcardFilter("organizationCode", this.wildcard(reqDto.getOrganizationCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getWarehouseCode())) {
            queryVo.addEqualFilter("physicsWarehouseCode", reqDto.getWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderLevelList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getOrderLevelList()) {
                FilterFieldVo aFilter = FilterFieldVo.equal((String)"orderLevel", (String)((Integer)o).toString(), (LogicalSymbol)LogicalSymbol.OR);
                filter.addSubFilterFieldVos(new FilterFieldVo[]{aFilter});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSaleOrderStatusList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getSaleOrderStatusList()) {
                this.addWildcardFilter(filter, new String[]{"orderStatus"}, this.wildcard((String)o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName())) {
            queryVo.addWildcardFilter("customerName", "*" + reqDto.getCustomerName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryName())) {
            queryVo.addWildcardFilter("deliveryName", "*" + reqDto.getDeliveryName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryPhone())) {
            queryVo.addWildcardFilter("deliveryPhone", "*" + reqDto.getDeliveryPhone() + "*");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderSource())) {
            String[] split = RptUtil.regExSplit((String)reqDto.getOrderSource());
            queryVo.addInFilter("orderSource", split);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getLogisticsCompany())) {
            queryVo.addWildcardFilter("logisticsCompany", "*" + reqDto.getLogisticsCompany() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getLogisticsNo())) {
            queryVo.addWildcardFilter("logisticsNo", this.wildcard(reqDto.getLogisticsNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getShippingNo())) {
            queryVo.addWildcardFilter("shippingNo", this.wildcard(reqDto.getShippingNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryType())) {
            queryVo.addWildcardFilter("deliveryType", "*" + reqDto.getDeliveryType() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getProvince())) {
            queryVo.addWildcardFilter("province", "*" + reqDto.getProvince() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getProvinceCode())) {
            queryVo.addEqualFilter("provinceCode", reqDto.getProvinceCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryOutBatchNo())) {
            queryVo.addWildcardFilter("deliveryOutBatchNo", "*" + reqDto.getDeliveryOutBatchNo() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderType())) {
            queryVo.addEqualFilter("orderType", reqDto.getOrderType());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderTypeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getOrderTypeList()) {
                this.addWildcardFilter(filter, new String[]{"orderType"}, this.wildcard((String)o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderStatusList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getOrderStatusList()) {
                this.addWildcardFilter(filter, new String[]{"orderStatus"}, this.wildcard((String)o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderSourceList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getOrderSourceList()) {
                this.addWildcardFilter(filter, new String[]{"orderSource"}, this.wildcard((String)o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getDeliveryPhysicalWarehouseList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getDeliveryPhysicalWarehouseList()) {
                this.addWildcardFilter(filter, new String[]{"physicsWarehouseCode"}, this.wildcard((String)o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getDeliveryTypeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (Object o : reqDto.getDeliveryTypeList()) {
                this.addWildcardFilter(filter, new String[]{"deliveryType"}, this.wildcard((String)o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        log.info("\u9500\u552e\u8ba2\u5355ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        queryVo.addSort("id", SortOrder.DESC);
        return queryVo;
    }

    public RestResponse<SaleOrderCountVo> querySaleOrderItemByCount(SaleOrderContrastPageParams dto) {
        List aggResults;
        OSSearchVo queryVo = this.initSearchVo(dto);
        ArrayList<AggFieldVo> aggFieldVoList = new ArrayList<AggFieldVo>();
        AggFieldVo saleOrderStatus = AggFieldVo.terms((String)"orderStatus");
        aggFieldVoList.add(saleOrderStatus);
        queryVo.setAggFields(aggFieldVoList);
        log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2ES\u7edf\u8ba1\u72b6\u6001\u5165\u53c2,\u7d22\u5f15\u540d\u79f0:{},\u641c\u7d22\u53c2\u6570:{}", (Object)this.saleOrderItemIndexName, (Object)JSON.toJSONString((Object)queryVo));
        SearchResultVo searchResultVo = this.searchData(this.saleOrderItemIndexName, queryVo);
        log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2ES\u7edf\u8ba1\u72b6\u6001\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)queryVo));
        SaleOrderCountVo data = new SaleOrderCountVo();
        log.info("querySaleOrderItemByCount-searchResultVo:{}", (Object)JSON.toJSONString((Object)searchResultVo));
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new SaleOrderCountVo());
        }
        if (searchResultVo != null && CollectionUtils.isNotEmpty((Collection)(aggResults = searchResultVo.getAggResults()))) {
            for (AggResult aggResult : aggResults) {
                List aggResultItems = aggResult.getAggResultItems();
                log.info("aggResultItems:{}", (Object)JSON.toJSONString((Object)aggResultItems));
                if (!Objects.equals("orderStatus", aggResult.getFieldName()) || !CollectionUtils.isNotEmpty((Collection)aggResultItems)) continue;
                BigDecimal allCount = BigDecimal.ZERO;
                for (AggResultItem aggResultItem : aggResultItems) {
                    String fieldValue = aggResultItem.getFieldValue();
                    if (Objects.equals(SaleOrderStatusEnum.WAIT_CHECK.getCode(), fieldValue)) {
                        data.setWaitCheckCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.WAIT_PICK.getCode(), fieldValue)) {
                        data.setWaitCheckCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.WAIT_DELIVERY.getCode(), fieldValue)) {
                        data.setWaitDeliveryCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.COMPLETE.getCode(), fieldValue)) {
                        data.setCompleteCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.RECEIVED.getCode(), fieldValue)) {
                        data.setReceivedCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.CANCEL.getCode(), fieldValue)) {
                        data.setCancelCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.FINISH.getCode(), fieldValue)) {
                        data.setFinishCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.SPLIT.getCode(), fieldValue)) {
                        data.setSplitCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.CANCELING.getCode(), fieldValue)) {
                        data.setCancelingCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals(SaleOrderStatusEnum.OBSOLETE.getCode(), fieldValue)) {
                        data.setObsoleteCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    }
                    allCount = allCount.add(BigDecimal.valueOf(aggResultItem.getDocCount()));
                }
                data.setAllCount(allCount);
            }
        }
        return new RestResponse((Object)data);
    }
}

