/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.constant.SaleRefundStatusEnum;
import com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams;
import com.dtyunxi.cis.search.api.dto.response.EsSaleRefundCountVO;
import com.dtyunxi.cis.search.api.dto.response.SaleRefundRespVo;
import com.dtyunxi.cis.search.api.query.trade.EsSaleRefundQueryApi;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.util.EsParamUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.AggFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.AggResult;
import com.dtyunxi.huieryun.opensearch.vo.AggResultItem;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsSaleRefundQueryServiceImpl
extends BaseEsService
implements EsSaleRefundQueryApi {
    private static final Logger log = LoggerFactory.getLogger(EsSaleRefundQueryServiceImpl.class);
    String indexName = "tr_sale_refund";

    @PostConstruct
    private void init() {
        this.indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.indexName;
    }

    private OSSearchVo initSearchVo(EsSaleReturnOrderListPageParams reqDto) throws Exception {
        OSSearchVo queryVo = EsParamUtils.newInstance().getSearchVo(reqDto);
        queryVo.addEqualFilter("dr", "0");
        queryVo.addSort("id", SortOrder.DESC);
        log.info("\u9500\u552e\u9000\u8d27\u5355ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<SaleRefundRespVo>> querySaleRefundListPage(EsSaleReturnOrderListPageParams dto) {
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            queryVo.setPage(dto.getPageNum().intValue());
            queryVo.setPageSize(dto.getPageSize().intValue());
            SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            pageInfo.setTotal(searchResultVo.getTotalSize());
            pageInfo.setPageSize(searchResultVo.getPageSize());
            pageInfo.setPageNum(searchResultVo.getCurrentPage());
            pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
            List dtoList = searchResultVo.getDocValues((RowMapper)new RowMapper<SaleRefundRespVo>(){

                public SaleRefundRespVo mapRow(Map<String, Object> docValue) {
                    return (SaleRefundRespVo)JacksonUtil.readValue((String)JacksonUtil.toJson(docValue), SaleRefundRespVo.class);
                }
            });
            pageInfo.setList(dtoList);
        }
        catch (Exception e) {
            log.error("\u9500\u552e\u9000\u8d27\u5355ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BizException("\u9500\u552e\u9000\u8d27\u5355ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<EsSaleRefundCountVO> queryByCount(EsSaleReturnOrderListPageParams dto) {
        EsSaleRefundCountVO saleRefundCountVO = new EsSaleRefundCountVO();
        try {
            List aggResults;
            OSSearchVo queryVo = this.initSearchVo(dto);
            ArrayList<AggFieldVo> aggFieldVoList = new ArrayList<AggFieldVo>();
            AggFieldVo saleOrderStatus = AggFieldVo.terms((String)"refundStatus");
            aggFieldVoList.add(saleOrderStatus);
            queryVo.setAggFields(aggFieldVoList);
            SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
            log.info("\u9500\u552e\u9000\u8d27\u5355ES[queryByCount-searchResultVo]:{}", (Object)JSON.toJSONString((Object)searchResultVo));
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)saleRefundCountVO);
            }
            if (searchResultVo != null && CollectionUtils.isNotEmpty((Collection)(aggResults = searchResultVo.getAggResults()))) {
                for (AggResult aggResult : aggResults) {
                    List aggResultItems = aggResult.getAggResultItems();
                    log.info("transferOrderStatus-aggResultItems:{}", (Object)JSON.toJSONString((Object)aggResultItems));
                    if (!Objects.equals("refundStatus", aggResult.getFieldName()) || !CollectionUtils.isNotEmpty((Collection)aggResultItems)) continue;
                    BigDecimal allCount = BigDecimal.ZERO;
                    for (AggResultItem aggResultItem : aggResultItems) {
                        String fieldValue = aggResultItem.getFieldValue();
                        if (Objects.equals(SaleRefundStatusEnum.WAIT_CHECK.getCode(), fieldValue)) {
                            saleRefundCountVO.setWaitCheckCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        } else if (Objects.equals(SaleRefundStatusEnum.COMPLETE.getCode(), fieldValue)) {
                            saleRefundCountVO.setCompleteCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        } else if (Objects.equals("WAIT_HANDLE", fieldValue)) {
                            saleRefundCountVO.setWaitHandleCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        } else if (Objects.equals(SaleRefundStatusEnum.PART_OUTBOUND.getCode(), fieldValue)) {
                            saleRefundCountVO.setPartOutBoundCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        } else if (Objects.equals(SaleRefundStatusEnum.CANCEL.getCode(), fieldValue)) {
                            saleRefundCountVO.setCancelCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        } else if (Objects.equals(SaleRefundStatusEnum.CANCELING.getCode(), fieldValue)) {
                            saleRefundCountVO.setCancelingCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        } else if (Objects.equals(SaleRefundStatusEnum.HAD_CHECK.getCode(), fieldValue)) {
                            saleRefundCountVO.setHadCheckCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        } else if (Objects.equals(SaleRefundStatusEnum.CLOSE.getCode(), fieldValue)) {
                            saleRefundCountVO.setCloseCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        } else if (Objects.equals(SaleRefundStatusEnum.INVALID.getCode(), fieldValue)) {
                            saleRefundCountVO.setInvalidCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        }
                        allCount = allCount.add(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    }
                    saleRefundCountVO.setAllCount(allCount);
                }
            }
        }
        catch (Exception e) {
            log.error("\u9500\u552e\u9000\u8d27\u5355\u72b6\u6001\u7edf\u8ba1ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BizException("\u9500\u552e\u9000\u8d27\u5355\u72b6\u6001\u7edf\u8ba1ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)saleRefundCountVO);
    }
}

