/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.util;

import com.dtyunxi.cis.search.api.anno.SearchCondition;
import com.dtyunxi.cis.search.api.constant.SearchType;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.util.DateUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsParamUtils {
    private static final Logger logger = LoggerFactory.getLogger(EsParamUtils.class);
    private OSSearchVo queryVo = new OSSearchVo();

    public static EsParamUtils newInstance() {
        return new EsParamUtils();
    }

    public OSSearchVo getSearchVo(Object obj) throws Exception {
        Class<?> c = obj.getClass();
        List fieldList = Arrays.stream(c.getDeclaredFields()).filter(e -> Objects.nonNull(e.getAnnotation(SearchCondition.class))).collect(Collectors.toList());
        Map<String, List<Field>> keyFieldMap = fieldList.stream().collect(Collectors.groupingBy(e -> e.getAnnotation(SearchCondition.class).key()));
        for (Field field : c.getDeclaredFields()) {
            Object fieldVal;
            SearchCondition condition = field.getAnnotation(SearchCondition.class);
            if (condition == null || Objects.isNull(fieldVal = this.getFieldVal(obj, field))) continue;
            if (condition.searchType() == SearchType.EQUAL) {
                logger.info("\u7cbe\u51c6\u641c\u7d22:{},{}", (Object)this.getKey(field, condition.key()), (Object)fieldVal.toString());
                this.queryVo.addEqualFilter(this.getKey(field, condition.key()), fieldVal.toString());
                continue;
            }
            if (condition.searchType() == SearchType.WILDCARD) {
                if (condition.keys().length > 0) {
                    logger.info("\u6a21\u7cca\u6279\u91cf\u641c\u7d22:{},{}", (Object)condition.keys(), (Object)("*" + fieldVal.toString() + "*"));
                    this.queryVo.addWildcardFilter(condition.keys(), "*" + fieldVal.toString() + "*", LogicalSymbol.OR);
                    continue;
                }
                logger.info("\u6a21\u7cca\u641c\u7d22:{},{}", (Object)this.getKey(field, condition.key()), (Object)("*" + fieldVal.toString() + "*"));
                this.queryVo.addWildcardFilter(this.getKey(field, condition.key()), "*" + fieldVal.toString() + "*");
                continue;
            }
            if (condition.searchType() == SearchType.RANGE) {
                List<Field> keyFieldList;
                if (condition.priority() != 1 || (keyFieldList = keyFieldMap.get(condition.key())).size() != 2) continue;
                keyFieldList.stream().sorted(Comparator.comparing(handle -> handle.getAnnotation(SearchCondition.class).priority()));
                String o1 = this.getFieldVal(obj, keyFieldList.get(0)).toString();
                String o2 = this.getFieldVal(obj, keyFieldList.get(1)).toString();
                logger.info("\u8303\u56f4\u641c\u7d22:{},[{},{}]", new Object[]{this.getKey(field, condition.key()), this.beginTimeLong(o1), this.endTimeLong(o2)});
                this.queryVo.addRangeFilter(this.getKey(field, condition.key()), this.beginTimeLong(o1), this.endTimeLong(o2));
                continue;
            }
            if (condition.searchType() == SearchType.PAGE_NUM) {
                logger.info("\u9875\u6570:{}", (Object)fieldVal.toString());
                this.queryVo.setPage(Integer.parseInt(fieldVal.toString()));
                continue;
            }
            if (condition.searchType() == SearchType.PAGE_SIZE) {
                logger.info("\u6bcf\u9875\u663e\u793a:{}", (Object)fieldVal.toString());
                this.queryVo.setPageSize(Integer.parseInt(fieldVal.toString()));
                continue;
            }
            if (condition.searchType() == SearchType.ORDER_BY) {
                logger.info("\u6392\u5e8f:{}", (Object)fieldVal.toString());
                this.queryVo.addSort(fieldVal.toString(), SortOrder.DESC);
                continue;
            }
            if (condition.searchType() != SearchType.DR) continue;
            this.queryVo.addEqualFilter("dr", fieldVal.toString());
        }
        return this.queryVo;
    }

    private String getKey(Field field, String key) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)key)) {
            return key;
        }
        return field.getName();
    }

    private Object getFieldVal(Object obj, Field field) throws Exception {
        Class<?> c = obj.getClass();
        String fieldName = field.getName();
        String getMethod = "get" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
        Method method = c.getMethod(getMethod, new Class[0]);
        Object val = method.invoke(obj, new Object[0]);
        return val;
    }

    protected String wildcard(String wildcard) {
        if (StringUtils.isBlank((String)wildcard)) {
            return "";
        }
        return String.format("*%s*", wildcard).replaceAll(" ", "");
    }

    protected Date beginTime(String time) {
        return DateUtil.parse((String)(time + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern());
    }

    protected Date endTime(String time) {
        return DateUtil.parse((String)(time + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern());
    }

    protected Date beginTime() {
        return this.beginTime("1970-01-01");
    }

    protected Date endTime() {
        return this.endTime("2050-12-30");
    }

    protected String beginTimeLong(String time) {
        return String.valueOf(this.beginTime(time).getTime());
    }

    protected String endTimeLong(String time) {
        return String.valueOf(this.endTime(time).getTime());
    }
}

