/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBeanReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.api.dto.response.SellerSkuPriceDto;
import com.dtyunxi.yundt.module.bitem.biz.price.IItemPriceTypeService;
import com.dtyunxi.yundt.module.bitem.biz.price.PriceRuleHelper;
import com.dtyunxi.yundt.module.bitem.biz.price.constants.PriceTypeEnum;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BItemPriceService
implements IBItemPriceService {
    private static Logger logger = LoggerFactory.getLogger(BItemPriceService.class);
    @Value(value="${itemPrice.usePriceCenterPrice:true}")
    private boolean usePriceCenterPrice;
    @Value(value="${itemPrice.useRules:DEFAULT}")
    private String itemPriceUseRules;
    @Resource
    private List<IItemPriceTypeService> itemPriceTypeServiceList;
    @Autowired
    private PriceRuleHelper priceRuleHelper;
    private static Map<PriceTypeEnum, IItemPriceTypeService> itemPriceTypeMap;

    public IItemPriceTypeService getPriceService(Long shopId) {
        PriceTypeEnum priceTypeEnum;
        if (Objects.isNull(itemPriceTypeMap)) {
            itemPriceTypeMap = this.itemPriceTypeServiceList.stream().collect(Collectors.toMap(IItemPriceTypeService::priceType, Function.identity()));
        }
        if (itemPriceTypeMap.containsKey((Object)(priceTypeEnum = this.priceRuleHelper.toPriceTypeEnum(shopId)))) {
            return itemPriceTypeMap.get((Object)priceTypeEnum);
        }
        logger.error("[\u4ef7\u683c\u67e5\u8be2] >>> \u6a21\u5f0f[{}]\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b", (Object)this.itemPriceUseRules);
        throw new BizException("10000", "\u6a21\u5f0f" + this.itemPriceUseRules + "\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    public RestResponse<List<ItemPolicyPriceRespDto>> getItemPrice(CommunalPriceQueryReqDto communalPriceQueryReqDto) {
        logger.info("[\u83b7\u53d6\u5546\u54c1\u4ef7\u683c],\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)communalPriceQueryReqDto));
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)communalPriceQueryReqDto.getSkuList())) {
            List itemPolicyPriceRespDtos;
            ArrayList centerPriceItems = Lists.newArrayList();
            ArrayList centerItems = Lists.newArrayList();
            Map<Long, List<CommunalPriceQueryReqDto.ItemSkuPriceReqDto>> map = communalPriceQueryReqDto.getSkuList().stream().collect(Collectors.groupingBy(CommunalPriceQueryReqDto.ItemSkuPriceReqDto::getShopId));
            for (Map.Entry<Long, List<CommunalPriceQueryReqDto.ItemSkuPriceReqDto>> entry : map.entrySet()) {
                PriceTypeEnum priceTypeEnum = this.getPriceService(entry.getKey()).priceType();
                if (PriceTypeEnum.PRICE_CENTER.getCode().equals(priceTypeEnum.getCode())) {
                    centerPriceItems.addAll((Collection)entry.getValue());
                    continue;
                }
                centerItems.addAll((Collection)entry.getValue());
            }
            if (CollectionUtils.isNotEmpty((Collection)centerPriceItems)) {
                communalPriceQueryReqDto.setSkuList((List)centerPriceItems);
                itemPolicyPriceRespDtos = (List)RestResponseHelper.extractData(itemPriceTypeMap.get((Object)PriceTypeEnum.PRICE_CENTER).getItemPrice(communalPriceQueryReqDto));
                if (CollectionUtils.isNotEmpty((Collection)itemPolicyPriceRespDtos)) {
                    result.addAll(itemPolicyPriceRespDtos);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)centerItems)) {
                communalPriceQueryReqDto.setSkuList((List)centerItems);
                itemPolicyPriceRespDtos = (List)RestResponseHelper.extractData(itemPriceTypeMap.get((Object)PriceTypeEnum.TCBJ).getItemPrice(communalPriceQueryReqDto));
                if (CollectionUtils.isNotEmpty((Collection)itemPolicyPriceRespDtos)) {
                    result.addAll(itemPolicyPriceRespDtos);
                }
            }
        }
        return new RestResponse((Object)result);
    }

    public RestResponse<PriceAddOrModifyRespDto> queryPriceLimit(PriceBeanReqDto priceBeanReqDto) {
        return this.getPriceService(CollectionUtils.isNotEmpty((Collection)priceBeanReqDto.getPriceItemReqDtos()) ? ((PriceItemModifyReqDto)priceBeanReqDto.getPriceItemReqDtos().get(0)).getShopId() : null).queryPriceLimit(priceBeanReqDto);
    }

    public Map<String, SellerSkuPriceDto> getSellerSkuPrice(SellerSkuPriceReqDto sellerSkuPriceReqDto) {
        return this.getPriceService(sellerSkuPriceReqDto.getShopId()).getSellerSkuPrice(sellerSkuPriceReqDto);
    }
}

