/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerBuyScopeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoStorageQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjAvilableReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjAvilableRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalBatchQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IManagementBlockQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.CycleBuyDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.RateByDayEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.RateByMonthEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.RateByWeekEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DistributionSetReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirItemRelativeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DistributionSetRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemCycleBuyRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShopRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IShelfQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.cyclebuy.query.IItemCycleBuyQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.distribution.query.IDistributionQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.CountItemSalesReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.CountItemSalesRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ItemSkuActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityPriceBranchQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityStockReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.RemainingStockBatchReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.SupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.TargetCustomerReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.NotSupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.RemainingStockBatchRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivitySimpleInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.service.query.IActivityGroupQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBCustomerBuyScopeService;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.IBshopService;
import com.dtyunxi.yundt.module.bitem.api.constants.ItemConstant;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemDefineAttrDto;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemSkuBundleDto;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemSkuInfoDto;
import com.dtyunxi.yundt.module.bitem.api.dto.ShopItemDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemDepthQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemStorageQueryDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.StorageBranchQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ActivityStatisticsRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.CommonItemInfo;
import com.dtyunxi.yundt.module.bitem.api.dto.response.CustomerItemAuthInfo;
import com.dtyunxi.yundt.module.bitem.api.dto.response.CycleRateDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemActivityPriceRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemBaseInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemDetailCycleBuyDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemDetailInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ShopInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.BaseActivityDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.ItemActivityInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.ItemForActivityInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.enums.ShopTagEnum;
import com.dtyunxi.yundt.module.bitem.biz.constants.commonConstant;
import com.dtyunxi.yundt.module.bitem.biz.impl.BItemModuleHelper;
import com.dtyunxi.yundt.module.bitem.biz.inventory.ItemInventoryStrategyHelper;
import com.dtyunxi.yundt.module.bitem.biz.inventory.ItemInventoryStrategyService;
import com.dtyunxi.yundt.module.bitem.biz.price.ItemPriceHelper;
import com.dtyunxi.yundt.module.bitem.biz.service.IBInventoryService;
import com.dtyunxi.yundt.module.bitem.biz.service.IBItemActivityService;
import com.dtyunxi.yundt.module.bitem.biz.util.PageInfoUtil;
import com.dtyunxi.yundt.module.bitem.biz.util.QueryKeyGenerator;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BitemServiceImpl
implements IBitemService {
    private static final Logger logger = LoggerFactory.getLogger(BitemServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemStorageQueryApi itemStorageQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Autowired
    private IActivityItemQueryApi activityItemQueryApi;
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IBItemActivityService activityService;
    @Resource
    private IActivityGroupQueryApi activityGroupQueryApi;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IUnitQueryApi unitQueryApi;
    @Resource
    private IItemCycleBuyQueryApi itemCycleBuyQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IManagementBlockQueryApi managementBlockQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private IDistributionQueryApi distributionQueryApi;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Autowired
    private IBItemPriceService ibItemPriceService;
    @Resource
    private IBCustomerBuyScopeService customerBuyScopeService;
    @Resource
    private IBshopService bshopService;
    @Resource
    private IShelfQueryApi shelfQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ItemPriceHelper itemPriceHelper;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private ICargoStorageQueryApi cargoStorageQueryApi;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private IBInventoryService inventoryService;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private IActivityExtQueryApi activityExtQueryApi;
    @Autowired
    private BItemModuleHelper bItemModuleHelper;
    @Value(value="${item.storage.userItemCenter:true}")
    private boolean userItemCenter;
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private ItemInventoryStrategyHelper itemInventoryStrategyHelper;

    public Boolean queryStorageType() {
        return this.userItemCenter;
    }

    public Long queryVirStorage(Long shopId, Long itemId, Long skuId) {
        RestResponse listRestResponse = this.itemSkuQueryApi.queryBySkuId((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        List itemSkuRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>(1);
        ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
        itemStorageQueryDto.setSkuId(skuId);
        itemStorageQueryDto.setShopId(shopId);
        itemStorageQueryDto.setCargoCode(((ItemSkuRespDto)itemSkuRespDtos.get(0)).getCargoCode());
        itemStorageList.add(itemStorageQueryDto);
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List<ItemStorageQueryDto> itemStorageQueryDtos = this.queryBranchItemStorage(storageBranchQueryReqDto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemStorageQueryDtos)) {
            logger.info("\u67e5\u8be2\u5e93\u5b58shopId={}, skuId = {}, cargoCode = {}, storage={}", new Object[]{shopId, skuId, ((ItemSkuRespDto)itemSkuRespDtos.get(0)).getCargoCode(), itemStorageQueryDtos.get(0).getAvaNum()});
            return itemStorageQueryDtos.get(0).getAvaNum();
        }
        return 0L;
    }

    public List<ItemStorageQueryDto> queryBranchItemStorage(StorageBranchQueryReqDto storageBranchQueryReqDto) {
        logger.info("queryBranchItemStorage\u53c2\u6570>>>{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)storageBranchQueryReqDto));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)storageBranchQueryReqDto.getItemStorageList())) {
            throw new BizException("\u5546\u54c1\u5e93\u5b58\u67e5\u8be2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ItemStorageQueryDto> result = new ArrayList<ItemStorageQueryDto>(storageBranchQueryReqDto.getItemStorageList().size());
        if (this.userItemCenter) {
            ItemStorageBranchQueryReqDto itemStorageBranchQueryReqDto = new ItemStorageBranchQueryReqDto();
            ArrayList selfList = new ArrayList(storageBranchQueryReqDto.getItemStorageList().size());
            CubeBeanUtils.copyCollection(selfList, (Collection)storageBranchQueryReqDto.getItemStorageList(), ShelfReqDto.class);
            itemStorageBranchQueryReqDto.setShelfList(selfList);
            logger.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u53c2\u6570>>>{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)itemStorageBranchQueryReqDto));
            RestResponse listRestResponse = this.itemStorageQueryApi.queryBranchItemStorage(itemStorageBranchQueryReqDto);
            List itemStorageQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            logger.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u7ed3\u679c>>>{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)itemStorageBranchQueryReqDto));
            Map<String, ItemStorageQueryRespDto> itemStorageMap = itemStorageQueryRespDtoList.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId(), e -> e, (o1, o2) -> o1));
            for (ItemStorageQueryDto itemStorageQueryDto : storageBranchQueryReqDto.getItemStorageList()) {
                ItemStorageQueryDto itemStorageResultDto = new ItemStorageQueryDto();
                itemStorageResultDto.setShopId(itemStorageQueryDto.getShopId());
                itemStorageResultDto.setSkuId(itemStorageQueryDto.getSkuId());
                itemStorageResultDto.setCargoCode(itemStorageQueryDto.getCargoCode());
                ItemStorageQueryRespDto itemStorageQueryRespDto = itemStorageMap.get(itemStorageQueryDto.getShopId() + "_" + itemStorageQueryDto.getSkuId());
                itemStorageResultDto.setAvaNum(itemStorageQueryRespDto.getAvaNum());
                result.add(itemStorageResultDto);
            }
        } else {
            ArrayList<TcbjAvilableReqDto> cargoStorageList = new ArrayList<TcbjAvilableReqDto>(storageBranchQueryReqDto.getItemStorageList().size());
            HashMap<Long, Object> shopWarehouseCodeMap = new HashMap<Long, Object>();
            Set<Long> shopIds = storageBranchQueryReqDto.getItemStorageList().stream().map(ItemStorageQueryDto::getShopId).collect(Collectors.toSet());
            if (shopIds.size() == 1) {
                WarehouseRespDto warehouseRespDto = this.inventoryService.queryWarehouseByShopId((Long)shopIds.iterator().next());
                Iterator warehouseCode = warehouseRespDto.getCode();
                shopWarehouseCodeMap.put(shopIds.iterator().next(), warehouseCode);
            } else {
                Map<Long, WarehouseRespDto> shopWarehouseMap = this.inventoryService.queryWarehousesByShopIds(shopIds);
                for (Long shopId : shopIds) {
                    String warehouseCode;
                    WarehouseRespDto warehouseRespDto = shopWarehouseMap.get(shopId);
                    String string = warehouseCode = warehouseRespDto == null ? null : warehouseRespDto.getCode();
                    if (StringUtils.isEmpty((CharSequence)warehouseCode)) {
                        throw new BizException("\u5e97\u94fa[" + shopId + "]\u5bf9\u5e94\u7684\u4ea7\u54c1\u4e3b\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
                    }
                    shopWarehouseCodeMap.put(shopId, warehouseCode);
                }
            }
            for (ItemStorageQueryDto itemStorageQueryDto : storageBranchQueryReqDto.getItemStorageList()) {
                TcbjAvilableReqDto tcbjAvilableReqDto = new TcbjAvilableReqDto();
                tcbjAvilableReqDto.setCargoCode(itemStorageQueryDto.getCargoCode());
                tcbjAvilableReqDto.setWarehouseCode((String)shopWarehouseCodeMap.get(itemStorageQueryDto.getShopId()));
                cargoStorageList.add(tcbjAvilableReqDto);
            }
            TcbjAvilableReqDto cargoStorageQueryReqDto = new TcbjAvilableReqDto();
            cargoStorageQueryReqDto.setList(cargoStorageList.stream().collect(Collectors.toSet()).stream().collect(Collectors.toList()));
            cargoStorageQueryReqDto.setWarehouseCode(((TcbjAvilableReqDto)cargoStorageList.get(0)).getWarehouseCode());
            logger.info("[\u6279\u91cf\u67e5\u8be2\u5e93\u5b58\u4e2d\u5fc3\u8d27\u54c1\u5e93\u5b58\u53c2\u6570]>>>{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)cargoStorageQueryReqDto));
            RestResponse cargoStorageQueryRestResp = this.tcbjInventoryApi.avilableYingXiaoYun(cargoStorageQueryReqDto);
            List cargoStorageQueryRespDto = (List)RestResponseHelper.extractData((RestResponse)cargoStorageQueryRestResp);
            logger.info("[\u6279\u91cf\u67e5\u8be2\u5e93\u5b58\u4e2d\u5fc3\u8d27\u54c1\u5e93\u5b58\u7ed3\u679c]>>>{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)cargoStorageQueryRespDto));
            Map<String, Double> availableNumMap = cargoStorageQueryRespDto.stream().collect(Collectors.groupingBy(e -> e.getWarehouseCode() + "_" + e.getCargoCode(), Collectors.summingDouble(TcbjAvilableRespDto::getAvailable)));
            for (ItemStorageQueryDto itemStorageQueryDto : storageBranchQueryReqDto.getItemStorageList()) {
                ItemStorageQueryDto itemStorageResultDto = new ItemStorageQueryDto();
                itemStorageResultDto.setShopId(itemStorageQueryDto.getShopId());
                itemStorageResultDto.setSkuId(itemStorageQueryDto.getSkuId());
                itemStorageResultDto.setCargoCode(itemStorageQueryDto.getCargoCode());
                String warehouseCode = (String)shopWarehouseCodeMap.get(itemStorageQueryDto.getShopId());
                Double availableNum = availableNumMap.getOrDefault(warehouseCode + "_" + itemStorageQueryDto.getCargoCode(), 0.0);
                itemStorageResultDto.setAvaNum(Long.valueOf(availableNum.longValue()));
                result.add(itemStorageResultDto);
            }
        }
        return result;
    }

    public PageInfo<ItemInfoRespDto> pageQuery(ItemQueryReqDto itemQueryReqDto, Integer pageNum, Integer pageSize) {
        if (null == itemQueryReqDto) {
            itemQueryReqDto = new ItemQueryReqDto();
            itemQueryReqDto.setType(ItemConstant.ORDINARY_ITEM);
        }
        if (StringUtils.isNotEmpty((CharSequence)itemQueryReqDto.getKeyword())) {
            itemQueryReqDto.setKeyword("%" + itemQueryReqDto.getKeyword() + "%");
        }
        itemQueryReqDto.setInstanceId(this.context.instanceId());
        itemQueryReqDto.setTenantId(this.context.tenantId());
        String filter = com.alibaba.fastjson.JSON.toJSONString((Object)itemQueryReqDto);
        RestResponse restResponse = this.itemQueryApi.queryByKeyword(filter, pageNum, pageSize);
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        PageInfo pageInfo = new PageInfo();
        if (null == itemSearchRespDto || null == itemSearchRespDto.getPageInfo() || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemSearchRespDto.getPageInfo().getList())) {
            return pageInfo;
        }
        List<ItemInfoRespDto> list = this.getItemInfoRespDtoList(itemSearchRespDto.getPageInfo().getList());
        BeanUtils.copyProperties((Object)itemSearchRespDto.getPageInfo(), (Object)pageInfo);
        pageInfo.setList(list);
        return pageInfo;
    }

    public PageInfo<ItemInfoRespDto> queryItemPageForOften(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        itemDepthReqDto.setCountType("1");
        PageInfo pageInfo = new PageInfo();
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        BeanCopierUtils.copy((Object)itemDepthReqDto, (Object)itemSearchQueryReqDto);
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        if (itemDepthReqDto.getBusType() == null) {
            itemSearchQueryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)itemDepthReqDto.getDirIds())) {
            String[] dirIds = StringUtils.split((String)itemDepthReqDto.getDirIds(), (String)",");
            List dirIdList = Arrays.stream(dirIds).map(Long::new).collect(Collectors.toList());
            itemSearchQueryReqDto.setDirIds(dirIdList);
        }
        itemSearchQueryReqDto.setSearch(Boolean.valueOf(false));
        CountItemSalesReqDto countItemSalesReqDto = new CountItemSalesReqDto();
        List<Long> customerIdList = this.getCustomerIdListByUserId(this.context.userId());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerIdList)) {
            return new PageInfo();
        }
        countItemSalesReqDto.setUserIdList(customerIdList);
        countItemSalesReqDto.setInstanceId(this.context.instanceId());
        countItemSalesReqDto.setTenantId(this.context.tenantId());
        Calendar c = Calendar.getInstance();
        Date endTime = c.getTime();
        countItemSalesReqDto.setTimeEnd(endTime);
        if ("1".equals(itemDepthReqDto.getCountType())) {
            c.add(2, -6);
        } else {
            c.add(2, -3);
        }
        Date startTime = c.getTime();
        countItemSalesReqDto.setTimeStart(startTime);
        countItemSalesReqDto.setCountType(itemDepthReqDto.getCountType());
        List itemSalesList = (List)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.countItemSalesForUser(com.alibaba.fastjson.JSON.toJSONString((Object)countItemSalesReqDto)));
        ArrayList itemIds = Lists.newArrayList();
        HashMap<Long, Long> countItemMap = new HashMap<Long, Long>();
        for (CountItemSalesRespDto countItemSalesRespDto : itemSalesList) {
            itemIds.add(countItemSalesRespDto.getItemId());
            countItemMap.put(countItemSalesRespDto.getItemId(), countItemSalesRespDto.getSaleCount());
        }
        itemSearchQueryReqDto.setItemIds((List)itemIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemIds)) {
            boolean customerBuyScopeLimit;
            if (Objects.isNull(itemDepthReqDto.getShopId())) {
                List shopIdList = this.bshopService.customerShop().stream().map(ShopDto::getId).collect(Collectors.toList());
                if (CollUtil.isEmpty((Collection)itemSearchQueryReqDto.getShopIds())) {
                    itemSearchQueryReqDto.setShopIds(shopIdList);
                } else {
                    itemSearchQueryReqDto.getShopIds().addAll(shopIdList);
                }
            }
            if (!(customerBuyScopeLimit = this.customerBuyScopeService.setCustomerBuyScopeLimit(itemDepthReqDto, itemSearchQueryReqDto, null))) {
                return pageInfo;
            }
            itemSearchQueryReqDto.setStatus(Integer.valueOf(1));
            logger.info("[\u5546\u54c1\u641c\u7d22] >>> \u5546\u54c1\u67e5\u8be2\u5217\u8868\u53c2\u6570[{}]", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)itemSearchQueryReqDto));
            ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, pageNum, pageSize));
            if (null == itemSearchRespDto || !PageInfoUtil.isNotEmpty(itemSearchRespDto.getPageInfo())) {
                return pageInfo;
            }
            List<ItemInfoRespDto> list = this.convertToItemInfoRespDto(itemSearchRespDto.getPageInfo().getList());
            BeanUtils.copyProperties((Object)itemSearchRespDto.getPageInfo(), (Object)pageInfo);
            pageInfo.setList(list);
            return pageInfo;
        }
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemIds.size())));
        if (null == itemSearchRespDto || !PageInfoUtil.isNotEmpty(itemSearchRespDto.getPageInfo())) {
            return pageInfo;
        }
        HashMap<Long, Object> itemRespMap = new HashMap<Long, Object>();
        for (Object itemRespDto : itemSearchRespDto.getPageInfo().getList()) {
            Long saleCount = (Long)countItemMap.get(itemRespDto.getId());
            itemRespDto.setPurchaseNum(saleCount);
            itemRespMap.put(itemRespDto.getId(), itemRespDto);
        }
        ArrayList newItemList = Lists.newArrayList();
        for (Long itemId : itemIds) {
            ItemRespDto itemDto = (ItemRespDto)itemRespMap.get(itemId);
            if (!Objects.nonNull(itemDto)) continue;
            newItemList.add(itemDto);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)newItemList)) {
            return pageInfo;
        }
        int startPage = (pageNum - 1) * pageSize + 1;
        ArrayList<ItemRespDto> respDtoList = new ArrayList<ItemRespDto>(pageSize);
        for (int i = startPage; i <= pageNum * pageSize; ++i) {
            if (newItemList.size() < i || i - 1 < 0) continue;
            respDtoList.add((ItemRespDto)newItemList.get(i - 1));
        }
        List<ItemInfoRespDto> list = this.convertToItemInfoRespDto(respDtoList);
        pageInfo.setList(list);
        pageInfo.setTotal((long)newItemList.size());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setPageNum(pageNum.intValue());
        return pageInfo;
    }

    public PageInfo<ItemSkuInfoDto> queryItemPageForNear(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        String brandIdStr;
        String subTypeListStr;
        itemDepthReqDto.setCountType("2");
        PageInfo pageInfo = new PageInfo();
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        BeanCopierUtils.copy((Object)itemDepthReqDto, (Object)itemSearchQueryReqDto);
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        if (itemDepthReqDto.getBusType() == null) {
            itemSearchQueryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        if (StrUtil.isNotBlank((CharSequence)(subTypeListStr = itemDepthReqDto.getSubTypeList()))) {
            List subTypeList = Arrays.stream(subTypeListStr.split(",")).map(value -> Integer.valueOf(value)).collect(Collectors.toList());
            itemSearchQueryReqDto.setSubTypeList(subTypeList);
        }
        if (StrUtil.isNotBlank((CharSequence)(brandIdStr = itemDepthReqDto.getBrandIds()))) {
            List brandIds = Arrays.stream(brandIdStr.split(",")).map(value -> Long.valueOf(value)).collect(Collectors.toList());
            itemSearchQueryReqDto.setInBrandIds(brandIds);
        }
        if (StringUtils.isNotBlank((CharSequence)itemDepthReqDto.getDirIds())) {
            String[] dirIds = StringUtils.split((String)itemDepthReqDto.getDirIds(), (String)",");
            List dirIdList = Arrays.stream(dirIds).map(Long::new).collect(Collectors.toList());
            itemSearchQueryReqDto.setDirIds(dirIdList);
        }
        itemSearchQueryReqDto.setSearch(Boolean.valueOf(false));
        CountItemSalesReqDto countItemSalesReqDto = new CountItemSalesReqDto();
        List<Long> customerIdList = this.getCustomerIdListByUserId(this.context.userId());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerIdList)) {
            return new PageInfo();
        }
        countItemSalesReqDto.setUserIdList(customerIdList);
        countItemSalesReqDto.setInstanceId(this.context.instanceId());
        countItemSalesReqDto.setTenantId(this.context.tenantId());
        Calendar c = Calendar.getInstance();
        Date endTime = c.getTime();
        countItemSalesReqDto.setTimeEnd(endTime);
        c.add(2, -3);
        Date startTime = c.getTime();
        countItemSalesReqDto.setTimeStart(startTime);
        countItemSalesReqDto.setCountType(itemDepthReqDto.getCountType());
        List itemSalesList = (List)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.countItemSalesForUser(com.alibaba.fastjson.JSON.toJSONString((Object)countItemSalesReqDto)));
        HashMap<Long, Long> countItemMap = new HashMap<Long, Long>();
        for (CountItemSalesRespDto countItemSalesRespDto : itemSalesList) {
            if (countItemMap.containsKey(countItemSalesRespDto.getItemId())) {
                countItemMap.put(countItemSalesRespDto.getItemId(), (Long)countItemMap.get(countItemSalesRespDto.getItemId()) + countItemSalesRespDto.getSaleCount());
                continue;
            }
            countItemMap.put(countItemSalesRespDto.getItemId(), countItemSalesRespDto.getSaleCount());
        }
        logger.info("\u67e5\u8be2\u5230\u7684\u5546\u54c1\u8d2d\u4e70\u6b21\u6570\u5185\u5bb9\u4e3a[{}]", countItemMap);
        List skuIdList = itemSalesList.stream().map(item -> item.getItemId()).collect(Collectors.toList());
        Set shopIdList = itemSalesList.stream().map(CountItemSalesRespDto::getShopId).collect(Collectors.toSet());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuIdList)) {
            return pageInfo;
        }
        itemSearchQueryReqDto.setShopIds((List)Lists.newArrayList(shopIdList));
        RestResponse skuRestResp = this.itemSkuQueryApi.queryBySkuId(skuIdList);
        List skuRespList = (List)RestResponseHelper.extractData((RestResponse)skuRestResp);
        HashSet itemIds = Sets.newHashSet();
        for (ItemSkuRespDto itemSkuRespDto : skuRespList) {
            itemIds.add(itemSkuRespDto.getItemId());
        }
        itemSearchQueryReqDto.setItemIds((List)Lists.newArrayList((Iterable)itemIds));
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemIds.size())));
        if (null == itemSearchRespDto || !PageInfoUtil.isNotEmpty(itemSearchRespDto.getPageInfo())) {
            return pageInfo;
        }
        HashMap<Long, ItemInfoRespDto> itemMap = new HashMap<Long, ItemInfoRespDto>();
        List<ItemSkuRespDto> skuList = this.convertToSkuInfoRespDto(itemSearchRespDto.getPageInfo().getList(), itemMap);
        Map<String, ItemSkuRespDto> skuMap = skuList.stream().collect(Collectors.toMap(sku -> sku.getShopId() + "_" + sku.getId(), o -> o, (o1, o2) -> o1));
        ArrayList newSkuList = Lists.newArrayList();
        if (ObjectUtil.isNotEmpty((Object)itemDepthReqDto.getOrderByDate())) {
            if (itemDepthReqDto.getOrderByDate().equals(1)) {
                itemSalesList = itemSalesList.stream().sorted(Comparator.comparing(CountItemSalesRespDto::getCreateTime)).collect(Collectors.toList());
            } else if (itemDepthReqDto.getOrderByDate().equals(2)) {
                itemSalesList = itemSalesList.stream().sorted(Comparator.comparing(CountItemSalesRespDto::getCreateTime).reversed()).collect(Collectors.toList());
            }
        }
        for (CountItemSalesRespDto sku2 : itemSalesList) {
            ItemSkuRespDto itemSkuRespDto = skuMap.get(sku2.getShopId() + "_" + sku2.getItemId());
            if (!Objects.nonNull(itemSkuRespDto)) continue;
            newSkuList.add(sku2);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)newSkuList)) {
            return pageInfo;
        }
        List<Object> skuInfoList = Lists.newArrayList();
        for (CountItemSalesRespDto sku3 : newSkuList) {
            ItemSkuInfoDto skuInfo = new ItemSkuInfoDto();
            ItemSkuRespDto itemSkuRespDto = skuMap.get(sku3.getShopId() + "_" + sku3.getItemId());
            skuInfo.setBalance(itemSkuRespDto.getBalance());
            skuInfo.setItemId(itemSkuRespDto.getItemId());
            skuInfo.setSkuId(itemSkuRespDto.getId());
            skuInfo.setSellPrice(itemSkuRespDto.getPrice());
            skuInfo.setAttr(itemSkuRespDto.getAttr());
            skuInfo.setMinPackage(itemSkuRespDto.getMinPackage());
            skuInfo.setStockDisplay(itemSkuRespDto.getStockDisplay());
            skuInfo.setLimitMin(itemSkuRespDto.getLimitMin());
            skuInfo.setLimitMinMode(itemSkuRespDto.getLimitMinMode());
            skuInfo.setMultipleStatus(itemSkuRespDto.getMultipleStatus());
            ItemInfoRespDto itemInfoRespDto = (ItemInfoRespDto)itemMap.get(skuInfo.getItemId());
            skuInfo.setItemName(itemInfoRespDto.getName());
            skuInfo.setShopId(itemInfoRespDto.getShopId());
            skuInfo.setImgPath(itemInfoRespDto.getMainPic());
            skuInfo.setWholesaleLimitMin(itemInfoRespDto.getWholesaleLimitMin());
            skuInfo.setWholesaleLimitMax(itemInfoRespDto.getWholesaleLimitMax());
            skuInfo.setUnit(itemInfoRespDto.getUnit());
            skuInfo.setUnitName(itemInfoRespDto.getUnitName());
            skuInfo.setSubType(itemInfoRespDto.getSubType());
            skuInfo.setItemCode(itemInfoRespDto.getCode());
            Long count = (Long)countItemMap.get(skuInfo.getSkuId());
            skuInfo.setPurchaseNum(count);
            logger.info("\u5546\u54c1id=[{}]\u8d2d\u4e70\u6b21\u6570\u5185\u5bb9\u4e3a[{}]", (Object)skuInfo.getSkuId(), (Object)count);
            skuInfoList.add(skuInfo);
        }
        if (ObjectUtil.isNotEmpty((Object)itemDepthReqDto.getOrderByTimes())) {
            if (itemDepthReqDto.getOrderByTimes().equals(1)) {
                skuInfoList = skuInfoList.stream().sorted(Comparator.comparing(ItemSkuInfoDto::getPurchaseNum)).collect(Collectors.toList());
            } else if (itemDepthReqDto.getOrderByTimes().equals(2)) {
                skuInfoList = skuInfoList.stream().sorted(Comparator.comparing(ItemSkuInfoDto::getPurchaseNum).reversed()).collect(Collectors.toList());
            }
        }
        int startPage = (pageNum - 1) * pageSize + 1;
        ArrayList<ItemSkuInfoDto> respDtoList = new ArrayList<ItemSkuInfoDto>(pageSize);
        for (int i = startPage; i <= pageNum * pageSize; ++i) {
            if (skuInfoList.size() < i || i - 1 < 0) continue;
            respDtoList.add((ItemSkuInfoDto)skuInfoList.get(i - 1));
        }
        try {
            this.setSkuPolicyPriceInfo(respDtoList, customerIdList);
        }
        catch (Exception e) {
            logger.error("[\u4ef7\u683c\u67e5\u8be2] >>> \u67e5\u4ef7\u5931\u8d25", (Throwable)e);
        }
        this.getActivityForNearBuy(respDtoList, customerIdList);
        pageInfo.setList(respDtoList);
        pageInfo.setTotal((long)skuInfoList.size());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setPageNum(pageNum.intValue());
        return pageInfo;
    }

    private void getActivityForNearBuy(List<ItemSkuInfoDto> respDtoList, List<Long> customerIdList) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(respDtoList)) {
            List activityShopIds = respDtoList.stream().map(e -> e.getShopId()).distinct().collect(Collectors.toList());
            List activityItemIds = respDtoList.stream().map(e -> e.getItemId()).distinct().collect(Collectors.toList());
            ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
            queryReqDto.setShopIdList(activityShopIds);
            queryReqDto.setItemIdList(activityItemIds);
            queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ORDER.getKey(), ActivityDimensionEnum.COUPON.getKey()}));
            queryReqDto.setDisplay(Integer.valueOf(1));
            Map<String, List<ItemActivityTagDto>> tagMaps = this.activityService.queryItemActivityTags(queryReqDto);
            HashSet activityIdSet = Sets.newHashSet();
            for (List<ItemActivityTagDto> itemActivityTagDtoList : tagMaps.values()) {
                for (ItemActivityTagDto itemActivityTagDto : itemActivityTagDtoList) {
                    activityIdSet.add(itemActivityTagDto.getActivityId());
                }
            }
            RemainingStockBatchReqDto reqDto = new RemainingStockBatchReqDto();
            ArrayList<ActivityStockReqDto> activityStockList = new ArrayList<ActivityStockReqDto>();
            for (ItemSkuInfoDto itemInfoRespDto : respDtoList) {
                String key = String.valueOf(itemInfoRespDto.getShopId()) + itemInfoRespDto.getItemId();
                if (!tagMaps.containsKey(key)) continue;
                ActivityStockReqDto stockReqDto = new ActivityStockReqDto();
                ArrayList<Long> activityIds = new ArrayList<Long>();
                List<ItemActivityTagDto> itemActivityTagDtos = tagMaps.get(key);
                for (ItemActivityTagDto itemActivityTagDto : itemActivityTagDtos) {
                    if (!ActivityDimensionEnum.ORDER.getKey().equals(itemActivityTagDto.getDimension())) continue;
                    activityIds.add(itemActivityTagDto.getActivityId());
                }
                stockReqDto.setItemId(itemInfoRespDto.getItemId());
                stockReqDto.setShopId(itemInfoRespDto.getShopId());
                stockReqDto.setActivityIds(activityIds);
                activityStockList.add(stockReqDto);
            }
            reqDto.setActivityStockList(activityStockList);
            RestResponse activityRemainingStockBatch = this.itemActivityStockApi.getActivityRemainingStockBatch(reqDto);
            RemainingStockBatchRespDto respDto = (RemainingStockBatchRespDto)RestResponseHelper.extractData((RestResponse)activityRemainingStockBatch);
            Map activityListMap = respDto.getActivityListMap();
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setIdList(customerIdList);
            RestResponse listRestResp = this.customerExtQueryApi.queryByList(com.alibaba.fastjson.JSON.toJSONString((Object)searchReqDto));
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
            TargetCustomerReqDto targetCustomerReqDto = new TargetCustomerReqDto();
            targetCustomerReqDto.setActivityIds((List)Lists.newArrayList((Iterable)activityIdSet));
            targetCustomerReqDto.setCustomerInfoList(customerRespDtos);
            List targetActivityIds = (List)this.itemActivityStockApi.validateTargetCustomersAndMallType(targetCustomerReqDto).getData();
            for (ItemSkuInfoDto itemSkuInfoDto : respDtoList) {
                String activityKey = String.valueOf(itemSkuInfoDto.getShopId()) + itemSkuInfoDto.getItemId();
                if (!tagMaps.containsKey(activityKey)) continue;
                List<ItemActivityTagDto> tagDtos = tagMaps.get(activityKey);
                List enableActivityIds = (List)activityListMap.get(itemSkuInfoDto.getShopId() + "_" + itemSkuInfoDto.getItemId());
                tagDtos.removeIf(tagDtox -> {
                    if (ActivityDimensionEnum.COUPON.getKey().equals(tagDtox.getDimension()) && !targetActivityIds.contains(tagDtox.getActivityId())) {
                        return true;
                    }
                    if (!ActivityDimensionEnum.ORDER.getKey().equals(tagDtox.getDimension())) {
                        return false;
                    }
                    return !targetActivityIds.contains(tagDtox.getActivityId()) || !enableActivityIds.contains(tagDtox.getActivityId());
                });
                itemSkuInfoDto.setTags(tagDtos);
            }
        }
    }

    public void setSkuPolicyPriceInfo(List<ItemSkuInfoDto> respDtoList, List<Long> customerIdList) {
        if (CollUtil.isEmpty(respDtoList) || CollUtil.isEmpty(customerIdList)) {
            return;
        }
        CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
        List skuPriceReqDtos = respDtoList.stream().map(skuInfo -> {
            CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
            skuPriceReqDto.setSkuId(skuInfo.getSkuId());
            skuPriceReqDto.setItemId(skuInfo.getItemId());
            skuPriceReqDto.setShopId(skuInfo.getShopId());
            return skuPriceReqDto;
        }).collect(Collectors.toList());
        communalPriceQueryReqDto.setSkuList(skuPriceReqDtos);
        communalPriceQueryReqDto.setCustomerIds(customerIdList);
        List itemPolicyPriceRespDtos = (List)this.ibItemPriceService.getItemPrice(communalPriceQueryReqDto).getData();
        if (CollUtil.isEmpty((Collection)itemPolicyPriceRespDtos)) {
            return;
        }
        Map priceMap = itemPolicyPriceRespDtos.stream().collect(Collectors.toMap(skuInfo -> {
            String key = skuInfo.getShopId() + "-" + skuInfo.getSkuId();
            return key;
        }, Function.identity(), (o1, o2) -> o2));
        for (ItemSkuInfoDto itemSkuInfoDto : respDtoList) {
            ItemPolicyPriceRespDto itemPolicyPriceRespDto;
            String key = itemSkuInfoDto.getShopId() + "-" + itemSkuInfoDto.getSkuId();
            if (!priceMap.containsKey(key) || (itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)priceMap.get(key)) == null) continue;
            Integer buyNum = itemSkuInfoDto.getShoppingCartItemNum();
            BigDecimal price = this.itemPriceHelper.getDefaultMatchPrice(itemPolicyPriceRespDto, buyNum);
            itemSkuInfoDto.setSellPrice(price);
        }
    }

    @Deprecated
    public Long getCustomerIdByUserId(Long userId) {
        String key = "user_customerId_" + this.context.userId();
        Long customerId = (Long)this.cacheService.getCache(key, Long.class);
        if (null == customerId) {
            RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(1));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            Assert.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList()), (String)"\u5f53\u524d\u767b\u5f55\u4eba\u672a\u7ed1\u5b9a\u7ec4\u7ec7", (Object[])new Object[0]);
            Long orgInfoId = ((OrganizationDto)pageInfo.getList().get(0)).getId();
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setOrgInfoIds((List)Lists.newArrayList((Object[])new Long[]{orgInfoId}));
            searchReqDto.setTenantId(this.context.tenantId());
            RestResponse listRestResp = this.customerExtQueryApi.queryByList(com.alibaba.fastjson.JSON.toJSONString((Object)searchReqDto));
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                throw new BizException("\u5ba2\u6237\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            customerId = ((CustomerRespDto)customerRespDtos.get(0)).getId();
            this.cacheService.add(key, (Object)customerId, 604800);
        }
        return customerId;
    }

    public List<Long> getCustomerIdListByUserId(Long userId) {
        RestResponse listRestResponse = this.customerExtQueryApi.queryCustomerIdsByUserId(userId);
        List customerIdList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerIdList)) {
            throw new BizException("\u5f53\u524d\u767b\u5f55\u4eba\u5bf9\u5e94\u7684\u5ba2\u6237\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return customerIdList;
    }

    public List<ItemInfoRespDto> getItemTags(List<ItemInfoRespDto> itemInfoRespDtos, Long customerId) {
        this.setItemActivityInfo(itemInfoRespDtos, false, false, Objects.isNull(customerId) ? null : Lists.newArrayList((Object[])new Long[]{customerId}));
        return itemInfoRespDtos;
    }

    public Boolean isOnshelf(Long shopId, Long itemId, Long skuId) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemId);
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setSkuId(skuId);
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(com.alibaba.fastjson.JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1)).getData();
        return null != pageInfo && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList());
    }

    public PageInfo<ItemInfoRespDto> queryItemPageDepth(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        CustomerItemAuthInfo customerItemAuthInfo;
        String brandIdStr;
        PageInfo pageInfo = new PageInfo();
        Boolean activitySearch = false;
        if (null != itemDepthReqDto.getActivityId() || null != itemDepthReqDto.getCouponTpId()) {
            activitySearch = true;
            pageSize = pageSize == null ? 1000 : pageSize;
        }
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        BeanCopierUtils.copy((Object)itemDepthReqDto, (Object)itemSearchQueryReqDto);
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        if (itemDepthReqDto.getBusType() == null) {
            itemSearchQueryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        if (ItemBusTypeEnum.INTEGRAL.getType().equals(itemDepthReqDto.getItemType())) {
            itemDepthReqDto.setBusType(ItemBusTypeEnum.INTEGRAL.getType());
        }
        List itemIds = null;
        if (StringUtils.isNotBlank((CharSequence)itemDepthReqDto.getItemIds())) {
            String[] itemIdArr = StringUtils.split((String)itemDepthReqDto.getItemIds(), (String)",");
            itemIds = Arrays.stream(itemIdArr).map(Long::new).collect(Collectors.toList());
        }
        List<Object> shopIds = null;
        List<ShopItemDto> shopItems = null;
        logger.info("activitySearch==>{}", (Object)activitySearch);
        if (activitySearch.booleanValue()) {
            shopItems = this.activityService.queryShopItems(itemDepthReqDto.getActivityId(), itemDepthReqDto.getCouponTpId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(shopItems)) {
                return pageInfo;
            }
            itemIds = shopItems.stream().map(ShopItemDto::getItemId).collect(Collectors.toList());
            shopIds = shopItems.stream().map(ShopItemDto::getShopId).collect(Collectors.toList());
        } else if (itemDepthReqDto.getShopId() != null) {
            shopIds = Lists.newArrayList((Object[])new Long[]{itemDepthReqDto.getShopId()});
        }
        itemSearchQueryReqDto.setItemIds(itemIds);
        itemSearchQueryReqDto.setShopIds(shopIds);
        if (Objects.isNull(itemDepthReqDto.getShopId())) {
            List shopIdList = this.bshopService.customerShop().stream().map(ShopDto::getId).collect(Collectors.toList());
            if (CollUtil.isEmpty((Collection)itemSearchQueryReqDto.getShopIds())) {
                itemSearchQueryReqDto.setShopIds(shopIdList);
                shopIds = shopIdList;
            } else if (activitySearch.booleanValue()) {
                itemSearchQueryReqDto.getShopIds().retainAll(shopIdList);
                if (CollUtil.isEmpty((Collection)itemSearchQueryReqDto.getShopIds())) {
                    logger.info("[\u5546\u54c1\u641c\u7d22] >>> \u6d3b\u52a8\u9650\u5236\u7684\u5e97\u94fa\u8ddf\u7528\u6237\u53ef\u4e70\u7684\u5e97\u94fa\u65e0\u4ea4\u96c6\uff0c\u7528\u6237\u65e0\u53ef\u4e70\u5546\u54c1\u5217\u8868");
                    return pageInfo;
                }
            }
        }
        logger.info("itemSearchQueryReqDto==>{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)itemSearchQueryReqDto));
        if (itemSearchQueryReqDto.getShopId() == null && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getShopIds())) {
            return pageInfo;
        }
        if (itemSearchQueryReqDto.getShopIds() != null && itemSearchQueryReqDto.getShopIds().size() == 1) {
            itemSearchQueryReqDto.setShopId((Long)itemSearchQueryReqDto.getShopIds().get(0));
        } else {
            logger.warn("\u5e97\u94fa\u4fe1\u606f\u4e3a\u7a7a\u6216\u8005\u5e97\u94fa\u5b58\u5728\u591a\u6761\u6570\u636e");
        }
        String attachment = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        String sellerOrgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.sellerorgid");
        if (Objects.isNull(itemDepthReqDto.getCustomerId()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemDepthReqDto.getCustomerIdList())) {
            logger.info("\u5c0fb\u5bf9\u5e94\u7684\u7ec4\u7ec7id\u4e3a:{}", (Object)attachment);
            if (StringUtils.isNotBlank((CharSequence)attachment) && itemDepthReqDto.getShopId() != null && StringUtils.isEmpty((CharSequence)sellerOrgId)) {
                Long customerId = this.getCustomerIdListByMerchantIdAndOrgInfoId(Long.valueOf(attachment), itemDepthReqDto.getShopId());
                if (customerId == null) {
                    List<Long> customerIdList = this.getCustomerIdListByUserId(this.context.userId());
                    Assert.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(customerIdList), (String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u5ba2\u6237", (Object[])new Object[0]);
                    itemDepthReqDto.setCustomerIdList(customerIdList);
                } else {
                    itemDepthReqDto.setCustomerId(customerId);
                    itemDepthReqDto.setCustomerIdList((List)Lists.newArrayList((Object[])new Long[]{itemDepthReqDto.getCustomerId()}));
                }
            } else {
                List<Long> customerIdList = this.getCustomerIdListByUserId(this.context.userId());
                Assert.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(customerIdList), (String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u5ba2\u6237", (Object[])new Object[0]);
                itemDepthReqDto.setCustomerIdList(customerIdList);
            }
        } else if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemDepthReqDto.getCustomerIdList())) {
            itemDepthReqDto.setCustomerIdList((List)Lists.newArrayList((Object[])new Long[]{itemDepthReqDto.getCustomerId()}));
        }
        HashMap outSkuIdsMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)itemDepthReqDto.getDirIds())) {
            String[] dirIds = StringUtils.split((String)itemDepthReqDto.getDirIds(), (String)",");
            List dirIdList = Arrays.stream(dirIds).map(Long::new).collect(Collectors.toList());
            itemSearchQueryReqDto.setDirIds(dirIdList);
        }
        itemSearchQueryReqDto.setSearch(Boolean.valueOf(false));
        itemSearchQueryReqDto.setSubType(itemDepthReqDto.getSubType());
        String subTypeListStr = itemDepthReqDto.getSubTypeList();
        if (StrUtil.isNotBlank((CharSequence)subTypeListStr)) {
            List subTypeList = Arrays.stream(subTypeListStr.split(",")).map(value -> Integer.valueOf(value)).collect(Collectors.toList());
            itemSearchQueryReqDto.setSubTypeList(subTypeList);
        }
        if (StrUtil.isNotBlank((CharSequence)(brandIdStr = itemDepthReqDto.getBrandIds()))) {
            List brandIds = Arrays.stream(brandIdStr.split(",")).map(Long::valueOf).collect(Collectors.toList());
            itemSearchQueryReqDto.setInBrandIds(brandIds);
        }
        if (!(customerItemAuthInfo = this.customerBuyScopeService.setCustomerItemAuth(itemDepthReqDto, itemSearchQueryReqDto, outSkuIdsMap)).getState().booleanValue()) {
            return pageInfo;
        }
        Map<String, BigDecimal> inventoryMap = null;
        Integer inventoryFlag = itemDepthReqDto.getInventoryFlag();
        if (Objects.equals(inventoryFlag, 1)) {
            ArrayList itemIdList = Lists.newArrayList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemDepthReqDto.getSkuIdList())) {
                logger.info("itemSkuQueryApi.queryBySkuId\u67e5\u8be2\u6761\u4ef6skuId\u4fe1\u606f\u4e3a\u7a7a");
                return pageInfo;
            }
            List itemSkuRespDtoList = (List)this.itemSkuQueryApi.queryBySkuId(itemDepthReqDto.getSkuIdList()).getData();
            Map<String, Long> mapSku = itemSkuRespDtoList.stream().collect(Collectors.toMap(ItemSkuRespDto::getCode, ItemSkuRespDto::getItemId));
            ArrayList<String> cargoCodeList = new ArrayList<String>(mapSku.keySet());
            Long shopId = (Long)shopIds.stream().findFirst().get();
            Long customerId = ObjectUtil.isEmpty((Object)itemDepthReqDto.getCustomerId()) ? (Long)itemDepthReqDto.getCustomerIdList().stream().findFirst().get() : itemDepthReqDto.getCustomerId();
            ItemInventoryStrategyEnum itemInventoryStrategyEnum = this.itemInventoryStrategyHelper.strategyOfCustomerFlag(customerId, sellerOrgId);
            ItemInventoryStrategyService strategyService = ItemInventoryStrategyHelper.getStrategyService(itemInventoryStrategyEnum.getCode());
            List<CsLogicInventoryTotalRespDto> inventoryList = strategyService.getInventoryList((List<String>)cargoCodeList, shopId, customerId);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(inventoryList)) {
                return pageInfo;
            }
            List<Long> skuItemIdList = itemSkuRespDtoList.stream().map(ItemSkuRespDto::getItemId).collect(Collectors.toList());
            Map<Long, Long> itemIdToInventoryMap = this.bItemModuleHelper.queryInventoryControlRule(skuItemIdList, (Long)shopIds.iterator().next());
            inventoryMap = inventoryList.stream().collect(Collectors.toMap(CsLogicInventoryTotalRespDto::getCargoCode, CsLogicInventoryTotalRespDto::getAvailable));
            for (String cargoCode : inventoryMap.keySet()) {
                Long inventory;
                Long itemId = mapSku.get(cargoCode);
                if (Objects.nonNull(itemIdToInventoryMap) && !itemIdToInventoryMap.isEmpty() && null != (inventory = itemIdToInventoryMap.get(itemId))) {
                    BigDecimal inventoryBigDecimal = new BigDecimal(inventory);
                    BigDecimal available = Optional.ofNullable(inventoryMap.get(cargoCode)).orElse(BigDecimal.ZERO);
                    if (available.compareTo(inventoryBigDecimal) <= 0) continue;
                }
                itemIdList.add(itemId);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemIdList)) {
                itemSearchQueryReqDto.setItemIds((List)itemIdList);
            }
        }
        itemSearchQueryReqDto.setStatus(Integer.valueOf(1));
        logger.info("[\u5546\u54c1\u641c\u7d22] >>> \u5546\u54c1\u67e5\u8be2\u5217\u8868\u53c2\u6570[{}]", (Object)itemSearchQueryReqDto);
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, pageNum, pageSize));
        if (null == itemSearchRespDto || PageInfoUtil.isEmpty(itemSearchRespDto.getPageInfo())) {
            return pageInfo;
        }
        Integer deliveryType = this.checkDeliveryType(itemDepthReqDto.getCustomerId());
        List<ItemInfoRespDto> list = this.newConvertToItemInfoRespDto(itemSearchRespDto.getPageInfo().getList(), inventoryMap, deliveryType);
        if (ItemBusTypeEnum.ORDINARY.getType().equals(itemSearchQueryReqDto.getBusType()) && activitySearch.booleanValue() && Integer.valueOf(1).equals(itemDepthReqDto.getIsMakeUp())) {
            this.setItemActivityInfo(list, false, true, itemDepthReqDto.getCustomerIdList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            if (CollUtil.isNotEmpty(outSkuIdsMap)) {
                for (ItemInfoRespDto itemInfoRespDto : list) {
                    List outSkuIds = (List)outSkuIdsMap.get(itemInfoRespDto.getId());
                    List itemSkuList = itemInfoRespDto.getItemSkuList();
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)outSkuIds)) continue;
                    itemSkuList.removeIf(skuRespDto -> outSkuIds.contains(skuRespDto.getId()));
                }
            }
            Map shopSkuMap = customerItemAuthInfo.getShopSkuMap();
            if (Objects.nonNull(itemSearchQueryReqDto.getShopId()) && shopSkuMap.containsKey(itemSearchQueryReqDto.getShopId())) {
                Set skuIdSet = (Set)shopSkuMap.get(itemSearchQueryReqDto.getShopId());
                list.forEach(item -> item.setItemSkuList(item.getItemSkuList().stream().filter(skuInfo -> skuIdSet.contains(skuInfo.getId())).collect(Collectors.toList())));
            }
            HashSet unitIds = Sets.newHashSet();
            list.forEach(item -> {
                ItemSkuRespDto itemSkuRespDto;
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)item.getItemSkuList()) && Objects.nonNull((itemSkuRespDto = (ItemSkuRespDto)item.getItemSkuList().get(0)).getUnit())) {
                    unitIds.add(itemSkuRespDto.getUnit());
                    item.setUnit(itemSkuRespDto.getUnit());
                }
                item.setItemSkuSellState(CollUtil.isNotEmpty((Collection)item.getItemSkuList()));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)item.getTags())) {
                    item.setTagNum(Integer.valueOf(item.getTags().size()));
                } else {
                    item.setTagNum(Integer.valueOf(0));
                }
            });
            if (Objects.equals(itemDepthReqDto.getStockLimit(), 1)) {
                list.forEach(item -> {
                    if (item.isItemSkuSellState()) {
                        ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)item.getItemSkuList().get(0);
                        item.setItemSkuStockState(Objects.nonNull(itemSkuRespDto) && itemSkuRespDto.getBalance() > 0L);
                    } else {
                        item.setItemSkuStockState(Boolean.FALSE.booleanValue());
                    }
                });
            }
            if (Objects.equals(itemDepthReqDto.getActivityLimit(), 1)) {
                list.forEach(item -> {
                    if (item.isItemSkuSellState()) {
                        item.setItemActivityState(item.getTagNum() > 0);
                    } else {
                        item.setItemActivityState(Boolean.FALSE.booleanValue());
                    }
                });
            }
            Map<String, String> unitMap = this.getUnitMapByUnitIds(Lists.newArrayList((Iterable)unitIds));
            for (ItemInfoRespDto itemInfoRespDto : list) {
                if (!Objects.nonNull(itemInfoRespDto.getUnit())) continue;
                itemInfoRespDto.setUnitName(unitMap.get(itemInfoRespDto.getUnit()));
            }
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)itemSearchRespDto.getPageInfo(), (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList(list);
        this.setSkuOtherInfo((PageInfo<ItemInfoRespDto>)pageInfo);
        return pageInfo;
    }

    private Integer checkDeliveryType(Long customerId) {
        if (customerId == null) {
            return OrderDeliveryTypeEnum.SELLER.getType();
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(customerId));
        if (customerRespDto == null || !OrderDeliveryTypeEnum.FACTORY.getType().equals(customerRespDto.getDeliverMethod())) {
            return OrderDeliveryTypeEnum.SELLER.getType();
        }
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(customerRespDto.getMerchantId()));
        if (sellerRespDto == null || !Integer.valueOf(1).equals(sellerRespDto.getIsFactoryDelivery())) {
            return OrderDeliveryTypeEnum.SELLER.getType();
        }
        return OrderDeliveryTypeEnum.FACTORY.getType();
    }

    private List<ItemInfoRespDto> newConvertToItemInfoRespDto(List<ItemRespDto> itemRespDtos, Map<String, BigDecimal> inventoryMap, Integer deliveryType) {
        logger.info("[\u5206\u9875\u6570\u636e]\uff1a{}", itemRespDtos);
        ArrayList<ItemInfoRespDto> result = new ArrayList<ItemInfoRespDto>(itemRespDtos.size());
        HashSet<Long> unitIds = new HashSet<Long>(itemRespDtos.size());
        if (inventoryMap == null) {
            Set<String> cargoCodeSet = itemRespDtos.stream().collect(Collectors.groupingBy(ItemRespDto::getLongCode)).keySet();
            CsLogicInventoryTotalBatchQueryDto tcbjAvilableReqDto = new CsLogicInventoryTotalBatchQueryDto();
            tcbjAvilableReqDto.setCargoCodeList((List)Lists.newArrayList((Iterable)cargoCodeSet));
            WarehouseRespDto warehouseRespDto = this.inventoryService.queryWarehouseByShopId(itemRespDtos.get(0).getShopId());
            String warehouseCode = warehouseRespDto.getCode();
            tcbjAvilableReqDto.setWarehouseCode(warehouseCode);
            List inventoryList = (List)this.csLogicInventoryTotalQueryApi.queryWarehouseInventory(tcbjAvilableReqDto).getData();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)inventoryList)) {
                inventoryMap = inventoryList.stream().collect(Collectors.toMap(CsLogicInventoryTotalRespDto::getCargoCode, CsLogicInventoryTotalRespDto::getAvailable));
            }
        }
        for (ItemRespDto itemRespDto : itemRespDtos) {
            ItemSkuRespDto itemSkuRespDto;
            String[] split;
            ItemInfoRespDto itemInfoRespDto = new ItemInfoRespDto();
            itemInfoRespDto.setSellPrice(BigDecimal.ZERO);
            itemInfoRespDto.setMarkingOutPrice(BigDecimal.ZERO);
            BeanCopierUtils.copy((Object)itemRespDto, (Object)itemInfoRespDto);
            if (StringUtils.isNotEmpty((CharSequence)itemRespDto.getWholesaleLimitMin())) {
                String wholesaleLimitMin = itemRespDto.getWholesaleLimitMin();
                split = wholesaleLimitMin.split("\\.");
                itemInfoRespDto.setWholesaleLimitMin(split[0]);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemRespDto.getWholesaleLimitMax())) {
                String wholesaleLimitMax = itemRespDto.getWholesaleLimitMax();
                split = wholesaleLimitMax.split("\\.");
                itemInfoRespDto.setWholesaleLimitMax(split[0]);
            }
            itemInfoRespDto.setShelfType(itemRespDto.getShelfType());
            itemInfoRespDto.setItemId(itemRespDto.getId());
            if (Objects.isNull(itemInfoRespDto.getShopId())) {
                itemInfoRespDto.setShopId(((ItemShopRespDto)itemRespDto.getItemShopList().get(0)).getShopId());
            }
            List<ItemSkuRespDto> skuList = this.newFfilterOnSelfSkuAndModifyAndOther(itemInfoRespDto.getItemSkuList(), inventoryMap, itemInfoRespDto.getItemId(), itemInfoRespDto.getShopId(), itemRespDto.getItemShelfInfoList(), (CommonItemInfo)itemInfoRespDto);
            itemInfoRespDto.setItemSkuList(skuList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuList) && StringUtils.isNotEmpty((CharSequence)(itemSkuRespDto = (ItemSkuRespDto)skuList.get(0)).getUnit())) {
                unitIds.add(Long.valueOf(itemSkuRespDto.getUnit()));
            }
            itemInfoRespDto.setSellPrice(this.getMinPrice(skuList));
            itemInfoRespDto.setMinPrice(itemInfoRespDto.getSellPrice());
            itemInfoRespDto.setMaxPrice(this.getMaxPrice(skuList));
            itemInfoRespDto.setMarkingOutPrice(this.getMaxMktPrice(skuList));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemMediasList())) {
                itemInfoRespDto.setMainPic(((ItemMediasRespDto)itemRespDto.getItemMediasList().get(0)).getPath1());
            }
            itemInfoRespDto.setSaleCount(itemRespDto.getSalesCount());
            itemInfoRespDto.setItemSkuList(skuList);
            itemInfoRespDto.setDirId(itemRespDto.getDirId());
            itemInfoRespDto.setDirName(itemRespDto.getDirName());
            itemInfoRespDto.setItemSkuList(skuList);
            itemInfoRespDto.setDeliveryType(deliveryType);
            result.add(itemInfoRespDto);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(unitIds)) {
            List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
            Map<Long, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(UnitRespDto::getId, UnitRespDto::getName, (e1, e2) -> e1));
            for (ItemInfoRespDto itemInfo : result) {
                if (!StringUtils.isNotEmpty((CharSequence)itemInfo.getUnit())) continue;
                String unitName = unitNameMap.get(Long.valueOf(itemInfo.getUnit()));
                itemInfo.setUnitName(unitName);
            }
        }
        return result;
    }

    private <T extends ItemSkuRespDto> List<T> newFfilterOnSelfSkuAndModifyAndOther(List<T> orgSkuList, Map<String, BigDecimal> avaNumMap, Long itemId, Long shopId, List<ItemShelfRespDto> itemShelfInfoList, CommonItemInfo commonItemInfo) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemId);
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setStatus(Integer.valueOf(1));
        Object skuShelfMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemShelfInfoList)) {
            skuShelfMap = itemShelfInfoList.stream().collect(Collectors.groupingBy(itemShelfRespDto -> itemShelfRespDto.getShopId() + itemShelfRespDto.getSkuId().toString()));
        }
        if (skuShelfMap.size() == 0) {
            logger.error("\u65e0\u4e0a\u67b6\u4fe1\u606f{}\uff0c{}", (Object)itemId, (Object)shopId);
            return null;
        }
        HashedMap finalSkuShelfMap = skuShelfMap;
        return orgSkuList.stream().filter(arg_0 -> BitemServiceImpl.lambda$newFfilterOnSelfSkuAndModifyAndOther$25((Map)finalSkuShelfMap, shopId, arg_0)).map(arg_0 -> BitemServiceImpl.lambda$newFfilterOnSelfSkuAndModifyAndOther$26((Map)finalSkuShelfMap, shopId, avaNumMap, commonItemInfo, arg_0)).collect(Collectors.toList());
    }

    private Map<String, String> getUnitMapByUnitIds(ArrayList<String> unitIds) {
        RestResponse listRestResponse;
        List respDtoList;
        HashMap<String, String> unitMap = new HashMap<String, String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(unitIds) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(respDtoList = (List)(listRestResponse = this.unitQueryApi.queryByIds(StringUtils.join((Object[])unitIds.stream().filter(StringUtils::isNotEmpty).map(Long::valueOf).toArray(), (String)","))).getData()))) {
            for (UnitRespDto unitDto : respDtoList) {
                unitMap.put("" + unitDto.getId(), unitDto.getName());
            }
        }
        return unitMap;
    }

    private void filterSku(CustomerItemAuthInfo shopCustomerItemAuthInfo, CustomerItemAuthInfo customerItemAuthInfo, List<ItemInfoRespDto> list, ItemSearchQueryReqDto itemSearchQueryReqDto) {
        List shopIdList = itemSearchQueryReqDto.getShopIds();
        if (Objects.nonNull(shopCustomerItemAuthInfo)) {
            shopIdList = shopCustomerItemAuthInfo.getShopIdList();
        }
        if (!CollUtil.isNotEmpty((Collection)shopIdList) || shopIdList.size() <= 1 || !CollUtil.isNotEmpty((Collection)customerItemAuthInfo.getCustomerIdList()) || customerItemAuthInfo.getCustomerIdList().size() <= 1) {
            return;
        }
        logger.info("[\u5546\u54c1\u641c\u7d22] >>> \u5546\u54c1\u641c\u7d22\u51fa\u73b0\u591a\u5e97\u94fa\uff0c\u591a\u5ba2\u6237\u60c5\u51b5\uff0c\u8fdb\u884c sku \u8fc7\u6ee4");
        List customerItemAuthList = customerItemAuthInfo.getCustomerItemAuthList();
        Map customerSkuMap = customerItemAuthList.stream().collect(Collectors.groupingBy(CustomerBuyScopeRespDto::getCustomerId, Collectors.mapping(CustomerBuyScopeRespDto::getBusinessId, Collectors.toSet())));
        Map shopCustomerMap = this.customerBuyScopeService.getShopCustomerMap(shopIdList);
        if (CollUtil.isEmpty((Map)shopCustomerMap)) {
            return;
        }
        for (ItemInfoRespDto item : list) {
            if (!item.isItemSkuSellState()) continue;
            Long shopId = item.getShopId();
            List itemSkuList = item.getItemSkuList();
            if (Objects.isNull(shopId)) {
                item.setItemSkuSellState(false);
                continue;
            }
            if (!shopCustomerMap.containsKey(shopId)) {
                item.setItemSkuSellState(false);
                continue;
            }
            List customerIds = (List)shopCustomerMap.get(shopId);
            if (CollUtil.isEmpty((Collection)customerIds)) {
                item.setItemSkuSellState(false);
                continue;
            }
            for (Long customerId : customerIds) {
                if (!customerSkuMap.containsKey(customerId)) {
                    logger.info("[\u5546\u54c1\u641c\u7d22] >>> \u5ba2\u6237[{}]\u4e0d\u53ef\u8d2d\u4e70\u5e97\u94fa[{}]\u4e0b\u7684\u5546\u54c1[{}:{}]", new Object[]{customerId, shopId, item.getId(), item.getName()});
                    item.setItemSkuSellState(false);
                    continue;
                }
                ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)itemSkuList.get(0);
                Long skuId = itemSkuRespDto.getId();
                item.setItemSkuSellState(customerSkuMap.get(customerId).contains(skuId));
                if (item.isItemSkuSellState()) continue;
                logger.info("[\u5546\u54c1\u641c\u7d22] >>> \u5ba2\u6237[{}]\u4e0d\u53ef\u8d2d\u4e70\u5e97\u94fa[{}]\u4e0b\u65e0\u6388\u6743\u7684\u5546\u54c1[{}:{}]", new Object[]{customerId, shopId, item.getId(), item.getName()});
            }
        }
    }

    private void setSkuOtherInfo(ItemDetailInfoRespDto itemDetailInfoRespDto, Long shopId) {
        ItemBaseInfoRespDto itemBaseInfo = itemDetailInfoRespDto.getItemBaseInfo();
        List itemSkuList = itemBaseInfo.getItemSkuList();
        if (CollUtil.isEmpty((Collection)itemSkuList)) {
            return;
        }
        List skuIds = itemSkuList.stream().map(ItemSkuRespDto::getId).collect(Collectors.toList());
        ShelfQueryReqDto shelfQueryReqDto = new ShelfQueryReqDto();
        shelfQueryReqDto.setShopIds((List)ListUtil.toList((Object[])new Long[]{shopId}));
        shelfQueryReqDto.setSkuIds(skuIds);
        RestResponse listRestResponse = this.shelfQueryApi.queryShelfList(shelfQueryReqDto);
        List shelfQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map skuInfoMap = shelfQueryRespDtos.stream().filter(item -> Objects.nonNull(item.getShopId()) && Objects.nonNull(item.getSkuId())).collect(Collectors.toMap(item -> String.valueOf(item.getShopId()) + String.valueOf(item.getSkuId()), Function.identity(), (o1, o2) -> o2));
        itemSkuList.forEach(skuInfo -> {
            String key;
            Long skuId = skuInfo.getId();
            if (Objects.nonNull(skuId) && skuInfoMap.containsKey(key = String.valueOf(shopId) + String.valueOf(skuId))) {
                ShelfQueryRespDto shelfQueryRespDto = (ShelfQueryRespDto)skuInfoMap.get(key);
                skuInfo.setLimitMin(shelfQueryRespDto.getLimitMin());
                skuInfo.setLimitMinMode(shelfQueryRespDto.getLimitMinMode());
                skuInfo.setStockDisplay(shelfQueryRespDto.getStockDisplay());
                skuInfo.setMultipleStatus(shelfQueryRespDto.getMultipleStatus());
            }
        });
    }

    private void setSkuOtherInfo(PageInfo<ItemInfoRespDto> pageInfo) {
        List list = pageInfo.getList();
        HashSet<Long> shopIdSet = new HashSet<Long>();
        HashSet skuIdSet = new HashSet();
        for (ItemInfoRespDto item2 : list) {
            List itemSkuList = item2.getItemSkuList();
            if (CollUtil.isEmpty((Collection)itemSkuList)) continue;
            Long shopId = item2.getShopId();
            if (Objects.nonNull(shopId)) {
                shopIdSet.add(shopId);
            }
            itemSkuList.forEach(skuInfo -> {
                Long skuId = skuInfo.getId();
                if (Objects.nonNull(skuId)) {
                    skuIdSet.add(skuId);
                }
            });
        }
        if (!CollUtil.isNotEmpty(shopIdSet) || !CollUtil.isNotEmpty(skuIdSet)) {
            return;
        }
        ShelfQueryReqDto shelfQueryReqDto = new ShelfQueryReqDto();
        shelfQueryReqDto.setShopIds(new ArrayList(shopIdSet));
        shelfQueryReqDto.setSkuIds(new ArrayList(skuIdSet));
        RestResponse listRestResponse = this.shelfQueryApi.queryShelfList(shelfQueryReqDto);
        List shelfQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map skuInfoMap = shelfQueryRespDtos.stream().filter(item -> Objects.nonNull(item.getShopId()) && Objects.nonNull(item.getSkuId())).collect(Collectors.toMap(item -> String.valueOf(item.getShopId()) + String.valueOf(item.getSkuId()), Function.identity(), (o1, o2) -> o2));
        for (ItemInfoRespDto item3 : list) {
            Long shopId;
            List itemSkuList = item3.getItemSkuList();
            if (CollUtil.isEmpty((Collection)itemSkuList) || Objects.isNull(shopId = item3.getShopId())) continue;
            itemSkuList.forEach(skuInfo -> {
                String key;
                Long skuId = skuInfo.getId();
                if (Objects.nonNull(skuId) && skuInfoMap.containsKey(key = String.valueOf(shopId) + String.valueOf(skuId))) {
                    ShelfQueryRespDto shelfQueryRespDto = (ShelfQueryRespDto)skuInfoMap.get(key);
                    skuInfo.setLimitMin(shelfQueryRespDto.getLimitMin());
                    skuInfo.setLimitMinMode(shelfQueryRespDto.getLimitMinMode());
                    skuInfo.setStockDisplay(shelfQueryRespDto.getStockDisplay());
                    skuInfo.setMultipleStatus(shelfQueryRespDto.getMultipleStatus());
                }
            });
        }
    }

    public void setItemPolicyPriceInfo(List<ItemInfoRespDto> list) {
        List<Long> shopIds = list.stream().filter(e -> e.getShopId() != null).map(e -> e.getShopId()).distinct().collect(Collectors.toList());
        List<Long> matchCustomerIds = this.bItemModuleHelper.getCustomerIdsByUserIdAndShopId(this.context.userId(), shopIds);
        CommunalPriceQueryReqDto reqDto = new CommunalPriceQueryReqDto();
        reqDto.setCustomerIds(matchCustomerIds);
        reqDto.setPolicyDate(new Date());
        ArrayList skuPriceReqDtoList = new ArrayList();
        list.forEach(itemInfo -> {
            if (itemInfo.getItemSkuList() != null) {
                itemInfo.getItemSkuList().forEach(skuInfo -> {
                    CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                    skuPriceReqDto.setSkuId(skuInfo.getId());
                    skuPriceReqDto.setItemId(itemInfo.getItemId());
                    skuPriceReqDto.setShopId(itemInfo.getShopId());
                    skuPriceReqDto.setSkuSellPrice(skuInfo.getPrice());
                    skuPriceReqDtoList.add(skuPriceReqDto);
                });
            }
        });
        reqDto.setSkuList(skuPriceReqDtoList);
        List itemPolicyPriceRespDtos = (List)this.ibItemPriceService.getItemPrice(reqDto).getData();
        if (itemPolicyPriceRespDtos != null && !itemPolicyPriceRespDtos.isEmpty()) {
            Map<Long, List<ItemPolicyPriceRespDto>> itemPolicyMap = itemPolicyPriceRespDtos.stream().collect(Collectors.groupingBy(ItemPolicyPriceRespDto::getItemId));
            Map skuPriceMap = itemPolicyPriceRespDtos.stream().collect(Collectors.toMap(item -> item.getShopId() + "-" + item.getSkuId(), Function.identity(), (o1, o2) -> o2));
            list.forEach(itemInfo -> {
                List itemSkuPriceList = (List)itemPolicyMap.get(itemInfo.getItemId());
                itemInfo.setItemSkuPolicyPriceList(itemSkuPriceList);
                if (CollUtil.isEmpty((Collection)itemSkuPriceList)) {
                    if (itemInfo.getItemSkuList() != null) {
                        itemInfo.setSellPrice(null);
                        itemInfo.setMinPrice(null);
                        itemInfo.setMaxPrice(null);
                        itemInfo.setMarkingOutPrice(null);
                        for (ItemSkuRespDto skuInfo : itemInfo.getItemSkuList()) {
                            skuInfo.setPrice(null);
                        }
                    }
                    return;
                }
                BigDecimal curPrice = itemInfo.getMinPrice();
                BigDecimal itemSkuMinPrice = this.itemPriceHelper.getItemSkuPolicyMinPrice(itemSkuPriceList);
                BigDecimal itemSkuMaxPrice = this.itemPriceHelper.getItemSkuPolicyMaxPrice(itemSkuPriceList);
                itemInfo.setMinPrice(itemSkuMinPrice);
                itemInfo.setMaxPrice(itemSkuMaxPrice);
                if (itemInfo.getItemSkuList() != null) {
                    for (ItemSkuRespDto skuInfo : itemInfo.getItemSkuList()) {
                        String key = skuInfo.getShopId() + "-" + skuInfo.getId();
                        if (!skuPriceMap.containsKey(key)) {
                            itemInfo.setSellPrice(null);
                            itemInfo.setMinPrice(null);
                            itemInfo.setMaxPrice(null);
                            itemInfo.setMarkingOutPrice(null);
                            skuInfo.setPrice(null);
                            continue;
                        }
                        ItemPolicyPriceRespDto itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)skuPriceMap.get(key);
                        Integer buyNum = skuInfo.getShoppingCartItemNum();
                        BigDecimal price = this.itemPriceHelper.getDefaultMatchPrice(itemPolicyPriceRespDto, buyNum);
                        skuInfo.setPrice(price);
                        itemInfo.setSellPrice(price);
                    }
                }
            });
        } else {
            list.forEach(itemInfo -> {
                itemInfo.setSellPrice(null);
                itemInfo.setMinPrice(null);
                itemInfo.setMaxPrice(null);
                itemInfo.setMarkingOutPrice(null);
                if (itemInfo.getItemSkuList() != null) {
                    for (ItemSkuRespDto skuInfo : itemInfo.getItemSkuList()) {
                        skuInfo.setPrice(null);
                    }
                }
            });
        }
    }

    private BigDecimal getItemSkuPolicyMinPrice(List<ItemPolicyPriceRespDto> itemSkuPrice) {
        BigDecimal minPrice = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(itemSkuPrice)) {
            minPrice = itemSkuPrice.stream().map(e -> {
                BigDecimal skuMinPrce = BigDecimal.ZERO;
                if (e.getHasLadderPrice()) {
                    skuMinPrce = e.getLadderPrices().stream().map(ladderPrice -> ladderPrice.getPrice() == null ? BigDecimal.ZERO : ladderPrice.getPrice()).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
                    return skuMinPrce;
                }
                if (e.getHasDiscountPrice()) {
                    return e.getDiscountPrice();
                }
                if (e.getPrice() != null) {
                    return e.getPrice();
                }
                return skuMinPrce;
            }).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        }
        return minPrice;
    }

    private BigDecimal getItemSkuPolicyMaxPrice(List<ItemPolicyPriceRespDto> itemSkuPriceList) {
        BigDecimal maxPrice = BigDecimal.ZERO;
        if (CollUtil.isEmpty(itemSkuPriceList)) {
            return maxPrice;
        }
        for (ItemPolicyPriceRespDto itemSku : itemSkuPriceList) {
            BigDecimal skuMaxPrce = BigDecimal.ZERO;
            if (itemSku.getHasLadderPrice()) {
                skuMaxPrce = itemSku.getLadderPrices().stream().map(ladderPrice -> ladderPrice.getPrice() == null ? BigDecimal.ZERO : ladderPrice.getPrice()).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            } else if (itemSku.getHasDiscountPrice()) {
                skuMaxPrce = itemSku.getDiscountPrice();
            } else if (itemSku.getPrice() != null) {
                skuMaxPrce = itemSku.getPrice();
            }
            if (skuMaxPrce.compareTo(maxPrice) <= 0) continue;
            maxPrice = skuMaxPrce;
        }
        return maxPrice;
    }

    public ItemChangeApplyDetailDto getDetailByItemId(Long shopId, Long itemId, Integer busType) {
        ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(itemId, "sku,attributes,medias", null).getData();
        if (null == itemDetailRespDto || null == itemDetailRespDto.getItem()) {
            return null;
        }
        if (busType == null) {
            busType = ItemBusTypeEnum.ORDINARY.getType();
        }
        ItemChangeApplyDetailDto itemChangeApplyDetailDto = this.getByItemDetailRespDto(shopId, itemDetailRespDto, busType);
        return itemChangeApplyDetailDto;
    }

    public BigDecimal queryItemPrice(Long shopId, Long itemId, Long skuId) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setSkuId(skuId);
        shelfReqDto.setItemId(itemId);
        shelfReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(com.alibaba.fastjson.JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1000)).getData();
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            List prices = pageInfo.getList().stream().map(ItemShelfRespDto::getPrice).sorted().collect(Collectors.toList());
            return (BigDecimal)prices.get(0);
        }
        return null;
    }

    private ItemChangeApplyDetailDto getByItemDetailRespDto(Long shopId, ItemDetailRespDto itemDetailRespDto, Integer busType) {
        ItemDefineAttrDto itemDefineAttrDto;
        Long itemId = itemDetailRespDto.getItem().getId();
        ItemChangeApplyDetailDto itemChangeApplyDetailDto = new ItemChangeApplyDetailDto();
        ItemRespDto itemRespDto = itemDetailRespDto.getItem();
        if (null != itemRespDto) {
            itemChangeApplyDetailDto.setIsAfterSale(itemRespDto.getIsAfterSale());
            BeanUtils.copyProperties((Object)itemRespDto, (Object)itemChangeApplyDetailDto);
            itemChangeApplyDetailDto.setItemName(itemRespDto.getName());
            itemChangeApplyDetailDto.setItemCode(itemRespDto.getCode());
            itemChangeApplyDetailDto.setBrief(itemRespDto.getBrief());
            itemChangeApplyDetailDto.setVirtual(itemRespDto.getVitrual());
            itemChangeApplyDetailDto.setBrandId(itemRespDto.getBrandId());
            itemChangeApplyDetailDto.setType(itemRespDto.getType());
            itemChangeApplyDetailDto.setSpuid(Long.valueOf(itemRespDto.getSpuid() == null ? 0L : itemRespDto.getSpuid()));
            itemChangeApplyDetailDto.setSupplierId(itemRespDto.getSupplierId());
            itemChangeApplyDetailDto.setYear(itemRespDto.getYear());
            itemChangeApplyDetailDto.setSaleChannel(itemRespDto.getSaleChannel());
            itemChangeApplyDetailDto.setShelfType(itemRespDto.getShelfType());
            itemChangeApplyDetailDto.setOrganizationId(itemRespDto.getOrganizationId());
            itemChangeApplyDetailDto.setOrganizationName(itemRespDto.getOrganizationName());
            itemChangeApplyDetailDto.setBusType(busType);
        }
        List<ItemSkuBundleDto> skuBundleList = itemDetailRespDto.getItemSkuList().stream().map(sku -> {
            ItemSkuBundleDto itemSkuBundleDto = new ItemSkuBundleDto();
            BeanUtils.copyProperties((Object)sku, (Object)itemSkuBundleDto);
            Map skuAttrMap = (Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class);
            itemSkuBundleDto.setAttrMap(skuAttrMap);
            ArrayList priceList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)priceList, (Collection)sku.getItemPriceList(), ItemPriceReqDto.class);
            itemSkuBundleDto.setPrices((List)priceList);
            return itemSkuBundleDto;
        }).collect(Collectors.toList());
        if (shopId != null && busType != null) {
            itemChangeApplyDetailDto.setSkuList(this.fillSelectFlagAndOtherInfo(shopId, itemId, busType, skuBundleList, itemChangeApplyDetailDto));
        } else {
            itemChangeApplyDetailDto.setSkuList(skuBundleList);
        }
        itemChangeApplyDetailDto.setShopId(shopId);
        ArrayList targetMediaList = Lists.newArrayList();
        List sourceMediaList = itemDetailRespDto.getItemMediasList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)sourceMediaList)) {
            CubeBeanUtils.copyCollection((Collection)targetMediaList, (Collection)sourceMediaList, ItemMediasReqDto.class);
        }
        itemChangeApplyDetailDto.setMedias((List)targetMediaList);
        List attributesList = itemDetailRespDto.getItemAttributesList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)attributesList) && null != (itemDefineAttrDto = (ItemDefineAttrDto)ObjectHelper.Json2Bean((String)((ItemAttributesRespDto)attributesList.get(0)).getAttrs(), ItemDefineAttrDto.class))) {
            if (shopId != null) {
                itemChangeApplyDetailDto.setSellPoint(itemDefineAttrDto.getSellPoint());
                itemChangeApplyDetailDto.setItemBarCode(itemDefineAttrDto.getItemBarCode());
                itemChangeApplyDetailDto.setPublishChannel(itemDefineAttrDto.getPublishChannel());
                itemChangeApplyDetailDto.setShippingTemplateId(itemDefineAttrDto.getShippingTemplateId());
                itemChangeApplyDetailDto.setUniformFreight(itemDefineAttrDto.getUniformFreight());
                itemChangeApplyDetailDto.setPropList(itemDefineAttrDto.getPropList());
                this.setDirList(itemChangeApplyDetailDto, shopId, itemId, busType);
            } else {
                itemChangeApplyDetailDto.setSellPoint(itemDefineAttrDto.getSellPoint());
                itemChangeApplyDetailDto.setFrontDirList(itemDefineAttrDto.getFrontDirList());
                itemChangeApplyDetailDto.setItemBarCode(itemDefineAttrDto.getItemBarCode());
                itemChangeApplyDetailDto.setPublishChannel(itemDefineAttrDto.getPublishChannel());
                itemChangeApplyDetailDto.setShippingTemplateId(itemDefineAttrDto.getShippingTemplateId());
                itemChangeApplyDetailDto.setUniformFreight(itemDefineAttrDto.getUniformFreight());
                itemChangeApplyDetailDto.setPropList(itemDefineAttrDto.getPropList());
                itemChangeApplyDetailDto.setBackDirList(itemDefineAttrDto.getBackDirList());
            }
            itemChangeApplyDetailDto.setBackDirList(itemDefineAttrDto.getBackDirList());
        }
        return itemChangeApplyDetailDto;
    }

    private List<ItemSkuBundleDto> fillSelectFlagAndOtherInfo(Long shopId, Long itemId, Integer busType, List<ItemSkuBundleDto> skuBundleList, ItemChangeApplyDetailDto itemChangeApplyDetailDto) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setItemId(itemId);
        shelfReqDto.setBusType(busType);
        Map<Long, ItemShelfRespDto> itemShelfRespDtoMap = this.queryShelfAndToSkuIdMap(shelfReqDto);
        Map<Long, DistributionSetRespDto> distributionSets = this.getDistributionSet(shopId, itemId);
        for (ItemSkuBundleDto itemSkuBundleDto : skuBundleList) {
            ItemShelfRespDto itemShelfRespDto = itemShelfRespDtoMap.get(itemSkuBundleDto.getId());
            if (itemShelfRespDto == null) continue;
            itemChangeApplyDetailDto.setStockDisplay(itemShelfRespDto.getStockDisplay());
            itemChangeApplyDetailDto.setLimitMin(itemShelfRespDto.getLimitMin());
            itemChangeApplyDetailDto.setLimitMinMode(itemShelfRespDto.getLimitMinMode());
            itemChangeApplyDetailDto.setMultipleStatus(itemShelfRespDto.getMultipleStatus());
            itemSkuBundleDto.setIsSelect(Integer.valueOf(itemShelfRespDto.getStatus() != null && 1 == itemShelfRespDto.getStatus() ? 1 : 0));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkuBundleDto.getPrices())) {
                for (ItemPriceReqDto itemPriceReqDto : itemSkuBundleDto.getPrices()) {
                    if (!"\u552e\u4ef7".equals(itemPriceReqDto.getName())) continue;
                    itemPriceReqDto.setPrice(itemShelfRespDto.getPrice());
                }
            }
            if (itemShelfRespDto.getShelfIntegral() != null) {
                if (itemChangeApplyDetailDto.getCashType() == null) {
                    itemChangeApplyDetailDto.setRuleRemark(itemShelfRespDto.getShelfIntegral().getRuleRemark());
                    itemChangeApplyDetailDto.setCashType(itemShelfRespDto.getShelfIntegral().getCashType());
                }
                itemSkuBundleDto.setCashAmount(itemShelfRespDto.getShelfIntegral().getCashAmount());
                itemSkuBundleDto.setCashLimit(itemShelfRespDto.getShelfIntegral().getCashLimit());
                itemSkuBundleDto.setCashIntegral(itemShelfRespDto.getShelfIntegral().getCashIntegral());
            }
            itemSkuBundleDto.setShelfAmount(this.queryVirStorage(shopId, itemId, itemSkuBundleDto.getId()));
            if (!distributionSets.containsKey(itemSkuBundleDto.getId())) continue;
            itemSkuBundleDto.setDistributionSet(distributionSets.get(itemSkuBundleDto.getId()));
            itemChangeApplyDetailDto.setDistribution(itemShelfRespDto.getDistribution());
        }
        return skuBundleList;
    }

    private Map<Long, ItemShelfRespDto> queryShelfAndToSkuIdMap(ShelfReqDto shelfReqDto) {
        RestResponse pageInfoRestResponse = this.itemQueryApi.queryItemShelf(com.alibaba.fastjson.JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(10000));
        if (!"0".equals(pageInfoRestResponse.getResultCode())) {
            throw new BizException(pageInfoRestResponse.getResultCode(), pageInfoRestResponse.getResultMsg());
        }
        PageInfo itemShelfRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (itemShelfRespDtoPageInfo == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemShelfRespDtoPageInfo.getList())) {
            return Collections.EMPTY_MAP;
        }
        List list = itemShelfRespDtoPageInfo.getList();
        return list.stream().collect(Collectors.toMap(ItemShelfRespDto::getSkuId, itemShelfRespDto -> itemShelfRespDto, (e1, e2) -> e1));
    }

    private Map<Long, DistributionSetRespDto> getDistributionSet(Long shopId, Long itemId) {
        DistributionSetReqDto reqDto = new DistributionSetReqDto();
        reqDto.setShopId(shopId);
        reqDto.setItemId(itemId);
        List distributionSets = (List)RestResponseHelper.extractData((RestResponse)this.distributionQueryApi.queryList(reqDto));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)distributionSets)) {
            return Collections.emptyMap();
        }
        Map<Long, DistributionSetRespDto> map = distributionSets.stream().collect(Collectors.toMap(DistributionSetRespDto::getSkuId, e -> e, (e1, e2) -> e1));
        return map;
    }

    private void setDirList(ItemChangeApplyDetailDto itemChangeApplyDetailDto, Long shopId, Long itemId, Integer busType) {
        DirItemRelativeReqDto dirItemRelativeReqDto = new DirItemRelativeReqDto();
        dirItemRelativeReqDto.setShopId(shopId);
        dirItemRelativeReqDto.setItemId(itemId);
        dirItemRelativeReqDto.setBusType(busType);
        List dirItems = (List)this.itemQueryApi.queryItemDirRelative(com.alibaba.fastjson.JSON.toJSONString((Object)dirItemRelativeReqDto)).getData();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirItems)) {
            Map<String, List<DirItemRelativeQueryRespDto>> dirItemMap = dirItems.stream().collect(Collectors.groupingBy(dto -> dto.getDirType() + String.valueOf(dto.getBusType())));
            itemChangeApplyDetailDto.setFrontDirList(this.getDirIdsByType(dirItemMap, "front", busType));
            itemChangeApplyDetailDto.setShopDirs(this.getDirIdsByType(dirItemMap, "shop", busType));
            itemChangeApplyDetailDto.setPointDirIds(this.getDirIdsByType(dirItemMap, "point", busType));
        }
    }

    private List<Long> getDirIdsByType(Map<String, List<DirItemRelativeQueryRespDto>> dirItemMap, String dirType, Integer busType) {
        if (dirItemMap.containsKey(dirType + busType)) {
            return dirItemMap.get(dirType + busType).stream().map(DirItemRelativeQueryRespDto::getDirId).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void filter(List<ItemRespDto> itemRespDtos, List<ShopItemDto> shopItems) {
        logger.info("\u6d3b\u52a8\u5546\u54c1\u8fc7\u6ee4\u524d\u6570\u636e\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString(itemRespDtos));
        Iterator<ItemRespDto> it = itemRespDtos.iterator();
        while (it.hasNext()) {
            ItemRespDto item = it.next();
            boolean contain = false;
            for (ShopItemDto shoItem : shopItems) {
                if (!item.getItemId().equals(shoItem.getItemId()) || !item.getSellerId().equals(shoItem.getSellerId())) continue;
                contain = true;
                item.setShopId(shoItem.getShopId());
            }
            if (contain) continue;
            it.remove();
        }
        logger.info("\u6d3b\u52a8\u5546\u54c1\u8fc7\u6ee4\u540e\u6570\u636e\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString(itemRespDtos));
    }

    private List<ItemInfoRespDto> convertToItemInfoRespDto(List<ItemRespDto> itemRespDtos) {
        logger.info("[\u5206\u9875\u6570\u636e]\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString(itemRespDtos));
        ArrayList<ItemInfoRespDto> result = new ArrayList<ItemInfoRespDto>(itemRespDtos.size());
        HashSet<Long> unitIds = new HashSet<Long>(itemRespDtos.size());
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>();
        for (ItemRespDto itemRespDto : itemRespDtos) {
            Object shopId = itemRespDto.getShopId();
            if (Objects.isNull(shopId)) {
                shopId = ((ItemShopRespDto)itemRespDto.getItemShopList().get(0)).getShopId();
            }
            List itemSkuList = itemRespDto.getItemSkuList();
            for (ItemSkuRespDto skuRespDto : itemSkuList) {
                ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
                itemStorageQueryDto.setSkuId(skuRespDto.getId());
                itemStorageQueryDto.setShopId((Long)shopId);
                itemStorageQueryDto.setCargoCode(skuRespDto.getCargoCode());
                itemStorageList.add(itemStorageQueryDto);
            }
        }
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List<ItemStorageQueryDto> itemStorageQueryDtos = this.queryBranchItemStorage(storageBranchQueryReqDto);
        Map<String, Long> avaNumMap = itemStorageQueryDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId() + "_" + e.getCargoCode(), e -> Optional.of(e).map(ItemStorageQueryDto::getAvaNum).orElse(0L), (o1, o2) -> o1));
        for (ItemRespDto itemRespDto : itemRespDtos) {
            ItemSkuRespDto itemSkuRespDto;
            String[] split;
            ItemInfoRespDto itemInfoRespDto = new ItemInfoRespDto();
            itemInfoRespDto.setSellPrice(BigDecimal.ZERO);
            itemInfoRespDto.setMarkingOutPrice(BigDecimal.ZERO);
            BeanCopierUtils.copy((Object)itemRespDto, (Object)itemInfoRespDto);
            if (StringUtils.isNotEmpty((CharSequence)itemRespDto.getWholesaleLimitMin())) {
                String wholesaleLimitMin = itemRespDto.getWholesaleLimitMin();
                split = wholesaleLimitMin.split("\\.");
                itemInfoRespDto.setWholesaleLimitMin(split[0]);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemRespDto.getWholesaleLimitMax())) {
                String wholesaleLimitMax = itemRespDto.getWholesaleLimitMax();
                split = wholesaleLimitMax.split("\\.");
                itemInfoRespDto.setWholesaleLimitMax(split[0]);
            }
            itemInfoRespDto.setShelfType(itemRespDto.getShelfType());
            itemInfoRespDto.setItemId(itemRespDto.getId());
            if (Objects.isNull(itemInfoRespDto.getShopId())) {
                itemInfoRespDto.setShopId(((ItemShopRespDto)itemRespDto.getItemShopList().get(0)).getShopId());
            }
            List<ItemSkuRespDto> skuList = this.filterOnSelfSkuAndModifyAndOther(itemInfoRespDto.getItemSkuList(), avaNumMap, itemInfoRespDto.getItemId(), itemInfoRespDto.getShopId(), itemRespDto.getItemShelfInfoList(), (CommonItemInfo)itemInfoRespDto);
            itemInfoRespDto.setItemSkuList(skuList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuList) && StringUtils.isNotEmpty((CharSequence)(itemSkuRespDto = (ItemSkuRespDto)skuList.get(0)).getUnit())) {
                unitIds.add(Long.valueOf(itemSkuRespDto.getUnit()));
            }
            itemInfoRespDto.setSellPrice(this.getMinPrice(skuList));
            itemInfoRespDto.setMinPrice(itemInfoRespDto.getSellPrice());
            itemInfoRespDto.setMaxPrice(this.getMaxPrice(skuList));
            itemInfoRespDto.setMarkingOutPrice(this.getMaxMktPrice(skuList));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemMediasList())) {
                itemInfoRespDto.setMainPic(((ItemMediasRespDto)itemRespDto.getItemMediasList().get(0)).getPath1());
            }
            itemInfoRespDto.setSaleCount(itemRespDto.getSalesCount());
            itemInfoRespDto.setItemSkuList(skuList);
            itemInfoRespDto.setDirId(itemRespDto.getDirId());
            itemInfoRespDto.setDirName(itemRespDto.getDirName());
            itemInfoRespDto.setItemSkuList(skuList);
            result.add(itemInfoRespDto);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(unitIds)) {
            List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
            Map<Long, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(UnitRespDto::getId, UnitRespDto::getName, (e1, e2) -> e1));
            for (ItemInfoRespDto itemInfo : result) {
                if (!StringUtils.isNotEmpty((CharSequence)itemInfo.getUnit())) continue;
                String unitName = unitNameMap.get(Long.valueOf(itemInfo.getUnit()));
                itemInfo.setUnitName(unitName);
            }
        }
        List itemIdList = result.stream().map(ItemInfoRespDto::getItemId).collect(Collectors.toList());
        logger.info("\u67e5\u8be2\u5546\u54c1\u5c5e\u6027\u7684itemIdList\u4e3a[{}]", itemIdList);
        RestResponse restResponse = this.itemQueryApi.queryItemAttrByItemIdList(itemIdList);
        List attributesRespDtos = (List)restResponse.getData();
        logger.info("\u67e5\u8be2\u5546\u54c1\u5c5e\u6027\u7684\u54cd\u5e94\u4e3a[{}]", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)restResponse));
        if (CollUtil.isNotEmpty((Collection)attributesRespDtos)) {
            Map<Long, String> attrsMap = attributesRespDtos.stream().collect(Collectors.toMap(ItemAttributesRespDto::getItemId, ItemAttributesRespDto::getAttrs, (key1, key2) -> key1));
            logger.info("\u5546\u54c1\u5c5e\u6027\u7684\u4fe1\u606f\u96c6\u5408\u4e3a[{}]", attrsMap);
            result.stream().forEach(bean -> {
                String attrs = (String)attrsMap.get(bean.getItemId());
                if (ObjectUtil.isNotNull((Object)attrs)) {
                    logger.info("\u5546\u54c1id\u4e3a[{}]\uff0c\u5176\u5c5e\u6027\u7684\u4fe1\u606f\u4e3a[{}]", (Object)bean.getItemId(), (Object)attrs);
                    ItemDefineAttrDto itemDefineAttrDto = (ItemDefineAttrDto)ObjectHelper.Json2Bean((String)attrs, ItemDefineAttrDto.class);
                    bean.setSellPoint(itemDefineAttrDto.getSellPoint());
                }
            });
        }
        return result;
    }

    private List<ItemSkuRespDto> convertToSkuInfoRespDto(List<ItemRespDto> itemRespDtos, Map<Long, ItemInfoRespDto> itemMap) {
        ArrayList<ItemInfoRespDto> result = new ArrayList<ItemInfoRespDto>(itemRespDtos.size());
        ArrayList skuList = Lists.newArrayList();
        HashSet<Long> unitIds = new HashSet<Long>(itemRespDtos.size());
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>();
        for (ItemRespDto itemRespDto : itemRespDtos) {
            Object shopId = itemRespDto.getShopId();
            if (Objects.isNull(shopId)) {
                shopId = ((ItemShopRespDto)itemRespDto.getItemShopList().get(0)).getShopId();
            }
            List itemSkuList = itemRespDto.getItemSkuList();
            for (ItemSkuRespDto skuRespDto : itemSkuList) {
                ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
                itemStorageQueryDto.setSkuId(skuRespDto.getId());
                itemStorageQueryDto.setShopId((Long)shopId);
                itemStorageQueryDto.setCargoCode(skuRespDto.getCargoCode());
                itemStorageList.add(itemStorageQueryDto);
            }
        }
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List<ItemStorageQueryDto> itemStorageQueryDtos = this.queryBranchItemStorage(storageBranchQueryReqDto);
        Map<String, Long> avaNumMap = itemStorageQueryDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId() + "_" + e.getCargoCode(), e -> Optional.of(e).map(ItemStorageQueryDto::getAvaNum).orElse(0L), (o1, o2) -> o1));
        for (ItemRespDto itemRespDto : itemRespDtos) {
            List skuTempList;
            String[] split;
            ItemInfoRespDto itemInfoRespDto = new ItemInfoRespDto();
            BeanCopierUtils.copy((Object)itemRespDto, (Object)itemInfoRespDto);
            itemInfoRespDto.setCode(itemRespDto.getCode());
            if (StringUtils.isNotEmpty((CharSequence)itemRespDto.getWholesaleLimitMin())) {
                String wholesaleLimitMin = itemRespDto.getWholesaleLimitMin();
                split = wholesaleLimitMin.split("\\.");
                itemInfoRespDto.setWholesaleLimitMin(split[0]);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemRespDto.getWholesaleLimitMax())) {
                String wholesaleLimitMax = itemRespDto.getWholesaleLimitMax();
                split = wholesaleLimitMax.split("\\.");
                itemInfoRespDto.setWholesaleLimitMax(split[0]);
            }
            itemInfoRespDto.setShelfType(itemRespDto.getShelfType());
            itemInfoRespDto.setItemId(itemRespDto.getId());
            if (Objects.isNull(itemInfoRespDto.getShopId())) {
                itemInfoRespDto.setShopId(((ItemShopRespDto)itemRespDto.getItemShopList().get(0)).getShopId());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuTempList = this.filterOnSelfSkuAndModifyAndOther(itemInfoRespDto.getItemSkuList(), avaNumMap, itemInfoRespDto.getItemId(), itemInfoRespDto.getShopId(), itemRespDto.getItemShelfInfoList(), (CommonItemInfo)itemInfoRespDto))) {
                skuList.addAll(skuTempList);
                ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)skuTempList.get(0);
                if (StringUtils.isNotEmpty((CharSequence)itemSkuRespDto.getUnit())) {
                    unitIds.add(Long.valueOf(itemSkuRespDto.getUnit()));
                    itemInfoRespDto.setUnit(itemSkuRespDto.getUnit());
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemMediasList())) {
                itemInfoRespDto.setMainPic(((ItemMediasRespDto)itemRespDto.getItemMediasList().get(0)).getPath1());
            }
            result.add(itemInfoRespDto);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(unitIds)) {
            List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
            Map<Long, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(UnitRespDto::getId, UnitRespDto::getName, (e1, e2) -> e1));
            for (ItemInfoRespDto itemInfo2 : result) {
                if (!StringUtils.isNotEmpty((CharSequence)itemInfo2.getUnit())) continue;
                String unitName = unitNameMap.get(Long.valueOf(itemInfo2.getUnit()));
                itemInfo2.setUnitName(unitName);
            }
        }
        Map<Long, ItemInfoRespDto> itemInfoMap = result.stream().collect(Collectors.toMap(itemInfo -> itemInfo.getItemId(), o -> o, (o1, o2) -> o1));
        itemMap.putAll(itemInfoMap);
        return skuList;
    }

    private List<String> getShopTags(ShopBaseDto shopDto) {
        String shopTag;
        ArrayList shopTags = Lists.newArrayList();
        if (null != shopDto && null != (shopTag = ShopTagEnum.getTagByShopType((Integer)shopDto.getType().intValue()))) {
            shopTags.add(shopTag);
        }
        return shopTags;
    }

    private BigDecimal getMinPrice(List<ItemSkuRespDto> skuList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuList)) {
            return BigDecimal.ZERO;
        }
        return skuList.stream().map(sku -> sku.getPrice() == null ? BigDecimal.ZERO : sku.getPrice()).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getMaxPrice(List<ItemSkuRespDto> skuList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuList)) {
            return BigDecimal.ZERO;
        }
        return skuList.stream().map(sku -> sku.getPrice() == null ? BigDecimal.ZERO : sku.getPrice()).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getMaxMktPrice(List<ItemSkuRespDto> skuList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuList)) {
            return BigDecimal.ZERO;
        }
        ArrayList priceList = Lists.newArrayList();
        skuList.forEach(sku -> {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)sku.getItemPriceList())) {
                for (ItemPriceRespDto price : sku.getItemPriceList()) {
                    if (!"\u5212\u7ebf\u4ef7".equals(price.getName()) || price.getPrice() == null) continue;
                    priceList.add(price.getPrice());
                }
            }
        });
        return priceList.stream().max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getMaxMktPriceForBaseItem(List<ItemSkuInfoRespDto> skuList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuList)) {
            return BigDecimal.ZERO;
        }
        ArrayList priceList = Lists.newArrayList();
        skuList.forEach(sku -> {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)sku.getItemPriceList())) {
                for (ItemPriceRespDto price : sku.getItemPriceList()) {
                    if (!"\u5212\u7ebf\u4ef7".equals(price.getName()) || price.getPrice() == null) continue;
                    priceList.add(price.getPrice());
                }
            }
        });
        return priceList.stream().max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
    }

    public void setItemActivityInfo(List<ItemInfoRespDto> itemInfoRespDtos, Boolean needStatistics, Boolean needPrice, List<Long> customerIdList) {
        HashSet shopIds = Sets.newHashSet();
        HashSet itemIds = Sets.newHashSet();
        itemInfoRespDtos.forEach(itemInfoRespDto -> {
            shopIds.add(itemInfoRespDto.getShopId());
            itemIds.add(itemInfoRespDto.getItemId());
        });
        ArrayList activityIdList = Lists.newArrayList();
        Map<Object, Object> priceMaps = new HashMap();
        Map<Object, Object> activityMap = new HashMap();
        HashMap orgIdMap = new HashMap();
        if (needPrice.booleanValue()) {
            HashMap customerIdMap = new HashMap();
            this.bshopService.queryCustomerInfoByShopIds((Set)shopIds).forEach((shopId, customer) -> {
                customerIdMap.put(shopId, customer.getCustomerId());
                orgIdMap.put(shopId, customer.getOrgId());
            });
            ArrayList skuActivityPriceDtos = Lists.newArrayList();
            for (ItemInfoRespDto itemInfoRespDto2 : itemInfoRespDtos) {
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemInfoRespDto2.getItemSkuList())) continue;
                for (Object skuRespDto : itemInfoRespDto2.getItemSkuList()) {
                    if (customerIdMap.get(itemInfoRespDto2.getShopId()) == null) continue;
                    ItemSkuActivityPriceDto skuActivityPriceDto = new ItemSkuActivityPriceDto();
                    skuActivityPriceDto.setItemId(itemInfoRespDto2.getItemId());
                    skuActivityPriceDto.setSkuId(skuRespDto.getId());
                    skuActivityPriceDto.setShopId(itemInfoRespDto2.getShopId());
                    skuActivityPriceDto.setCustomerId((Long)customerIdMap.get(itemInfoRespDto2.getShopId()));
                    skuActivityPriceDto.setSellPrice(skuRespDto.getPrice());
                    skuActivityPriceDtos.add(skuActivityPriceDto);
                }
            }
            ActivityPriceBranchQueryReqDto activityPriceBranchQueryReqDto = new ActivityPriceBranchQueryReqDto();
            activityPriceBranchQueryReqDto.setItemSkuActivityPriceList((List)skuActivityPriceDtos);
            List itemSkuActivityPriceDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.queryBranchItemSkuActivityPrice(activityPriceBranchQueryReqDto));
            priceMaps = itemSkuActivityPriceDtos.stream().collect(Collectors.groupingBy(priceDto -> priceDto.getShopId() + priceDto.getItemId().toString()));
            HashSet<Long> itemActivityIdList = new HashSet<Long>();
            for (List list : priceMaps.values()) {
                for (ItemSkuActivityPriceDto tagDto2 : list) {
                    activityIdList.add(tagDto2.getActivityId());
                    itemActivityIdList.add(tagDto2.getActivityId());
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemActivityIdList)) {
                List activityRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryActivityListByIds((List)Lists.newArrayList(itemActivityIdList)));
                activityMap = activityRespDtoList.stream().collect(Collectors.toMap(ActivityRespDto::getId, o -> o));
            }
        }
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setShopIdList((List)Lists.newArrayList((Iterable)shopIds));
        queryReqDto.setItemIdList((List)Lists.newArrayList((Iterable)itemIds));
        queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ORDER.getKey(), ActivityDimensionEnum.COUPON.getKey()}));
        queryReqDto.setDisplay(Integer.valueOf(1));
        Map<String, List<ItemActivityTagDto>> tagMaps = this.activityService.queryItemActivityTags(queryReqDto);
        for (List list : tagMaps.values()) {
            for (ItemActivityTagDto itemActivityTagDto : list) {
                activityIdList.add(itemActivityTagDto.getActivityId());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerIdList)) {
            customerIdList = this.getCustomerIdListByUserId(this.context.userId());
        }
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setIdList(customerIdList);
        RestResponse restResponse = this.customerExtQueryApi.queryByList(com.alibaba.fastjson.JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)restResponse);
        TargetCustomerReqDto targetCustomerReqDto = new TargetCustomerReqDto();
        targetCustomerReqDto.setActivityIds((List)activityIdList);
        targetCustomerReqDto.setCustomerInfoList(customerRespDtos);
        List targetActivityIds = (List)this.itemActivityStockApi.validateTargetCustomersAndMallType(targetCustomerReqDto).getData();
        RemainingStockBatchReqDto remainingStockBatchReqDto = new RemainingStockBatchReqDto();
        ArrayList<ActivityStockReqDto> activityStockList = new ArrayList<ActivityStockReqDto>();
        for (ItemInfoRespDto itemInfoRespDto3 : itemInfoRespDtos) {
            String key = String.valueOf(itemInfoRespDto3.getShopId()) + itemInfoRespDto3.getItemId();
            if (!tagMaps.containsKey(key)) continue;
            ActivityStockReqDto stockReqDto = new ActivityStockReqDto();
            ArrayList<Long> activityIds = new ArrayList<Long>();
            List<ItemActivityTagDto> itemActivityTagDtos = tagMaps.get(key);
            for (ItemActivityTagDto itemActivityTagDto : itemActivityTagDtos) {
                if (!ActivityDimensionEnum.ORDER.getKey().equals(itemActivityTagDto.getDimension())) continue;
                activityIds.add(itemActivityTagDto.getActivityId());
            }
            stockReqDto.setItemId(itemInfoRespDto3.getItemId());
            stockReqDto.setShopId(itemInfoRespDto3.getShopId());
            stockReqDto.setActivityIds(activityIds);
            activityStockList.add(stockReqDto);
        }
        remainingStockBatchReqDto.setActivityStockList(activityStockList);
        RestResponse activityRemainingStockBatch = this.itemActivityStockApi.getActivityRemainingStockBatch(remainingStockBatchReqDto);
        RemainingStockBatchRespDto respDto = (RemainingStockBatchRespDto)RestResponseHelper.extractData((RestResponse)activityRemainingStockBatch);
        Map activityListMap = respDto.getActivityListMap();
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        String group = "yundt-cube-center-common-" + pfile;
        for (ItemInfoRespDto itemInfoRespDto4 : itemInfoRespDtos) {
            Long itemId = itemInfoRespDto4.getItemId();
            Long shopId2 = itemInfoRespDto4.getShopId();
            String key = String.valueOf(shopId2) + itemId;
            if (tagMaps.containsKey(key)) {
                List<ItemActivityTagDto> itemActivityTagDtos = tagMaps.get(key);
                List enableActivityIds = (List)activityListMap.get(shopId2 + "_" + itemId);
                itemActivityTagDtos.removeIf(tagDto -> {
                    if (ActivityDimensionEnum.COUPON.getKey().equals(tagDto.getDimension()) && !targetActivityIds.contains(tagDto.getActivityId())) {
                        return true;
                    }
                    if (ActivityDimensionEnum.ORDER.getKey().equals(tagDto.getDimension())) {
                        return !targetActivityIds.contains(tagDto.getActivityId()) || !enableActivityIds.contains(tagDto.getActivityId());
                    }
                    return false;
                });
                itemInfoRespDto4.setTags(itemActivityTagDtos);
            }
            if (!needPrice.booleanValue() || !priceMaps.containsKey(key)) continue;
            List itemActivityPriceDtos = (List)priceMaps.get(key);
            ItemSkuActivityPriceDto minPrice = (ItemSkuActivityPriceDto)itemActivityPriceDtos.get(0);
            ActivitySimpleInfoDto simpleInfoDto = new ActivitySimpleInfoDto();
            simpleInfoDto.setActivityId(minPrice.getActivityId());
            simpleInfoDto.setActivityTag(minPrice.getActivityTag());
            simpleInfoDto.setActivityTemplateId(minPrice.getActivityTemplateId());
            ArrayList activityPriceList = Lists.newArrayList();
            for (int i = 0; i < itemActivityPriceDtos.size(); ++i) {
                boolean target = targetActivityIds.contains(simpleInfoDto.getActivityId());
                if (!target) continue;
                ItemSkuActivityPriceDto activityPriceDto = (ItemSkuActivityPriceDto)itemActivityPriceDtos.get(i);
                ItemActivityPriceRespDto activityPrice = new ItemActivityPriceRespDto();
                activityPrice.setItemId(itemId);
                activityPrice.setShopId(shopId2);
                activityPrice.setSkuId(activityPriceDto.getSkuId());
                activityPrice.setActivityPrice(activityPriceDto.getActivityPrice());
                activityPrice.setActivityType(ActivityType.getByType((Long)activityPriceDto.getActivityTemplateId()));
                activityPrice.setActivityId(activityPriceDto.getActivityId());
                activityPrice.setActivityName(activityPriceDto.getActivityTag());
                activityPrice.setPromotionMethod(activityPriceDto.getPromotionMethod());
                activityPrice.setDiscount(activityPriceDto.getDiscount());
                ActivityRespDto activityRespDto = (ActivityRespDto)activityMap.get(activityPrice.getActivityId());
                if (Objects.nonNull(activityRespDto)) {
                    activityPrice.setBeginTime(activityRespDto.getBeginTime());
                    activityPrice.setEndTime(activityRespDto.getEndTime());
                    activityPrice.setPreheatStartTime(activityRespDto.getPreheatStartTime());
                    activityPrice.setRemainingStock(activityPriceDto.getRemainingStock());
                    if (ActivityType.SECKILL_TOB_ACTIVITY.equals((Object)activityPrice.getActivityType())) {
                        activityPrice.setPurchaseNumLimit(this.getPurchaseNumLimit(activityRespDto.getId(), group));
                        activityPrice.setRemainingJoinNum(this.getRemainingJoinNum(activityRespDto.getId(), (Long)orgIdMap.get(activityPrice.getShopId()), group));
                    }
                }
                if (i == 0) {
                    itemInfoRespDto4.setActivityPrice(activityPrice);
                }
                activityPriceList.add(activityPrice);
            }
            itemInfoRespDto4.setActivityPriceList((List)activityPriceList);
            if (!needStatistics.booleanValue()) continue;
            List<ActivityItemRespDto> activityItems = this.getJoinItems(itemId, simpleInfoDto.getActivityId(), shopId2);
            ActivityStatisticsRespDto activityStatisticsRespDto = this.getActivityStatistics(simpleInfoDto, activityItems, itemInfoRespDto4);
            itemInfoRespDto4.setActivityStatistics(activityStatisticsRespDto);
        }
    }

    private Integer getRemainingJoinNum(Long activityId, Long userId, String group) {
        Integer joinNum = (Integer)this.cacheService.hget(group, QueryKeyGenerator.getCustomerJoinActivityNumKey(activityId), userId.toString(), Integer.class);
        Integer activityLimit = (Integer)this.cacheService.getCache(group, QueryKeyGenerator.getActivityLimitKey(activityId), Integer.class);
        if (null == activityLimit) {
            return null;
        }
        if (null == joinNum) {
            return activityLimit;
        }
        if (joinNum >= activityLimit) {
            return 0;
        }
        return activityLimit - joinNum;
    }

    private Integer getPurchaseNumLimit(Long activityId, String group) {
        return (Integer)this.cacheService.getCache(group, QueryKeyGenerator.getItemLimitKey(activityId), Integer.class);
    }

    private ItemSkuActivityPriceDto getMinItemActivityPriceDto(List<ItemSkuActivityPriceDto> itemActivityPriceDtos) {
        itemActivityPriceDtos.sort(Comparator.comparing(ItemSkuActivityPriceDto::getActivityPrice, BigDecimal::compareTo));
        return itemActivityPriceDtos.get(0);
    }

    private ActivityStatisticsRespDto getActivityStatistics(ActivitySimpleInfoDto simpleInfoDto, List<ActivityItemRespDto> activityItems, ItemInfoRespDto itemInfoRespDto) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(simpleInfoDto.getActivityId().longValue()).getData();
        ActivityStatisticsRespDto statistics = new ActivityStatisticsRespDto();
        if (simpleInfoDto.getActivityTemplateId().equals(ActivityType.GROUP_ACTIVITY.getId())) {
            Integer groupNumber = this.activityService.getGroupNumber(activityRespDto);
            statistics.setGroupNumber(groupNumber);
            Long totalGroupNumber = (Long)this.activityGroupQueryApi.countGroupNumber(simpleInfoDto.getActivityId(), null).getData();
            statistics.setTotalGroupNumber(Integer.valueOf(totalGroupNumber == null ? 0 : totalGroupNumber.intValue()));
        } else if (simpleInfoDto.getActivityTemplateId().equals(ActivityType.SECKILL_ACTIVITY.getId())) {
            Long totalStock = activityItems.stream().mapToLong(ActivityItemRespDto::getOriginalStock).sum();
            statistics.setOriginalStock(totalStock);
            Long remainingStock = activityItems.stream().mapToLong(ActivityItemRespDto::getRemainingStock).sum();
            statistics.setRemainingStock(remainingStock);
        } else if (simpleInfoDto.getActivityTemplateId().equals(ActivityType.TIME_DISCOUNT_ACTIVITY.getId())) {
            Long totalStock = itemInfoRespDto.getItemSkuList().stream().mapToLong(ItemSkuRespDto::getShelfAmount).sum();
            statistics.setOriginalStock(totalStock);
            statistics.setRemainingStock(totalStock);
        }
        return statistics;
    }

    private ItemActivityPriceRespDto getItemActivityPriceRespDto(ActivityRespDto activityRespDto, List<ActivityItemRespDto> activityItems, Long itemId, Long activityId) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(activityItems)) {
            return null;
        }
        try {
            ItemActivityPriceRespDto minActivityPrice = new ItemActivityPriceRespDto();
            activityItems.stream().sorted(Comparator.comparing(ActivityItemRespDto::getActivityPrice, (o1, o2) -> o1.compareTo((BigDecimal)o2))).findFirst().ifPresent(activityItem -> {
                minActivityPrice.setItemId(itemId);
                minActivityPrice.setSkuId(activityItem.getSkuId());
                minActivityPrice.setActivityPrice(activityItem.getActivityPrice());
                minActivityPrice.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
                minActivityPrice.setActivityId(activityId);
            });
            return minActivityPrice;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private List<ItemInfoRespDto> getItemInfoRespDtoList(List<ItemRespDto> itemRespDtoList) {
        return this.convertToItemInfoRespDto(itemRespDtoList);
    }

    public ItemDetailInfoRespDto queryItemDetail(Long itemId, Long shopId, Integer busType, Long customerId) {
        ItemDetailInfoRespDto itemDetailInfoRespDto;
        if (null == itemId || itemId == 0L) {
            return null;
        }
        if (busType == null) {
            busType = ItemBusTypeEnum.ORDINARY.getType();
        }
        if (Objects.nonNull(itemDetailInfoRespDto = this.doQueryItemDetail(itemId, shopId, null, busType, customerId)) && Objects.nonNull(itemDetailInfoRespDto.getItemBaseInfo())) {
            BrandRespDto brandRespDto;
            ItemBaseInfoRespDto itemBaseInfo;
            List itemAttributesRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemAttrByItemIdList((List)ListUtil.toList((Object[])new Long[]{itemId})));
            ItemAttributesRespDto itemAttributesRespDto = (ItemAttributesRespDto)itemAttributesRespDtos.get(0);
            if (Objects.nonNull(itemAttributesRespDto) && StrUtil.isNotBlank((CharSequence)itemAttributesRespDto.getAttrs())) {
                try {
                    Map map = (Map)JSON.parseObject((String)itemAttributesRespDto.getAttrs(), Map.class);
                    itemDetailInfoRespDto.setAttrs(map);
                }
                catch (Exception map) {
                    // empty catch block
                }
            }
            if (Objects.nonNull((itemBaseInfo = itemDetailInfoRespDto.getItemBaseInfo()).getBrandId()) && StrUtil.isBlank((CharSequence)itemBaseInfo.getBrand()) && Objects.nonNull(brandRespDto = (BrandRespDto)RestResponseHelper.extractData((RestResponse)this.brandQueryApi.queryById(itemBaseInfo.getBrandId())))) {
                itemBaseInfo.setBrand(brandRespDto.getName());
            }
        }
        return itemDetailInfoRespDto;
    }

    private List<ItemDetailCycleBuyDto> getShopItemCycleBuyData(Long shopId, Long itemId) {
        RestResponse itemCycleBuyResp = this.itemCycleBuyQueryApi.queryItemCycleBuy(shopId, itemId);
        if (itemCycleBuyResp != null && "0".equals(itemCycleBuyResp.getResultCode())) {
            List itemCycleBuyRespDtoList = (List)itemCycleBuyResp.getData();
            return this.processCycleBuyData(itemCycleBuyRespDtoList);
        }
        return Collections.EMPTY_LIST;
    }

    private List<ItemDetailCycleBuyDto> processCycleBuyData(List<ItemCycleBuyRespDto> itemCycleBuyRespDtoList) {
        LinkedList cycleBuyMetaDtoList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemCycleBuyRespDtoList)) {
            itemCycleBuyRespDtoList.forEach(respDto -> {
                ItemDetailCycleBuyDto cycleBuyDto = new ItemDetailCycleBuyDto();
                Integer code = respDto.getDeliveryType();
                cycleBuyDto.setCode(code);
                cycleBuyDto.setName(CycleBuyDeliveryTypeEnum.getByCode((int)respDto.getDeliveryType()).getName());
                cycleBuyDto.setCurrentDelivery(respDto.getCurrentDelivery());
                cycleBuyDto.setLatestDays(respDto.getLatestDays());
                cycleBuyDto.setLatestHour(respDto.getLatestHour());
                Object[] deliveryRate = respDto.getDeliveryRate();
                if (ArrayUtils.isNotEmpty((Object[])deliveryRate)) {
                    List dataList = Stream.of(deliveryRate).map(subCode -> {
                        CycleRateDto rateDto = new CycleRateDto();
                        rateDto.setCode(subCode);
                        if (CycleBuyDeliveryTypeEnum.BY_DAY.getCode() == code.intValue()) {
                            rateDto.setName(RateByDayEnum.getByCode((int)subCode).getName());
                        }
                        if (CycleBuyDeliveryTypeEnum.BY_WEEK.getCode() == code.intValue()) {
                            rateDto.setName(RateByWeekEnum.getByCode((int)subCode).getName());
                        }
                        if (CycleBuyDeliveryTypeEnum.BY_MONTH.getCode() == code.intValue()) {
                            rateDto.setName(RateByMonthEnum.getByCode((int)subCode).getName());
                        }
                        return rateDto;
                    }).collect(Collectors.toList());
                    cycleBuyDto.setDataList(dataList);
                }
                cycleBuyMetaDtoList.add(cycleBuyDto);
            });
        }
        return cycleBuyMetaDtoList;
    }

    private <T extends ItemSkuRespDto> List<T> filterOnSelfSkuAndModifyAndOther(List<T> orgSkuList, Map<String, Long> avaNumMap, Long itemId, Long shopId, List<ItemShelfRespDto> itemShelfInfoList, CommonItemInfo commonItemInfo) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemId);
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setStatus(Integer.valueOf(1));
        Object skuShelfMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemShelfInfoList)) {
            skuShelfMap = itemShelfInfoList.stream().collect(Collectors.groupingBy(itemShelfRespDto -> itemShelfRespDto.getShopId() + itemShelfRespDto.getSkuId().toString()));
        }
        if (skuShelfMap.size() == 0) {
            logger.error("\u65e0\u4e0a\u67b6\u4fe1\u606f{}\uff0c{}", (Object)itemId, (Object)shopId);
            return null;
        }
        HashedMap finalSkuShelfMap = skuShelfMap;
        return orgSkuList.stream().filter(arg_0 -> BitemServiceImpl.lambda$filterOnSelfSkuAndModifyAndOther$80((Map)finalSkuShelfMap, shopId, arg_0)).map(arg_0 -> BitemServiceImpl.lambda$filterOnSelfSkuAndModifyAndOther$81((Map)finalSkuShelfMap, shopId, avaNumMap, commonItemInfo, arg_0)).collect(Collectors.toList());
    }

    private <T extends ItemSkuRespDto> List<T> filterOnSelfSkuAndModifyAndOther(List<T> orgSkuList, Long itemId, Long shopId, Map<String, Long> activityStockMap, List<ItemShelfRespDto> itemShelfInfoList, CommonItemInfo commonItemInfo, List<Long> activityIdsList) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemId);
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setStatus(Integer.valueOf(1));
        Object skuShelfMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemShelfInfoList)) {
            skuShelfMap = itemShelfInfoList.stream().collect(Collectors.groupingBy(itemShelfRespDto -> itemShelfRespDto.getShopId() + "_" + itemShelfRespDto.getSkuId().toString()));
        }
        if (skuShelfMap.size() == 0) {
            logger.error("\u65e0\u4e0a\u67b6\u4fe1\u606f{}\uff0c{}", (Object)itemId, (Object)shopId);
            return null;
        }
        HashedMap finalSkuShelfMap = skuShelfMap;
        logger.info("finalSkuShelfMap=[{}]", (Object)finalSkuShelfMap);
        logger.info("activityStockMap=[{}]", activityStockMap);
        return orgSkuList.stream().filter(arg_0 -> BitemServiceImpl.lambda$filterOnSelfSkuAndModifyAndOther$83((Map)finalSkuShelfMap, shopId, arg_0)).map(arg_0 -> this.lambda$filterOnSelfSkuAndModifyAndOther$84(shopId, (Map)finalSkuShelfMap, activityStockMap, commonItemInfo, arg_0)).collect(Collectors.toList());
    }

    private ItemDetailInfoRespDto doQueryItemDetail(Long itemId, Long shopId, Integer itemType, Integer busType, Long customerId) {
        String attrs;
        PageInfo itemAttrPage;
        UnitRespDto unitRespDto;
        ItemSkuInfoRespDto itemSkuRespDto;
        String[] split;
        ItemSearchQueryReqDto queryReqDto = new ItemSearchQueryReqDto();
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setItemIds((List)Lists.newArrayList((Object[])new Long[]{itemId}));
        queryReqDto.setItemType(itemType);
        queryReqDto.setShopId(shopId);
        queryReqDto.setBusType(busType);
        ItemSearchRespDto searchRespDto = (ItemSearchRespDto)this.itemQueryApi.queryItemByDirIdDepth(queryReqDto, Integer.valueOf(1), Integer.valueOf(1)).getData();
        logger.info("\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)searchRespDto));
        if (null == searchRespDto || null == searchRespDto.getPageInfo() || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchRespDto.getPageInfo().getList())) {
            return null;
        }
        ItemRespDto itemRespDto = (ItemRespDto)searchRespDto.getPageInfo().getList().get(0);
        ItemDetailInfoRespDto itemDetailInfoRespDto = new ItemDetailInfoRespDto();
        ItemBaseInfoRespDto itemBaseInfo = new ItemBaseInfoRespDto();
        CubeBeanUtils.copyProperties((Object)itemBaseInfo, (Object)itemRespDto, (String[])new String[]{"minPrice"});
        if (StringUtils.isNotEmpty((CharSequence)itemRespDto.getWholesaleLimitMin())) {
            String wholesaleLimitMin = itemRespDto.getWholesaleLimitMin();
            split = wholesaleLimitMin.split("\\.");
            itemBaseInfo.setWholesaleLimitMin(split[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)itemRespDto.getWholesaleLimitMax())) {
            String wholesaleLimitMax = itemRespDto.getWholesaleLimitMax();
            split = wholesaleLimitMax.split("\\.");
            itemBaseInfo.setWholesaleLimitMax(split[0]);
        }
        itemBaseInfo.setItemMediasList(itemRespDto.getItemMediasList());
        ArrayList itemSkuList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSkuList, (Collection)itemRespDto.getItemSkuList(), ItemSkuInfoRespDto.class);
        if (Objects.isNull(shopId)) {
            shopId = ((ItemShopRespDto)itemRespDto.getItemShopList().get(0)).getShopId();
        }
        Assert.notNull((Object)shopId, (String)"\u4e0a\u67b6\u5546\u54c1\u8be6\u60c5\u4e2dshopId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        ShopInfoRespDto shopInfo = new ShopInfoRespDto();
        if (shopDto != null) {
            CubeBeanUtils.copyProperties((Object)shopInfo, (Object)shopDto, (String[])new String[0]);
        }
        itemDetailInfoRespDto.setShop(shopInfo);
        Long orgInfoId = null;
        if (Objects.isNull(customerId)) {
            ServiceContext serviceContext = ServiceContext.getContext();
            String object = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
            if (object != null) {
                customerId = Long.valueOf(object);
                List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds((List)Lists.newArrayList((Object[])new Long[]{customerId})));
                orgInfoId = ((CustomerRespDto)customerRespDtos.get(0)).getOrgInfoId();
            } else {
                orgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
                RestResponse sellerRespDtoRest = this.sellerQueryApi.queryById(shopDto.getSellerId());
                SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)sellerRespDtoRest);
                RestResponse customerRespDtoRest = this.customerExtQueryApi.queryCustomerByOrgAndMerch(orgInfoId, sellerRespDto.getOrganizationId());
                CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRest);
                Assert.notNull((Object)customerRespDto, (String)"\u4e0a\u67b6\u5546\u54c1\u8be6\u60c5\u4e2d\u5ba2\u6237\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                customerId = customerRespDto.getId();
            }
        } else {
            CustomerExtDetailRespDto customer = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(customerId));
            orgInfoId = customer.getOrgInfoId();
        }
        logger.info("\u6839\u636e\u7ecf\u9500\u5546\u767b\u5f55\u7684userId\u67e5\u8be2\u5ba2\u6237id\u4e3a [{}]", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)customerId));
        ArrayList activityIdsList = Lists.newArrayList();
        ItemForActivityInfoRespDto activityInfoRespDto = this.activityService.queryActivityByItemId(itemId, shopId, activityIdsList, customerId);
        itemBaseInfo.setItemSkuList(this.filterOnSelfSkuAndModifyAndOther(itemSkuList, itemId, shopId, activityInfoRespDto.getRemainingStockMap(), itemRespDto.getItemShelfInfoList(), (CommonItemInfo)itemBaseInfo, activityIdsList));
        List<ItemPolicyPriceRespDto> itemPolicyPriceRespDtoList = this.getItemPolicyPrice(itemId, shopId, customerId, itemBaseInfo.getItemSkuList());
        if (!CollectionUtils.isEmpty(itemPolicyPriceRespDtoList)) {
            itemBaseInfo.setItemSkuPolicyPriceList(itemPolicyPriceRespDtoList);
            BigDecimal itemSkuPolicyMinPrice = this.itemPriceHelper.getItemSkuPolicyMinPrice(itemPolicyPriceRespDtoList);
            BigDecimal itemSkuPolicyMaxPrice = this.itemPriceHelper.getItemSkuPolicyMaxPrice(itemPolicyPriceRespDtoList);
            itemBaseInfo.setMinPrice(itemSkuPolicyMinPrice == null ? null : Double.valueOf(itemSkuPolicyMinPrice.abs().doubleValue()));
            itemBaseInfo.setMaxPrice(itemSkuPolicyMaxPrice == null ? null : Double.valueOf(itemSkuPolicyMaxPrice.abs().doubleValue()));
            Map skuPriceMap = itemPolicyPriceRespDtoList.stream().collect(Collectors.toMap(item -> item.getShopId() + "-" + item.getSkuId(), Function.identity(), (o1, o2) -> o2));
            for (ItemSkuInfoRespDto itemSkuInfoRespDto : itemBaseInfo.getItemSkuList()) {
                List itemPriceList = itemSkuInfoRespDto.getItemPriceList();
                String key = shopId + "-" + itemSkuInfoRespDto.getId();
                if (!skuPriceMap.containsKey(key)) {
                    for (ItemPriceRespDto itemPriceRespDto : itemPriceList) {
                        itemPriceRespDto.setPrice(null);
                    }
                    continue;
                }
                ItemPolicyPriceRespDto itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)skuPriceMap.get(key);
                BigDecimal price = this.itemPriceHelper.getDefaultMatchPrice(itemPolicyPriceRespDto, null);
                itemSkuInfoRespDto.setPrice(price);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemBaseInfo.getItemSkuList()) && StringUtils.isNotEmpty((CharSequence)(itemSkuRespDto = (ItemSkuInfoRespDto)itemBaseInfo.getItemSkuList().get(0)).getUnit()) && Objects.nonNull(unitRespDto = (UnitRespDto)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryById(Long.valueOf(itemSkuRespDto.getUnit()))))) {
            itemBaseInfo.setUnit(unitRespDto.getName());
        }
        itemBaseInfo.setSellPrice(itemBaseInfo.getMinPrice() == null ? null : new BigDecimal(itemBaseInfo.getMinPrice()));
        itemBaseInfo.setMarkingOutPrice(this.getMaxMktPriceForBaseItem(itemBaseInfo.getItemSkuList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemMediasList())) {
            itemBaseInfo.setMainPic(((ItemMediasRespDto)itemRespDto.getItemMediasList().get(0)).getPath1());
        }
        if (null != (itemAttrPage = (PageInfo)this.itemQueryApi.queryItemAttrById(itemRespDto.getId(), Integer.valueOf(1), Integer.valueOf(1)).getData()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemAttrPage.getList()) && StringUtils.isNotEmpty((CharSequence)(attrs = ((ItemAttributesRespDto)itemAttrPage.getList().get(0)).getAttrs()))) {
            ItemDefineAttrDto itemDefineAttrDto = (ItemDefineAttrDto)com.alibaba.fastjson.JSON.parseObject((String)attrs, ItemDefineAttrDto.class);
            itemBaseInfo.setItemDefineAttrDto(itemDefineAttrDto);
        }
        itemBaseInfo.setSaleCount(itemRespDto.getSalesCount());
        itemDetailInfoRespDto.setItemBaseInfo(itemBaseInfo);
        if (ItemBusTypeEnum.INTEGRAL.getType().equals(busType)) {
            return itemDetailInfoRespDto;
        }
        ArrayList skuActivityPriceDtos = Lists.newArrayList();
        for (ItemSkuInfoRespDto itemSkuInfoRespDto : itemBaseInfo.getItemSkuList()) {
            ItemSkuActivityPriceDto skuActivityPriceDto = new ItemSkuActivityPriceDto();
            skuActivityPriceDto.setItemId(itemId);
            skuActivityPriceDto.setSkuId(itemSkuInfoRespDto.getId());
            skuActivityPriceDto.setShopId(shopId);
            skuActivityPriceDto.setCustomerId(customerId);
            skuActivityPriceDto.setSellPrice(itemSkuInfoRespDto.getPrice());
            skuActivityPriceDtos.add(skuActivityPriceDto);
        }
        ActivityPriceBranchQueryReqDto branchQueryReqDto = new ActivityPriceBranchQueryReqDto();
        branchQueryReqDto.setItemSkuActivityPriceList((List)skuActivityPriceDtos);
        List itemSkuActivityPriceDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.queryBranchItemSkuActivityPrice(branchQueryReqDto));
        Map<String, List<ItemSkuActivityPriceDto>> priceDtoMap = itemSkuActivityPriceDtos.stream().collect(Collectors.groupingBy(priceDto -> priceDto.getShopId() + priceDto.getItemId().toString()));
        List<ItemSkuActivityPriceDto> priceDtos = priceDtoMap.get(shopId.toString() + itemId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(priceDtos)) {
            ItemSkuActivityPriceDto minPirce = this.getMinItemActivityPriceDto(priceDtos);
            if (Objects.nonNull(minPirce.getActivityId())) {
                ActivitySimpleInfoDto simpleInfoDto = new ActivitySimpleInfoDto();
                simpleInfoDto.setActivityId(minPirce.getActivityId());
                simpleInfoDto.setActivityTag(minPirce.getActivityTag());
                simpleInfoDto.setActivityTemplateId(minPirce.getActivityTemplateId());
                ArrayList<ActivityItemRespDto> items = new ArrayList<ActivityItemRespDto>(priceDtos.size());
                for (ItemSkuActivityPriceDto priceDto2 : priceDtos) {
                    ActivityItemRespDto activityItemRespDto = new ActivityItemRespDto();
                    activityItemRespDto.setOriginalStock(Long.valueOf(0L));
                    activityItemRespDto.setRemainingStock(priceDto2.getRemainingStock());
                    activityItemRespDto.setSkuId(priceDto2.getSkuId());
                    activityItemRespDto.setItemId(priceDto2.getItemId());
                    activityItemRespDto.setShopId(priceDto2.getShopId());
                    activityItemRespDto.setActivityPrice(priceDto2.getActivityPrice());
                    activityItemRespDto.setActivityId(priceDto2.getActivityId());
                    activityItemRespDto.setPromotionMethod(priceDto2.getPromotionMethod());
                    activityItemRespDto.setDiscount(priceDto2.getDiscount());
                    items.add(activityItemRespDto);
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(items)) {
                    this.setItemActivityInfo(activityIdsList, activityInfoRespDto, items);
                    this.setItemActivitySkus(items, simpleInfoDto, itemDetailInfoRespDto, activityIdsList, orgInfoId);
                }
            }
        } else {
            activityInfoRespDto.setItemActivityInfo(null);
        }
        this.setCouponActivityShopName(activityInfoRespDto);
        itemDetailInfoRespDto.setActivityInfoRespDto(activityInfoRespDto);
        this.setSkuOtherInfo(itemDetailInfoRespDto, shopId);
        return itemDetailInfoRespDto;
    }

    private void setCouponActivityShopName(ItemForActivityInfoRespDto activityInfoRespDto) {
        if (Objects.isNull(activityInfoRespDto)) {
            return;
        }
        List itemActivityInfo = activityInfoRespDto.getItemActivityInfo();
        if (CollUtil.isEmpty((Collection)itemActivityInfo)) {
            return;
        }
        Set shopIds = itemActivityInfo.stream().map(BaseActivityDto::getShopId).collect(Collectors.toSet());
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIds));
        Map<Long, String> shopNameMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getId, ShopDto::getName));
        itemActivityInfo.forEach(item -> {
            if (shopNameMap.containsKey(item.getShopId())) {
                item.setShopName((String)shopNameMap.get(item.getShopId()));
            }
        });
    }

    private List<ItemPolicyPriceRespDto> getItemPolicyPrice(Long itemId, Long shopId, Long customerId, List<? extends ItemSkuRespDto> itemSkuList) {
        CommunalPriceQueryReqDto reqDto = new CommunalPriceQueryReqDto();
        reqDto.setCustId(customerId);
        reqDto.setPolicyDate(new Date());
        ArrayList skuPriceReqDtos = new ArrayList();
        itemSkuList.forEach(skuInfo -> {
            CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
            skuPriceReqDto.setSkuId(skuInfo.getId());
            skuPriceReqDto.setItemId(itemId);
            skuPriceReqDto.setShopId(shopId);
            skuPriceReqDto.setSkuSellPrice(skuInfo.getPrice());
            skuPriceReqDtos.add(skuPriceReqDto);
        });
        reqDto.setSkuList(skuPriceReqDtos);
        return (List)this.ibItemPriceService.getItemPrice(reqDto).getData();
    }

    private void setItemActivityInfo(List<Long> activityIdsList, ItemForActivityInfoRespDto activityInfoRespDto, List<ActivityItemRespDto> items) {
        List activityIds = items.stream().map(ActivityItemRespDto::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityIds(activityIds);
        logger.info("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)activityDto));
        List activityRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.activityQueryApi.queryActivityList(activityDto));
        logger.info("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)activityRespDtos));
        ArrayList list = Lists.newArrayList();
        for (ActivityRespDto activityRespDto : activityRespDtos) {
            if (!activityIdsList.contains(activityRespDto.getId())) continue;
            ItemActivityInfoRespDto respDto = new ItemActivityInfoRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)activityRespDto, (String[])new String[0]);
            respDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
            activityInfoRespDto.getItemActivityInfo().add(respDto);
        }
    }

    private <T extends ItemSkuRespDto> List<ActivityItemRespDto> getJoinItems(long itemId, Long activityId, Long shopId) {
        ActivityItemQueryReqDto queryReqDto = new ActivityItemQueryReqDto();
        queryReqDto.setItemId(Long.valueOf(itemId));
        queryReqDto.setShopId(shopId);
        queryReqDto.setActivityId(activityId);
        return (List)this.activityItemQueryApi.queryAll(queryReqDto).getData();
    }

    private void setItemActivitySkus(List<ActivityItemRespDto> activityItems, ActivitySimpleInfoDto activityInfo, ItemDetailInfoRespDto itemDetailInfo, List<Long> activityIdsList, Long orgInfoId) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(activityItems)) {
            return;
        }
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        String group = "yundt-cube-center-common-" + pfile;
        ArrayList activitySkus = Lists.newArrayList();
        ArrayList activityPriceList = Lists.newArrayList();
        itemDetailInfo.getItemBaseInfo().getItemSkuList().forEach(sku -> {
            ItemSkuInfoRespDto activitySku = new ItemSkuInfoRespDto();
            CubeBeanUtils.copyProperties((Object)activitySku, (Object)sku, (String[])new String[0]);
            for (ActivityItemRespDto activityItem : activityItems) {
                ItemPriceRespDto activityPrice = new ItemPriceRespDto();
                activityPrice.setName("\u6d3b\u52a8\u4ef7");
                activityPrice.setCurrency("\u5143");
                activityPrice.setItemId(activityItem.getItemId());
                activityPrice.setSkuId(activityItem.getSkuId());
                activityPrice.setPrice(activityItem.getActivityPrice());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activitySku.getItemPriceList())) {
                    activitySku.getItemPriceList().add(activityPrice);
                }
                if (activityInfo.getActivityTemplateId().equals(ActivityType.GROUP_ACTIVITY.getId()) || activityInfo.getActivityTemplateId().equals(ActivityType.SECKILL_ACTIVITY.getId())) {
                    activitySku.setShelfAmount(activityItem.getRemainingStock());
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)sku.getItemPriceList())) {
                    sku.getItemPriceList().add(activityPrice);
                }
                ItemActivityPriceRespDto itemActivityPrice = new ItemActivityPriceRespDto();
                itemActivityPrice.setItemId(activityItem.getItemId());
                itemActivityPrice.setShopId(activityItem.getShopId());
                itemActivityPrice.setSkuId(activityItem.getSkuId());
                itemActivityPrice.setActivityPrice(activityItem.getActivityPrice());
                itemActivityPrice.setActivityType(ActivityType.getByType((Long)activityInfo.getActivityTemplateId()));
                itemActivityPrice.setActivityId(activityItem.getActivityId());
                itemActivityPrice.setActivityName(activityInfo.getActivityTag());
                itemActivityPrice.setRemainingStock(activityItem.getRemainingStock());
                itemActivityPrice.setPromotionMethod(activityItem.getPromotionMethod());
                itemActivityPrice.setDiscount(activityItem.getDiscount());
                if (ActivityType.SECKILL_TOB_ACTIVITY.equals((Object)itemActivityPrice.getActivityType())) {
                    itemActivityPrice.setPurchaseNumLimit(this.getPurchaseNumLimit(activityItem.getActivityId(), group));
                    itemActivityPrice.setRemainingJoinNum(this.getRemainingJoinNum(activityItem.getActivityId(), orgInfoId, group));
                }
                activityPriceList.add(itemActivityPrice);
            }
            activitySkus.add(activitySku);
        });
        itemDetailInfo.getItemBaseInfo().setActivitySkus((List)activitySkus);
        activityPriceList.removeIf(itemActivityPriceRespDto -> !activityIdsList.contains(itemActivityPriceRespDto.getActivityId()));
        itemDetailInfo.getItemBaseInfo().setActivityPriceList((List)activityPriceList);
    }

    public PageInfo<ItemInfoRespDto> queryItemPageForHomepage(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        ArrayList respDtos = Lists.newArrayList();
        if (CollUtil.isEmpty((Collection)respDtos)) {
            return new PageInfo();
        }
        List itemIds = respDtos.stream().map(bean -> bean.getItemId()).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo();
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        BeanCopierUtils.copy((Object)itemDepthReqDto, (Object)itemSearchQueryReqDto);
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        itemSearchQueryReqDto.setSearch(Boolean.valueOf(false));
        if (itemDepthReqDto.getBusType() == null) {
            itemSearchQueryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        itemSearchQueryReqDto.setItemIds(itemIds);
        List<Long> customerIdList = this.getCustomerIdListByUserId(this.context.userId());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerIdList)) {
            return new PageInfo();
        }
        HashMap outSkuIdsMap = new HashMap();
        CustomerItemAuthInfo customerItemAuthInfo = this.customerBuyScopeService.setCustomerItemAuth(itemDepthReqDto, itemSearchQueryReqDto, outSkuIdsMap);
        if (!customerItemAuthInfo.getState().booleanValue()) {
            return pageInfo;
        }
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemIds.size())));
        if (null == itemSearchRespDto || !PageInfoUtil.isNotEmpty(itemSearchRespDto.getPageInfo())) {
            return pageInfo;
        }
        List<ItemInfoRespDto> list = this.convertToItemInfoRespDto(itemSearchRespDto.getPageInfo().getList());
        try {
            List itemList = list.stream().map(item -> item.getItemId() + "-" + item.getName()).collect(Collectors.toList());
            logger.info("[\u5546\u54c1\u641c\u7d22] >>> \u5546\u54c1\u67e5\u8be2\u7ed3\u679c{}", itemList);
            this.setItemPolicyPriceInfo(list);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5ba2\u6237\u7684\u653f\u7b56\u4ef7\u683c\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        Boolean activitySearch = false;
        if (ItemBusTypeEnum.ORDINARY.getType().equals(itemSearchQueryReqDto.getBusType()) || activitySearch.booleanValue()) {
            this.setItemActivityInfo(list, activitySearch, true, itemDepthReqDto.getCustomerIdList());
        }
        if (ItemBusTypeEnum.ORDINARY.getType().equals(itemSearchQueryReqDto.getBusType()) && activitySearch.booleanValue() && Integer.valueOf(1).equals(itemDepthReqDto.getIsMakeUp())) {
            this.setItemActivityInfo(list, false, true, itemDepthReqDto.getCustomerIdList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            list.stream().filter(item -> item.getShelfType() == null && item.getShopId() != null && item.getItemId() != null).forEach(item -> {
                RestResponse itemCycleBuyResp = this.itemCycleBuyQueryApi.queryItemCycleBuy(item.getShopId(), item.getItemId());
                if ("0".equals(itemCycleBuyResp.getResultCode()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((Collection)itemCycleBuyResp.getData()))) {
                    item.setShelfType(ShelfTypeEnum.PERIOD.getType());
                } else {
                    item.setShelfType(ShelfTypeEnum.NORMAL.getType());
                }
            });
            if (CollUtil.isNotEmpty(outSkuIdsMap)) {
                for (ItemInfoRespDto itemInfoRespDto : list) {
                    List outSkuIds = (List)outSkuIdsMap.get(itemInfoRespDto.getId());
                    List itemSkuList = itemInfoRespDto.getItemSkuList();
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)outSkuIds)) continue;
                    itemSkuList.removeIf(skuRespDto -> outSkuIds.contains(skuRespDto.getId()));
                }
            }
            Map shopSkuMap = customerItemAuthInfo.getShopSkuMap();
            if (Objects.nonNull(itemSearchQueryReqDto.getShopId()) && shopSkuMap.containsKey(itemSearchQueryReqDto.getShopId())) {
                Set skuIdSet = (Set)shopSkuMap.get(itemSearchQueryReqDto.getShopId());
                list.forEach(item -> item.setItemSkuList(item.getItemSkuList().stream().filter(skuInfo -> skuIdSet.contains(skuInfo.getId())).collect(Collectors.toList())));
            }
            list.forEach(item -> {
                item.setItemSkuSellState(CollUtil.isNotEmpty((Collection)item.getItemSkuList()));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)item.getTags())) {
                    item.setTagNum(Integer.valueOf(item.getTags().size()));
                } else {
                    item.setTagNum(Integer.valueOf(0));
                }
            });
            if (Objects.equals(itemDepthReqDto.getStockLimit(), 1)) {
                list.forEach(item -> {
                    if (item.isItemSkuSellState()) {
                        ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)item.getItemSkuList().get(0);
                        item.setItemSkuStockState(Objects.nonNull(itemSkuRespDto) && itemSkuRespDto.getBalance() > 0L);
                    } else {
                        item.setItemSkuStockState(Boolean.FALSE.booleanValue());
                    }
                });
            }
            if (Objects.equals(itemDepthReqDto.getActivityLimit(), 1)) {
                list.forEach(item -> {
                    if (item.isItemSkuSellState()) {
                        item.setItemActivityState(item.getTagNum() > 0);
                    } else {
                        item.setItemActivityState(Boolean.FALSE.booleanValue());
                    }
                });
            }
            this.filterSku(null, customerItemAuthInfo, list, itemSearchQueryReqDto);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)itemSearchRespDto.getPageInfo(), (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList(list);
        this.setSkuOtherInfo((PageInfo<ItemInfoRespDto>)pageInfo);
        ArrayList inStockList = new ArrayList();
        ArrayList outStockList = new ArrayList();
        HashSet unitIds = Sets.newHashSet();
        list.forEach(item -> {
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)item.getItemSkuList().get(0);
            if (Objects.nonNull(itemSkuRespDto.getUnit())) {
                unitIds.add(itemSkuRespDto.getUnit());
                item.setUnit(itemSkuRespDto.getUnit());
            }
            if (item.isItemSkuSellState()) {
                if (Objects.nonNull(itemSkuRespDto) && itemSkuRespDto.getBalance() > 0L) {
                    inStockList.add(item);
                } else {
                    outStockList.add(item);
                }
            } else {
                outStockList.add(item);
            }
        });
        Map<String, String> unitMap = this.getUnitMapByUnitIds(Lists.newArrayList((Iterable)unitIds));
        for (ItemInfoRespDto itemInfoRespDto : list) {
            if (!Objects.nonNull(itemInfoRespDto.getUnit())) continue;
            itemInfoRespDto.setUnitName(unitMap.get(itemInfoRespDto.getUnit()));
        }
        List newInStockList = inStockList.stream().sorted(Comparator.comparing(ItemInfoRespDto::getTagNum, Comparator.reverseOrder())).collect(Collectors.toList());
        newInStockList.addAll(outStockList);
        pageInfo.setList(newInStockList);
        return pageInfo;
    }

    public Long getCustomerIdListByMerchantIdAndOrgInfoId(Long orgInfoId, Long shopId) {
        ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(shopId));
        if (Objects.isNull(shopBaseDto)) {
            throw new BizException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RestResponse customerRespDtoRestResponse = this.customerExtQueryApi.queryCustomerByOrgAndMerch(orgInfoId, shopBaseDto.getOrganizationId());
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRestResponse);
        if (Objects.isNull(customerRespDto)) {
            return null;
        }
        return customerRespDto.getId();
    }

    public List<NotSupportSingleItemDto> getNotSupportSingleItem(SupportSingleItemDto supportSingleItemDto) {
        List notSupportSingleItemDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.queryNotSupportSingleItem(supportSingleItemDto));
        logger.info("[\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1\u4fe1\u606f],\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)notSupportSingleItemDtos));
        return notSupportSingleItemDtos;
    }

    private /* synthetic */ ItemSkuRespDto lambda$filterOnSelfSkuAndModifyAndOther$84(Long shopId, Map finalSkuShelfMap, Map activityStockMap, CommonItemInfo commonItemInfo, ItemSkuRespDto itemSkuInfoRespDto) {
        String key = shopId.toString() + "_" + itemSkuInfoRespDto.getId();
        ItemShelfRespDto itemShelfRespDto = (ItemShelfRespDto)((List)finalSkuShelfMap.get(key)).get(0);
        Long activityStock = (Long)activityStockMap.get(key);
        if (ObjectUtil.isEmpty((Object)activityStock)) {
            activityStock = commonConstant.INIT_STOCK;
        }
        logger.info("key\u662f[{}],itemShelfRespDto=[{}],activityStock=[{}]", new Object[]{key, itemShelfRespDto, activityStock});
        itemSkuInfoRespDto.setPrice(itemShelfRespDto.getPrice());
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>(1);
        ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
        itemStorageQueryDto.setSkuId(itemShelfRespDto.getSkuId());
        itemStorageQueryDto.setShopId(itemShelfRespDto.getShopId());
        itemStorageQueryDto.setCargoCode(itemSkuInfoRespDto.getCargoCode());
        itemStorageList.add(itemStorageQueryDto);
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List<ItemStorageQueryDto> itemStorageQueryDtos = this.queryBranchItemStorage(storageBranchQueryReqDto);
        itemSkuInfoRespDto.setShelfAmount(Long.valueOf(itemStorageQueryDtos.get(0).getAvaNum() + activityStock));
        itemSkuInfoRespDto.setBalance(itemSkuInfoRespDto.getShelfAmount());
        itemSkuInfoRespDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkuInfoRespDto.getItemPriceList())) {
            for (ItemPriceRespDto itemPriceRespDto : itemSkuInfoRespDto.getItemPriceList()) {
                if (!"\u552e\u4ef7".equals(itemPriceRespDto.getName())) continue;
                itemPriceRespDto.setPrice(itemShelfRespDto.getPrice());
            }
        }
        if (itemShelfRespDto.getShelfIntegral() != null) {
            Long cashIntegral = itemShelfRespDto.getShelfIntegral().getCashIntegral();
            BigDecimal cashAmount = itemShelfRespDto.getShelfIntegral().getCashAmount();
            itemSkuInfoRespDto.setCashIntegral(cashIntegral);
            itemSkuInfoRespDto.setCashAmount(cashAmount);
            if (commonItemInfo != null) {
                if (commonItemInfo.getCashType() == null) {
                    commonItemInfo.setCashType(itemShelfRespDto.getShelfIntegral().getCashType());
                }
                if (commonItemInfo instanceof ItemBaseInfoRespDto && commonItemInfo.getRuleRemark() == null) {
                    commonItemInfo.setRuleRemark(itemShelfRespDto.getShelfIntegral().getRuleRemark());
                }
                if (commonItemInfo instanceof ItemInfoRespDto) {
                    ItemInfoRespDto itemInfoRespDto = (ItemInfoRespDto)commonItemInfo;
                    if (itemInfoRespDto.getCashAmount() == null || itemInfoRespDto.getCashAmount().compareTo(cashAmount) > 0) {
                        itemInfoRespDto.setCashAmount(cashAmount);
                        itemInfoRespDto.setCashIntegral(cashIntegral);
                    } else if (!(itemInfoRespDto.getCashAmount() != null && itemInfoRespDto.getCashAmount().compareTo(BigDecimal.ZERO) != 0 || itemInfoRespDto.getCashIntegral() != null && itemInfoRespDto.getCashIntegral() <= cashIntegral)) {
                        itemInfoRespDto.setCashAmount(cashAmount);
                        itemInfoRespDto.setCashIntegral(cashIntegral);
                    }
                }
            }
        }
        return itemSkuInfoRespDto;
    }

    private static /* synthetic */ boolean lambda$filterOnSelfSkuAndModifyAndOther$83(Map finalSkuShelfMap, Long shopId, ItemSkuRespDto itemSkuInfoRespDto) {
        return org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((Collection)finalSkuShelfMap.get(shopId.toString() + "_" + itemSkuInfoRespDto.getId())));
    }

    private static /* synthetic */ ItemSkuRespDto lambda$filterOnSelfSkuAndModifyAndOther$81(Map finalSkuShelfMap, Long shopId, Map avaNumMap, CommonItemInfo commonItemInfo, ItemSkuRespDto itemSkuInfoRespDto) {
        ItemShelfRespDto itemShelfRespDto = (ItemShelfRespDto)((List)finalSkuShelfMap.get(shopId.toString() + itemSkuInfoRespDto.getId())).get(0);
        itemSkuInfoRespDto.setShopId(shopId);
        itemSkuInfoRespDto.setStockDisplay(itemShelfRespDto.getStockDisplay());
        itemSkuInfoRespDto.setLimitMin(itemShelfRespDto.getLimitMin());
        itemSkuInfoRespDto.setLimitMinMode(itemShelfRespDto.getLimitMinMode());
        itemSkuInfoRespDto.setMultipleStatus(itemShelfRespDto.getMultipleStatus());
        itemSkuInfoRespDto.setPrice(itemShelfRespDto.getPrice());
        itemSkuInfoRespDto.setShelfAmount((Long)avaNumMap.get(itemShelfRespDto.getShopId() + "_" + itemShelfRespDto.getSkuId() + "_" + itemSkuInfoRespDto.getCargoCode()));
        itemSkuInfoRespDto.setBalance(itemSkuInfoRespDto.getShelfAmount());
        itemSkuInfoRespDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkuInfoRespDto.getItemPriceList())) {
            for (ItemPriceRespDto itemPriceRespDto : itemSkuInfoRespDto.getItemPriceList()) {
                if (!"\u552e\u4ef7".equals(itemPriceRespDto.getName())) continue;
                itemPriceRespDto.setPrice(itemShelfRespDto.getPrice());
            }
        }
        if (itemShelfRespDto.getShelfIntegral() != null) {
            Long cashIntegral = itemShelfRespDto.getShelfIntegral().getCashIntegral();
            BigDecimal cashAmount = itemShelfRespDto.getShelfIntegral().getCashAmount();
            itemSkuInfoRespDto.setCashIntegral(cashIntegral);
            itemSkuInfoRespDto.setCashAmount(cashAmount);
            if (commonItemInfo != null) {
                if (commonItemInfo.getCashType() == null) {
                    commonItemInfo.setCashType(itemShelfRespDto.getShelfIntegral().getCashType());
                }
                if (commonItemInfo instanceof ItemBaseInfoRespDto && commonItemInfo.getRuleRemark() == null) {
                    commonItemInfo.setRuleRemark(itemShelfRespDto.getShelfIntegral().getRuleRemark());
                }
                if (commonItemInfo instanceof ItemInfoRespDto) {
                    ItemInfoRespDto itemInfoRespDto = (ItemInfoRespDto)commonItemInfo;
                    if (itemInfoRespDto.getCashAmount() == null || itemInfoRespDto.getCashAmount().compareTo(cashAmount) > 0) {
                        itemInfoRespDto.setCashAmount(cashAmount);
                        itemInfoRespDto.setCashIntegral(cashIntegral);
                    } else if (!(itemInfoRespDto.getCashAmount() != null && itemInfoRespDto.getCashAmount().compareTo(BigDecimal.ZERO) != 0 || itemInfoRespDto.getCashIntegral() != null && itemInfoRespDto.getCashIntegral() <= cashIntegral)) {
                        itemInfoRespDto.setCashAmount(cashAmount);
                        itemInfoRespDto.setCashIntegral(cashIntegral);
                    }
                }
            }
        }
        return itemSkuInfoRespDto;
    }

    private static /* synthetic */ boolean lambda$filterOnSelfSkuAndModifyAndOther$80(Map finalSkuShelfMap, Long shopId, ItemSkuRespDto itemSkuInfoRespDto) {
        return org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((Collection)finalSkuShelfMap.get(shopId.toString() + itemSkuInfoRespDto.getId())));
    }

    private static /* synthetic */ ItemSkuRespDto lambda$newFfilterOnSelfSkuAndModifyAndOther$26(Map finalSkuShelfMap, Long shopId, Map avaNumMap, CommonItemInfo commonItemInfo, ItemSkuRespDto itemSkuInfoRespDto) {
        ItemShelfRespDto itemShelfRespDto = (ItemShelfRespDto)((List)finalSkuShelfMap.get(shopId.toString() + itemSkuInfoRespDto.getId())).get(0);
        itemSkuInfoRespDto.setShopId(shopId);
        itemSkuInfoRespDto.setStockDisplay(itemShelfRespDto.getStockDisplay());
        itemSkuInfoRespDto.setLimitMin(itemShelfRespDto.getLimitMin());
        itemSkuInfoRespDto.setLimitMinMode(itemShelfRespDto.getLimitMinMode());
        itemSkuInfoRespDto.setMultipleStatus(itemShelfRespDto.getMultipleStatus());
        itemSkuInfoRespDto.setPrice(itemShelfRespDto.getPrice());
        if (avaNumMap != null) {
            itemSkuInfoRespDto.setShelfAmount(Long.valueOf(avaNumMap.getOrDefault(itemSkuInfoRespDto.getCargoCode(), new BigDecimal(0)).longValue()));
        } else {
            itemSkuInfoRespDto.setShelfAmount(Long.valueOf(0L));
        }
        itemSkuInfoRespDto.setBalance(itemSkuInfoRespDto.getShelfAmount());
        itemSkuInfoRespDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        if (itemShelfRespDto.getShelfIntegral() != null) {
            Long cashIntegral = itemShelfRespDto.getShelfIntegral().getCashIntegral();
            BigDecimal cashAmount = itemShelfRespDto.getShelfIntegral().getCashAmount();
            itemSkuInfoRespDto.setCashIntegral(cashIntegral);
            itemSkuInfoRespDto.setCashAmount(cashAmount);
            if (commonItemInfo != null) {
                if (commonItemInfo.getCashType() == null) {
                    commonItemInfo.setCashType(itemShelfRespDto.getShelfIntegral().getCashType());
                }
                if (commonItemInfo instanceof ItemBaseInfoRespDto && commonItemInfo.getRuleRemark() == null) {
                    commonItemInfo.setRuleRemark(itemShelfRespDto.getShelfIntegral().getRuleRemark());
                }
                if (commonItemInfo instanceof ItemInfoRespDto) {
                    ItemInfoRespDto itemInfoRespDto = (ItemInfoRespDto)commonItemInfo;
                    if (itemInfoRespDto.getCashAmount() == null || itemInfoRespDto.getCashAmount().compareTo(cashAmount) > 0) {
                        itemInfoRespDto.setCashAmount(cashAmount);
                        itemInfoRespDto.setCashIntegral(cashIntegral);
                    } else if (!(itemInfoRespDto.getCashAmount() != null && itemInfoRespDto.getCashAmount().compareTo(BigDecimal.ZERO) != 0 || itemInfoRespDto.getCashIntegral() != null && itemInfoRespDto.getCashIntegral() <= cashIntegral)) {
                        itemInfoRespDto.setCashAmount(cashAmount);
                        itemInfoRespDto.setCashIntegral(cashIntegral);
                    }
                }
            }
        }
        return itemSkuInfoRespDto;
    }

    private static /* synthetic */ boolean lambda$newFfilterOnSelfSkuAndModifyAndOther$25(Map finalSkuShelfMap, Long shopId, ItemSkuRespDto itemSkuInfoRespDto) {
        return org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((Collection)finalSkuShelfMap.get(shopId.toString() + itemSkuInfoRespDto.getId())));
    }
}

