/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyConfigRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseSupplyConfigQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.module.bitem.biz.inventory.ItemInventoryStrategyService;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ItemInventoryStrategyHelper {
    private static final Logger log = LoggerFactory.getLogger(ItemInventoryStrategyHelper.class);
    @Resource
    private IWarehouseSupplyConfigQueryApi warehouseSupplyConfigQueryApi;
    @Resource
    private List<ItemInventoryStrategyService> itemInventoryStrategyServiceList;
    public static Map<String, ItemInventoryStrategyService> STRATEGY_SERVICE_TABLE = null;

    @PostConstruct
    public void init() {
        STRATEGY_SERVICE_TABLE = this.itemInventoryStrategyServiceList.stream().collect(Collectors.toMap(v -> v.getStrategy().getCode(), service -> service));
    }

    public ItemInventoryStrategyEnum strategyOfCustomerFlag(Long customerId, Long shopId, String organizationId) {
        if (null == customerId) {
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        if (null == shopId && null == organizationId) {
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        WarehouseSupplyConfigReqDto warehouseSupplyConfigReqDto = new WarehouseSupplyConfigReqDto();
        warehouseSupplyConfigReqDto.setCustomerId(customerId);
        warehouseSupplyConfigReqDto.setShopId(shopId);
        warehouseSupplyConfigReqDto.setOrganizationId(Long.valueOf(organizationId));
        PageInfo warehouseSupplyConfigRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseSupplyConfigQueryApi.queryByPage(JSON.toJSONString((Object)warehouseSupplyConfigReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        List configRespDtos = warehouseSupplyConfigRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)configRespDtos)) {
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        WarehouseSupplyConfigRespDto warehouseSupplyConfigRespDto = (WarehouseSupplyConfigRespDto)configRespDtos.stream().findFirst().get();
        return ItemInventoryStrategyEnum.getByCode((Integer)warehouseSupplyConfigRespDto.getSupplyType());
    }

    public static ItemInventoryStrategyService getStrategyService(String code) {
        log.info(" get inventory strategy code is {} .", (Object)code);
        if (StringUtils.isEmpty((Object)code)) {
            log.info(" code is empty string , choose default strategy . ");
            return STRATEGY_SERVICE_TABLE.get(ItemInventoryStrategyEnum.DEFAULT.getCode());
        }
        ItemInventoryStrategyService itemInventoryStrategyService = STRATEGY_SERVICE_TABLE.get(code);
        if (null == itemInventoryStrategyService) {
            return STRATEGY_SERVICE_TABLE.get(ItemInventoryStrategyEnum.DEFAULT.getCode());
        }
        return itemInventoryStrategyService;
    }
}

