/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.price;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.bitem.biz.price.constants.PriceTypeEnum;
import com.yx.tcbj.center.price.api.dto.response.EnablePriceConfigRespDto;
import com.yx.tcbj.center.price.api.query.IEnablePriceConfigQueryApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PriceRuleHelper {
    public static final String TCBJ = "TCBJ";
    public static final String PRICE_CENTER = "PRICE_CENTER";
    @Autowired
    private IEnablePriceConfigQueryApi enablePriceConfigQueryApi;

    public boolean isUseCenterPrice(Long shopId) {
        EnablePriceConfigRespDto enablePriceConfigRespDto = (EnablePriceConfigRespDto)RestResponseHelper.extractData((RestResponse)this.enablePriceConfigQueryApi.queryByShopId(shopId));
        return enablePriceConfigRespDto != null;
    }

    public boolean isNotUseCenterPrice(Long shopId) {
        return !this.isUseCenterPrice(shopId);
    }

    public PriceTypeEnum toPriceTypeEnum(Long shopId) {
        if (shopId == null) {
            return null;
        }
        return PriceTypeEnum.toPriceTypeEnum(this.isUseCenterPrice(shopId) ? PRICE_CENTER : TCBJ);
    }
}

