/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.inventory.impl;

import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalBatchQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.module.bitem.biz.inventory.ItemInventoryStrategyService;
import com.dtyunxi.yundt.module.bitem.biz.service.IBInventoryService;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ItemInventoryDefaultStrategyServiceImpl
implements ItemInventoryStrategyService {
    private static final Logger log = LoggerFactory.getLogger(ItemInventoryDefaultStrategyServiceImpl.class);
    @Resource
    private IBInventoryService inventoryService;
    @Resource
    private ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;

    @Override
    public ItemInventoryStrategyEnum getStrategy() {
        return ItemInventoryStrategyEnum.DEFAULT;
    }

    @Override
    public List<CsLogicInventoryTotalRespDto> getInventoryList(List<String> cargoCodeList, Long shopId, Long customerId) {
        log.info("\u9ed8\u8ba4\u5e93\u5b58\u67e5\u8be2\u7b56\u7565 req params , cargoCodeList : {} ,organizationId : {} ,customerId : {} .", new Object[]{cargoCodeList, shopId, customerId});
        WarehouseRespDto warehouseRespDto = this.inventoryService.queryWarehouseByShopId(shopId);
        CsLogicInventoryTotalBatchQueryDto tcbjAvilableReqDto = new CsLogicInventoryTotalBatchQueryDto();
        tcbjAvilableReqDto.setWarehouseCode(warehouseRespDto.getCode());
        tcbjAvilableReqDto.setCargoCodeList(cargoCodeList);
        return (List)this.csLogicInventoryTotalQueryApi.queryWarehouseInventory(tcbjAvilableReqDto).getData();
    }

    @Override
    public List<String> getWarehouseList(Long shopId, Long customerId) {
        WarehouseRespDto warehouseRespDto = this.inventoryService.queryWarehouseByShopId(shopId);
        return Lists.newArrayList((Object[])new String[]{warehouseRespDto.getCode()});
    }
}

