/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuthLimitDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.api.IBitemLibService;
import com.dtyunxi.yundt.module.bitem.api.constants.AuthTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.constants.CustomerBuyScopeTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemListQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemListInfo;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemListRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.SellerSkuPriceDto;
import com.dtyunxi.yundt.module.bitem.biz.price.ItemPriceHelper;
import com.dtyunxi.yundt.module.bitem.biz.price.PriceRuleHelper;
import com.dtyunxi.yundt.module.bitem.biz.price.impl.TcbjPriceImpl;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.ItemBrandAuthApi;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthCheckItemsReqDto;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthCheckItemsRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BitemLibServiceImpl
implements IBitemLibService {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(BitemLibServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BitemLibServiceImpl.class);
    @Value(value="${itemPrice.useRules:DEFAULT}")
    private String itemPriceUseRules;
    @Resource
    private IContext context;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private TcbjPriceImpl tcbjPriceImpl;
    @Resource
    private IBItemPriceService ibItemPriceService;
    @Resource
    private ItemPriceHelper itemPriceHelper;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Autowired
    private PriceRuleHelper priceRuleHelper;
    @Resource
    private ItemBrandAuthApi itemBrandAuthApi;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private IBasePriceItemQueryApi iBasePriceItemQueryApi;

    public ItemListInfo queryDealerItemlib(ItemListQueryReqDto itemListQueryReqDto, Integer pageNum, Integer pageSize) {
        if (itemListQueryReqDto.getInstanceId() == null) {
            itemListQueryReqDto.setInstanceId(this.context.instanceId());
        }
        if (itemListQueryReqDto.getTenantId() == null) {
            itemListQueryReqDto.setTenantId(this.context.tenantId());
        }
        String attachment = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        logger.info("\u5927b\u7684\u7ec4\u7ec7id\u4e3a:{}", (Object)attachment);
        if (StringUtils.isBlank((CharSequence)attachment)) {
            logger.info("\u83b7\u53d6\u5230\u7684\u7ec4\u7ec7id\u4e3a\u7a7a");
            return new ItemListInfo();
        }
        List shopBaseDtos = (List)this.shopExtQueryApi.queryShopListBySellerOrgId(Long.valueOf(attachment)).getData();
        if (CollectionUtils.isEmpty((Collection)shopBaseDtos)) {
            logger.info("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u5e97\u94fa\u5217\u8868\u4e3a\u7a7a");
            return new ItemListInfo();
        }
        itemListQueryReqDto.setShopId(((ShopBaseDto)shopBaseDtos.get(0)).getId());
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6570\u636e\u53c2\u6570={}", JSON.toJSON((Object)itemListQueryReqDto));
        PageInfo<ItemListRespDto> pageInfo = this.queryItem(itemListQueryReqDto, pageNum, pageSize);
        ItemListInfo itemListInfo = new ItemListInfo();
        itemListInfo.setPageInfo(pageInfo);
        return itemListInfo;
    }

    private void filterLimit(ItemReqDto itemReqDto) {
        List limitList = itemReqDto.getLimitList();
        if (CollUtil.isEmpty((Collection)limitList)) {
            return;
        }
        List limitDtos = limitList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getBusinessType()) && Objects.nonNull(item.getTargetType()) && CollUtil.isNotEmpty((Collection)item.getTargetIdList())).collect(Collectors.groupingBy(item -> item.getBusinessType() + "-" + item.getTargetType())).values().stream().map(items -> {
            HashSet targetIdList = new HashSet();
            items.forEach(item -> targetIdList.addAll(item.getTargetIdList()));
            ItemAuthLimitDto itemAuthLimitDto = new ItemAuthLimitDto();
            itemAuthLimitDto.setTargetIdList(new ArrayList(targetIdList));
            itemAuthLimitDto.setTargetType(((ItemAuthLimitDto)items.get(0)).getTargetType());
            itemAuthLimitDto.setBusinessType(((ItemAuthLimitDto)items.get(0)).getBusinessType());
            return itemAuthLimitDto;
        }).collect(Collectors.toList());
        itemReqDto.setLimitList(limitDtos);
    }

    public PageInfo<ItemSkuExtRespDto> queryItemLibSkuByPage(ItemListQueryReqDto itemListQueryReqDto, Integer pageNum, Integer pageSize) {
        if (itemListQueryReqDto.getInstanceId() == null) {
            itemListQueryReqDto.setInstanceId(this.context.instanceId());
        }
        if (itemListQueryReqDto.getTenantId() == null) {
            itemListQueryReqDto.setTenantId(this.context.tenantId());
        }
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6570\u636e\u53c2\u6570={}", JSON.toJSON((Object)itemListQueryReqDto));
        ItemReqDto itemReqDto = new ItemReqDto();
        BeanUtils.copyProperties((Object)itemListQueryReqDto, (Object)itemReqDto);
        itemReqDto.setId(null);
        itemReqDto.setCode(itemListQueryReqDto.getItemCode());
        itemReqDto.setName(itemListQueryReqDto.getItemName());
        itemReqDto.setDirId(itemListQueryReqDto.getBackDirId());
        itemReqDto.setType(itemListQueryReqDto.getType());
        this.filterLimit(itemReqDto);
        if (itemListQueryReqDto.getBundle() != null) {
            if (itemListQueryReqDto.getBundle() == 1) {
                itemReqDto.setType(ItemTypeEnum.BUNDLE.getType());
            } else if (itemReqDto.getType() == null) {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{ItemTypeEnum.GENERAL.getType(), ItemTypeEnum.VIRTUAL.getType(), ItemTypeEnum.PRODUCT.getType()}));
            } else {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{itemReqDto.getType()}));
            }
        }
        Long currentUserOrgId = this.getCurrentUserOrgId(this.context.userId());
        ArrayList brandOrgIds = CustomerTypeEnum.DEALER.getCode().equals(itemListQueryReqDto.getChannel()) ? this.queryBrandOrgIds(currentUserOrgId) : Lists.newArrayList((Object[])new Long[]{currentUserOrgId});
        itemReqDto.setOrganizationIdList(brandOrgIds);
        if (AuthTypeEnum.RETAILER.getCode().equals(itemListQueryReqDto.getAuthType())) {
            Assert.notNull((Object)itemListQueryReqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            HashSet brandIds = Sets.newHashSet();
            HashSet dirIds = Sets.newHashSet();
            HashSet disableSkuids = Sets.newHashSet();
            HashSet skuIds = Sets.newHashSet();
            ItemAuthQueryReqDto itemAuthQueryReqDto = new ItemAuthQueryReqDto();
            itemAuthQueryReqDto.setChannel(Integer.valueOf(1));
            itemAuthQueryReqDto.setTargetType(Integer.valueOf(2));
            itemAuthQueryReqDto.setOrganizationIdList((List)Lists.newArrayList((Object[])new Long[]{itemListQueryReqDto.getMerchantId()}));
            itemAuthQueryReqDto.setPageNum(Integer.valueOf(1));
            itemAuthQueryReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            RestResponse pageInfoRestResp = this.itemAuthQueryApi.queryItemAuthPage(itemAuthQueryReqDto);
            PageInfo itemAuthPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
            if (Objects.isNull(itemAuthPageInfo) || CollectionUtils.isEmpty((Collection)itemAuthPageInfo.getList())) {
                return new PageInfo();
            }
            for (ItemAuthQueryRespDto itemAuthQueryRespDto : itemAuthPageInfo.getList()) {
                CustomerBuyScopeTypeEnum type = CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)itemAuthQueryRespDto.getBusinessType());
                if (type == null) continue;
                switch (type) {
                    case SKU: {
                        skuIds.add(itemAuthQueryRespDto.getBusinessId());
                        break;
                    }
                    case BRAND: {
                        brandIds.add(itemAuthQueryRespDto.getBusinessId());
                        break;
                    }
                    case CATEGORY: {
                        dirIds.add(itemAuthQueryRespDto.getBusinessId());
                        break;
                    }
                    case BANSKU: {
                        disableSkuids.add(itemAuthQueryRespDto.getBusinessId());
                        break;
                    }
                }
            }
            itemReqDto.setDirIdList((List)Lists.newArrayList((Iterable)dirIds));
            itemReqDto.setBrandIdList((List)Lists.newArrayList((Iterable)brandIds));
            itemReqDto.setSkuIdList((List)Lists.newArrayList((Iterable)skuIds));
            itemReqDto.setOutSkuIdList((List)Lists.newArrayList((Iterable)disableSkuids));
        }
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93sku\u5217\u8868: {}", (Object)JSON.toJSONString((Object)itemReqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemLibSkuByPage(itemReqDto, pageNum, pageSize));
        this.setSkuPrice((PageInfo<ItemSkuExtRespDto>)pageInfo, itemListQueryReqDto);
        return pageInfo;
    }

    private void setSkuPrice(PageInfo<ItemSkuExtRespDto> pageInfo, ItemListQueryReqDto itemListQueryReqDto) {
    }

    public PageInfo<ItemSkuExtRespDto> queryDealerSkuByPage(ItemListQueryReqDto itemListQueryReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6570\u636e\u53c2\u6570={}", JSON.toJSON((Object)itemListQueryReqDto));
        Long sellerId = itemListQueryReqDto.getSellerId();
        Assert.notNull((Object)sellerId, (String)"\u6240\u5c5e\u5546\u5bb6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SellerRespDto sellerRespDto = (SellerRespDto)this.sellerQueryApi.queryById(sellerId).getData();
        Long sellerOrgId = sellerRespDto.getOrganizationId();
        Long customerId = null;
        ServiceContext serviceContext = ServiceContext.getContext();
        String CUSTOMERID_HEAD = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        customerId = StringUtils.isNotEmpty((CharSequence)CUSTOMERID_HEAD) ? Long.valueOf(CUSTOMERID_HEAD) : this.getCustomerIdByUserIdAndSellerOrgId(this.context.userId(), sellerOrgId);
        Assert.notNull((Object)customerId, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet brandIds = Sets.newHashSet();
        HashSet dirIds = Sets.newHashSet();
        HashSet disableSkuids = Sets.newHashSet();
        Set<Object> skuIds = Sets.newHashSet();
        ItemAuthQueryReqDto itemAuthQueryReqDto = new ItemAuthQueryReqDto();
        itemAuthQueryReqDto.setCustomerId(customerId);
        itemAuthQueryReqDto.setTargetIdList((List)Lists.newArrayList((Object[])new Long[]{customerId}));
        itemAuthQueryReqDto.setTargetType(Integer.valueOf(1));
        itemAuthQueryReqDto.setChannel(Integer.valueOf(2));
        itemAuthQueryReqDto.setCustomerChannelSource(Integer.valueOf(3));
        itemAuthQueryReqDto.setPageNum(Integer.valueOf(1));
        itemAuthQueryReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        RestResponse pageInfoRestResp = this.itemAuthQueryApi.queryItemAuthPage(itemAuthQueryReqDto);
        PageInfo itemAuthPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        if (Objects.isNull(itemAuthPageInfo) || CollectionUtils.isEmpty((Collection)itemAuthPageInfo.getList())) {
            return new PageInfo();
        }
        for (ItemAuthQueryRespDto itemAuthQueryRespDto : itemAuthPageInfo.getList()) {
            CustomerBuyScopeTypeEnum type = CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)itemAuthQueryRespDto.getBusinessType());
            if (type == null) continue;
            switch (type) {
                case SKU: {
                    skuIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BRAND: {
                    brandIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case CATEGORY: {
                    dirIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BANSKU: {
                    disableSkuids.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
            }
        }
        skuIds = this.filterItemsByBrandAuthCheck((Set<Long>)skuIds);
        ItemReqDto itemReqDto = new ItemReqDto();
        BeanUtils.copyProperties((Object)itemListQueryReqDto, (Object)itemReqDto);
        itemReqDto.setId(null);
        String keyword = itemListQueryReqDto.getKeyword();
        if (StrUtil.isNotBlank((CharSequence)keyword)) {
            itemReqDto.setKeyword(keyword);
        } else {
            itemReqDto.setCode(itemListQueryReqDto.getItemCode());
            itemReqDto.setName(itemListQueryReqDto.getItemName());
        }
        itemReqDto.setDirId(itemListQueryReqDto.getBackDirId());
        itemReqDto.setType(itemListQueryReqDto.getType());
        itemReqDto.setBrandId(itemListQueryReqDto.getBrandId());
        itemReqDto.setBrandIdList(itemListQueryReqDto.getBrandIdList());
        ArrayList<Integer> subTypeListReq = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty((Collection)itemReqDto.getSubTypeList())) {
            subTypeListReq.addAll(itemReqDto.getSubTypeList());
        }
        if (!Objects.isNull(itemReqDto.getSubType())) {
            subTypeListReq.add(itemReqDto.getSubType());
        } else {
            subTypeListReq.add(SubTypeEnum.PRODUCT.getType());
            subTypeListReq.add(SubTypeEnum.GIFT.getType());
        }
        itemReqDto.setSubTypeList(subTypeListReq);
        if (itemListQueryReqDto.getBundle() != null) {
            if (itemListQueryReqDto.getBundle() == 1) {
                itemReqDto.setType(ItemTypeEnum.BUNDLE.getType());
            } else if (itemReqDto.getType() == null) {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{ItemTypeEnum.GENERAL.getType(), ItemTypeEnum.VIRTUAL.getType(), ItemTypeEnum.PRODUCT.getType()}));
            } else {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{itemReqDto.getType()}));
            }
        }
        itemReqDto.setDirIdList((List)Lists.newArrayList((Iterable)dirIds));
        itemReqDto.setBrandIdList((List)Lists.newArrayList((Iterable)brandIds));
        itemReqDto.setSkuIdList((List)Lists.newArrayList(skuIds));
        itemReqDto.setOutSkuIdList((List)Lists.newArrayList((Iterable)disableSkuids));
        itemReqDto.setSellerId(null);
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93sku\u5217\u8868: {}", (Object)JSON.toJSONString((Object)itemReqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemLibSkuByPage(itemReqDto, pageNum, pageSize));
        Long shopId = itemListQueryReqDto.getShopId();
        this.replaceCustSkuPrice(pageInfo.getList(), customerId, shopId);
        return pageInfo;
    }

    private Set<Long> filterItemsByBrandAuthCheck(Set<Long> skuIds) {
        log.info("filterItemsByBrandAuthCheck\u5904\u7406\u524d skuIds={}", (Object)JSONObject.toJSONString(skuIds));
        CustomerRespDto customerRespDto = this.getJxsCustomerInfo();
        ShopQueryReqDto shopQueryDto = new ShopQueryReqDto();
        shopQueryDto.setCodes(Collections.singletonList(String.valueOf(customerRespDto.getOrgInfoId())));
        logger.info("\u5e97\u94fa\u4fe1\u606f\u6761\u4ef6\uff1a{}", (Object)JSONObject.toJSONString((Object)shopQueryDto));
        ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByCode(customerRespDto.getThirdPartyId()));
        if (shopDto == null) {
            throw new BizException("\u6ca1\u6709\u5bf9\u5e94\u7684\u5e97\u94fa\u4fe1\u606f");
        }
        ItemBrandAuthCheckItemsReqDto itemBrandAuthAddReqDto = ItemBrandAuthCheckItemsReqDto.builder().authType(null).saleControlType("2").ppfOrgId(customerRespDto.getMerchantId()).shopId(shopDto.getId()).skuIds(new ArrayList<Long>(skuIds)).build();
        log.info("itemBrandAuthApi.filterItemsByBrandAuthCheck() req={}", (Object)JSONObject.toJSONString((Object)itemBrandAuthAddReqDto));
        ItemBrandAuthCheckItemsRespDto itemBrandAuthCheckItemsRespDto = (ItemBrandAuthCheckItemsRespDto)this.itemBrandAuthApi.itemBrandAuthCheckItems(itemBrandAuthAddReqDto).getData();
        log.info("itemBrandAuthApi.filterItemsByBrandAuthCheck() result={}", (Object)JSONObject.toJSONString((Object)itemBrandAuthCheckItemsRespDto));
        HashSet<Long> skuIdsResult = new HashSet<Long>(itemBrandAuthCheckItemsRespDto.getPassSkuIds());
        log.info("filterItemsByBrandAuthCheck\u5904\u7406\u540e skuIds={}", (Object)JSONObject.toJSONString(skuIdsResult));
        if (skuIdsResult.isEmpty()) {
            skuIdsResult.add(99999999L);
        }
        return skuIdsResult;
    }

    private CustomerRespDto getJxsCustomerInfo() {
        String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.organizationid={}", (Object)orgId);
        if (orgId != null) {
            CustomerRespDto customerRespDto = (CustomerRespDto)this.iCustomerQueryApi.queryByOrgInfoId(Long.valueOf(orgId)).getData();
            log.info("\u4ece yes.req.cus.b2b.organizationid \u83b7\u53d6\u6210\u529f customerRespDto={}", (Object)JSONObject.toJSONString((Object)customerRespDto));
            if (customerRespDto == null) {
                throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
            }
            return customerRespDto;
        }
        log.info("\u4ece yes.req.cus.b2b.organizationid \u83b7\u53d6\u5931\u8d25");
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.customerid={}", (Object)customerid);
        if (customerid == null) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u8bf7\u6c42\u5934\u83b7\u53d6customerid\u5f02\u5e38");
        }
        List customerLssList = (List)this.iCustomerQueryApi.queryCustomerListByIds(Collections.singletonList(Long.valueOf(customerid))).getData();
        if (customerLssList == null || customerLssList.isEmpty()) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5c0fb\u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
        }
        List customerJxsList = (List)this.iCustomerQueryApi.queryCustomerByOrgId(Collections.singletonList(((CustomerRespDto)customerLssList.get(0)).getMerchantId())).getData();
        if (customerJxsList != null && !customerJxsList.isEmpty()) {
            log.info("\u4ece yes.req.cus.b2b.customerid \u83b7\u53d6\u6210\u529f customerRespDtoList={}", (Object)JSONObject.toJSONString((Object)customerJxsList));
            return (CustomerRespDto)customerJxsList.get(0);
        }
        log.info("\u4ece yes.req.cus.b2b.customerid \u83b7\u53d6\u5931\u8d25");
        throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25");
    }

    public PageInfo<ItemSkuQueryRespDto> querySkuByPage(ItemSkuQueryReqDto itemSkuQueryReqDto, Integer pageNum, Integer pageSize) {
        Long userOrgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        Integer channel = itemSkuQueryReqDto.getChannel();
        if (Objects.equals(channel, CustomerTypeEnum.DEALER.getCode())) {
            ShopToBQueryReqDto shopToBQueryReqDto = new ShopToBQueryReqDto();
            shopToBQueryReqDto.setOrganizationIdList((List)ListUtil.toList((Object[])new Long[]{userOrgInfoId}));
            shopToBQueryReqDto.setPageNum(1);
            shopToBQueryReqDto.setPageSize(10000);
            shopToBQueryReqDto.setStatus("NORMAL");
            shopToBQueryReqDto.setSellerStatus("NORMAL");
            PageInfo shopToBListRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryPage(shopToBQueryReqDto));
            if (CollUtil.isEmpty((Collection)shopToBListRespDtoPageInfo.getList())) {
                return new PageInfo(ListUtil.empty());
            }
            List shopIdList = shopToBListRespDtoPageInfo.getList().stream().map(ShopToBListRespDto::getId).distinct().collect(Collectors.toList());
            ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
            itemAuthReqDto.setTargetType(ItemAuthEnum.TargetType.SHOP.getCode());
            itemAuthReqDto.setTargetIdList(shopIdList);
            itemAuthReqDto.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
            List itemAuthRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.list(itemAuthReqDto));
            if (CollUtil.isEmpty((Collection)itemAuthRespDtos)) {
                return new PageInfo(ListUtil.empty());
            }
            itemSkuQueryReqDto.setInSkuIdList(itemAuthRespDtos.stream().map(ItemAuthRespDto::getBusinessId).distinct().collect(Collectors.toList()));
        } else {
            itemSkuQueryReqDto.setItemOrgId(userOrgInfoId);
        }
        RestResponse pageInfo = this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, pageNum, pageSize);
        return (PageInfo)pageInfo.getData();
    }

    private void replaceCustSkuPrice(List<ItemSkuExtRespDto> list, Long customerId, Long shopId) {
        block4: {
            SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
            if (!CollectionUtils.isNotEmpty(list)) break block4;
            Set skuIdList = list.stream().map(e -> e.getSkuId() != null ? e.getSkuId() : e.getId()).collect(Collectors.toSet());
            sellerSkuPriceReqDto.setSkuIdList(new ArrayList(skuIdList));
            sellerSkuPriceReqDto.setCustomerId(customerId);
            if (this.priceRuleHelper.isNotUseCenterPrice(shopId)) {
                Map<String, SellerSkuPriceDto> skuPriceDtoMap = this.tcbjPriceImpl.getSellerSkuPrice(sellerSkuPriceReqDto);
                for (ItemSkuExtRespDto itemSkuExtRespDto : list) {
                    Long skuId = itemSkuExtRespDto.getSkuId() != null ? itemSkuExtRespDto.getSkuId() : itemSkuExtRespDto.getId();
                    String tmpKey = customerId + "-" + skuId;
                    SellerSkuPriceDto skuPriceDto = skuPriceDtoMap.get(tmpKey);
                    itemSkuExtRespDto.setItemPrice(skuPriceDto != null ? skuPriceDto.getMaxSkuPrice() : BigDecimal.ZERO);
                }
            } else {
                CommunalPriceQueryReqDto reqDto = new CommunalPriceQueryReqDto();
                reqDto.setCustomerIds(Arrays.asList(customerId));
                reqDto.setPolicyDate(new Date());
                ArrayList skuPriceReqDtoList = new ArrayList();
                list.forEach(itemSkuInfo -> {
                    CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                    skuPriceReqDto.setSkuId(itemSkuInfo.getId());
                    skuPriceReqDto.setItemId(itemSkuInfo.getItemId());
                    skuPriceReqDto.setShopId(shopId);
                    skuPriceReqDtoList.add(skuPriceReqDto);
                });
                reqDto.setSkuList(skuPriceReqDtoList);
                List itemPolicyPriceRespDtos = (List)this.ibItemPriceService.getItemPrice(reqDto).getData();
                Map priceMap = itemPolicyPriceRespDtos.stream().collect(Collectors.toMap(skuInfo -> {
                    String key = skuInfo.getShopId() + "-" + skuInfo.getSkuId();
                    return key;
                }, Function.identity(), (o1, o2) -> o2));
                for (ItemSkuExtRespDto itemSkuExtRespDto : list) {
                    Long skuId;
                    Long l = skuId = itemSkuExtRespDto.getSkuId() != null ? itemSkuExtRespDto.getSkuId() : itemSkuExtRespDto.getId();
                    String tmpKey = shopId + "-" + skuId;
                    ItemPolicyPriceRespDto itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)priceMap.get(tmpKey);
                    if (itemPolicyPriceRespDto == null) continue;
                    BigDecimal price = this.itemPriceHelper.getDefaultMatchPrice(itemPolicyPriceRespDto, null);
                    itemSkuExtRespDto.setItemPrice(price);
                }
            }
        }
    }

    private Long getCustomerIdByUserIdAndSellerOrgId(Long userId, Long sellerOrgId) {
        Long merchantId = sellerOrgId;
        Long userOrgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        ArrayList<Long> orgInfoIdList = new ArrayList<Long>();
        orgInfoIdList.add(userOrgInfoId);
        searchReqDto.setOrgInfoIds(orgInfoIdList);
        searchReqDto.setTenantId(this.context.tenantId());
        searchReqDto.setMerchantId(merchantId);
        RestResponse listRestResp = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (!CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            return ((CustomerRespDto)customerRespDtos.get(0)).getId();
        }
        return null;
    }

    private PageInfo<ItemListRespDto> queryItem(ItemListQueryReqDto itemListQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo result = new PageInfo();
        HashSet brandIds = Sets.newHashSet();
        HashSet dirIds = Sets.newHashSet();
        HashSet disableSkuids = Sets.newHashSet();
        ArrayList shopIds = new ArrayList();
        HashSet skuIds = Sets.newHashSet();
        ItemAuthQueryReqDto itemAuthQueryReqDto = new ItemAuthQueryReqDto();
        itemAuthQueryReqDto.setChannel(Integer.valueOf(2));
        itemAuthQueryReqDto.setTargetType(Integer.valueOf(2));
        itemAuthQueryReqDto.setPageNum(Integer.valueOf(1));
        itemAuthQueryReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        itemAuthQueryReqDto.setTargetIdList((List)Lists.newArrayList((Object[])new Long[]{itemListQueryReqDto.getShopId()}));
        itemAuthQueryReqDto.setKeyword(itemListQueryReqDto.getKeyword());
        RestResponse pageInfoRestResp = this.itemAuthQueryApi.queryItemAuthPage(itemAuthQueryReqDto);
        PageInfo itemAuthPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        if (Objects.isNull(itemAuthPageInfo) || CollectionUtils.isEmpty((Collection)itemAuthPageInfo.getList())) {
            return result;
        }
        for (ItemAuthQueryRespDto itemAuthQueryRespDto : itemAuthPageInfo.getList()) {
            CustomerBuyScopeTypeEnum type = CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)itemAuthQueryRespDto.getBusinessType());
            if (type == null) continue;
            switch (type) {
                case SKU: {
                    skuIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BRAND: {
                    brandIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case CATEGORY: {
                    dirIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BANSKU: {
                    disableSkuids.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
            }
        }
        Long currentUserOrgId = this.getCurrentUserOrgId(this.context.userId());
        ItemReqDto itemReqDto = new ItemReqDto();
        BeanUtils.copyProperties((Object)itemListQueryReqDto, (Object)itemReqDto);
        itemReqDto.setId(null);
        itemReqDto.setCode(itemListQueryReqDto.getItemCode());
        itemReqDto.setSkuCode(itemListQueryReqDto.getSkuCode());
        itemReqDto.setName(itemListQueryReqDto.getItemName());
        itemReqDto.setDirId(itemListQueryReqDto.getBackDirId());
        itemReqDto.setType(itemListQueryReqDto.getType());
        if (itemListQueryReqDto.getBundle() != null) {
            if (itemListQueryReqDto.getBundle() == 1) {
                itemReqDto.setType(ItemTypeEnum.BUNDLE.getType());
            } else if (itemReqDto.getType() == null) {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{ItemTypeEnum.GENERAL.getType(), ItemTypeEnum.VIRTUAL.getType(), ItemTypeEnum.PRODUCT.getType()}));
            } else {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{itemReqDto.getType()}));
            }
        }
        List<Long> brandOrgIds = this.queryBrandOrgIds(currentUserOrgId);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            brandOrgIds = brandOrgIds.stream().distinct().collect(Collectors.toList());
        }
        itemReqDto.setDirIdList((List)Lists.newArrayList((Iterable)dirIds));
        itemReqDto.setBrandIdList((List)Lists.newArrayList((Iterable)brandIds));
        itemReqDto.setSkuIdList((List)Lists.newArrayList((Iterable)skuIds));
        itemReqDto.setShopId(null);
        logger.info("queryItem \u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93\u5217\u8868: {}", (Object)JSON.toJSONString((Object)itemReqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.searchItemLibByPage(itemReqDto, pageNum, pageSize));
        logger.info("queryItem \u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93\u5217\u8868: pageInfo:{}", (Object)JSON.toJSONString((Object)pageInfo));
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return result;
        }
        logger.info("queryItem : disableSkuids:{}", (Object)JSON.toJSONString((Object)disableSkuids));
        HashMap selleNameMap = new HashMap(64);
        List<ItemListRespDto> list = pageInfo.getList().stream().map(t -> this.convertToItemListRespDto((ItemRespDto)t, selleNameMap, Lists.newArrayList((Iterable)disableSkuids))).collect(Collectors.toList());
        this.fillItemResDirName(list);
        this.fillPrice(skuIds, list);
        logger.info("queryItem : return list:{}", (Object)JSON.toJSONString(list));
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        result.setList(list);
        return result;
    }

    private void fillPrice(Set<Long> skuIds, List<ItemListRespDto> list) {
        BasePriceItemQueryReqDto reqDto = new BasePriceItemQueryReqDto();
        reqDto.setOrganizationIdList((List)Lists.newArrayList((Object[])new Long[]{1000000000000000001L}));
        reqDto.setTypeIdList((List)Lists.newArrayList((Object[])new Long[]{1L}));
        reqDto.setSkuIdList((List)Lists.newArrayList(skuIds));
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u57fa\u7840\u4ef7\u683c\u660e\u7ec6\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iBasePriceItemQueryApi.queryByPage(reqDto, Integer.valueOf(1), Integer.valueOf(skuIds.size())));
        if (Objects.nonNull(pageInfo) && CollUtil.isNotEmpty((Collection)pageInfo.getList())) {
            Map itemRespDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(BasePriceItemRespDto::getSkuId, Function.identity(), (v1, v2) -> v1));
            for (ItemListRespDto listRespDto : list) {
                for (ItemSkuRespDto sku : listRespDto.getSkus()) {
                    if (!itemRespDtoMap.containsKey(sku.getId())) continue;
                    sku.setSalePrice(((BasePriceItemRespDto)itemRespDtoMap.get(sku.getId())).getItemPrice());
                }
                if (!CollUtil.isNotEmpty((Collection)listRespDto.getSkus())) continue;
                ItemSkuRespDto skuRespDto = (ItemSkuRespDto)listRespDto.getSkus().get(0);
                listRespDto.setBarCode(skuRespDto.getBarCode());
                listRespDto.setMinPackage(skuRespDto.getMinPackage());
            }
        }
    }

    private void fillItemResDirName(List<ItemListRespDto> list) {
        List dirIdList = list.stream().map(e -> e.getDirId()).collect(Collectors.toList());
        List res = (List)RestResponseHelper.extractData((RestResponse)this.directoryQueryApi.queryDirByIds(StringUtils.join(dirIdList, (String)",")));
        Map<Long, DirectoryItemRespDto> dirItemMap = res.stream().collect(Collectors.toMap(DirectoryItemRespDto::getId, p -> p, (o, n) -> o));
        list.forEach(e -> {
            DirectoryItemRespDto dirItemDto = (DirectoryItemRespDto)dirItemMap.get(e.getDirId());
            if (dirItemDto != null) {
                e.setDirName(dirItemDto.getName());
            }
        });
    }

    private Long getCurrentUserOrgId(Long userId) {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
    }

    private List<Long> queryBrandSellerId(Long currentUserOrgId) {
        ArrayList<Long> res = new ArrayList<Long>();
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setOrgInfoIds(Arrays.asList(currentUserOrgId));
        searchReqDto.setInstanceId(this.context.instanceId());
        searchReqDto.setType(Integer.valueOf(2));
        searchReqDto.setTenantId(this.context.tenantId());
        List customerListResp = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto)));
        customerListResp.forEach(e -> {
            SellerRespDto sellerRespDto;
            Long merchantId = e.getMerchantId();
            if (merchantId != null && (sellerRespDto = (SellerRespDto)this.sellerExtQueryApi.querySellerByOrganizationId(merchantId).getData()) != null) {
                res.add(sellerRespDto.getId());
            }
        });
        return res;
    }

    private List<Long> queryBrandOrgIds(Long currentUserOrgId) {
        List merchantIds = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryUpperOrgIdsByOrgId(currentUserOrgId));
        Long merchantId = (Long)merchantIds.stream().findFirst().get();
        BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode((String)String.valueOf(merchantId));
        Assert.isTrue((null != bizChannelEnum ? 1 : 0) != 0, (String)"\u5f53\u524d\u6e20\u9053\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return bizChannelEnum.getBizTypes();
    }

    private ItemListRespDto convertToItemListRespDto(ItemRespDto itemRespDto, Map<Long, String> sellerNameMap, List<Long> disableSkuids) {
        List<BigDecimal> sellPriceList;
        if (null == sellerNameMap) {
            sellerNameMap = new HashMap<Long, String>(64);
        }
        List mediaList = itemRespDto.getItemMediasList();
        List<ItemSkuRespDto> skuList = itemRespDto.getItemSkuList();
        if (CollectionUtils.isNotEmpty(disableSkuids)) {
            skuList = skuList.stream().filter(e -> disableSkuids.contains(e.getId())).collect(Collectors.toList());
        }
        String imgPath = null;
        if (CollectionUtils.isNotEmpty((Collection)mediaList)) {
            List imgPathList = mediaList.stream().map(ItemMediasRespDto::getPath1).collect(Collectors.toList());
            imgPath = (String)imgPathList.get(0);
        }
        BigDecimal minSellPrice = null;
        BigDecimal maxSellPrice = null;
        Long itemTotalStorage = 0L;
        if (CollectionUtils.isNotEmpty(skuList) && CollectionUtils.isNotEmpty(sellPriceList = this.getSortPrices(skuList))) {
            minSellPrice = sellPriceList.get(0);
            maxSellPrice = sellPriceList.get(sellPriceList.size() - 1);
        }
        ItemListRespDto itemListRespDto = new ItemListRespDto();
        BeanUtils.copyProperties((Object)itemRespDto, (Object)itemListRespDto);
        itemListRespDto.setItemId(itemRespDto.getId());
        itemListRespDto.setIsAfterSale(itemRespDto.getIsAfterSale());
        itemListRespDto.setItemCode(itemRespDto.getCode());
        itemListRespDto.setItemName(itemRespDto.getName());
        itemListRespDto.setMinSellPrice(minSellPrice);
        itemListRespDto.setMaxSellPrice(maxSellPrice);
        itemListRespDto.setItemTotalStorage(itemTotalStorage);
        itemListRespDto.setImgPath(imgPath);
        itemListRespDto.setSkus(skuList);
        itemListRespDto.setType(itemRespDto.getType());
        Long sellerId = itemRespDto.getSellerId();
        String sellerName = this.getSellerName(sellerId, sellerNameMap);
        itemListRespDto.setSellerName(sellerName);
        return itemListRespDto;
    }

    private List<BigDecimal> getSortPrices(List<ItemSkuRespDto> skuList) {
        List<Object> sellPriceList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(skuList)) {
            sellPriceList = skuList.stream().map(ItemSkuRespDto::getPrice).filter(Objects::nonNull).collect(Collectors.toList()).stream().sorted().collect(Collectors.toList());
        }
        return sellPriceList;
    }

    private String getSellerName(Long sellerId, Map<Long, String> sellerNameMap) {
        String sellerName = null;
        if (sellerNameMap.containsKey(sellerId)) {
            sellerName = sellerNameMap.get(sellerId);
        } else {
            SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(sellerId));
            if (sellerRespDto != null) {
                sellerName = sellerRespDto.getName();
                sellerNameMap.put(sellerId, sellerName);
            }
        }
        return sellerName;
    }
}

