/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoStorageQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.bitem.biz.service.IBInventoryService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BInventoryService
implements IBInventoryService {
    private static final Logger logger = LoggerFactory.getLogger(BInventoryService.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ICargoStorageQueryApi cargoStorageQueryApi;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;

    @Override
    public WarehouseRespDto queryWarehouseByShopId(Long shopId) {
        String cacheKey = "queryWarehouseIdByShopId_" + shopId;
        WarehouseRespDto warehouse = (WarehouseRespDto)this.cacheService.getCache(cacheKey, WarehouseRespDto.class);
        if (warehouse == null) {
            RestResponse shopBaseRestResp = this.shopQueryApi.queryBaseById(shopId);
            ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)shopBaseRestResp);
            RestResponse sellerRespDtoRestResponse = this.sellerQueryApi.queryById(shopBaseDto.getSellerId());
            Long organizationId = ((SellerRespDto)RestResponseHelper.extractData((RestResponse)sellerRespDtoRestResponse)).getOrganizationId();
            List<WarehouseRespDto> warehouseRespDtos = this.queryWarehouseByOrgIds(Lists.newArrayList((Object[])new Long[]{organizationId}));
            warehouse = warehouseRespDtos.get(0);
            this.cacheService.add(cacheKey, (Object)warehouse, 1080000);
        }
        return warehouse;
    }

    @Override
    public Map<Long, WarehouseRespDto> queryWarehousesByShopIds(Set<Long> shopIds) {
        HashSet<Long> searchShopIds = new HashSet<Long>();
        HashMap<Long, WarehouseRespDto> map_shop_warhouse = new HashMap<Long, WarehouseRespDto>();
        for (Long shopId : shopIds) {
            String cacheKey = "queryWarehouseIdByShopId_" + shopId;
            WarehouseRespDto warehouse = (WarehouseRespDto)this.cacheService.getCache(cacheKey, WarehouseRespDto.class);
            if (warehouse == null) {
                searchShopIds.add(shopId);
                continue;
            }
            map_shop_warhouse.put(shopId, warehouse);
        }
        if (CollectionUtils.isEmpty(searchShopIds)) {
            return map_shop_warhouse;
        }
        RestResponse listRestResponse = this.shopQueryApi.queryBaseListByIds(searchShopIds);
        List shopBaseList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map<Long, Long> map_shopid_sellerid = shopBaseList.stream().collect(Collectors.toMap(ShopBaseDto::getId, ShopBaseDto::getSellerId));
        List sellerIds = shopBaseList.stream().map(ShopBaseDto::getSellerId).distinct().collect(Collectors.toList());
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIds);
        RestResponse sellerListRestResponse = this.sellerQueryApi.queryList(sellerQueryReqDto);
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)sellerListRestResponse);
        Map<Long, Long> map_sellerid_orgid = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getId, SellerRespDto::getOrganizationId));
        List<Long> orgIds = sellerRespDtos.stream().map(SellerRespDto::getOrganizationId).distinct().collect(Collectors.toList());
        List<WarehouseRespDto> warehouseRespDtos = this.queryWarehouseByOrgIds(orgIds);
        Map<Long, WarehouseRespDto> map_org_warhouse = warehouseRespDtos.stream().collect(Collectors.toMap(WarehouseRespDto::getOrganizationId, warehouseRespDto -> warehouseRespDto, (o1, o2) -> o1));
        logger.info("map_shopid_sellerid : {}\uff0cmap_sellerid_orgid : {}\uff0cmap_org_warhouse : {}", new Object[]{StringUtils.join((Object[])new Object[]{map_shopid_sellerid, ","}), StringUtils.join((Object[])new Object[]{map_sellerid_orgid, ","}), StringUtils.join((Object[])new Object[]{map_org_warhouse, ","})});
        for (Long shopId : searchShopIds) {
            Long orgId;
            Long sellerId;
            if (!map_shopid_sellerid.containsKey(shopId) || !map_sellerid_orgid.containsKey(sellerId = map_shopid_sellerid.get(shopId)) || !map_org_warhouse.containsKey(orgId = map_sellerid_orgid.get(sellerId))) continue;
            map_shop_warhouse.put(shopId, map_org_warhouse.get(orgId));
            String cacheKey = "queryWarehouseIdByShopId_" + shopId;
            this.cacheService.add(cacheKey, (Object)map_org_warhouse.get(orgId), 86400 + RandomUtils.nextInt((int)60, (int)360));
        }
        return map_shop_warhouse;
    }

    @Override
    public List<WarehouseRespDto> queryWarehouseByOrgIds(List<Long> orgIds) {
        WarehouseQueryReqDto warehouseQueryReqDto = new WarehouseQueryReqDto();
        warehouseQueryReqDto.setOrganizationIds(orgIds);
        warehouseQueryReqDto.setType("0");
        warehouseQueryReqDto.setMainWarehouse(Integer.valueOf(1));
        RestResponse pageInfoRestResp = this.warehouseQueryApi.queryWarehousePage(warehouseQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo warehousePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        if (Objects.isNull(warehousePageInfo) || CollectionUtils.isEmpty((Collection)warehousePageInfo.getList())) {
            throw new BizException("\u5546\u5bb6\u5bf9\u5e94\u7684\u4ea7\u54c1\u4e3b\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return warehousePageInfo.getList();
    }

    @Override
    public List<CargoRespDto> queryCargoListByCargoCodes(List<String> cargoCodes) {
        RestResponse cargoListRestResp = this.cargoQueryApi.listByCodes(cargoCodes);
        List cargos = (List)RestResponseHelper.extractData((RestResponse)cargoListRestResp);
        if (CollectionUtils.isEmpty((Collection)cargos)) {
            throw new BizException("\u8d27\u54c1\u5728\u5e93\u5b58\u4e2d\u5fc3\u4e0d\u5b58\u5728");
        }
        return cargos;
    }
}

