/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IProhibiteSaleItemApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.BatchOptProhibiteSaleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ProhibiteSaleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.ICustomerAuthItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.module.bitem.api.service.ICustomerAuthItemExtService;
import com.dtyunxi.yundt.module.bitem.biz.service.ICustomerAuthItemService;
import com.dtyunxi.yundt.module.bitem.biz.service.IProhibiteSaleService;
import com.dtyunxi.yundt.module.bitem.biz.util.AuthItemCachUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IProhibiteSaleServiceImpl
implements IProhibiteSaleService {
    private static final Logger logger = LoggerFactory.getLogger(IProhibiteSaleServiceImpl.class);
    @Autowired
    private IProhibiteSaleItemApi prohibiteSaleItemApi;
    @Autowired
    private AuthItemCachUtil authItemCachUtil;
    @Autowired
    private ICustomerAuthItemQueryApi customerAuthItemQueryApi;
    @Autowired
    private ICustomerAuthItemService customerAuthItemService;
    @Autowired
    private ICustomerAuthItemExtService customerAuthItemExtService;
    @Autowired
    private IItemSkuQueryApi itemSkuQueryApi;

    @Override
    public RestResponse<Void> batchOptProhibiteSaleItem(BatchOptProhibiteSaleItemReqDto batchOptProhibiteSaleItemReqDto) {
        this.prohibiteSaleItemApi.batchOptProhibiteSaleItem(batchOptProhibiteSaleItemReqDto);
        this.authItemCachUtil.delAuthItemCache(batchOptProhibiteSaleItemReqDto.getCustomerId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> batchOptProhibiteSaleItemBySkuIds(List<Long> skuIdList, Integer opt) {
        if (CollectionUtils.isEmpty(skuIdList)) {
            logger.warn("SkuIdList is empty, no operation performed");
            return RestResponse.VOID;
        }
        try {
            List<Long> customerIds = this.getCustomerIdsBySkuIds(skuIdList);
            if (CollectionUtils.isEmpty(customerIds)) {
                logger.info("No customers found for the given skuIds: {}", skuIdList);
                return RestResponse.VOID;
            }
            for (Long customerId : customerIds) {
                BatchOptProhibiteSaleItemReqDto reqDto = this.createBatchOptRequest(customerId, skuIdList);
                reqDto.setOptType(opt);
                logger.info("\u8c03\u7528\u7981\u552eAPI: {}", (Object)JSONObject.toJSONString((Object)reqDto));
                RestResponseHelper.checkOrThrow((RestResponse)this.prohibiteSaleItemApi.batchOptProhibiteSaleItem(reqDto));
                this.authItemCachUtil.delAuthItemCache(customerId);
                logger.info("Successfully processed prohibite sale for customer: {} with skuIds: {}", (Object)customerId, skuIdList);
            }
        }
        catch (Exception e) {
            logger.error("Error processing prohibite sale by skuIds: {}", skuIdList, (Object)e);
        }
        return RestResponse.VOID;
    }

    private BatchOptProhibiteSaleItemReqDto createBatchOptRequest(Long customerId, List<Long> skuIdList) {
        BatchOptProhibiteSaleItemReqDto reqDto = new BatchOptProhibiteSaleItemReqDto();
        reqDto.setCustomerId(customerId);
        HashMap<Long, Long> skuToItemIdMap = new HashMap<Long, Long>();
        try {
            RestResponse response = this.itemSkuQueryApi.querySkuExtBySkuId(skuIdList);
            List customerAuthItems = (List)RestResponseHelper.extractData((RestResponse)response);
            if (CollectionUtils.isNotEmpty((Collection)customerAuthItems)) {
                for (ItemSkuExtRespDto item : customerAuthItems) {
                    if (item.getSkuId() == null || item.getItemId() == null) continue;
                    skuToItemIdMap.put(item.getSkuId(), item.getItemId());
                }
                logger.info("Found {} item mappings for skuIds: {}", (Object)skuToItemIdMap.size(), skuIdList);
            }
        }
        catch (Exception e) {
            logger.info("Error getting item IDs for skuIds: {}", skuIdList, (Object)e);
        }
        reqDto.setProhibiteSaleItemReqDtos(skuIdList.stream().map(r -> {
            ProhibiteSaleItemReqDto prohibiteSaleItemReqDto = new ProhibiteSaleItemReqDto();
            prohibiteSaleItemReqDto.setCustomerId(customerId);
            prohibiteSaleItemReqDto.setSkuId(r);
            Long itemId = (Long)skuToItemIdMap.get(r);
            if (itemId != null) {
                prohibiteSaleItemReqDto.setItemId(itemId);
            }
            return prohibiteSaleItemReqDto;
        }).filter(r -> Objects.nonNull(r.getItemId())).collect(Collectors.toList()));
        logger.debug("Created BatchOptProhibiteSaleItemReqDto for customer: {}", (Object)customerId);
        return reqDto;
    }

    private List<Long> getCustomerIdsBySkuIds(List<Long> skuIdList) {
        HashSet customerIdSet = new HashSet();
        try {
            RestResponse response = this.customerAuthItemExtService.queryAuthItemBySkuIdsExt(skuIdList);
            List customerAuthItems = (List)RestResponseHelper.extractData((RestResponse)response);
            if (CollectionUtils.isNotEmpty((Collection)customerAuthItems)) {
                List ids = customerAuthItems.stream().map(CustomerAuthItemRespDto::getCustomerId).filter(id -> id != null && id > 0L).distinct().collect(Collectors.toList());
                customerIdSet.addAll(ids);
                logger.debug("Found {} customers for skuIds: {}", (Object)customerIdSet.size(), skuIdList);
            }
        }
        catch (Exception e) {
            logger.error("Error getting customer IDs for skuIds: {}", skuIdList, (Object)e);
        }
        return new ArrayList<Long>(customerIdSet);
    }
}

