/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.service.impl;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IProhibiteSaleItemApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.BatchOptProhibiteSaleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ProhibiteSaleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.ICustomerAuthItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.module.bitem.api.service.ICustomerAuthItemExtService;
import com.dtyunxi.yundt.module.bitem.biz.service.ICustomerAuthItemService;
import com.dtyunxi.yundt.module.bitem.biz.service.IProhibiteSaleService;
import com.dtyunxi.yundt.module.bitem.biz.util.AuthItemCachUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IProhibiteSaleServiceImpl
implements IProhibiteSaleService {
    private static final Logger logger = LoggerFactory.getLogger(IProhibiteSaleServiceImpl.class);
    private static final int BATCH_SIZE = 1000;
    private static final int THREAD_POOL_SIZE = 5;
    private final ExecutorService executorService = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private IProhibiteSaleItemApi prohibiteSaleItemApi;
    @Autowired
    private AuthItemCachUtil authItemCachUtil;
    @Autowired
    private ICustomerAuthItemQueryApi customerAuthItemQueryApi;
    @Autowired
    private ICustomerAuthItemService customerAuthItemService;
    @Autowired
    private ICustomerAuthItemExtService customerAuthItemExtService;
    @Autowired
    private IItemSkuQueryApi itemSkuQueryApi;

    @Override
    public RestResponse<Void> batchOptProhibiteSaleItem(BatchOptProhibiteSaleItemReqDto batchOptProhibiteSaleItemReqDto) {
        this.prohibiteSaleItemApi.batchOptProhibiteSaleItem(batchOptProhibiteSaleItemReqDto);
        this.authItemCachUtil.delAuthItemCache(batchOptProhibiteSaleItemReqDto.getCustomerId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> batchOptProhibiteSaleItemBySkuIds(List<Long> skuIdList, Integer opt) {
        if (CollectionUtils.isEmpty(skuIdList)) {
            logger.warn("SkuIdList is empty, no operation performed");
            return RestResponse.VOID;
        }
        try {
            int totalSize = skuIdList.size();
            logger.info("Starting batch prohibite sale operation for {} SKUs", (Object)totalSize);
            Map<Long, Long> skuToItemIdMap = this.preloadSkuItemMapping(skuIdList);
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (int i = 0; i < totalSize; i += 1000) {
                int endIndex = Math.min(i + 1000, totalSize);
                List<Long> batchSkuIds = skuIdList.subList(i, endIndex);
                logger.info("Processing batch {}/{} with {} SKUs", new Object[]{i / 1000 + 1, (totalSize + 1000 - 1) / 1000, batchSkuIds.size()});
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.processBatch(batchSkuIds, opt, skuToItemIdMap), this.executorService);
                futures.add(future);
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            logger.info("Completed batch prohibite sale operation for all {} SKUs", (Object)totalSize);
        }
        catch (Exception e) {
            logger.error("Error in batch prohibite sale operation: {}", (Object)e.getMessage(), (Object)e);
        }
        return RestResponse.VOID;
    }

    private Map<Long, Long> preloadSkuItemMapping(List<Long> skuIdList) {
        ConcurrentHashMap<Long, Long> skuToItemIdMap = new ConcurrentHashMap<Long, Long>();
        try {
            for (int i = 0; i < skuIdList.size(); i += 1000) {
                int endIndex = Math.min(i + 1000, skuIdList.size());
                List<Long> batchSkuIds = skuIdList.subList(i, endIndex);
                RestResponse response = this.itemSkuQueryApi.querySkuExtBySkuId(batchSkuIds);
                List skuExtItems = (List)RestResponseHelper.extractData((RestResponse)response);
                if (!CollectionUtils.isNotEmpty((Collection)skuExtItems)) continue;
                for (ItemSkuExtRespDto item : skuExtItems) {
                    if (item.getSkuId() == null || item.getItemId() == null) continue;
                    skuToItemIdMap.put(item.getSkuId(), item.getItemId());
                }
            }
            logger.info("Preloaded mapping for {} SKUs out of {} requested", (Object)skuToItemIdMap.size(), (Object)skuIdList.size());
        }
        catch (Exception e) {
            logger.error("Error preloading SKU-Item mappings: {}", (Object)e.getMessage(), (Object)e);
        }
        return skuToItemIdMap;
    }

    private void processBatch(List<Long> batchSkuIds, Integer opt, Map<Long, Long> skuToItemIdMap) {
        try {
            Map<Long, List<Long>> customerSkuBatches = this.getCustomerSkuBatches(batchSkuIds);
            if (customerSkuBatches.isEmpty()) {
                logger.info("No customers found for the given batch of skuIds, size: {}", (Object)batchSkuIds.size());
                return;
            }
            ArrayList<CompletableFuture<Void>> customerFutures = new ArrayList<CompletableFuture<Void>>();
            for (Map.Entry<Long, List<Long>> entry : customerSkuBatches.entrySet()) {
                Long customerId = entry.getKey();
                List<Long> customerSkuIds = entry.getValue();
                for (int i = 0; i < customerSkuIds.size(); i += 1000) {
                    int endIndex = Math.min(i + 1000, customerSkuIds.size());
                    List<Long> subBatchSkuIds = customerSkuIds.subList(i, endIndex);
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.processCustomerBatch(customerId, subBatchSkuIds, opt, skuToItemIdMap), this.executorService);
                    customerFutures.add(future);
                }
            }
            CompletableFuture.allOf(customerFutures.toArray(new CompletableFuture[0])).join();
        }
        catch (Exception e) {
            logger.error("Error processing batch of {} skuIds: {}", new Object[]{batchSkuIds.size(), e.getMessage(), e});
        }
    }

    private void processCustomerBatch(Long customerId, List<Long> customerSkuIds, Integer opt, Map<Long, Long> skuToItemIdMap) {
        try {
            BatchOptProhibiteSaleItemReqDto reqDto = this.createBatchOptRequest(customerId, customerSkuIds, skuToItemIdMap);
            reqDto.setOptType(opt);
            logger.debug("Calling prohibite sale API for customer: {} with {} SKUs", (Object)customerId, (Object)customerSkuIds.size());
            RestResponseHelper.checkOrThrow((RestResponse)this.prohibiteSaleItemApi.batchOptProhibiteSaleItem(reqDto));
            this.authItemCachUtil.delAuthItemCache(customerId);
            logger.debug("Successfully processed prohibite sale for customer: {}", (Object)customerId);
        }
        catch (Exception e) {
            logger.error("Error processing prohibite sale for customer: {} with {} SKUs: {}", new Object[]{customerId, customerSkuIds.size(), e.getMessage(), e});
        }
    }

    private Map<Long, List<Long>> getCustomerSkuBatches(List<Long> skuIds) {
        ConcurrentHashMap<Long, List<Long>> customerSkuMap = new ConcurrentHashMap<Long, List<Long>>();
        try {
            List<Long> customerIds = this.getCustomerIdsBySkuIds(skuIds);
            if (CollectionUtils.isEmpty(customerIds)) {
                return customerSkuMap;
            }
            ArrayList<CompletableFuture<Map.Entry>> customerFutures = new ArrayList<CompletableFuture<Map.Entry>>();
            for (Long l : customerIds) {
                CompletableFuture<Map.Entry> future = CompletableFuture.supplyAsync(() -> {
                    List<Long> customerSkuIds = this.getCustomerAuthorizedSkuIds(customerId, skuIds);
                    return new AbstractMap.SimpleEntry<Long, List<Long>>(customerId, customerSkuIds);
                }, this.executorService);
                customerFutures.add(future);
            }
            for (CompletableFuture completableFuture : customerFutures) {
                try {
                    Map.Entry entry = (Map.Entry)completableFuture.get(30L, TimeUnit.SECONDS);
                    if (!CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))) continue;
                    customerSkuMap.put((Long)entry.getKey(), (List<Long>)entry.getValue());
                }
                catch (Exception e) {
                    logger.error("Error getting customer authorized SKUs: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error preparing customer-SKU batches: {}", (Object)e.getMessage(), (Object)e);
        }
        return customerSkuMap;
    }

    private List<Long> getCustomerAuthorizedSkuIds(Long customerId, List<Long> skuIds) {
        try {
            RestResponse<List<CustomerAuthItemRespDto>> response = this.customerAuthItemService.queryAuthItemBySkuIds(skuIds);
            List authItems = (List)RestResponseHelper.extractData(response);
            if (CollectionUtils.isEmpty((Collection)authItems)) {
                return new ArrayList<Long>();
            }
            return authItems.stream().filter(item -> Objects.equals(item.getCustomerId(), customerId)).map(CustomerAuthItemRespDto::getSkuId).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Error getting authorized SKUs for customer {}: {}", new Object[]{customerId, e.getMessage(), e});
            return new ArrayList<Long>();
        }
    }

    private BatchOptProhibiteSaleItemReqDto createBatchOptRequest(Long customerId, List<Long> skuIdList, Map<Long, Long> skuToItemIdMap) {
        BatchOptProhibiteSaleItemReqDto reqDto = new BatchOptProhibiteSaleItemReqDto();
        reqDto.setCustomerId(customerId);
        List prohibiteSaleItemReqDtos = skuIdList.stream().map(skuId -> {
            ProhibiteSaleItemReqDto itemReqDto = new ProhibiteSaleItemReqDto();
            itemReqDto.setCustomerId(customerId);
            itemReqDto.setSkuId(skuId);
            Long itemId = (Long)skuToItemIdMap.get(skuId);
            if (itemId != null) {
                itemReqDto.setItemId(itemId);
            }
            return itemReqDto;
        }).filter(dto -> dto.getItemId() != null).collect(Collectors.toList());
        reqDto.setProhibiteSaleItemReqDtos(prohibiteSaleItemReqDtos);
        return reqDto;
    }

    private List<Long> getCustomerIdsBySkuIds(List<Long> skuIdList) {
        HashSet customerIdSet = new HashSet();
        try {
            RestResponse response = this.customerAuthItemExtService.queryAuthItemBySkuIdsExt(skuIdList);
            List customerAuthItems = (List)RestResponseHelper.extractData((RestResponse)response);
            if (CollectionUtils.isNotEmpty((Collection)customerAuthItems)) {
                List ids = customerAuthItems.stream().map(CustomerAuthItemRespDto::getCustomerId).filter(id -> id != null && id > 0L).distinct().collect(Collectors.toList());
                customerIdSet.addAll(ids);
                logger.debug("Found {} customers for skuIds: {}", (Object)customerIdSet.size(), skuIdList);
            }
        }
        catch (Exception e) {
            logger.error("Error getting customer IDs for skuIds: {}", skuIdList, (Object)e);
        }
        return new ArrayList<Long>(customerIdSet);
    }
}

