/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlInventoryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BaseRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryItemRespDto;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BItemModuleHelper {
    private static final Logger logger = LoggerFactory.getLogger(BItemModuleHelper.class);
    @Autowired
    private IContext context;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private ICustomerQueryApi customerApi;
    @Resource
    private IControlInventoryQueryApi controlInventoryQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;

    public Long getByShopName(String name) {
        ShopDto shopDto;
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        shopQueryDto.setInstanceId(this.context.instanceId());
        shopQueryDto.setTenantId(this.context.tenantId());
        shopQueryDto.setName(name);
        shopQueryDto.setStatus("NORMAL");
        PageInfo shopDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByConditions(shopQueryDto, 10, 1));
        if (shopDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)shopDtoPageInfo.getList()) && null != (shopDto = shopDtoPageInfo.getList().stream().findFirst().orElseGet(() -> null))) {
            return shopDto.getId();
        }
        return null;
    }

    public List<Long> getCustomerIdsByUserIdAndShopId(Long userId, List<Long> shopIds) {
        ServiceContext serviceContext;
        String object;
        Assert.notEmpty(shopIds, (String)"shopId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userId, (String)"userId\u4e0d\u80fd\u4e3a\u7a7a");
        if (userId.equals(this.context.userId()) && (object = (serviceContext = ServiceContext.getContext()).getAttachment("yes.req.cus.b2b.customerid")) != null) {
            return Collections.singletonList(Long.valueOf(object));
        }
        Long orgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        ArrayList<Long> customerIdList = new ArrayList<Long>();
        for (Long shopId : shopIds) {
            ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
            SellerRespDto sellerRespDto = (SellerRespDto)this.sellerQueryApi.queryById(shopDto.getSellerId()).getData();
            RestResponse customerRespDtoRest = this.customerExtQueryApi.queryCustomerByOrgAndMerch(orgInfoId, sellerRespDto.getOrganizationId());
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRest);
            if (customerRespDto != null) {
                customerIdList.add(customerRespDto.getId());
                continue;
            }
            logger.info("userId={},\u4e0d\u662f\u5546\u5bb6shopId={}\u7684\u6240\u5c5e\u7684\u5ba2\u6237", (Object)userId, (Object)shopId);
        }
        return customerIdList;
    }

    public Map<Long, Long> queryInventoryControlRule(List<Long> itemIdList, Long shopId) {
        logger.info("queryInventoryControlRule==>\u8fdb\u5165\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\uff0citemId={},shopId={}", (Object)JSON.toJSONString(itemIdList), (Object)shopId);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerApi.queryCustomerRespDto(Collections.singletonList(shopId)));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            logger.info("\u8be5\u7ba1\u63a7\u89c4\u5219\u5e97\u94fa{}\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)shopId);
            return new HashMap<Long, Long>();
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        Long customerId = customerRespDto.getId();
        CustomerControlInventoryReqDto reqDto = new CustomerControlInventoryReqDto();
        reqDto.setCustomerId(customerId);
        reqDto.setItemIdList(itemIdList);
        reqDto.setOrgId(customerRespDto.getMerchantId());
        List areaCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes(areaCodeList);
            List parentAreaCodeList = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto));
            if (CollectionUtils.isNotEmpty((Collection)parentAreaCodeList)) {
                parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
                reqDto.setCustomerAreaCodeList(parentAreaCodeList);
            }
        }
        logger.info("\u67e5\u8be2\u5ba2\u6237\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u89c4\u5219\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        List controlInventoryItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.controlInventoryQueryApi.queryRuleByCustomerNew(reqDto));
        if (CollectionUtils.isEmpty((Collection)controlInventoryItemRespDtos)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u4fe1\u606f");
            return new HashMap<Long, Long>();
        }
        logger.info("\u67e5\u8be2\u5ba2\u6237\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u89c4\u5219\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)controlInventoryItemRespDtos));
        HashMap<Long, Long> controlInventoryItemMap = new HashMap<Long, Long>();
        Map<Long, List<ControlInventoryItemRespDto>> itemControlMap = controlInventoryItemRespDtos.stream().collect(Collectors.groupingBy(ControlInventoryItemRespDto::getItemId));
        for (Long itemId : itemControlMap.keySet()) {
            List itemRuleList = itemControlMap.get(itemId).stream().sorted(Comparator.comparing(BaseRuleRespDto::getRuleSort)).collect(Collectors.toList());
            ControlInventoryItemRespDto controlInventoryItemRespDto = (ControlInventoryItemRespDto)itemRuleList.get(0);
            Integer floorInventoryCount = controlInventoryItemRespDto.getFloorInventoryCount();
            Long inventory = 0L;
            if (null != floorInventoryCount) {
                inventory = (long)floorInventoryCount;
            }
            controlInventoryItemMap.put(itemId, inventory);
        }
        logger.info("\u7ba1\u63a7\u5546\u54c1key\u4e3aid, value\u4e3a\u5b89\u5168\u5e93\u5b58:{}", (Object)JSON.toJSONString(controlInventoryItemMap));
        return controlInventoryItemMap;
    }
}

