/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerBuyScopeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBCustomerBuyScopeService;
import com.dtyunxi.yundt.module.bitem.api.constants.CustomerBuyScopeTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.dto.CustomerBuyScopeComputeDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemDepthQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.CustomerItemAuthInfo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerBuyScopeServiceImpl
implements IBCustomerBuyScopeService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerBuyScopeServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ICacheService cacheService;
    @Value(value="${customer.buy.scope.queryLimit:20}")
    private Integer queryLimit;
    private static String authPre = "AUTH_CACHE_PRE:";

    public CustomerBuyScopeComputeDto buyScopeCompute(List<Long> targetIdList, ItemAuthEnum.TargetType targetType) {
        ArrayList queryTargetIds = Lists.newArrayList();
        CustomerBuyScopeComputeDto computeDto = this.computeByCache(targetIdList, queryTargetIds);
        this.computeByDb(targetType, queryTargetIds, computeDto);
        logger.info("\u83b7\u53d6\u5230\u8ba1\u7b97\u5bf9\u8c61:{}", (Object)computeDto);
        return computeDto;
    }

    private void computeByDb(ItemAuthEnum.TargetType targetType, List<Long> queryTargetIds, CustomerBuyScopeComputeDto computeDto) {
        Stream.iterate(0, n -> n + 1).limit(this.countStep(queryTargetIds.size()).intValue()).forEach(i -> {
            List batchIds = queryTargetIds.stream().skip(i * this.queryLimit).limit(this.queryLimit.intValue()).collect(Collectors.toList());
            ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
            itemAuthReqDto.setTargetType(targetType.getCode());
            itemAuthReqDto.setTargetIdList(batchIds);
            itemAuthReqDto.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
            List resp = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.list(itemAuthReqDto));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)resp)) {
                List<CustomerBuyScopeComputeDto> scopeComputeDtos = this.transferComputeDto(resp);
                scopeComputeDtos.forEach(data -> {
                    computeDto.appendBanSkuIds(data.getBanSkuIds());
                    computeDto.appendBrandIds(data.getBrandIds());
                    computeDto.appendDirIds(data.getDirIds());
                    computeDto.appendSkuIds(data.getSkuIds());
                    this.cacheService.setCache("COMMON", authPre + data.getTargetId(), (Object)JSONObject.toJSONString((Object)data), 1800);
                });
            }
        });
    }

    private CustomerBuyScopeComputeDto computeByCache(List<Long> targetIdList, List<Long> queryTargetIds) {
        CustomerBuyScopeComputeDto computeDto = new CustomerBuyScopeComputeDto();
        Optional.of(targetIdList.stream().map(tar -> {
            String cache = (String)this.cacheService.getCache("COMMON", authPre + tar, String.class);
            if (StringUtils.isEmpty((CharSequence)cache)) {
                queryTargetIds.add((Long)tar);
            }
            return cache;
        }).filter(StringUtils::isNotBlank).map(cache -> (CustomerBuyScopeComputeDto)JSONObject.parseObject((String)cache, CustomerBuyScopeComputeDto.class)).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(datas -> datas.forEach(data -> {
            computeDto.appendBanSkuIds(data.getBanSkuIds());
            computeDto.appendBrandIds(data.getBrandIds());
            computeDto.appendDirIds(data.getDirIds());
            computeDto.appendSkuIds(data.getSkuIds());
        }));
        return computeDto;
    }

    private List<CustomerBuyScopeComputeDto> transferComputeDto(List<ItemAuthRespDto> resp) {
        Map<Long, List<ItemAuthRespDto>> targetMap = resp.stream().collect(Collectors.groupingBy(ItemAuthRespDto::getTargetId));
        return targetMap.entrySet().stream().map(entry -> {
            CustomerBuyScopeComputeDto computeDto = new CustomerBuyScopeComputeDto();
            computeDto.setTargetId((Long)entry.getKey());
            ((List)entry.getValue()).stream().collect(Collectors.groupingBy(ItemAuthRespDto::getBusinessType)).forEach((type, val) -> {
                List businessIds = val.stream().map(ItemAuthRespDto::getBusinessId).collect(Collectors.toList());
                if (CollUtil.isEmpty(businessIds)) {
                    return;
                }
                switch (CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)type)) {
                    case BRAND: {
                        computeDto.setBrandIds(businessIds);
                        break;
                    }
                    case CATEGORY: {
                        computeDto.setDirIds(businessIds);
                        break;
                    }
                    case SKU: {
                        computeDto.setSkuIds(businessIds);
                        break;
                    }
                    case BANSKU: {
                        computeDto.setBanSkuIds(businessIds);
                        break;
                    }
                }
            });
            return computeDto;
        }).collect(Collectors.toList());
    }

    private Integer countStep(Integer size) {
        return (size + this.queryLimit - 1) / this.queryLimit;
    }

    public List<CustomerBuyScopeRespDto> getBuyScopeList(List<Long> targetIdList, ItemAuthEnum.TargetType targetType) {
        ArrayList queryTargetIds = Lists.newArrayList();
        List itemAuthRespDtos = targetIdList.stream().map(tar -> {
            String cache = (String)this.cacheService.getCache(authPre + tar, String.class);
            if (StringUtils.isEmpty((CharSequence)cache)) {
                queryTargetIds.add(tar);
            }
            return cache;
        }).filter(StringUtils::isNotBlank).flatMap(cache -> JSONArray.parseArray((String)cache, ItemAuthRespDto.class).stream()).collect(Collectors.toList());
        int pageNum = 1;
        while (true) {
            ItemAuthPageReqDto itemAuthReqDto = new ItemAuthPageReqDto();
            itemAuthReqDto.setTargetType(targetType.getCode());
            itemAuthReqDto.setTargetIdList((List)queryTargetIds);
            itemAuthReqDto.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
            itemAuthReqDto.setPageSize(this.queryLimit);
            itemAuthReqDto.setPageNum(Integer.valueOf(pageNum));
            PageInfo resp = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.listByPage(itemAuthReqDto));
            itemAuthRespDtos.addAll(resp.getList());
            if (resp.getTotal() < (long)(resp.getPageSize() * resp.getPageNum()) || org.springframework.util.CollectionUtils.isEmpty((Collection)resp.getList())) break;
            ++pageNum;
        }
        Map<Long, List<ItemAuthRespDto>> targetMap = itemAuthRespDtos.stream().collect(Collectors.groupingBy(ItemAuthRespDto::getTargetId));
        targetMap.forEach((targetId, values) -> this.cacheService.setCache(authPre + targetId, (Object)JSONObject.toJSONString((Object)itemAuthRespDtos), 600));
        return itemAuthRespDtos.stream().map(item -> {
            CustomerBuyScopeRespDto customerBuyScopeRespDto = new CustomerBuyScopeRespDto();
            customerBuyScopeRespDto.setCustomerId(item.getTargetId());
            customerBuyScopeRespDto.setBusinessId(item.getBusinessId());
            customerBuyScopeRespDto.setBusinessType(item.getBusinessType());
            return customerBuyScopeRespDto;
        }).collect(Collectors.toList());
    }

    public Map<CustomerBuyScopeTypeEnum, List<CustomerBuyScopeRespDto>> getBuyScopeMap(List<Long> targetIdList, ItemAuthEnum.TargetType targetType) {
        List<CustomerBuyScopeRespDto> customerBuyScopeList = this.getBuyScopeList(targetIdList, targetType);
        Map<CustomerBuyScopeTypeEnum, List<CustomerBuyScopeRespDto>> customerBuyScopeMap = customerBuyScopeList.stream().filter(item -> Objects.nonNull(CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)item.getBusinessType()))).collect(Collectors.groupingBy(item -> CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)item.getBusinessType()), Collectors.toList()));
        return customerBuyScopeMap;
    }

    public Map<Long, List<Long>> getShopCustomerMap(List<Long> shopIds) {
        if (CollUtil.isEmpty(shopIds)) {
            return null;
        }
        List shopList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(new HashSet<Long>(shopIds)));
        if (CollUtil.isEmpty((Collection)shopList)) {
            return null;
        }
        List sellerIdList = shopList.stream().filter(shop -> Objects.nonNull(shop.getSellerId())).map(ShopDto::getSellerId).collect(Collectors.toList());
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIdList);
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
        if (CollUtil.isEmpty((Collection)sellerRespDtos)) {
            return null;
        }
        List merchantIds = sellerRespDtos.stream().map(SellerRespDto::getOrganizationId).collect(Collectors.toList());
        Long currentUserOrgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListByOrgIds(merchantIds));
        if (CollUtil.isEmpty((Collection)customerRespDtos)) {
            return null;
        }
        List customerIds = customerRespDtos.stream().filter(customerDto -> Objects.equals(currentUserOrgId, customerDto.getOrgInfoId())).map(BaseRespDto::getId).collect(Collectors.toList());
        Map<Long, Long> shopSellerMap = shopList.stream().collect(Collectors.toMap(ShopDto::getId, ShopDto::getSellerId, (o1, o2) -> o2));
        Map<Long, Long> sellerOrgMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getId, SellerRespDto::getOrganizationId, (o1, o2) -> o2));
        Map orgMap = customerRespDtos.stream().filter(customerDto -> Objects.equals(currentUserOrgId, customerDto.getOrgInfoId())).collect(Collectors.groupingBy(CustomerRespDto::getMerchantId, Collectors.toList()));
        HashMap<Long, List<Long>> shopCustomerMap = new HashMap<Long, List<Long>>();
        shopSellerMap.entrySet().stream().filter(obj -> sellerOrgMap.containsKey(obj.getValue())).forEach(obj -> {
            Long orgId = (Long)sellerOrgMap.get(obj.getValue());
            if (orgMap.containsKey(orgId)) {
                shopCustomerMap.put((Long)obj.getKey(), ((List)orgMap.get(orgId)).stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            }
        });
        return shopCustomerMap;
    }

    private List<Long> getCustomerIdByShopId(List<Long> shopIds) {
        if (CollUtil.isEmpty(shopIds)) {
            return null;
        }
        List shopList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(new HashSet<Long>(shopIds)));
        if (CollUtil.isEmpty((Collection)shopList)) {
            return null;
        }
        List sellerIdList = shopList.stream().filter(shop -> Objects.nonNull(shop.getSellerId())).map(ShopDto::getSellerId).collect(Collectors.toList());
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIdList);
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
        if (CollUtil.isEmpty((Collection)sellerRespDtos)) {
            return null;
        }
        List merchantIds = sellerRespDtos.stream().map(SellerRespDto::getOrganizationId).collect(Collectors.toList());
        Long currentUserOrgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListByOrgIds(merchantIds));
        if (CollUtil.isEmpty((Collection)customerRespDtos)) {
            return null;
        }
        List<Long> customerIds = customerRespDtos.stream().filter(customerDto -> Objects.equals(currentUserOrgId, customerDto.getOrgInfoId())).map(BaseRespDto::getId).collect(Collectors.toList());
        return customerIds;
    }

    public List<Long> getCurrentCustomerId(List<Long> shopIds) {
        return this.getCustomerIdByShopId(shopIds);
    }

    public boolean setCustomerBuyScopeLimit(ItemDepthQueryReqDto itemDepthReqDto, ItemSearchQueryReqDto itemSearchQueryReqDto, Map<Long, List<Long>> outSkuIdsMap) {
        CustomerItemAuthInfo customerItemAuthInfo = this.setCustomerItemAuth(itemDepthReqDto, itemSearchQueryReqDto, outSkuIdsMap);
        return customerItemAuthInfo.getState();
    }

    public CustomerItemAuthInfo setCustomerItemAuth(ItemDepthQueryReqDto itemDepthReqDto, ItemSearchQueryReqDto itemSearchQueryReqDto, Map<Long, List<Long>> outSkuIdsMap) {
        CustomerItemAuthInfo customerItemAuthInfo = new CustomerItemAuthInfo();
        List customerIds = itemDepthReqDto.getCustomerIdList();
        if (itemDepthReqDto.getCustomerId() != null) {
            customerIds.add(itemDepthReqDto.getCustomerId());
        }
        if (CollUtil.isEmpty((Collection)customerIds)) {
            List shopIds = itemSearchQueryReqDto.getShopIds();
            Long shopId = itemSearchQueryReqDto.getShopId();
            if (CollUtil.isEmpty((Collection)shopIds) && Objects.isNull(shopId)) {
                return customerItemAuthInfo;
            }
            if (Objects.nonNull(shopId)) {
                if (CollUtil.isNotEmpty((Collection)shopIds) && !shopIds.contains(shopId)) {
                    return customerItemAuthInfo;
                }
                shopIds = ListUtil.toList((Object[])new Long[]{shopId});
            }
            if (CollUtil.isEmpty((Collection)shopIds)) {
                RestResponse customerRestResponse = this.customerExtQueryApi.queryCustomerIdsByUserId(this.context.userId());
                customerIds = (List)RestResponseHelper.extractData((RestResponse)customerRestResponse);
            } else {
                customerIds = this.getCurrentCustomerId(shopIds);
            }
            if (CollUtil.isEmpty(customerIds)) {
                return customerItemAuthInfo;
            }
        }
        Long brandId = itemDepthReqDto.getBrandId();
        itemSearchQueryReqDto.setBrandId(brandId);
        CustomerBuyScopeComputeDto scopeCompute = this.buyScopeCompute(customerIds, ItemAuthEnum.TargetType.CUSTOMER);
        if (CollUtil.isEmpty((Collection)scopeCompute.getSkuIds())) {
            logger.info("[\u5ba2\u6237id\u4e3a{}\u53ef\u4e70] >>> \u6ca1\u6709\u6388\u6743\u53ef\u4e70\u5546\u54c1\uff0c\u5ba2\u6237\u65e0\u5546\u54c1\u53ef\u8d2d\u4e70", (Object)customerIds.get(0));
            return customerItemAuthInfo;
        }
        if (this.setLimitData(itemDepthReqDto, itemSearchQueryReqDto, outSkuIdsMap, customerItemAuthInfo, customerIds, brandId, scopeCompute)) {
            return customerItemAuthInfo;
        }
        customerItemAuthInfo.setState(Boolean.TRUE);
        return customerItemAuthInfo;
    }

    private boolean setLimitData(ItemDepthQueryReqDto itemDepthReqDto, ItemSearchQueryReqDto itemSearchQueryReqDto, Map<Long, List<Long>> outSkuIdsMap, CustomerItemAuthInfo customerItemAuthInfo, List<Long> customerIds, Long brandId, CustomerBuyScopeComputeDto scopeCompute) {
        List skuRespDtos;
        List itemIdList;
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)scopeCompute.getBrandIds())) {
            if (Objects.isNull(brandId)) {
                itemSearchQueryReqDto.setInBrandIds(scopeCompute.getBrandIds());
            } else if (org.springframework.util.CollectionUtils.isEmpty((Collection)scopeCompute.getBrandIds()) || !scopeCompute.getBrandIds().contains(brandId)) {
                logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u524d\u7aef\u9650\u5236\u4e86\u54c1\u724c[{}]\uff0c\u4e0e\u6570\u636e\u5e93\u9650\u5236\u65e0\u4ea4\u96c6\uff0c\u5ba2\u6237\u65e0\u5546\u54c1\u53ef\u8d2d\u4e70", (Object)brandId);
                return true;
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)scopeCompute.getDirIds())) {
            List dirIds = itemSearchQueryReqDto.getDirIds();
            if (CollUtil.isEmpty((Collection)dirIds)) {
                itemSearchQueryReqDto.setDirIds(scopeCompute.getDirIds());
            } else {
                scopeCompute.getDirIds().retainAll(dirIds);
                if (CollUtil.isEmpty((Collection)scopeCompute.getDirIds())) {
                    logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u524d\u7aef\u9650\u5236\u4e86\u7c7b\u76ee[{}]\uff0c\u4e0e\u6570\u636e\u5e93\u9650\u5236\u65e0\u4ea4\u96c6\uff0c\u5ba2\u6237\u65e0\u5546\u54c1\u53ef\u8d2d\u4e70", (Object)dirIds);
                    return true;
                }
                itemSearchQueryReqDto.setDirIds(scopeCompute.getDirIds());
            }
        }
        if (CollUtil.isEmpty(itemIdList = (skuRespDtos = (List)this.itemSkuQueryApi.queryBySkuId(scopeCompute.getSkuIds()).getData()).stream().map(ItemSkuRespDto::getItemId).collect(Collectors.toList()))) {
            return true;
        }
        List itemIds = itemSearchQueryReqDto.getItemIds();
        logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u5ba2\u6237{}\u53ef\u4e70\u7684 SKU \u5217\u8868\u4e3a{}\u8f6c\u4e3a\u5546\u54c1ID{}", new Object[]{customerIds, scopeCompute.getSkuIds(), itemIdList});
        if (CollUtil.isEmpty((Collection)itemIds)) {
            itemSearchQueryReqDto.setItemIds(itemIdList);
        } else {
            itemIdList.retainAll(itemIds);
            if (CollUtil.isEmpty(itemIdList)) {
                logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u5df2\u9650\u5236{}\u540e\u65e0\u4ea4\u96c6\uff0c\u5ba2\u6237\u65e0\u5546\u54c1\u53ef\u8d2d\u4e70", (Object)itemIds);
                return true;
            }
            itemSearchQueryReqDto.setItemIds(itemIdList);
        }
        logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u5ba2\u6237\u53ef\u4e70\u5546\u54c1ID{}", (Object)itemSearchQueryReqDto.getItemIds());
        if (Objects.nonNull(itemSearchQueryReqDto.getShopId())) {
            customerItemAuthInfo.pull(itemSearchQueryReqDto.getShopId(), scopeCompute.getSkuIds());
            itemDepthReqDto.setSkuIdList(scopeCompute.getSkuIds());
        }
        customerItemAuthInfo.setCustomerIdList(customerIds);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)scopeCompute.getBanSkuIds())) {
            Map<Long, List<ItemSkuRespDto>> itemSkuMap = ((List)this.itemSkuQueryApi.queryBySkuId(itemDepthReqDto.getSkuIdList()).getData()).stream().collect(Collectors.groupingBy(ItemSkuRespDto::getItemId));
            itemSkuMap.forEach((itemId, list) -> {
                List skuIds = list.stream().map(ItemSkuRespDto::getItemId).collect(Collectors.toList());
                if (!outSkuIdsMap.containsKey(itemId)) {
                    outSkuIdsMap.put((Long)itemId, skuIds);
                } else {
                    ((List)outSkuIdsMap.get(itemId)).addAll(skuIds);
                }
            });
        }
        return false;
    }

    public CustomerItemAuthInfo setShopItemAuth(ItemDepthQueryReqDto itemDepthReqDto, ItemSearchQueryReqDto itemSearchQueryReqDto, Map<Long, List<Long>> outSkuIdsMap) {
        Map<CustomerBuyScopeTypeEnum, List<CustomerBuyScopeRespDto>> customerBuyScopeMap;
        CustomerItemAuthInfo customerItemAuthInfo = new CustomerItemAuthInfo();
        List shopIds = itemSearchQueryReqDto.getShopIds();
        Long shopId = itemSearchQueryReqDto.getShopId();
        if (CollUtil.isEmpty((Collection)shopIds) && Objects.isNull(shopId)) {
            return customerItemAuthInfo;
        }
        if (Objects.nonNull(shopId)) {
            shopIds = ListUtil.toList((Object[])new Long[]{shopId});
        }
        if (CollUtil.isEmpty(customerBuyScopeMap = this.getBuyScopeMap(shopIds, ItemAuthEnum.TargetType.SHOP))) {
            logger.info("[\u5e97\u94fa\u53ef\u5356] >>> \u6ca1\u6709\u6388\u6743\u53ef\u5356\u5546\u54c1\uff0c\u5e97\u94fa\u65e0\u5546\u54c1\u53ef\u5356");
            return customerItemAuthInfo;
        }
        Set<CustomerBuyScopeTypeEnum> customerBuyScopeTypeEnums = customerBuyScopeMap.keySet();
        for (CustomerBuyScopeTypeEnum key : customerBuyScopeTypeEnums) {
            List businessIds = customerBuyScopeMap.get(key).stream().map(CustomerBuyScopeRespDto::getBusinessId).collect(Collectors.toList());
            if (CollUtil.isEmpty(businessIds)) continue;
            switch (key) {
                case SKU: {
                    List skuRespDtos = (List)this.itemSkuQueryApi.queryBySkuId(businessIds).getData();
                    List itemIdList = skuRespDtos.stream().map(ItemSkuRespDto::getItemId).collect(Collectors.toList());
                    if (CollUtil.isEmpty(itemIdList)) {
                        return customerItemAuthInfo;
                    }
                    List itemIds = itemSearchQueryReqDto.getItemIds();
                    logger.info("[\u5e97\u94fa\u53ef\u5356] >>> \u5e97\u94fa{}\u53ef\u5356\u7684 SKU \u5217\u8868\u4e3a{}\u8f6c\u4e3a\u5546\u54c1ID{}", new Object[]{shopIds, businessIds, itemIdList});
                    if (CollUtil.isEmpty((Collection)itemIds)) {
                        itemSearchQueryReqDto.setItemIds(itemIdList);
                    } else {
                        itemIdList.retainAll(itemIds);
                        if (CollUtil.isEmpty(itemIdList)) {
                            logger.info("[\u5e97\u94fa\u53ef\u5356] >>> \u5df2\u9650\u5236{}\u540e\u65e0\u4ea4\u96c6\uff0c\u5e97\u94fa\u65e0\u5546\u54c1\u53ef\u5356", (Object)itemIds);
                            return customerItemAuthInfo;
                        }
                        itemSearchQueryReqDto.setItemIds(itemIdList);
                    }
                    customerItemAuthInfo.setShopIdList(shopIds);
                    customerItemAuthInfo.setShopItemAuthList(customerBuyScopeMap.get(key));
                    logger.info("[\u5e97\u94fa\u53ef\u5356] >>> \u53ef\u5356\u5546\u54c1ID{}", (Object)itemSearchQueryReqDto.getItemIds());
                    break;
                }
            }
        }
        customerItemAuthInfo.setState(Boolean.TRUE);
        return customerItemAuthInfo;
    }
}

