/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.price;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ItemPriceHelper {
    public BigDecimal getActualPolicyPrice(ItemPolicyPriceRespDto policyDto, Integer num) {
        if (num == null) {
            throw new RuntimeException("invalid num");
        }
        if (policyDto == null) {
            return null;
        }
        BigDecimal acutualPrice = null;
        if (policyDto.getHasLadderPrice() && policyDto.getLadderPrices() != null && !policyDto.getLadderPrices().isEmpty()) {
            for (ItemPolicyPriceRespDto.LadderPrice ladderPrice : policyDto.getLadderPrices()) {
                Integer lower = ladderPrice.getLower() == null ? -1 : ladderPrice.getLower();
                Integer upper = ladderPrice.getUpper() == null ? Integer.MAX_VALUE : ladderPrice.getUpper();
                if (num.compareTo(lower) < 0 || num.compareTo(upper) > 0) continue;
                acutualPrice = ladderPrice.getPrice();
                break;
            }
        }
        if (acutualPrice == null && policyDto.getHasDiscountPrice()) {
            acutualPrice = policyDto.getDiscountPrice();
        }
        if (acutualPrice == null) {
            acutualPrice = policyDto.getPrice();
        }
        return acutualPrice;
    }

    public BigDecimal getDefaultMatchPrice(ItemPolicyPriceRespDto policyDto, Integer num) {
        if (num == null || num == 0) {
            num = 1;
        }
        if (policyDto == null) {
            return null;
        }
        BigDecimal acutualPrice = null;
        if (policyDto.getHasLadderPrice() && policyDto.getLadderPrices() != null && !policyDto.getLadderPrices().isEmpty()) {
            for (ItemPolicyPriceRespDto.LadderPrice ladderPrice : policyDto.getLadderPrices()) {
                Integer lower = ladderPrice.getLower() == null ? -1 : ladderPrice.getLower();
                Integer upper = ladderPrice.getUpper() == null ? Integer.MAX_VALUE : ladderPrice.getUpper();
                if (num.compareTo(lower) < 0 || num.compareTo(upper) > 0) continue;
                acutualPrice = ladderPrice.getPrice();
                break;
            }
        }
        if (acutualPrice == null && policyDto.getHasDiscountPrice()) {
            acutualPrice = policyDto.getDiscountPrice();
        }
        if (acutualPrice == null) {
            acutualPrice = policyDto.getPrice();
        }
        return acutualPrice;
    }

    public BigDecimal getMinPolicyPrice(ItemPolicyPriceRespDto policyDto) {
        BigDecimal skuMinPrce = null;
        if (policyDto == null) {
            return null;
        }
        if (policyDto.getHasLadderPrice() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)policyDto.getLadderPrices())) {
            skuMinPrce = policyDto.getLadderPrices().stream().filter(e -> e.getPrice() != null).map(ladderPrice -> ladderPrice.getPrice()).min(BigDecimal::compareTo).orElse(null);
            return skuMinPrce;
        }
        if (policyDto.getHasDiscountPrice()) {
            return policyDto.getDiscountPrice();
        }
        if (policyDto.getPrice() != null) {
            return policyDto.getPrice();
        }
        return skuMinPrce;
    }

    public BigDecimal getMaxPolicyPrice(ItemPolicyPriceRespDto policyDto) {
        BigDecimal skuMaxPrce = null;
        if (policyDto == null) {
            return null;
        }
        if (policyDto.getHasLadderPrice() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)policyDto.getLadderPrices())) {
            skuMaxPrce = policyDto.getLadderPrices().stream().filter(e -> e.getPrice() != null).map(ladderPrice -> ladderPrice.getPrice()).max(BigDecimal::compareTo).orElse(null);
            return skuMaxPrce;
        }
        if (policyDto.getHasDiscountPrice()) {
            return policyDto.getDiscountPrice();
        }
        if (policyDto.getPrice() != null) {
            return policyDto.getPrice();
        }
        return skuMaxPrce;
    }

    public boolean isSkuPolicyPriceExist(ItemPolicyPriceRespDto itemPolicyPriceRespDto) {
        boolean res = true;
        if (itemPolicyPriceRespDto == null) {
            res = false;
        }
        if (!itemPolicyPriceRespDto.getHasLadderPrice() && !itemPolicyPriceRespDto.getHasDiscountPrice() && itemPolicyPriceRespDto.getPrice() == null) {
            res = false;
        }
        return res;
    }

    public BigDecimal getItemSkuPolicyMinPrice(List<ItemPolicyPriceRespDto> itemSkuPrice) {
        BigDecimal minPrice = null;
        if (!CollectionUtils.isEmpty(itemSkuPrice)) {
            minPrice = itemSkuPrice.stream().filter(e -> this.isSkuPolicyPriceExist((ItemPolicyPriceRespDto)e)).map(e -> {
                BigDecimal skuMinPrce = BigDecimal.ZERO;
                if (e.getHasLadderPrice()) {
                    skuMinPrce = e.getLadderPrices().stream().map(ladderPrice -> ladderPrice.getPrice() == null ? BigDecimal.ZERO : ladderPrice.getPrice()).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
                    return skuMinPrce;
                }
                if (e.getHasDiscountPrice()) {
                    return e.getDiscountPrice();
                }
                if (e.getPrice() != null) {
                    return e.getPrice();
                }
                return skuMinPrce;
            }).min(BigDecimal::compareTo).orElse(null);
        }
        return minPrice;
    }

    public BigDecimal getItemSkuPolicyMaxPrice(List<ItemPolicyPriceRespDto> itemSkuPriceList) {
        BigDecimal maxPrice = null;
        if (CollUtil.isEmpty(itemSkuPriceList)) {
            return maxPrice;
        }
        for (ItemPolicyPriceRespDto itemSku : itemSkuPriceList) {
            BigDecimal skuMaxPrce = null;
            if (itemSku.getHasLadderPrice()) {
                skuMaxPrce = itemSku.getLadderPrices().stream().map(ladderPrice -> ladderPrice.getPrice() == null ? BigDecimal.ZERO : ladderPrice.getPrice()).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            } else if (itemSku.getHasDiscountPrice()) {
                skuMaxPrce = itemSku.getDiscountPrice();
            } else if (itemSku.getPrice() != null) {
                skuMaxPrce = itemSku.getPrice();
            }
            if ((skuMaxPrce == null || maxPrice == null || skuMaxPrce.compareTo(maxPrice) <= 0) && (skuMaxPrce == null || maxPrice != null)) continue;
            maxPrice = skuMaxPrce;
        }
        return maxPrice;
    }

    public static void main(String[] args) {
        ItemPriceHelper priceHelper = new ItemPriceHelper();
        ArrayList<ItemPolicyPriceRespDto> itemSkuPriceList = new ArrayList<ItemPolicyPriceRespDto>();
        ItemPolicyPriceRespDto dto1 = new ItemPolicyPriceRespDto();
        itemSkuPriceList.add(dto1);
        ItemPolicyPriceRespDto dto2 = new ItemPolicyPriceRespDto();
        dto2.setPrice(BigDecimal.ZERO);
        itemSkuPriceList.add(dto2);
        BigDecimal itemPrice = priceHelper.getItemSkuPolicyMinPrice(itemSkuPriceList);
        System.out.println(itemPrice);
        BigDecimal skuPrice = priceHelper.getMaxPolicyPrice(dto1);
        System.out.println(skuPrice);
        BigDecimal skuPrice1 = priceHelper.getMaxPolicyPrice(dto1);
        System.out.println(skuPrice1);
    }
}

