/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IItemAuthApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemOnShelfListTobReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.OnItemTobReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ScopeBusinessType;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopQueryEnum;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBitemShelfService;
import com.dtyunxi.yundt.module.bitem.api.constants.CustomerBuyScopeTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemOnShelfReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemOnShelfTobReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ShopItemReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ShopSkuDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ShopItemRespDto;
import com.dtyunxi.yundt.module.bitem.biz.handler.OnShelfBHandler;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BitemShelfServiceImpl
implements IBitemShelfService {
    private static final Logger logger = LoggerFactory.getLogger(BitemShelfServiceImpl.class);
    @Autowired
    private OnShelfBHandler onShelfBHandler;
    @Resource
    private IContext context;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IItemAuthApi itemAuthApi;

    public void onShelf(ServiceEvent<?> serviceEvent) {
        this.onShelfBHandler.handle(serviceEvent);
        List itemOnShelfReqDtos = (List)serviceEvent.getData();
        for (ItemOnShelfReqDto itemOnShelfReqDto : itemOnShelfReqDtos) {
            if (!ObjectUtils.isNotEmpty((Object)itemOnShelfReqDto.getItemAuthId()) || !StringUtils.isNotBlank((CharSequence)itemOnShelfReqDto.getExternalCode())) continue;
            ItemAuthReqDto modifyReqDto = new ItemAuthReqDto();
            modifyReqDto.setId(itemOnShelfReqDto.getItemAuthId());
            modifyReqDto.setExternalCode(itemOnShelfReqDto.getExternalCode());
            this.itemAuthApi.modifyItemAuth(modifyReqDto);
        }
    }

    public ShopItemRespDto newCheckShopSkuScope(ShopItemReqDto shopItemReqDto) {
        Assert.notNull((Object)shopItemReqDto.getShopId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ItemAuthQueryReqDto itemAuthQueryReqDto = new ItemAuthQueryReqDto();
        itemAuthQueryReqDto.setChannel(Integer.valueOf(2));
        itemAuthQueryReqDto.setTargetType(Integer.valueOf(2));
        itemAuthQueryReqDto.setTargetIdList((List)Lists.newArrayList((Object[])new Long[]{shopItemReqDto.getShopId()}));
        itemAuthQueryReqDto.setPageNum(Integer.valueOf(1));
        itemAuthQueryReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        RestResponse pageInfoRestResp = this.itemAuthQueryApi.queryItemAuthPage(itemAuthQueryReqDto);
        PageInfo itemAuthPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        ShopItemRespDto respDto = new ShopItemRespDto();
        respDto.setCanShelf(true);
        CubeBeanUtils.copyProperties((Object)respDto, (Object)shopItemReqDto, (String[])new String[]{"skus"});
        if (Objects.isNull(itemAuthPageInfo) || CollectionUtils.isEmpty((Collection)itemAuthPageInfo.getList())) {
            respDto.setCanShelf(false);
            respDto.setErrMsg("\u5546\u54c1" + shopItemReqDto.getItemName() + "\u6ca1\u6709\u5728\u5e97\u94fa" + shopItemReqDto.getShopName() + "\u552e\u5356\u8303\u56f4\u5185.");
            return respDto;
        }
        ArrayList<Long> disableSkuids = new ArrayList<Long>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (ItemAuthQueryRespDto itemAuthQueryRespDto : itemAuthPageInfo.getList()) {
            CustomerBuyScopeTypeEnum type = CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)itemAuthQueryRespDto.getBusinessType());
            if (type == null) continue;
            switch (type) {
                case SKU: {
                    skuIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BANSKU: {
                    disableSkuids.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
            }
        }
        StringBuilder errMsg = new StringBuilder();
        HashSet matchSkuIds = Sets.newHashSet();
        if (!CollectionUtil.isEmpty(disableSkuids)) {
            for (ShopSkuDto skus : shopItemReqDto.getSkus()) {
                if (!disableSkuids.contains(skus.getSkuId())) continue;
                matchSkuIds.add(skus.getSkuId());
            }
        }
        if (!CollectionUtil.isEmpty(skuIds)) {
            for (ShopSkuDto skus : shopItemReqDto.getSkus()) {
                if (skuIds.contains(skus.getSkuId())) continue;
                matchSkuIds.add(skus.getSkuId());
            }
        }
        if (!CollectionUtil.isEmpty((Collection)matchSkuIds)) {
            Map<Long, String> skuMap = shopItemReqDto.getSkus().stream().filter(sku -> Objects.nonNull(sku.getSkuId()) && StringUtils.isNotEmpty((CharSequence)sku.getAttr())).collect(Collectors.toMap(ShopSkuDto::getSkuId, ShopSkuDto::getAttr, (o1, o2) -> o1));
            respDto.setCanShelf(false);
            errMsg.append("\u5546\u54c1\u89c4\u683c(");
            for (Long matchSkuId : matchSkuIds) {
                String attr = skuMap.get(matchSkuId);
                errMsg.append(attr + " ");
            }
            errMsg.append(")\u6ca1\u6709\u5728\u5e97\u94fa\u552e\u5356\u8303\u56f4\u5185.");
            respDto.setErrMsg(errMsg.toString());
        }
        return respDto;
    }

    public void batchOnShelfItem(List<ItemOnShelfTobReqDto> itemOnShelfReqDtos) {
        logger.info("======>\u5546\u54c1\u4e0a\u67b6\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(itemOnShelfReqDtos));
        ArrayList onItemTobReqDtos = new ArrayList();
        itemOnShelfReqDtos.forEach(itemOffShelfReqDto -> {
            OnItemTobReqDto onItemTobReqDto = new OnItemTobReqDto();
            if (itemOffShelfReqDto.getBusType() == null) {
                onItemTobReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
            } else {
                onItemTobReqDto.setBusType(itemOffShelfReqDto.getBusType());
            }
            if (ItemBusTypeEnum.INTEGRAL.getType().equals(itemOffShelfReqDto.getItemType())) {
                onItemTobReqDto.setBusType(ItemBusTypeEnum.INTEGRAL.getType());
                onItemTobReqDto.setItemType(null);
            }
            onItemTobReqDto.setItemId(itemOffShelfReqDto.getItemId());
            onItemTobReqDto.setSkuId(itemOffShelfReqDto.getSkuId());
            onItemTobReqDto.setShopId(itemOffShelfReqDto.getShopId());
            onItemTobReqDtos.add(onItemTobReqDto);
        });
        ItemOnShelfListTobReqDto itemOnShelfListReqDto = new ItemOnShelfListTobReqDto();
        itemOnShelfListReqDto.setOnItemList(onItemTobReqDtos);
        RestResponse restResponse = this.itemAuthApi.batchOnShelfItem(itemOnShelfListReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    public ShopItemRespDto checkShopSkuScope(ShopItemReqDto shopItemReqDto) {
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopItemReqDto.getShopId().longValue(), new String[]{ShopQueryEnum.SHOP_BUSI.name()}).getData();
        List shopBusinessScopeDtoList = shopDto.getShopBusinessScopeDto();
        Long currentUserOrgId = shopDto.getOrganizationId();
        ArrayList itemBrandFrontDirIds = Lists.newArrayList();
        this.fillItemFrontDirIds(itemBrandFrontDirIds, shopItemReqDto.getItemId(), currentUserOrgId);
        ShopItemRespDto respDto = new ShopItemRespDto();
        respDto.setCanShelf(true);
        CubeBeanUtils.copyProperties((Object)respDto, (Object)shopItemReqDto, (String[])new String[]{"skus"});
        if (CollectionUtil.isEmpty((Collection)shopBusinessScopeDtoList)) {
            respDto.setCanShelf(false);
            respDto.setErrMsg("\u5546\u54c1" + shopItemReqDto.getItemName() + "\u6ca1\u6709\u5728\u5e97\u94fa" + shopDto.getName() + "\u552e\u5356\u8303\u56f4\u5185.");
            return respDto;
        }
        ArrayList dealerBrandIds = new ArrayList();
        ArrayList dealerDirIds = new ArrayList();
        ArrayList disableSkuids = new ArrayList();
        shopBusinessScopeDtoList.forEach(shopScope -> {
            ScopeBusinessType type = ScopeBusinessType.fromCode((String)shopScope.getBusinessType());
            if (type != null) {
                switch (type) {
                    case BRAND: {
                        dealerBrandIds.add(shopScope.getBusinessId());
                        break;
                    }
                    case EXCEPT_SKU_ID: {
                        disableSkuids.add(shopScope.getBusinessId());
                        break;
                    }
                    case DIR: {
                        dealerDirIds.add(shopScope.getBusinessId());
                        break;
                    }
                }
            }
        });
        boolean brandInScope = true;
        boolean dirInScope = true;
        StringBuilder errMsg = new StringBuilder();
        StringBuilder dirErrMsg = new StringBuilder();
        brandInScope = shopItemReqDto.getBrandId() != null && !CollectionUtil.isEmpty(dealerBrandIds) ? dealerBrandIds.contains(shopItemReqDto.getBrandId()) : false;
        if (!CollectionUtil.isEmpty((Collection)itemBrandFrontDirIds) && !CollectionUtil.isEmpty(dealerDirIds)) {
            Long itemShelfDir;
            Iterator iterator = itemBrandFrontDirIds.iterator();
            while (iterator.hasNext() && !(dirInScope = dealerDirIds.contains(itemShelfDir = (Long)iterator.next()))) {
            }
            if (!dirInScope) {
                dirErrMsg.append("\u5546\u54c1\u6ca1\u6709\u5728\u5e97\u94fa[" + shopDto.getName() + "]\u552e\u5356\u8303\u56f4\u5185.");
            }
        } else {
            dirInScope = false;
            dirErrMsg.append("\u5546\u54c1\u6ca1\u6709\u5728\u5e97\u94fa[" + shopDto.getName() + "]\u552e\u5356\u8303\u56f4\u5185.");
        }
        List<Object> matchSkus = new ArrayList();
        if (!CollectionUtil.isEmpty(disableSkuids)) {
            matchSkus = shopItemReqDto.getSkus().stream().filter(e -> disableSkuids.contains(e.getSkuId())).collect(Collectors.toList());
        }
        if (!brandInScope) {
            respDto.setCanShelf(false);
            errMsg.append("\u5546\u54c1\u54c1\u724c" + shopItemReqDto.getBrandName() + "\u6ca1\u6709\u5728\u5e97\u94fa[" + shopDto.getName() + "]\u552e\u5356\u8303\u56f4\u5185.");
        }
        if (!dirInScope) {
            respDto.setCanShelf(false);
            errMsg.append(dirErrMsg.toString());
        }
        if (!respDto.getCanShelf()) {
            respDto.setErrMsg(errMsg.toString());
            return respDto;
        }
        if (!CollectionUtil.isEmpty(matchSkus)) {
            respDto.setCanShelf(false);
            errMsg.append("\u5546\u54c1\u89c4\u683c(");
            matchSkus.forEach(skuDto -> errMsg.append(skuDto.getAttr() + " "));
            errMsg.append(")\u6ca1\u6709\u5728\u5e97\u94fa\u552e\u5356\u8303\u56f4\u5185.");
            respDto.setErrMsg(errMsg.toString());
        }
        return respDto;
    }

    private void fillItemFrontDirIds(List<Long> itemFrontDirIds, Long itemId, Long currentUserOrgId) {
        Long brandSellerId = null;
        List<Long> upSellerIds = this.queryBrandSellerId(currentUserOrgId);
        Long l = brandSellerId = upSellerIds.isEmpty() ? null : upSellerIds.get(0);
        if (brandSellerId == null) {
            return;
        }
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        shopQueryDto.setTenantId(this.context.tenantId());
        shopQueryDto.setInstanceId(this.context.instanceId());
        shopQueryDto.setSellerId(brandSellerId);
        List shopBaseDtoList = (List)this.shopQueryApi.queryBaseShopList(shopQueryDto).getData();
        shopBaseDtoList.forEach(e -> {
            Long shopId = e.getId();
            List itemDirList = (List)this.directoryQueryApi.queryShopDirList(itemId, shopId, ItemBusTypeEnum.ORDINARY.getType(), "front").getData();
            if (!CollectionUtils.isEmpty((Collection)itemDirList)) {
                List res = itemDirList.stream().map(DirectoryItemRespDto::getId).collect(Collectors.toList());
                itemFrontDirIds.addAll(res);
            }
        });
    }

    private Long queryUerOrgId(Long userId) {
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(this.context.userId(), Integer.valueOf(1), Integer.valueOf(1));
        PageInfo organizationDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)organizationDtoPageInfo.getList()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u672a\u7ed1\u5b9a\u7ec4\u7ec7", (Object[])new Object[0]);
        return ((OrganizationDto)organizationDtoPageInfo.getList().get(0)).getId();
    }

    private List<Long> queryBrandSellerId(Long currentUserOrgId) {
        ArrayList<Long> res = new ArrayList<Long>();
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setOrgInfoIds(Arrays.asList(currentUserOrgId));
        searchReqDto.setInstanceId(this.context.instanceId());
        searchReqDto.setType(Integer.valueOf(2));
        searchReqDto.setTenantId(this.context.tenantId());
        List customerListResp = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto)));
        customerListResp.forEach(e -> {
            SellerRespDto sellerRespDto;
            Long merchantId = e.getMerchantId();
            if (merchantId != null && (sellerRespDto = (SellerRespDto)this.sellerExtQueryApi.querySellerByOrganizationId(merchantId).getData()) != null) {
                res.add(sellerRespDto.getId());
            }
        });
        return res;
    }

    public void modifyItemAuth(ItemAuthReqDto modifyReqDto) {
        if (!ObjectUtils.isNotEmpty((Object)modifyReqDto.getId())) {
            throw new BizException("\u66f4\u65b0\u5931\u8d25\uff0c\u5546\u54c1\u6388\u6743\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ItemAuthReqDto upDto = new ItemAuthReqDto();
        upDto.setId(modifyReqDto.getId());
        upDto.setExternalCode(modifyReqDto.getExternalCode());
        this.itemAuthApi.modifyItemAuth(upDto);
    }

    public void batchSetting(List<ItemOnShelfTobReqDto> itemOnShelfReqDtos) {
        ItemOnShelfListTobReqDto itemOnShelfListReqDto = this.getItemOnShelfListTobReqDto(itemOnShelfReqDtos);
        RestResponse restResponse = this.itemAuthApi.batchSetting(itemOnShelfListReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    private ItemOnShelfListTobReqDto getItemOnShelfListTobReqDto(List<ItemOnShelfTobReqDto> itemOnShelfReqDtos) {
        logger.info("======>\u5546\u54c1\u4e0a\u67b6\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(itemOnShelfReqDtos));
        ArrayList onItemTobReqDtos = new ArrayList();
        itemOnShelfReqDtos.forEach(itemOffShelfReqDto -> {
            OnItemTobReqDto onItemTobReqDto = new OnItemTobReqDto();
            BeanUtils.copyProperties((Object)itemOffShelfReqDto, (Object)onItemTobReqDto);
            if (itemOffShelfReqDto.getBusType() == null) {
                onItemTobReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
            } else {
                onItemTobReqDto.setBusType(itemOffShelfReqDto.getBusType());
            }
            if (ItemBusTypeEnum.INTEGRAL.getType().equals(itemOffShelfReqDto.getItemType())) {
                onItemTobReqDto.setBusType(ItemBusTypeEnum.INTEGRAL.getType());
                onItemTobReqDto.setItemType(null);
            }
            onItemTobReqDto.setItemId(itemOffShelfReqDto.getItemId());
            onItemTobReqDto.setSkuId(itemOffShelfReqDto.getSkuId());
            onItemTobReqDto.setShopId(itemOffShelfReqDto.getShopId());
            onItemTobReqDtos.add(onItemTobReqDto);
        });
        ItemOnShelfListTobReqDto itemOnShelfListReqDto = new ItemOnShelfListTobReqDto();
        itemOnShelfListReqDto.setOnItemList(onItemTobReqDtos);
        return itemOnShelfListReqDto;
    }
}

