/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.service.impl;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemNumRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.ICustomerAuthItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.ICustomerAuthItemQueryExtApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.module.bitem.biz.service.ICustomerAuthItemService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ICustomerAuthItemServiceImpl
implements ICustomerAuthItemService {
    private static final Logger logger = LoggerFactory.getLogger(ICustomerAuthItemServiceImpl.class);
    @Autowired
    private ICustomerAuthItemQueryApi customerAuthItemQueryApi;
    @Autowired
    private ICustomerAuthItemQueryExtApi iCustomerAuthItemQueryExtApi;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Override
    public RestResponse<PageInfo<CustomerAuthItemRespDto>> queryAuthItemPage(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        PageInfo pageInfo;
        SellerRespDto sellerRespDto = null;
        if (customerAuthItemPageReqDto.getOrganizationId() != null) {
            sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(customerAuthItemPageReqDto.getOrganizationId()));
        }
        if ((pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerAuthItemQueryApi.queryAuthItemPage(customerAuthItemPageReqDto))) != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            for (CustomerAuthItemRespDto customerAuthItemRespDto : pageInfo.getList()) {
                if (sellerRespDto == null) continue;
                customerAuthItemRespDto.setOrganizationName(sellerRespDto.getName());
            }
        }
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<CustomerAuthItemNumRespDto> queryAuthItemNum(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        return this.customerAuthItemQueryApi.queryAuthItemNum(customerAuthItemPageReqDto);
    }

    @Override
    public RestResponse<List<CustomerAuthItemRespDto>> queryAuthItemBySkuIds(List<Long> skuIds, Long orgId) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return new RestResponse(new ArrayList());
        }
        try {
            return this.iCustomerAuthItemQueryExtApi.queryAuthItemBySkuIds(skuIds, orgId);
        }
        catch (Exception e) {
            logger.error("Error querying auth items by skuIds: {}", skuIds, (Object)e);
            return new RestResponse(new ArrayList());
        }
    }
}

