/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.rest;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IItemAuthApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthStateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthAddBatchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.module.bitem.biz.service.IBItemAuthService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u670d\u52a1\uff1a\u5546\u54c1\u6388\u6743"})
@RestController
@RequestMapping(value={"/v1/bitem"})
public class BItemAuthRest {
    @Resource
    private IContext context;
    @Resource
    private IItemAuthApi itemAuthApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IBItemAuthService itemAuthService;

    @GetMapping(value={"/item-auth/page"})
    @ApiOperation(value="\u5546\u54c1\u6388\u6743\u5217\u8868(\u652f\u6301\u5ba2\u6237\u548c\u5e97\u94fa)", notes="\u5546\u54c1\u6388\u6743\u5217\u8868(\u652f\u6301\u5ba2\u6237\u548c\u5e97\u94fa)")
    public RestResponse<PageInfo<ItemAuthQueryRespDto>> page(@ModelAttribute @Valid ItemAuthQueryReqDto itemAuthQueryReqDto) {
        return this.itemAuthService.queryItemAuthPage(itemAuthQueryReqDto);
    }

    @PostMapping(value={"state"})
    @ApiOperation(value="\u5546\u54c1\u7981\u7528/\u542f\u7528")
    public RestResponse<Void> state(@RequestBody @Valid ItemAuthStateReqDto itemAuthStateReqDto) {
        return this.itemAuthApi.state(itemAuthStateReqDto);
    }

    @PostMapping(value={"batch"})
    @ApiOperation(value="\u65b0\u589e\u5546\u54c1\u6388\u6743", notes="\u65b0\u589e\u5546\u54c1\u6388\u6743\uff0c\u652f\u6301\u6279\u91cf")
    public RestResponse<List<Long>> batchItemAuth(@RequestBody ItemAuthAddBatchRespDto itemAuthAddBatchRespDto) {
        return this.itemAuthApi.batchItemAuth(itemAuthAddBatchRespDto);
    }

    @DeleteMapping(value={"/del"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5546\u54c1\u6388\u6743", notes="\u6279\u91cf\u5220\u9664\u5546\u54c1\u6388\u6743")
    public RestResponse<Void> removeItemAuth(@RequestParam(value="ids") List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return RestResponse.VOID;
        }
        String idsStr = ids.stream().map(id -> String.valueOf(id)).collect(Collectors.joining(","));
        Long instanceId = this.context.instanceId();
        instanceId = Objects.isNull(instanceId) ? -1L : instanceId;
        this.itemAuthApi.removeItemAuth(idsStr, instanceId);
        return RestResponse.VOID;
    }
}

