/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.group;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.model.ItemPurchaseLimit;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.GroupActivityDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.dtyunxi.yundt.module.marketing.biz.constant.GroupActivityConstant;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PurchaseQuantityLimitCondition
extends AbstractBaseTemplate {
    @Override
    public long getConditionTemplateId() {
        return GroupActivityConstant.PURCHASE_QUANTITY_LIMIT_TP_ID;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.GROUP_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        GroupActivityDto activityDto = (GroupActivityDto)t;
        ConditionReqDto conditionReqDto = this.getConditionReqDto();
        ArrayList itemPurchaseLimits = Lists.newArrayList();
        activityDto.getItems().forEach(itemDto -> {
            if (null != itemDto.getPurchaseQuantityLimit()) {
                ItemPurchaseLimit itemPurchaseLimit = new ItemPurchaseLimit();
                itemPurchaseLimit.setItemId(itemDto.getItemId());
                itemPurchaseLimit.setShopId(itemDto.getShopId());
                itemPurchaseLimit.setLimitQuantity(itemDto.getPurchaseQuantityLimit());
                itemPurchaseLimits.add(itemPurchaseLimit);
            }
        });
        HashMap conditionParam = Maps.newHashMap();
        conditionParam.put("PurchaseQuantityLimitCondition.items", itemPurchaseLimits);
        conditionReqDto.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return conditionReqDto;
    }

    @Override
    public <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        GroupActivityDto activityDto = (GroupActivityDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List itemPurchaseLimits = JSONArray.parseArray((String)jsonObject.getString("PurchaseQuantityLimitCondition.items"), ItemPurchaseLimit.class);
        if (CollectionUtils.isNotEmpty((Collection)itemPurchaseLimits)) {
            Map<String, Integer> limitMap = itemPurchaseLimits.stream().collect(Collectors.toMap(key -> key.getItemId().toString() + key.getShopId(), ItemPurchaseLimit::getLimitQuantity, (e1, e2) -> e1));
            activityDto.getItems().forEach(itemDto -> itemDto.setPurchaseQuantityLimit((Integer)limitMap.get(itemDto.getItemId().toString() + itemDto.getShopId())));
        }
    }
}

