/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupDetailReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.service.query.IActivityGroupQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.IGroupActivity;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityGroupDetailQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.GroupActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ActivityGroupListRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ActivityTermDetailRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.GroupActivityQueryRespDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.impl.AbstractActivityService;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.module.marketing.biz.util.PageInfoUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupActivityImpl
extends AbstractActivityService
implements IGroupActivity {
    private static Logger logger = LoggerFactory.getLogger(GroupActivityImpl.class);
    @Resource
    private IActivityApi activityApi;
    @Resource
    private IActivityExtQueryApi activityExtQueryApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IContext context;
    @Resource
    private MarketingModuleHelper marketingModuleHelper;
    @Resource
    private IActivityItemQueryApi activityItemQueryApi;
    @Resource
    private IBitemService itemService;
    @Resource
    private IActivityGroupQueryApi activityGroupQueryApi;
    @Autowired
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private IActivityExtApi activityExtApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IActivityService activityService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    protected <T extends BaseActivityTobDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        GroupActivityDto groupActivityDto = (GroupActivityDto)activityReqDto;
        ArrayList activityItems = Lists.newArrayList();
        groupActivityDto.getItems().forEach(itemDto -> itemDto.getSkus().forEach(skuDto -> {
            ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
            activityItemReqDto.setActivityPrice(skuDto.getGroupPrice());
            activityItemReqDto.setItemId(skuDto.getItemId());
            activityItemReqDto.setRemainingStock(skuDto.getActivityStock());
            activityItemReqDto.setOriginalStock(skuDto.getActivityStock());
            activityItemReqDto.setItemName(itemDto.getItemName());
            activityItemReqDto.setSkuId(skuDto.getSkuId());
            activityItemReqDto.setInstanceId(this.context.instanceId());
            activityItemReqDto.setTenantId(this.context.tenantId());
            activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
            activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
            activityItemReqDto.setShopId(itemDto.getShopId());
            activityItems.add(activityItemReqDto);
        }));
        return activityItems;
    }

    public Long add(GroupActivityDto groupActivityDto) {
        this.validate(groupActivityDto);
        groupActivityDto.setActivityCode(this.marketingModuleHelper.generateCode("PT"));
        return this.addActivity(groupActivityDto);
    }

    private void validate(GroupActivityDto groupActivityDto) {
        if (CollectionUtils.isEmpty((Collection)groupActivityDto.getItems())) {
            throw new BizException("\u6d3b\u52a8\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        groupActivityDto.getItems().forEach(itemDto -> {
            if (null == itemDto.getShopId()) {
                throw new BizException("\u5546\u54c1\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != itemDto.getPurchaseQuantityLimit() && itemDto.getPurchaseQuantityLimit() < 1) {
                throw new BizException("\u5546\u54c1\u8d2d\u4e70\u6570\u91cf\u9650\u5236\u9700\u8981\u5927\u4e8e0");
            }
            itemDto.getSkus().forEach(sku -> {
                if (null == sku.getGroupPrice()) {
                    throw new BizException("\u5546\u54c1\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (sku.getGroupPrice().compareTo(BigDecimal.ZERO) < 1) {
                    throw new BizException("\u5546\u54c1\u6d3b\u52a8\u4ef7\u683c\u9700\u5927\u4e8e0");
                }
                BigDecimal sellPrice = this.itemService.queryItemPrice(itemDto.getShopId(), itemDto.getItemId(), sku.getSkuId());
                if (null == sellPrice || sellPrice.compareTo(sku.getGroupPrice()) == -1) {
                    throw new BizException("\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u5546\u54c1\u552e\u4ef7");
                }
                if (sku.getGroupPrice().compareTo(BigDecimal.ZERO) < 1) {
                    throw new BizException("\u5546\u54c1\u6d3b\u52a8\u4ef7\u683c\u9700\u8981\u5927\u4e8e0");
                }
                if (sku.getActivityStock() < 1L) {
                    throw new BizException("\u5546\u54c1\u6d3b\u52a8\u5e93\u5b58\u9700\u8981\u5927\u4e8e0");
                }
            });
        });
    }

    private BigDecimal getSellPrice(Long skuId, List<ItemPriceRespDto> priceList) {
        return priceList.stream().filter(itemPriceRespDto -> skuId.equals(itemPriceRespDto.getSkuId()) && "\u552e\u4ef7".equals(itemPriceRespDto.getName())).map(ItemPriceRespDto::getPrice).findFirst().orElseGet(() -> BigDecimal.ZERO);
    }

    public GroupActivityDto getDetail(Long id) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        GroupActivityDto groupActivityDto = new GroupActivityDto(activityRespDto);
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.GROUP_ACTIVITY);
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), groupActivityDto));
        groupActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        Long totalGroupNumber = (Long)this.activityGroupQueryApi.countGroupNumber(id, null).getData();
        BigDecimal orderAmount = (BigDecimal)this.activityGroupQueryApi.countOrderAmount(id, null).getData();
        groupActivityDto.setTotalGroupNumber(totalGroupNumber);
        groupActivityDto.setOrderAmount(orderAmount);
        return groupActivityDto;
    }

    public PageInfo<ActivityGroupListRespDto> queryActivityGroupByPage(ActivityGroupReqDto activityGroupReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        PageInfo result = new PageInfo();
        Long activityId = activityGroupReqDto.getActivityId();
        GroupActivityDto activityDto = null;
        if (activityId != null) {
            activityDto = this.getDetail(activityId);
        }
        if (null == activityGroupReqDto.getGroupStatus()) {
            ArrayList statusList = Lists.newArrayList((Object[])new Integer[]{0, 1, 2});
            activityGroupReqDto.setGroupStatusList((List)statusList);
        }
        if (null != (pageInfo = (PageInfo)this.activityGroupQueryApi.queryByPage(activityGroupReqDto, pageNum, pageSize).getData()) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            ArrayList list = Lists.newArrayList();
            GroupActivityDto activityDetail = activityDto;
            pageInfo.getList().forEach(activityGroupRespDto -> {
                ActivityGroupListRespDto activityGroup = new ActivityGroupListRespDto();
                BeanCopierUtils.copy((Object)activityGroupRespDto, (Object)activityGroup);
                Long totalGroupNumber = (Long)this.activityGroupQueryApi.countGroupNumber(activityId, activityGroupRespDto.getId()).getData();
                activityGroup.setTotalGroupNumber(Integer.valueOf(totalGroupNumber.intValue()));
                BigDecimal orderAmount = (BigDecimal)this.activityGroupQueryApi.countOrderAmount(activityId, activityGroupRespDto.getId()).getData();
                activityGroup.setTotalOrderAmount(orderAmount);
                if (activityDetail != null) {
                    int lackNum = activityDetail.getGroupNumber() - totalGroupNumber.intValue();
                    activityGroup.setGroupLackNum(Integer.valueOf(lackNum < 0 ? 0 : lackNum));
                    MemberInfoDetailRespDto memberInfoDetailDto = (MemberInfoDetailRespDto)RestResponseHelper.extractData((RestResponse)this.memberInfoExtQueryApi.queryMemberInfoDetail(activityGroupRespDto.getOpenGroupPerson()));
                    if (memberInfoDetailDto != null && memberInfoDetailDto.getMemberInfoRespDto() != null) {
                        activityGroup.setPersonName(memberInfoDetailDto.getMemberInfoRespDto().getNickName());
                        activityGroup.setAvatar(memberInfoDetailDto.getMemberInfoRespDto().getAvatar());
                    }
                }
                list.add(activityGroup);
            });
            BeanUtils.copyProperties((Object)pageInfo, (Object)result);
            result.setList((List)list);
        }
        return result;
    }

    public ActivityTermDetailRespDto queryGroupDetailByPage(ActivityGroupDetailQueryReqDto requestDto, Integer pageNum, Integer pageSize) {
        ActivityTermDetailRespDto result = new ActivityTermDetailRespDto();
        ActivityGroupRespDto groupDto = (ActivityGroupRespDto)RestResponseHelper.extractData((RestResponse)this.activityGroupQueryApi.getById(Long.valueOf(requestDto.getGroupId())));
        if (groupDto != null && groupDto.getGroupStatus() == 3) {
            return null;
        }
        requestDto.setStatus(Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.activityGroupQueryApi.queryGroupDetailByPage((ActivityGroupDetailReqDto)requestDto, pageNum, pageSize));
        if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            for (ActivityGroupDetailRespDto groupDetailDto : pageInfo.getList()) {
                MemberInfoDetailRespDto memberInfoDetailDto = (MemberInfoDetailRespDto)RestResponseHelper.extractData((RestResponse)this.memberInfoExtQueryApi.queryMemberInfoDetail(groupDetailDto.getPlayerPersonId()));
                if (memberInfoDetailDto == null || memberInfoDetailDto.getMemberInfoRespDto() == null) continue;
                groupDetailDto.setPlayerPersonName(memberInfoDetailDto.getMemberInfoRespDto().getNickName());
                groupDetailDto.setAvatar(memberInfoDetailDto.getMemberInfoRespDto().getAvatar());
            }
            result.setPageInfo(pageInfo);
        }
        if (groupDto != null) {
            result.setGroupStatus(groupDto.getGroupStatus());
            if (groupDto.getGroupStatus() == 0) {
                long remainTime = groupDto.getCloseTime().getTime() - System.currentTimeMillis();
                result.setRemainTime(remainTime < 0L ? 0L : remainTime);
                GroupActivityDto activityDto = this.getDetail(groupDto.getActivityId());
                Long totalGroupNumber = (Long)this.activityGroupQueryApi.countGroupNumber(groupDto.getActivityId(), groupDto.getId()).getData();
                Integer personCount = activityDto.getGroupNumber() - totalGroupNumber.intValue();
                result.setGroupLackNum(personCount);
                result.setGroupNumber(activityDto.getGroupNumber());
                result.setJoinGroupNumber(Integer.valueOf(totalGroupNumber.intValue()));
            } else {
                GroupActivityDto activityDto = this.getDetail(groupDto.getActivityId());
                Long totalGroupNumber = (Long)this.activityGroupQueryApi.countGroupNumber(groupDto.getActivityId(), groupDto.getId()).getData();
                result.setGroupNumber(activityDto.getGroupNumber());
                result.setJoinGroupNumber(Integer.valueOf(totalGroupNumber.intValue()));
            }
            result.setSuccessTime(groupDto.getSuccessTime());
            try {
                if (null != requestDto.getUserId()) {
                    Long memberId = this.marketingModuleHelper.getMemberIdByUserId(requestDto.getUserId());
                    requestDto.setPlayerPersonId(memberId);
                    PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)this.activityGroupQueryApi.queryGroupDetailByPage((ActivityGroupDetailReqDto)requestDto, Integer.valueOf(1), Integer.valueOf(1)));
                    if (page != null && CollectionUtils.isNotEmpty((Collection)page.getList())) {
                        result.setJoinFlag(Boolean.valueOf(true));
                    } else {
                        result.setJoinFlag(Boolean.valueOf(false));
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return result;
    }

    public PageInfo<GroupActivityQueryRespDto> queryByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo result = new PageInfo();
        activityQueryReqDto.setActivityType(ActivityType.GROUP_ACTIVITY);
        PageInfo pageInfo = this.activityService.queryByPage(activityQueryReqDto, pageNum, pageSize);
        List<Object> list = Lists.newArrayList();
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            list = pageInfo.getList().stream().map(activityListRespDto -> {
                GroupActivityQueryRespDto groupActivityQueryRespDto = new GroupActivityQueryRespDto();
                BeanUtils.copyProperties((Object)activityListRespDto, (Object)groupActivityQueryRespDto);
                return groupActivityQueryRespDto;
            }).collect(Collectors.toList());
        }
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        result.setList((List)list);
        return result;
    }
}

