/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.IBuyGiveActivity;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.buygive.BuyGiveActivityDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.impl.AbstractActivityService;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BuyGiveActivityImpl
extends AbstractActivityService
implements IBuyGiveActivity {
    @Autowired
    private IContext context;
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Autowired
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IActivityService activityService;

    public Long add(BuyGiveActivityDto activityReqDto) {
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("BG"));
        return this.addActivity(activityReqDto);
    }

    public BuyGiveActivityDto getDetail(Long id) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        BuyGiveActivityDto buyGiveActivityDto = new BuyGiveActivityDto();
        CubeBeanUtils.copyProperties((Object)buyGiveActivityDto, (Object)activityRespDto, (String[])new String[0]);
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.BUY_GIVE_ACTIVITY);
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), buyGiveActivityDto));
        buyGiveActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        buyGiveActivityDto.setOrganizationIds((List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryAllSuperiorOrgIdList()));
        return buyGiveActivityDto;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        BuyGiveActivityDto activityDto = (BuyGiveActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        if (activityDto.getSelectType() == 2) {
            activityDto.getActivityItems().stream().forEach(itemDto -> {
                ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                activityItemReqDto.setActivityPrice(BigDecimal.ZERO);
                activityItemReqDto.setItemId(itemDto.getItemId());
                activityItemReqDto.setItemName(itemDto.getItemName());
                activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                activityItemReqDto.setOriginalStock(Long.valueOf(null != itemDto.getTotalStock() ? itemDto.getTotalStock() : 0L));
                activityItemReqDto.setRemainingStock(Long.valueOf(null != itemDto.getTotalStock() ? itemDto.getTotalStock() : 0L));
                if (null != activityDto.getAttachNum()) {
                    activityItemReqDto.setAttachNum(activityDto.getAttachNum());
                }
                activityItemReqDto.setInstanceId(this.context.instanceId());
                activityItemReqDto.setTenantId(this.context.tenantId());
                activityItemReqDto.setShopId(itemDto.getShopId());
                activityItemReqDtos.add(activityItemReqDto);
            });
        }
        return activityItemReqDtos;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getUserIds(T activityReqDto) {
        BuyGiveActivityDto activityDto = (BuyGiveActivityDto)activityReqDto;
        if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityCustomers())) {
            List<Long> customerIds = activityDto.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            return customerIds;
        }
        return null;
    }
}

