/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.IFullReductionActivity;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivitySkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.fullreduction.FullReductionActivityDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.impl.AbstractActivityService;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FullReductionActivityImpl
extends AbstractActivityService
implements IFullReductionActivity {
    @Autowired
    private IContext context;
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Autowired
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IActivityService activityService;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IShopQueryApi shopQueryApi;

    public Long add(FullReductionActivityDto activityReqDto) {
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("FR"));
        if (activityReqDto.getSelectType() == 0 || activityReqDto.getSelectType() == 2) {
            List activityItems = this.activityService.queryAllItemByCondition(activityReqDto.getShopId(), activityReqDto.getBrandIds(), activityReqDto.getDirIds(), activityReqDto.getSelectType(), activityReqDto.getBlackItems());
            activityReqDto.setActivityItems(activityItems);
        }
        return this.addActivity(activityReqDto);
    }

    public void modify(FullReductionActivityDto activityReqDto) {
        Assert.notNull((Object)activityReqDto.getId(), (String)"\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)activityReqDto.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (activityReqDto.getSelectType() == 0 || activityReqDto.getSelectType() == 2) {
            List activityItems = this.activityService.queryAllItemByCondition(activityReqDto.getShopId(), activityReqDto.getBrandIds(), activityReqDto.getDirIds(), activityReqDto.getSelectType(), activityReqDto.getBlackItems());
            activityReqDto.setActivityItems(activityItems);
        }
        this.addActivity(activityReqDto);
    }

    public FullReductionActivityDto getDetail(Long id) {
        RestResponse shopBaseDtoRestResponse;
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        FullReductionActivityDto fullReductionActivityDto = new FullReductionActivityDto();
        CubeBeanUtils.copyProperties((Object)fullReductionActivityDto, (Object)activityRespDto, (String[])new String[0]);
        Long shopId = fullReductionActivityDto.getShopId();
        if (Objects.nonNull(shopId) && Objects.nonNull(shopBaseDtoRestResponse = this.shopQueryApi.queryBaseById(shopId)) && Objects.nonNull(shopBaseDtoRestResponse.getData())) {
            fullReductionActivityDto.setShopName(((ShopBaseDto)shopBaseDtoRestResponse.getData()).getName());
        }
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.FULL_REDUCTION_ACTIVITY);
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), fullReductionActivityDto));
        fullReductionActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        return fullReductionActivityDto;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        FullReductionActivityDto activityDto = (FullReductionActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        if (activityDto.getSelectType() == 1) {
            activityDto.getActivityItems().stream().forEach(itemDto -> {
                ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                activityItemReqDto.setActivityPrice(BigDecimal.ZERO);
                activityItemReqDto.setItemId(itemDto.getItemId());
                activityItemReqDto.setItemName(itemDto.getItemName());
                activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                activityItemReqDto.setRemainingStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setOriginalStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setActivityStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setSkuDesc(itemDto.getSkuDesc());
                activityItemReqDto.setInstanceId(this.context.instanceId());
                activityItemReqDto.setTenantId(this.context.tenantId());
                activityItemReqDto.setShopId(itemDto.getShopId());
                if (CollectionUtils.isNotEmpty((Collection)itemDto.getSkus())) {
                    activityItemReqDto.setSkuId(((PromotionActivitySkuDto)itemDto.getSkus().get(0)).getSkuId());
                }
                activityItemReqDtos.add(activityItemReqDto);
            });
        }
        return activityItemReqDtos;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getUserIds(T activityReqDto) {
        FullReductionActivityDto activityDto = (FullReductionActivityDto)activityReqDto;
        if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityCustomers())) {
            List<Long> customerIds = activityDto.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            return customerIds;
        }
        return null;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getCustomerTypes(T activityReqDto) {
        FullReductionActivityDto activityDto = (FullReductionActivityDto)activityReqDto;
        return activityDto.getCustomerTypeIds();
    }

    @Override
    protected <T extends BaseActivityTobDto> List<String> getCustomerAreaCodes(T activityReqDto) {
        FullReductionActivityDto activityDto = (FullReductionActivityDto)activityReqDto;
        return activityDto.getCustomerAreaCodes();
    }
}

