/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.TargetCustomerInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberCondition
extends AbstractBaseTemplate {
    private static final Logger logger = LoggerFactory.getLogger(MemberCondition.class);

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880293L;
    }

    @Override
    public long getRuleId() {
        return 1196945569812278429L;
    }

    @Override
    public boolean support(ActivityType type) {
        return true;
    }

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        JSONObject conditionObj = JSON.parseObject((String)conditionRespDto.getConditionParams());
        TargetCustomerInfoDto targetCustomerInfoDto = (TargetCustomerInfoDto)JSON.parseObject((String)conditionObj.getString("TargetCustomerCondition.value"), TargetCustomerInfoDto.class);
        if (null != targetCustomerInfoDto) {
            t.setCustomerGroupIds(targetCustomerInfoDto.getCustomerGroupIds());
            ArrayList idList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)targetCustomerInfoDto.getCustomerIds())) {
                idList.addAll(targetCustomerInfoDto.getCustomerIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)targetCustomerInfoDto.getBlackCustomerIds())) {
                idList.addAll(targetCustomerInfoDto.getBlackCustomerIds());
            }
            if (CollectionUtils.isNotEmpty(idList)) {
                CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                customerSearchReqDto.setIdList(idList);
                ICustomerQueryApi customerQueryApi = (ICustomerQueryApi)SpringBeanUtil.getBean(ICustomerQueryApi.class);
                PageInfo customers = (PageInfo)RestResponseHelper.extractData((RestResponse)customerQueryApi.queryByPageOnPost(customerSearchReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
                if (null != customers && CollectionUtils.isNotEmpty((Collection)customers.getList())) {
                    List activityCustomerDtos = customers.getList().stream().map(bean -> {
                        ActivityCustomerDto activityCustomerDto = new ActivityCustomerDto();
                        activityCustomerDto.setCustomerId(bean.getId());
                        activityCustomerDto.setCustomerCode(bean.getCode());
                        activityCustomerDto.setCustomerName(bean.getName());
                        activityCustomerDto.setRegion(bean.getRegion());
                        activityCustomerDto.setType(bean.getType());
                        activityCustomerDto.setCustomerTypeName(bean.getCustomerTypeName());
                        activityCustomerDto.setRegionNames(bean.getRegionNames());
                        activityCustomerDto.setStatusName(bean.getStatusName());
                        return activityCustomerDto;
                    }).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty((Collection)targetCustomerInfoDto.getCustomerIds())) {
                        t.setActivityCustomers(activityCustomerDtos);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)targetCustomerInfoDto.getBlackCustomerIds())) {
                        t.setBlackCustomers(activityCustomerDtos);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)targetCustomerInfoDto.getCustomerTypeIds())) {
                t.setCustomerTypeIds(targetCustomerInfoDto.getCustomerTypeIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)targetCustomerInfoDto.getCustomerAreaCodes())) {
                t.setCustomerAreaCodes(targetCustomerInfoDto.getCustomerAreaCodes());
            }
        }
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        ConditionReqDto conditionReqDto = this.getConditionReqDto();
        if (Objects.isNull(t.getSelectCustomer())) {
            t.setSelectCustomer(Integer.valueOf(0));
        }
        TargetCustomerInfoDto customerInfoDto = new TargetCustomerInfoDto();
        if (CollectionUtils.isNotEmpty((Collection)t.getActivityCustomers())) {
            List customerIds = t.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            customerInfoDto.setCustomerIds(customerIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)t.getCustomerTypeIds())) {
            customerInfoDto.setCustomerTypeIds(t.getCustomerTypeIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)t.getCustomerAreaCodes())) {
            customerInfoDto.setCustomerAreaCodes(t.getCustomerAreaCodes());
            CustomerAreaListReqDto reqDto = new CustomerAreaListReqDto();
            reqDto.setCodes(t.getCustomerAreaCodes());
            ICustomerAreaQueryApi customerAreaQueryApi = (ICustomerAreaQueryApi)SpringBeanUtil.getBean(ICustomerAreaQueryApi.class);
            List subAreaCodes = (List)customerAreaQueryApi.querySubCodeAll(reqDto).getData();
            customerInfoDto.setSubAreaCodes(subAreaCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)t.getCustomerGroupIds())) {
            customerInfoDto.setCustomerGroupIds(t.getCustomerGroupIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)t.getBlackCustomers())) {
            List blackCustomerIds = t.getBlackCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            customerInfoDto.setBlackCustomerIds(blackCustomerIds);
        }
        HashMap param = Maps.newHashMap();
        param.put("TargetCustomerCondition.type", t.getSelectCustomer());
        param.put("TargetCustomerCondition.value", customerInfoDto);
        conditionReqDto.setConditionParams(JSON.toJSONString((Object)param));
        return conditionReqDto;
    }
}

