/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.combination;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComBatch;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.CombinationRule;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.combination.CombinationActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.combination.CombinationBatch;
import com.dtyunxi.yundt.module.marketing.api.dto.request.combination.CombinationRuleContent;
import com.dtyunxi.yundt.module.marketing.api.dto.request.combination.GCombination;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinationCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(CombinationCondition.class);

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        CombinationActivityDto combinationActivityDto = (CombinationActivityDto)t;
        ITcbjInventoryApi tcbjInventoryApi = (ITcbjInventoryApi)SpringBeanUtil.getBean(ITcbjInventoryApi.class);
        IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
        List<WarehouseRespDto> warehouseRespDtos = this.queryWarehouseByOrgIds(Lists.newArrayList((Object[])new Long[]{combinationActivityDto.getOrganizationId()}));
        WarehouseRespDto warehouse = warehouseRespDtos.get(0);
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        CombinationRule combinationRule = (CombinationRule)JSON.parseObject((String)jsonObject.getString("CombinationCondition.rule"), CombinationRule.class);
        combinationActivityDto.setThresholdType(combinationRule.getThresholdType());
        combinationActivityDto.setPromotionType(combinationRule.getPromotionType());
        ComRuleContentDto contents = combinationRule.getComRuleContent();
        if (Objects.nonNull(contents)) {
            TcbjInventoryActReqDto inventoryActReqDto = new TcbjInventoryActReqDto();
            inventoryActReqDto.setActivityId(combinationActivityDto.getId());
            CombinationRuleContent combinationRuleContent = new CombinationRuleContent();
            CubeBeanUtils.copyProperties((Object)combinationRuleContent, (Object)contents, (String[])new String[0]);
            ArrayList combinationItems = Lists.newArrayList();
            contents.getCombinationItems().forEach(comItemDto -> {
                GCombination gCombination = new GCombination();
                CubeBeanUtils.copyProperties((Object)gCombination, (Object)comItemDto, (String[])new String[0]);
                logger.info("comItemDto:{},{}", comItemDto, (Object)gCombination);
                ArrayList batchs = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)batchs, (Collection)comItemDto.getBatchs(), CombinationBatch.class);
                gCombination.setBatchs((List)batchs);
                combinationItems.add(gCombination);
            });
            Long shopId = null;
            if (CollectionUtils.isNotEmpty((Collection)combinationItems)) {
                shopId = ((GCombination)combinationItems.get(0)).getShopId();
            }
            ShopBaseDto shopDto = null;
            if (null != shopId) {
                shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(((GCombination)combinationItems.get(0)).getShopId()).getData();
            }
            IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
            IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
            for (int i = 0; i < combinationItems.size(); ++i) {
                GCombination gItem = (GCombination)combinationItems.get(i);
                List skuList = (List)itemQueryApi.queryItemSkuByItemId(gItem.getItemId()).getData();
                for (ItemSkuRespDto sku : skuList) {
                    if (!sku.getId().equals(gItem.getSkuId())) continue;
                    BigDecimal price = itemService.queryItemPrice(shopId, gItem.getItemId(), gItem.getSkuId());
                    gItem.setSellPrice(price);
                    gItem.setRetailPrice(price);
                    Long stock = itemService.queryVirStorage(shopId, gItem.getItemId(), gItem.getSkuId());
                    gItem.setStock(stock);
                    ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)RestResponseHelper.extractData((RestResponse)itemQueryApi.queryItemDetail(gItem.getItemId(), "sku", null));
                    if (itemDetailRespDto == null || itemDetailRespDto.getItem() == null) break;
                    ItemRespDto item = itemDetailRespDto.getItem();
                    gItem.setSubType(item.getSubType());
                    break;
                }
                gItem.setShopName(shopDto == null ? null : shopDto.getName());
                logger.info("\u5546\u54c1\u6279\u6b21\u53c2\u6570\u524d:{}", (Object)JSON.toJSONString((Object)gItem));
                gItem.getBatchs().stream().forEach(batchObj -> {
                    CargoStorageDto queryDto = new CargoStorageDto();
                    queryDto.setCargoId(gItem.getCargoId());
                    queryDto.setBatch(batchObj.getBatch());
                    queryDto.setWarehouseId(warehouse.getId());
                    queryDto.setPageSize(Integer.valueOf(1000));
                    queryDto.setPageNum(Integer.valueOf(1));
                    logger.info("\u5e93\u5b58\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
                    PageInfo pageCargo = (PageInfo)RestResponseHelper.extractData((RestResponse)tcbjInventoryApi.queryCargoStorage(queryDto));
                    logger.info("\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageCargo));
                    if (CollectionUtils.isNotEmpty((Collection)pageCargo.getList())) {
                        CargoStorageDto cargoStorage = (CargoStorageDto)pageCargo.getList().get(0);
                        batchObj.setWarehouseName(warehouse.getName());
                        batchObj.setProduceTime(cargoStorage.getProduceTime());
                        batchObj.setExpireTime(cargoStorage.getExpireTime());
                        batchObj.setBalance(Integer.valueOf(cargoStorage.getBalance().intValue()));
                        batchObj.setAvailable(Integer.valueOf(cargoStorage.getAvailable().intValue()));
                    }
                });
                logger.info("\u5546\u54c1\u6279\u6b21\u53c2\u6570\u540e:{}", (Object)JSON.toJSONString((Object)gItem.getBatchs()));
            }
            combinationRuleContent.setCombinationItems((List)combinationItems);
            combinationActivityDto.setPromotionContent(combinationRuleContent);
        }
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944223312880296L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.COMBINATION_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        CombinationActivityDto combinationActivityDto = (CombinationActivityDto)t;
        ConditionReqDto condition = this.getConditionReqDto();
        if (Objects.isNull(combinationActivityDto.getPromotionContent())) {
            throw new BizException("\u4fc3\u9500\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CombinationRule rule = new CombinationRule();
        rule.setPromotionType(combinationActivityDto.getPromotionType());
        rule.setThresholdType(combinationActivityDto.getThresholdType());
        CombinationRuleContent combinationRule = combinationActivityDto.getPromotionContent();
        ComRuleContentDto ruleContentDto = new ComRuleContentDto();
        ruleContentDto.setTotalPrice(combinationRule.getTotalPrice());
        if (CollectionUtils.isNotEmpty((Collection)combinationRule.getCombinationItems())) {
            ArrayList combinationItems = new ArrayList();
            combinationRule.getCombinationItems().forEach(eItem -> {
                ComItemDto excItemDto = new ComItemDto();
                excItemDto.setSubType(eItem.getSubType());
                excItemDto.setItemId(eItem.getItemId());
                excItemDto.setItemName(eItem.getItemName());
                excItemDto.setItemCode(eItem.getItemCode());
                excItemDto.setShopId(eItem.getShopId());
                excItemDto.setShopName(eItem.getShopName());
                excItemDto.setSkuId(eItem.getSkuId());
                excItemDto.setSkuCode(eItem.getSkuCode());
                excItemDto.setAttr(eItem.getAttr());
                excItemDto.setBrand(eItem.getBrand());
                excItemDto.setDirName(eItem.getDirName());
                excItemDto.setCombinationPrice(eItem.getCombinationPrice());
                excItemDto.setCombinationNum(eItem.getCombinationNum());
                excItemDto.setSupportSingleBuy(eItem.getSupportSingleBuy());
                if (CollectionUtils.isNotEmpty((Collection)eItem.getBatchs())) {
                    ArrayList batchs = Lists.newArrayList();
                    eItem.getBatchs().forEach(batch -> {
                        ComBatch comBatch = new ComBatch();
                        comBatch.setBatch(batch.getBatch());
                        comBatch.setNum(batch.getNum());
                        batchs.add(comBatch);
                    });
                    excItemDto.setBatchs((List)batchs);
                }
                excItemDto.setCargoId(eItem.getCargoId());
                combinationItems.add(excItemDto);
            });
            ruleContentDto.setCombinationItems(combinationItems);
            if (combinationActivityDto.getThresholdType() == 1) {
                BigDecimal totalPrice = combinationItems.stream().map(e -> e.getCombinationPrice().multiply(BigDecimal.valueOf(e.getCombinationNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
                ruleContentDto.setTotalPrice(totalPrice);
            }
        }
        rule.setComRuleContent(ruleContentDto);
        HashMap conditionParam = Maps.newHashMap();
        conditionParam.put("CombinationCondition.rule", rule);
        logger.info("\u4f18\u60e0\u5957\u88c5\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }

    public List<WarehouseRespDto> queryWarehouseByOrgIds(List<Long> orgIds) {
        IWarehouseQueryApi warehouseQueryApi = (IWarehouseQueryApi)SpringBeanUtil.getBean(IWarehouseQueryApi.class);
        WarehouseQueryReqDto warehouseQueryReqDto = new WarehouseQueryReqDto();
        warehouseQueryReqDto.setOrganizationIds(orgIds);
        warehouseQueryReqDto.setType("0");
        warehouseQueryReqDto.setMainWarehouse(Integer.valueOf(1));
        RestResponse pageInfoRestResp = warehouseQueryApi.queryWarehousePage(warehouseQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo warehousePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        if (!Objects.isNull(warehousePageInfo) && !CollectionUtils.isEmpty((Collection)warehousePageInfo.getList())) {
            return warehousePageInfo.getList();
        }
        throw new BizException("\u5546\u5bb6\u5bf9\u5e94\u7684\u4ea7\u54c1\u4e3b\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
    }
}

