/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponHierarchyEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.OrderMatchCouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponOrderQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.module.bitem.api.IBCategoryService;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.marketing.api.ICoupon;
import com.dtyunxi.yundt.module.marketing.api.ICouponTemplate;
import com.dtyunxi.yundt.module.marketing.api.common.CouponUseTimeTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.CouponCalculateReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.CouponItemSkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.MatchCouponReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.OrderItemReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponDetailRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ExchangeItemRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.MatchCouponRespDto;
import com.dtyunxi.yundt.module.marketing.biz.enums.CouponRangeEnum;
import com.dtyunxi.yundt.module.marketing.biz.enums.MarketingModuleExcpCode;
import com.dtyunxi.yundt.module.marketing.biz.impl.CouponTemplateImpl;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponImpl
implements ICoupon {
    private static Logger logger = LoggerFactory.getLogger(CouponTemplateImpl.class);
    @Resource
    private ICouponOrderQueryApi couponOrderQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Resource
    private ICouponExtQueryApi couponExtQueryApi;
    @Resource
    private IBCategoryService categoryService;
    @Resource
    private ICouponTemplate couponTemplate;
    @Resource
    private IBitemService itemService;

    public List<MatchCouponRespDto> matchAvailable(MatchCouponReqDto matchCouponReqDto) {
        Long memberId = this.marketingModuleHelper.getMemberIdByContext();
        List<CouponExtRespDto> userCouponList = this.queryMemberCoupons(memberId, matchCouponReqDto.getCouponRange());
        OrderMatchCouponReqDto orderMatchCouponReqDto = this.getOrderMatchCouponReqDto(memberId, matchCouponReqDto);
        logger.info("\u5339\u914d\u53ef\u7528\u4f18\u60e0\u5238\u53c2\u6570\uff1b{}", (Object)JSONObject.toJSONString((Object)orderMatchCouponReqDto));
        RestResponse restResponse = this.couponOrderQueryApi.orderMatch(orderMatchCouponReqDto);
        List usableCouponList = (List)RestResponseHelper.extractData((RestResponse)restResponse);
        List<MatchCouponRespDto> matchCouponList = this.getMatchCouponList(usableCouponList, userCouponList, matchCouponReqDto);
        return matchCouponList;
    }

    private List<MatchCouponRespDto> getMatchCouponList(List<CouponExtRespDto> usableCouponList, List<CouponExtRespDto> userCouponList, MatchCouponReqDto matchCouponReqDto) {
        boolean usable = false;
        if (CollectionUtils.isNotEmpty(usableCouponList)) {
            usable = true;
            logger.info("\u3010\u8425\u9500\u4e2d\u5fc3\u5339\u914d\u5230\u53ef\u7528\u4f18\u60e0\u5238\u6570\u91cf\uff1a{}\u3011", (Object)usableCouponList.size());
        } else {
            logger.info("\u3010\u8425\u9500\u4e2d\u5fc3\u6ca1\u6709\u5339\u914d\u5230\u4f18\u60e0\u5238\u3011");
        }
        ArrayList disableList = Lists.newArrayList();
        ArrayList enableList = Lists.newArrayList();
        for (CouponExtRespDto couponExtRespDto : userCouponList) {
            MatchCouponRespDto matchCouponRespDto = new MatchCouponRespDto();
            CubeBeanUtils.copyProperties((Object)matchCouponRespDto, (Object)couponExtRespDto, (String[])new String[0]);
            CouponTemplateExtRespDto template = couponExtRespDto.getCouponTemplate();
            if (null != template) {
                if (null != template.getExtFields()) {
                    List sharedDiscountList = (List)template.getExtFields().get("sharedDiscountList");
                    matchCouponRespDto.setSharedDiscountList(sharedDiscountList);
                }
                matchCouponRespDto.setItemRange(template.getItemRange());
                matchCouponRespDto.setCouponCategory(template.getCouponCategory());
            }
            this.setMatchCouponUseTimeDto(matchCouponRespDto, couponExtRespDto);
            int status = 0;
            if (usable) {
                for (CouponExtRespDto usableCoupon : usableCouponList) {
                    if (!usableCoupon.getId().equals(couponExtRespDto.getId())) continue;
                    List usableItemList = usableCoupon.getAvailableItems().stream().map(itemVo -> Long.valueOf(itemVo.getItemId())).collect(Collectors.toList());
                    matchCouponRespDto.setUsableItemIds(usableItemList);
                    status = 1;
                }
            }
            matchCouponRespDto.setStatus(Integer.valueOf(status));
            matchCouponRespDto.setShopId(matchCouponReqDto.getShopId());
            if (status == 1) {
                enableList.add(matchCouponRespDto);
                continue;
            }
            disableList.add(matchCouponRespDto);
        }
        if (CouponRangeEnum.PLATFORM.getKey().equals(matchCouponReqDto.getCouponRange())) {
            logger.info("\u3010\u4e0b\u5355\u53ef\u7528\u5e73\u53f0\u5238\u6570\u91cf\uff1a{}\u3011", (Object)enableList.size());
        } else if (CouponRangeEnum.SELLER.getKey().equals(matchCouponReqDto.getCouponRange())) {
            logger.info("\u3010\u4e0b\u5355\u53ef\u7528\u5546\u5bb6\u5238\u6570\u91cf\uff1a{}\u3011", (Object)enableList.size());
        }
        enableList.addAll(disableList);
        return enableList;
    }

    private OrderMatchCouponReqDto getOrderMatchCouponReqDto(Long memberId, MatchCouponReqDto matchCouponReqDto) {
        OrderMatchCouponReqDto orderMatchCouponReqDto = new OrderMatchCouponReqDto();
        orderMatchCouponReqDto.setHierarchy(CouponHierarchyEnum.GENERAL.getHierarchy());
        orderMatchCouponReqDto.setOrderDate(new Date());
        orderMatchCouponReqDto.setMemberId(memberId);
        orderMatchCouponReqDto.setOrderAmount(matchCouponReqDto.getTotalAmount());
        ArrayList itemVos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)matchCouponReqDto.getItemList())) {
            for (OrderItemReqDto item : matchCouponReqDto.getItemList()) {
                ItemDetailRespDto itemDetail = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(item.getItemId(), "sku,attributes", null).getData();
                ItemRespDto itemRespDto = itemDetail.getItem();
                ItemVo itemVo = new ItemVo();
                itemVo.setItemId(item.getItemId().toString());
                itemVo.setShopId(item.getShopId().toString());
                if (null != itemRespDto.getBrandId()) {
                    itemVo.setItemBrands((List)Lists.newArrayList((Object[])new Long[]{itemRespDto.getBrandId()}));
                }
                itemVo.setItemCategory(this.getFrontDirIdList(itemDetail));
                itemVo.setNum(item.getItemNum().intValue());
                itemVo.setPrice(item.getSellPrice());
                itemVos.add(itemVo);
            }
        }
        orderMatchCouponReqDto.setItemVos((List)itemVos);
        return orderMatchCouponReqDto;
    }

    private List<Long> getFrontDirIdList(ItemDetailRespDto itemDetailRespDto) {
        List dirList = null;
        if (CollectionUtils.isNotEmpty((Collection)itemDetailRespDto.getItemAttributesList())) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)((ItemAttributesRespDto)itemDetailRespDto.getItemAttributesList().get(0)).getAttrs());
                dirList = JSON.parseArray((String)jsonObject.getString("frontDirList"), Long.class);
            }
            catch (Exception e) {
                logger.error("\u524d\u53f0\u7c7b\u76ee\u89e3\u6790\u9519\u8bef", (Throwable)e);
            }
        }
        ArrayList allDirList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(dirList)) {
            for (Long dirId : dirList) {
                List parentIdList = this.categoryService.getDirListParent(dirId);
                if (!CollectionUtils.isNotEmpty((Collection)parentIdList)) continue;
                allDirList.addAll(parentIdList);
            }
        }
        return allDirList;
    }

    public List<CouponExtRespDto> queryMemberCoupons(Long memberId, Integer couponRange) {
        return this.queryMemberCoupons(memberId, couponRange, null);
    }

    public List<CouponExtRespDto> queryMemberCoupons(Long memberId, Integer couponRange, List<Integer> couponCategoryList) {
        List<Object> couponList = Lists.newArrayList();
        String currentStr = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date());
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)memberId));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_status", (Object)CouponStatusEnum.CREATE.getStatus()));
        sqlFilterList.add(SqlFilter.le((String)"effective_time", (Object)currentStr));
        sqlFilterList.add(SqlFilter.gt((String)"invalid_time", (Object)currentStr));
        Criteria criteria = new Criteria();
        criteria.setFilters((List)sqlFilterList);
        String filter = ObjectHelper.bean2Json((Object)criteria);
        PageInfo pageInfo = (PageInfo)this.couponExtQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(100)).getData();
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return couponList;
        }
        couponList.addAll(pageInfo.getList());
        for (int i = 2; i <= pageInfo.getPages(); ++i) {
            PageInfo indexPageInfo = (PageInfo)this.couponExtQueryApi.queryByPage(filter, Integer.valueOf(i), Integer.valueOf(100)).getData();
            if (!CollectionUtils.isNotEmpty((Collection)indexPageInfo.getList())) continue;
            couponList.addAll(indexPageInfo.getList());
        }
        if (null != couponRange) {
            couponList = couponList.stream().filter(couponExtRespDto -> couponRange.equals(couponExtRespDto.getCouponRange())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(couponCategoryList)) {
            couponList = couponList.stream().filter(couponExtRespDto -> null != couponExtRespDto.getCouponTemplate() && couponCategoryList.contains(couponExtRespDto.getCouponTemplate().getCouponCategory())).collect(Collectors.toList());
        }
        return couponList;
    }

    public BigDecimal calculate(List<CouponCalculateReqDto> couponInfoList) {
        if (CollectionUtils.isEmpty(couponInfoList)) {
            return BigDecimal.ZERO;
        }
        LinkedHashMap<Long, CouponExtRespDto> couponMap = this.sortConpon(couponInfoList);
        Map<Long, CouponCalculateReqDto> couponInfoMap = couponInfoList.stream().collect(Collectors.toMap(couponCalculateReqDto -> couponCalculateReqDto.getCouponId(), e -> e, (c1, c2) -> c2));
        BigDecimal discountTotalAmount = BigDecimal.ZERO;
        ArrayList disccountedItems = Lists.newArrayList();
        for (Long couponId : couponMap.keySet()) {
            CouponExtRespDto coupon = couponMap.get(couponId);
            List orderItemReqDtos = couponInfoMap.get(couponId).getItemList();
            List<ItemVo> itemVos = orderItemReqDtos.stream().map(orderItemReqDto -> {
                ItemVo itemVo = new ItemVo();
                itemVo.setItemId(orderItemReqDto.getItemId().toString());
                itemVo.setSkuId(orderItemReqDto.getSkuId().toString());
                itemVo.setShopId(orderItemReqDto.getShopId().toString());
                itemVo.setPrice(orderItemReqDto.getSellPrice());
                itemVo.setNum(orderItemReqDto.getItemNum().intValue());
                return itemVo;
            }).collect(Collectors.toList());
            itemVos.forEach(itemVo -> disccountedItems.forEach(disaccountedItemVo -> {
                if (itemVo.getSkuId().equals(disaccountedItemVo.getSkuId()) && itemVo.getShopId().equals(disaccountedItemVo.getShopId())) {
                    itemVo.setPrice(disaccountedItemVo.getDiscountPrice());
                    itemVo.setExtendsAttribute(disaccountedItemVo.getExtendsAttribute());
                }
            }));
            CouponTemplateExtRespDto couponTemplate = coupon.getCouponTemplate();
            if (null == couponTemplate) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_INFO_INVALID);
            }
            BigDecimal discountAmount = this.calculateItemDiscountPrice(itemVos, couponTemplate);
            discountTotalAmount = discountTotalAmount.add(discountAmount);
            disccountedItems.addAll(itemVos);
        }
        return discountTotalAmount.setScale(2, 1);
    }

    private BigDecimal calculateItemDiscountPrice(List<ItemVo> itemVoList, CouponTemplateExtRespDto couponTemplate) {
        Map<String, ItemVo> itemVoMap = itemVoList.stream().collect(Collectors.toMap(ItemVo::getSkuId, e -> e, (itemFirst, itemNext) -> itemFirst));
        HashMap skuTotalAmountMap = Maps.newHashMap();
        BigDecimal itemTotalAmount = BigDecimal.ZERO;
        for (ItemVo itemVo : itemVoList) {
            BigDecimal skuTotalAmount = itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum()));
            skuTotalAmountMap.put(itemVo.getSkuId(), skuTotalAmount);
            itemTotalAmount = itemTotalAmount.add(skuTotalAmount);
        }
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        BigDecimal couponAmount = BigDecimal.ZERO;
        ItemVo marginItemVo = null;
        for (Map.Entry entry : skuTotalAmountMap.entrySet()) {
            String skuId = (String)entry.getKey();
            ItemVo itemVo = itemVoMap.get(skuId);
            BigDecimal skuTotalAmount = (BigDecimal)entry.getValue();
            BigDecimal shareAmount = BigDecimal.ZERO;
            BigDecimal actualAmount = BigDecimal.ZERO;
            if (CouponCategoryEnum.QUOTA_CASH.getCategory().equals(couponTemplate.getCouponCategory())) {
                BigDecimal skuAoumtRate = skuTotalAmount.divide(itemTotalAmount, 4, 1);
                shareAmount = skuAoumtRate.multiply(couponTemplate.getCouponValue()).setScale(2, 1);
                couponAmount = couponTemplate.getCouponValue();
            } else if (CouponCategoryEnum.DISCOUNT.getCategory().equals(couponTemplate.getCouponCategory())) {
                BigDecimal discountRate = BigDecimal.ONE.subtract(couponTemplate.getCouponValue().divide(BigDecimal.TEN, 4, 1));
                shareAmount = skuTotalAmount.multiply(discountRate).setScale(2, 1);
                couponAmount = couponAmount.add(shareAmount);
            } else {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u4f18\u60e0\u7c7b\u578b\uff01");
            }
            BigDecimal eachShareAmount = shareAmount.divide(BigDecimal.valueOf(itemVo.getNum()), 2, 1);
            BigDecimal discountPrice = itemVo.getPrice().subtract(eachShareAmount);
            if (BigDecimal.ZERO.compareTo(discountPrice) == 1) {
                discountPrice = BigDecimal.ZERO;
                eachShareAmount = itemVo.getPrice();
            } else {
                marginItemVo = itemVo;
            }
            itemVo.setDiscountPrice(discountPrice);
            logger.info("skuId\uff1a{}\uff0c\u4f18\u60e0\u540e\u4ef7\u683c:{}\uff0c \u6bcf\u4ef6\u4f18\u60e0\u91d1\u989d:{}", new Object[]{itemVo.getSkuId(), itemVo.getDiscountPrice(), eachShareAmount});
            actualAmount = eachShareAmount.multiply(BigDecimal.valueOf(itemVo.getNum()));
            marginItemVo = itemVo;
            totalDiscountAmount = totalDiscountAmount.add(actualAmount);
        }
        if (couponAmount.compareTo(totalDiscountAmount) == 1) {
            BigDecimal marginAmount = couponAmount.subtract(totalDiscountAmount);
            logger.info("\u4f18\u60e0\u5dee\u989d={}\uff0c\u8ffd\u52a0\u5230sku={}", (Object)marginAmount, (Object)marginItemVo.getSkuId());
            totalDiscountAmount = totalDiscountAmount.add(marginAmount);
        }
        logger.info("\u4f18\u60e0\u5238\u540d\u79f0\uff1a{}\uff0c\u4f18\u60e0\u91d1\u989d:{}", (Object)couponTemplate.getCouponName(), (Object)totalDiscountAmount);
        return totalDiscountAmount;
    }

    private LinkedHashMap<Long, CouponExtRespDto> sortConpon(List<CouponCalculateReqDto> couponInfoList) {
        LinkedHashMap<Long, CouponExtRespDto> couponMap = new LinkedHashMap<Long, CouponExtRespDto>();
        CouponExtRespDto platformCoupon = null;
        for (CouponCalculateReqDto couponCalculateReqDto : couponInfoList) {
            RestResponse restResponse = this.couponExtQueryApi.queryByIds((List)Lists.newArrayList((Object[])new Long[]{couponCalculateReqDto.getCouponId()}));
            CouponExtRespDto coupon = (CouponExtRespDto)((List)restResponse.getData()).get(0);
            if (null == coupon || null == coupon.getCouponTemplate()) {
                throw new BizException("\u4f18\u60e0\u5238\u4fe1\u606f\u9519\u8bef");
            }
            if (CouponRangeEnum.PLATFORM.getKey().equals(coupon.getCouponTemplate().getCouponRange())) {
                platformCoupon = coupon;
                continue;
            }
            if (!CouponRangeEnum.SELLER.getKey().equals(coupon.getCouponTemplate().getCouponRange())) continue;
            couponMap.put(couponCalculateReqDto.getCouponId(), coupon);
        }
        if (null != platformCoupon) {
            couponMap.put(platformCoupon.getId(), platformCoupon);
        }
        return couponMap;
    }

    private BigDecimal getExtendsAttribute(String key, ItemVo itemVo) {
        Map extendMap = itemVo.getExtendsAttribute();
        BigDecimal amount = (BigDecimal)extendMap.get(key);
        return amount == null ? BigDecimal.ZERO : amount;
    }

    private void setExtendsAttribute(String key, ItemVo itemVo, BigDecimal amount) {
        Map extendMap = itemVo.getExtendsAttribute();
        if (null == extendMap) {
            extendMap = Maps.newHashMap();
        }
        extendMap.put(key, amount);
    }

    public CouponDetailRespDto getById(Long id) {
        CouponExtRespDto couponExtRespDto = (CouponExtRespDto)this.couponExtQueryApi.queryById(id).getData();
        if (null == couponExtRespDto) {
            return null;
        }
        CouponDetailRespDto couponDetailRespDto = new CouponDetailRespDto();
        CubeBeanUtils.copyProperties((Object)couponDetailRespDto, (Object)couponExtRespDto, (String[])new String[0]);
        couponDetailRespDto.setCouponUseBeginTime(couponExtRespDto.getEffectiveTime());
        couponDetailRespDto.setCouponUseEndTime(couponExtRespDto.getInvalidTime());
        if (Objects.nonNull(couponExtRespDto.getCouponTemplate())) {
            couponDetailRespDto.setCouponCategory(couponExtRespDto.getCouponTemplate().getCouponCategory());
            couponDetailRespDto.setRemark(couponExtRespDto.getCouponTemplate().getRemark());
            couponDetailRespDto.setItemRange(couponExtRespDto.getCouponTemplate().getItemRange());
            couponDetailRespDto.setCouponRange(couponExtRespDto.getCouponTemplate().getCouponRange());
        }
        this.setCouponUseTimeDto((CouponRespDto)couponDetailRespDto, couponExtRespDto);
        return couponDetailRespDto;
    }

    private void setMatchCouponUseTimeDto(MatchCouponRespDto couponRespDto, CouponExtRespDto couponExtRespDto) {
        if (couponRespDto == null) {
            return;
        }
        if (couponExtRespDto == null) {
            return;
        }
        CouponUseTimeTobDto couponUseTimeTobDto = new CouponUseTimeTobDto();
        JSONObject value = new JSONObject();
        value.put("couponUseBeginTime", (Object)couponExtRespDto.getEffectiveTime());
        value.put("couponUseEndTime", (Object)couponExtRespDto.getInvalidTime());
        couponUseTimeTobDto.setValue((Object)value);
        if (couponExtRespDto.getValidityType() == CouponValidityTypeEnum.FOREVER_DATE.getType()) {
            couponUseTimeTobDto.setType(Integer.valueOf(3));
        } else {
            couponUseTimeTobDto.setType(Integer.valueOf(0));
        }
        couponRespDto.setCouponUseTimeDto(couponUseTimeTobDto);
    }

    private void setCouponUseTimeDto(CouponRespDto couponRespDto, CouponExtRespDto couponExtRespDto) {
        if (couponRespDto == null) {
            return;
        }
        if (couponExtRespDto == null) {
            return;
        }
        CouponUseTimeTobDto couponUseTimeTobDto = new CouponUseTimeTobDto();
        JSONObject value = new JSONObject();
        value.put("couponUseBeginTime", (Object)couponExtRespDto.getEffectiveTime());
        value.put("couponUseEndTime", (Object)couponExtRespDto.getInvalidTime());
        couponUseTimeTobDto.setValue((Object)value);
        if (couponExtRespDto.getValidityType() == CouponValidityTypeEnum.FOREVER_DATE.getType()) {
            couponUseTimeTobDto.setType(Integer.valueOf(3));
        } else {
            couponUseTimeTobDto.setType(Integer.valueOf(0));
        }
        couponRespDto.setCouponUseTimeDto(couponUseTimeTobDto);
    }

    private ExchangeItemRespDto convert(CouponItemSkuDto couponItemSkuDto) {
        ExchangeItemRespDto itemRespDto = new ExchangeItemRespDto();
        CubeBeanUtils.copyProperties((Object)itemRespDto, (Object)couponItemSkuDto, (String[])new String[0]);
        ItemDetailRespDto itemDetail = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(couponItemSkuDto.getItemId(), "attributes,sku,medias", null).getData();
        if (null == itemDetail) {
            return itemRespDto;
        }
        String path = ((ItemMediasRespDto)itemDetail.getItemMediasList().get(0)).getPath1();
        ItemSkuRespDto sku = itemDetail.getItemSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(couponItemSkuDto.getSkuId())).findAny().orElseGet(() -> null);
        itemRespDto.setImgPath(path);
        if (null != sku) {
            Map attrs = (Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class);
            itemRespDto.setAttrs(attrs);
        }
        itemRespDto.setItemName(itemDetail.getItem().getName());
        BigDecimal price = this.itemService.queryItemPrice(couponItemSkuDto.getShopId(), couponItemSkuDto.getItemId(), couponItemSkuDto.getSkuId());
        itemRespDto.setSellPrice(price);
        return itemRespDto;
    }
}

