/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.constant.UserConstant;
import com.dtyunxi.yundt.module.marketing.biz.constant.MarketingConstant;
import com.dtyunxi.yundt.module.marketing.biz.enums.MarketingModuleExcpCode;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MarketingModuleHelper {
    private static Logger logger = LoggerFactory.getLogger(MarketingModuleHelper.class);
    @Autowired
    private IContext context;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Autowired
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    private static final String ACTIVITY_CODE_NO = "ACTIVITY_CODE_NO";

    public Long getMemberIdByContext() {
        String key = "user_memberId" + this.context.userId();
        Long memberId = (Long)this.cacheService.getCache(key, Long.class);
        if (null == memberId) {
            MemberInfoDetailRespDto memberInfoDetailDto = (MemberInfoDetailRespDto)RestResponseHelper.extractData((RestResponse)this.memberInfoExtQueryApi.queryMemberInfoDetailByUserId(this.context.userId()));
            if (memberInfoDetailDto == null) {
                throw new BizException("\u4f1a\u5458\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            memberId = memberInfoDetailDto.getId();
            this.cacheService.add(key, (Object)memberId, 604800);
        }
        return memberId;
    }

    public Long getCustomerIdByContext() {
        String key = "user_customerId" + this.context.userId();
        Long customerId = (Long)this.cacheService.getCache(key, Long.class);
        if (null == customerId) {
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setUserIds((List)Lists.newArrayList((Object[])new Long[]{this.context.userId()}));
            searchReqDto.setTenantId(this.context.tenantId());
            RestResponse listRestResp = this.customerQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                throw new BizException("\u5ba2\u6237\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            customerId = ((CustomerRespDto)customerRespDtos.get(0)).getId();
            this.cacheService.add(key, (Object)customerId, 604800);
        }
        return customerId;
    }

    public Long getOrgIdByContext() {
        RestResponse longRestResp = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        return (Long)RestResponseHelper.extractData((RestResponse)longRestResp);
    }

    public Long getMemberIdByUserId(Long userId) {
        MemberInfoDetailRespDto memberInfoDetailDto = (MemberInfoDetailRespDto)RestResponseHelper.extractData((RestResponse)this.memberInfoExtQueryApi.queryMemberInfoDetailByUserId(userId));
        logger.info("getMemberIdByContext \u4f1a\u5458\u8fd4\u56de\u7ed3\u679c ={}", JSON.toJSON((Object)memberInfoDetailDto));
        if (memberInfoDetailDto == null) {
            throw new BizException("\u4f1a\u5458\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return memberInfoDetailDto.getId();
    }

    public Long getSellerId() {
        SellerQueryReqDto reqExam = new SellerQueryReqDto();
        SellerRespDto result = null;
        Integer roleType = this.getRoleType();
        Long userId = this.context.userId();
        if (UserConstant.OPERATOR.equals(roleType)) {
            reqExam.setGroupId(MarketingConstant.SELF_MERCHANT_FLAG);
        } else if (UserConstant.MERCHANT.equals(roleType)) {
            reqExam.setOwnerId(userId);
        }
        reqExam.setInstanceId(this.context.instanceId());
        RestResponse restResponse = this.sellerQueryApi.queryList(reqExam);
        logger.debug("\u67e5\u8be2\u7ed3\u679c\u4e3a\uff0c{}", (Object)JSON.toJSONString((Object)restResponse));
        List list = (List)restResponse.getData();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            result = (SellerRespDto)list.get(0);
        } else {
            UserDto userDto = (UserDto)this.userQueryApi.queryById(userId, null).getData();
            if (userDto != null && StringUtils.isNotBlank((String)userDto.getExtension())) {
                result = (SellerRespDto)this.sellerQueryApi.queryById(Long.valueOf(userDto.getExtension())).getData();
            }
        }
        if (result == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.SELLER_NOT_EXIST);
        }
        logger.info("\u5f53\u524d\u7528\u6237sellerId:{}", (Object)result.getId());
        return result.getId();
    }

    public Integer getRoleType() {
        Integer roleType = UserConstant.CONSUME;
        String[] res = new String[]{"role"};
        Long userId = this.context.userId();
        UserVo userVo = (UserVo)this.userQueryApi.queryByIdAndResource(userId, res, "{}").getData();
        if (null == userVo || CollectionUtils.isEmpty((Collection)userVo.getRoleSet())) {
            return roleType;
        }
        for (RoleDto roleDto : userVo.getRoleSet()) {
            if ("platMgmt".equals(roleDto.getCode()) || "platMgmtChild".equals(roleDto.getCode())) {
                roleType = UserConstant.OPERATOR;
                break;
            }
            if (!"merchant".equals(roleDto.getCode()) && !"merchantChild".equals(roleDto.getCode())) continue;
            roleType = UserConstant.MERCHANT;
            break;
        }
        logger.info("\u5f53\u524d\u7528\u6237roleType:{}", (Object)roleType);
        return roleType;
    }

    public String generateCode(String prefix) {
        StringBuilder code = new StringBuilder();
        String timeStr = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        code.append(prefix).append(timeStr);
        Long activityCodeNo = this.cacheService.incr(ACTIVITY_CODE_NO);
        Long model = activityCodeNo % 999L;
        if (model < 10L) {
            code.append("00").append(model);
        } else if (model < 100L) {
            code.append("0").append(model);
        } else {
            code.append(model);
        }
        int romNum = RandomUtils.nextInt((int)1, (int)999);
        if (romNum < 10) {
            code.append("00").append(romNum);
        } else if (romNum < 100) {
            code.append("0").append(romNum);
        } else {
            code.append(romNum);
        }
        return code.toString();
    }
}

