/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.timediscount;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.timediscount.model.TimeDisActItem;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.BlackItemSkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ApplicableActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivitySkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.timediscount.TimeDiscountActivityDto;
import com.dtyunxi.yundt.module.marketing.api.enums.SelectTypeEnum;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeDiscountItemsCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(TimeDiscountItemsCondition.class);

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880281L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.TIME_DISCOUNT_ACTIVITY.equals((Object)type) || ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        TimeDiscountActivityDto timeDiscountActivityDto = (TimeDiscountActivityDto)t;
        ConditionReqDto condition = this.getConditionReqDto();
        HashMap conditionParam = Maps.newHashMap();
        ArrayList timeDisActItems = Lists.newArrayList();
        if (SelectTypeEnum.ALL.getCode().equals(timeDiscountActivityDto.getSelectType()) || SelectTypeEnum.CATEGORY.getCode().equals(timeDiscountActivityDto.getSelectType())) {
            if (CollectionUtils.isNotEmpty((Collection)timeDiscountActivityDto.getActivityItems())) {
                timeDiscountActivityDto.getActivityItems().forEach(itemDto -> {
                    TimeDisActItem timeDisActItem = new TimeDisActItem();
                    timeDisActItem.setItemId(itemDto.getItemId());
                    timeDisActItem.setSkuId(itemDto.getSkuId());
                    timeDisActItem.setShopId(itemDto.getShopId());
                    timeDisActItem.setPromotionMethod(timeDiscountActivityDto.getPromotionMethod());
                    timeDisActItem.setPrice(itemDto.getSellPrice());
                    timeDisActItem.setDiscount(itemDto.getDiscount());
                    timeDisActItem.setActivityPrice(itemDto.getActivityPrice());
                    timeDisActItems.add(timeDisActItem);
                });
            }
        } else if (CollectionUtils.isNotEmpty((Collection)timeDiscountActivityDto.getActivityItems())) {
            timeDiscountActivityDto.getActivityItems().forEach(itemDto -> itemDto.getSkus().forEach(skuDto -> {
                TimeDisActItem timeDisActItem = new TimeDisActItem();
                timeDisActItem.setItemId(skuDto.getItemId());
                timeDisActItem.setSkuId(skuDto.getSkuId());
                timeDisActItem.setPrice(skuDto.getRetailPrice());
                timeDisActItem.setSkuName(skuDto.getSkuName());
                timeDisActItem.setItemCode(itemDto.getItemCode());
                timeDisActItem.setPromotionMethod(timeDiscountActivityDto.getPromotionMethod());
                timeDisActItem.setShopId(itemDto.getShopId());
                if (2 == timeDiscountActivityDto.getPromotionMethod()) {
                    timeDisActItem.setDiscount(skuDto.getDiscount());
                    if (null != skuDto.getRetailPrice()) {
                        timeDisActItem.setActivityPrice(skuDto.getRetailPrice().multiply(skuDto.getDiscount()).divide(new BigDecimal(10)));
                    }
                } else {
                    timeDisActItem.setActivityPrice(skuDto.getPromotionPrice());
                }
                timeDisActItems.add(timeDisActItem);
            }));
        }
        if (CollectionUtils.isNotEmpty((Collection)timeDiscountActivityDto.getBlackItems())) {
            List blackItems = timeDiscountActivityDto.getBlackItems().stream().map(itemDto -> {
                ItemSkuDto itemSkuDto = new ItemSkuDto();
                itemSkuDto.setItemId(itemDto.getItemId());
                itemSkuDto.setShopId(itemDto.getShopId());
                itemSkuDto.setSkuId(itemDto.getSkuId());
                return itemSkuDto;
            }).collect(Collectors.toList());
            conditionParam.put("ItemTimeLimitCondition.blackItems", blackItems);
        }
        conditionParam.put("ItemTimeLimitCondition.items", timeDisActItems);
        conditionParam.put("ItemTimeLimitCondition.type", timeDiscountActivityDto.getSelectType());
        conditionParam.put("ItemTimeLimitCondition.brandIds", timeDiscountActivityDto.getBrandIds());
        conditionParam.put("ItemTimeLimitCondition.dirIds", timeDiscountActivityDto.getDirIds());
        conditionParam.put("ItemTimeLimitCondition.promotionMethod", timeDiscountActivityDto.getPromotionMethod());
        conditionParam.put("ItemTimeLimitCondition.promotionValue", timeDiscountActivityDto.getPromotionValue());
        logger.info("\u9650\u65f6\u6298\u6263\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        TimeDiscountActivityDto timeDiscountActivityDto = (TimeDiscountActivityDto)t;
        IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
        IActivityItemQueryApi activityItemQueryApi = (IActivityItemQueryApi)SpringBeanUtil.getBean(IActivityItemQueryApi.class);
        IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        Integer selectType = jsonObject.getInteger("ItemTimeLimitCondition.type");
        Integer promotionMethod = jsonObject.getInteger("ItemTimeLimitCondition.promotionMethod");
        List conditionItems = JSONArray.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.items"), TimeDisActItem.class);
        if (SelectTypeEnum.ALL.getCode().equals(selectType) || SelectTypeEnum.CATEGORY.getCode().equals(selectType)) {
            List brandIds = JSON.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.brandIds"), Long.class);
            List dirIds = JSON.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.dirIds"), Long.class);
            List blackItems = JSON.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.blackItems"), ItemSkuDto.class);
            ArrayList<BlackItemSkuDto> blackActivityItems = new ArrayList<BlackItemSkuDto>();
            if (CollectionUtils.isNotEmpty((Collection)blackItems)) {
                for (ItemSkuDto blackItem : blackItems) {
                    ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(blackItem.getShopId(), blackItem.getItemId(), ItemBusTypeEnum.ORDINARY.getType());
                    BlackItemSkuDto blackItemSkuDto = new BlackItemSkuDto();
                    blackItemSkuDto.setItemId(blackItem.getItemId());
                    blackItemSkuDto.setItemCode(itemDetail.getItemCode());
                    blackItemSkuDto.setItemName(itemDetail.getItemName());
                    blackItemSkuDto.setShopId(blackItem.getShopId());
                    blackItemSkuDto.setSkuId(blackItem.getSkuId());
                    itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(blackItem.getSkuId())).findFirst().ifPresent(itemSku -> {
                        if (null != itemSku.getAttrMap()) {
                            String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                            blackItemSkuDto.setSkuDesc(skuName);
                            blackItemSkuDto.setAttr(skuName);
                        }
                    });
                    blackActivityItems.add(blackItemSkuDto);
                }
            }
            BigDecimal promotionValue = jsonObject.getBigDecimal("ItemTimeLimitCondition.promotionValue");
            timeDiscountActivityDto.setPromotionValue(promotionValue);
            timeDiscountActivityDto.setBrandIds(brandIds);
            timeDiscountActivityDto.setDirIds(dirIds);
            timeDiscountActivityDto.setBlackItems(blackActivityItems);
            return;
        }
        ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
        activityItemQueryReqDto.setActivityId(timeDiscountActivityDto.getId());
        List items = (List)activityItemQueryApi.queryAll(activityItemQueryReqDto).getData();
        Map<Long, List<ActivityItemRespDto>> group = items.stream().collect(Collectors.groupingBy(activitItem -> activitItem.getShopId() + activitItem.getItemId() + activitItem.getSkuId()));
        ArrayList activityItems = Lists.newArrayList();
        for (List<ActivityItemRespDto> itemDtos : group.values()) {
            Long itemId = itemDtos.get(0).getItemId();
            Long shopId = itemDtos.get(0).getShopId();
            ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(shopId, itemId, ItemBusTypeEnum.ORDINARY.getType());
            ApplicableActivityItemDto activityItemDto = new ApplicableActivityItemDto();
            activityItemDto.setItemId(itemId);
            activityItemDto.setSubType(itemDetail.getSubType());
            activityItemDto.setItemCode(itemDetail.getItemCode());
            activityItemDto.setItemName(itemDetail.getItemName());
            activityItemDto.setShopId(shopId);
            activityItemDto.setSkuId(itemDtos.get(0).getSkuId());
            if (null != shopId) {
                ShopBaseDto shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(shopId).getData();
                activityItemDto.setShopName(shopDto == null ? null : shopDto.getName());
            }
            activityItems.add(activityItemDto);
            Long totalStock = 0L;
            ArrayList activitySkuDtos = Lists.newArrayList();
            for (ActivityItemRespDto skuDto : itemDtos) {
                TimeDisActItem timeDisActItem = this.getTimeDisActItem(skuDto.getSkuId(), conditionItems);
                PromotionActivitySkuDto activitySkuDto = new PromotionActivitySkuDto();
                activitySkuDto.setSkuId(skuDto.getSkuId());
                activityItemDto.setActivityStock(skuDto.getOriginalStock());
                activityItemDto.setRemainingStock(skuDto.getActivityStock());
                activitySkuDto.setDiscount(timeDisActItem.getDiscount());
                activitySkuDto.setItemId(skuDto.getItemId());
                if (1 == promotionMethod) {
                    activitySkuDto.setPromotionPrice(skuDto.getActivityPrice());
                }
                itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(skuDto.getSkuId())).findFirst().ifPresent(itemSku -> {
                    if (null != itemSku.getAttrMap()) {
                        String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                        activitySkuDto.setSkuName(skuName);
                        activityItemDto.setSkuDesc(skuName);
                        activityItemDto.setAttr(skuName);
                    }
                });
                activitySkuDto.setRetailPrice(itemService.queryItemPrice(shopId, skuDto.getItemId(), skuDto.getSkuId()));
                Long stock = itemService.queryVirStorage(shopId, itemId, skuDto.getSkuId());
                activitySkuDto.setStock(stock);
                totalStock = totalStock + stock;
                activitySkuDtos.add(activitySkuDto);
            }
            activityItemDto.setSkus((List)activitySkuDtos);
            activityItemDto.setTotalStock(totalStock);
        }
        timeDiscountActivityDto.setPromotionMethod(promotionMethod);
        timeDiscountActivityDto.setActivityItems((List)activityItems);
    }

    private TimeDisActItem getTimeDisActItem(Long skuId, List<TimeDisActItem> conditionItems) {
        return conditionItems.stream().filter(timeDisActItem -> timeDisActItem.getSkuId().equals(skuId)).findFirst().orElseGet(() -> new TimeDisActItem());
    }
}

