/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl.serializa;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.module.marketing.api.IDeserializationDynamicDate;
import com.dtyunxi.yundt.module.marketing.api.ISerializeCouPonUseTimeValue;
import com.dtyunxi.yundt.module.marketing.api.common.CouponTemplateTobDto;
import com.dtyunxi.yundt.module.marketing.api.common.CouponUseTimeTobDto;
import com.dtyunxi.yundt.module.marketing.api.common.DynamicDate;
import com.dtyunxi.yundt.module.marketing.biz.impl.serializa.DeserializationDays;
import com.dtyunxi.yundt.module.marketing.biz.impl.serializa.DeserializationFixDate;
import com.dtyunxi.yundt.module.marketing.biz.impl.serializa.DeserializationForever;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SerializeCouPonUseTimeValueDistribute
implements ApplicationListener<ApplicationStartedEvent> {
    private static Map<Integer, ISerializeCouPonUseTimeValue> SERIALIZE_MAP = new HashMap<Integer, ISerializeCouPonUseTimeValue>();
    private static Map<Integer, IDeserializationDynamicDate> DESERIALIZATION_MAP = new HashMap<Integer, IDeserializationDynamicDate>();
    private static DeserializationFixDate deserializationFixDate = new DeserializationFixDate();
    private static DeserializationForever deserializationForever = new DeserializationForever();
    private static DeserializationDays deserializationDays = new DeserializationDays();

    public static void serialize(CouponTemplateTobDto couponTemplateTobDto) {
        CouponUseTimeTobDto couponUseTimeTobDto = couponTemplateTobDto.getCouponUseTimeReqDto();
        SERIALIZE_MAP.get(couponUseTimeTobDto.getType()).serialize(couponTemplateTobDto);
    }

    public static void deserialization(CouponTemplateTobDto couponTemplateTobDto) {
        if (couponTemplateTobDto.getValidityType() == CouponValidityTypeEnum.FIXED_DATE.getType()) {
            deserializationFixDate.deserialization(couponTemplateTobDto, null);
        } else if (couponTemplateTobDto.getValidityType() == CouponValidityTypeEnum.DYNAMIC_DATE.getType()) {
            DynamicDate dynamicDate = (DynamicDate)JSONObject.parseObject((String)couponTemplateTobDto.getDynamicDate(), DynamicDate.class);
            if (dynamicDate.getForever() != null && dynamicDate.getForever() == 1) {
                deserializationForever.deserialization(couponTemplateTobDto, dynamicDate);
            } else {
                deserializationDays.deserialization(couponTemplateTobDto, dynamicDate);
            }
        }
    }

    public void onApplicationEvent(ApplicationStartedEvent applicationStartedEvent) {
        ConfigurableApplicationContext context = applicationStartedEvent.getApplicationContext();
        Map map = context.getBeansOfType(ISerializeCouPonUseTimeValue.class);
        map.keySet().stream().forEach(k -> {
            ISerializeCouPonUseTimeValue impl = (ISerializeCouPonUseTimeValue)map.get(k);
            SERIALIZE_MAP.put(impl.getType(), impl);
        });
        Map smap = context.getBeansOfType(IDeserializationDynamicDate.class);
        smap.keySet().stream().forEach(k -> {
            IDeserializationDynamicDate impl = (IDeserializationDynamicDate)smap.get(k);
            DESERIALIZATION_MAP.put(impl.getSupportAfterDay(), impl);
        });
    }
}

