/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupReqDto;
import com.dtyunxi.yundt.module.context.api.IAppContext;
import com.dtyunxi.yundt.module.context.bo.Token;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.IGroupActivity;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityGroupDetailQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.GroupActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ActivityGroupListRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ActivityTermDetailRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.GroupActivityQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8425\u9500\u7ec4\u4ef6\uff1a\u62fc\u56e2\u6d3b\u52a8\u670d\u52a1"})
@Validated
@RestController
@RequestMapping(value={"/v1/marketing/group"})
public class GroupActivityRest {
    private static Logger logger = LoggerFactory.getLogger(GroupActivityRest.class);
    @Resource
    private IGroupActivity groupActivity;
    @Resource
    private IActivityService activityService;
    @Resource
    private IAppContext context;

    @ApiOperation(value="\u65b0\u589e\u62fc\u56e2\u6d3b\u52a8")
    @ApiImplicitParam(name="groupActivityDto", paramType="body", dataType="GroupActivityReqDto", required=true, value="\u62fc\u56e2\u6d3b\u52a8\u4fe1\u606f")
    @PostMapping(value={"/activity"})
    RestResponse<Long> add(@Valid @RequestBody GroupActivityDto groupActivityDto) {
        return new RestResponse((Object)this.groupActivity.add(groupActivityDto));
    }

    @ApiOperation(value="\u62fc\u56e2\u6d3b\u52a8\u8be6\u60c5")
    @GetMapping(value={"/activity/{id}"})
    RestResponse<GroupActivityDto> getDetail(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.groupActivity.getDetail(id));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u62fc\u56e2\u6d3b\u52a8\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", dataType="Int", paramType="query"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query")})
    @GetMapping(value={"/activity/list"})
    RestResponse<PageInfo<GroupActivityQueryRespDto>> queryByPage(ActivityQueryReqDto activityQueryReqDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        return new RestResponse((Object)this.groupActivity.queryByPage(activityQueryReqDto, pageNum, pageSize));
    }

    @ApiOperation(value="\u7ed3\u675f\u6d3b\u52a8", notes="\u624b\u52a8\u7ed3\u675f\u6d3b\u52a8\uff0c\u64cd\u4f5c\u4e0d\u53ef\u9006")
    @PutMapping(value={"/activity/{id}/closure"})
    RestResponse<Void> closure(@PathVariable(value="id") Long id) {
        this.activityService.finish(id);
        return new RestResponse();
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u62fc\u56e2\u961f\u4f0d\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", dataType="Int", paramType="query"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query")})
    @GetMapping(value={"/activity-group/list"})
    RestResponse<PageInfo<ActivityGroupListRespDto>> queryActivityGroupByPage(ActivityGroupReqDto activityGroupReqDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        return new RestResponse((Object)this.groupActivity.queryActivityGroupByPage(activityGroupReqDto, pageNum, pageSize));
    }

    @ApiOperation(value="\u67e5\u8be2\u62fc\u56e2\u961f\u4f0d\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", dataType="Int", paramType="query"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query")})
    @GetMapping(value={"/{groupId}/group-detail/list"})
    RestResponse<ActivityTermDetailRespDto> queryGroupDetailByPage(@RequestHeader(value="Access-Token", required=false) String accessToken, @PathVariable(value="groupId") Long groupId, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        Long userId = null;
        try {
            Token token = this.context.parse(accessToken);
            userId = token.getUserId();
            logger.info("Access-Token\u89e3\u6790\u51fa\u7684userId={}", (Object)userId);
        }
        catch (Exception e) {
            logger.info("token\u89e3\u6790\u9519\u8bef:{},", (Object)accessToken);
        }
        ActivityGroupDetailQueryReqDto activityGroupDetailReqDto = new ActivityGroupDetailQueryReqDto();
        activityGroupDetailReqDto.setGroupId(groupId.toString());
        activityGroupDetailReqDto.setUserId(userId);
        return new RestResponse((Object)this.groupActivity.queryGroupDetailByPage(activityGroupDetailReqDto, pageNum, pageSize));
    }

    @ApiOperation(value="\u5220\u9664\u6d3b\u52a8", notes="\u672a\u5f00\u59cb\u6d3b\u52a8\u4e0d\u53ef\u5220\u9664")
    @DeleteMapping(value={"/activity/{id}"})
    RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        this.activityService.delete(id);
        return new RestResponse();
    }
}

