/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.api.dto;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import java.util.List;
import java.util.Map;

@ApiModel(value="OrderExchangeDealDto", description="\u4e0b\u5355\u8fc7\u7a0b\u8f6c\u6362\u7684dto\u5bf9\u8c61\uff0c\u7528\u6765\u4f20\u8f93\u6570\u636e")
public class OrderExchangeDealDto {
    private Map<Long, ItemDetailRespDto> itemDetailMap = Maps.newHashMap();
    private Map<Long, ShopDto> shopMap = Maps.newHashMap();
    private Map<String, ItemShelfRespDto> itemShelfRespDtos = Maps.newHashMap();
    private Map<Long, List<BundleItemRespDto>> skuBundleItemsMap = Maps.newHashMap();

    public void addSkuBundleItems(Long skuId, List<BundleItemRespDto> bundleItemRespDtoList) {
        this.skuBundleItemsMap.put(skuId, bundleItemRespDtoList);
    }

    public List<BundleItemRespDto> getSkuBundleItems(Long skuId) {
        return this.skuBundleItemsMap.get(skuId);
    }

    public void addItemDetail(ItemDetailRespDto itemDetailRespDto) {
        this.itemDetailMap.put(itemDetailRespDto.getItem().getId(), itemDetailRespDto);
    }

    public void addItemShelf(ItemShelfRespDto itemShelfRespDto) {
        if (itemShelfRespDto == null) {
            return;
        }
        this.itemShelfRespDtos.put(this.getShelfKey(itemShelfRespDto.getSkuId(), itemShelfRespDto.getShopId()), itemShelfRespDto);
    }

    public void addShop(ShopDto shopDto) {
        this.shopMap.put(shopDto.getId(), shopDto);
    }

    public ShopDto getByShopId(Long shopId) {
        return this.shopMap.get(shopId);
    }

    public ItemDetailRespDto getByItemId(Long itemId) {
        return this.itemDetailMap.get(itemId);
    }

    String getShelfKey(Long skuId, Long shopId) {
        return shopId + "_" + skuId + "_";
    }

    public ItemShelfRespDto getOnSelfInfo(Long skuId, Long shopId) {
        return this.itemShelfRespDtos.get(this.getShelfKey(skuId, shopId));
    }
}

