/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.IErpOrderApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.FinanceAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.order.delivery.ITcbjDeliveryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.recipt.ITcbjReciptApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoOrderDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IStorageOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.InOrderCategory;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.SimpleRequestDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageShippingLogRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingCompanyRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.query.IShippingQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IinventoryService;
import com.dtyunxi.yundt.module.trade.api.dto.response.inventory.DeliveryItemLogisticsRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.inventory.DeliveryItemRecordRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.inventory.DeliveryItemRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InventoryServiceImpl
implements IinventoryService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryServiceImpl.class);
    @Resource
    private ICargoOrderDeliveryQueryApi orderDeliveryQueryApi;
    @Resource
    private IShippingQueryApi shippingQueryApi;
    @Resource
    private IStorageOrderQueryApi storageOrderQueryApi;
    @Resource
    private ITcbjReciptApi tcbjReciptApi;
    @Resource
    private IContext context;
    @Resource
    private IErpOrderApi erpOrderApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrderDeliveryQueryApi orderDeliveryApi;
    @Resource
    private ITcbjDeliveryApi tcbjDeliveryApi;

    public List<DeliveryItemRespDto> queryDeliveryItem(Long id) {
        return this.getDeliveryItemRespDtoList(id);
    }

    public PageInfo<DeliveryItemRecordRespDto> queryDeliveryItemRecord(String orderNo, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        StorageOrderPageReqDto reqDto = new StorageOrderPageReqDto();
        reqDto.setOrderNo(orderNo);
        reqDto.setCategory("CATEGORY_OUT");
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.storageOrderQueryApi.queryByPage(reqDto, pageNum, pageSize));
        logger.info("\u8ba2\u8d27\u5355\u53f7[{}]\u67e5\u8be2\u5bf9\u5e94\u7684\u53d1\u8d27\u4fe1\u606f[{}]", (Object)orderNo, (Object)JSONObject.toJSONString((Object)respDtoPageInfo));
        if (ObjectUtil.isNotEmpty((Object)respDtoPageInfo)) {
            BeanCopierUtils.copy((Object)respDtoPageInfo, (Object)pageInfo);
            ArrayList respDtoList = Lists.newArrayList();
            if (CollectionUtil.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                for (StorageOrderRespDto orderRespDto : respDtoPageInfo.getList()) {
                    DeliveryItemRecordRespDto respDto = new DeliveryItemRecordRespDto();
                    BeanCopierUtils.copy((Object)orderRespDto, (Object)respDto);
                    respDto.setDeliveryOrderNo(orderRespDto.getBusinessId());
                    respDto.setWarehouseName(orderRespDto.getWarehouseName());
                    respDto.setDeliveryTime(orderRespDto.getAuditTime());
                    long sum = this.getDeliveryItemRespDtoList(orderRespDto.getId()).stream().mapToLong(DeliveryItemRespDto::getSendOutNum).sum();
                    respDto.setSendOutNum(Long.valueOf(sum));
                    respDto.setStatus(String.valueOf(orderRespDto.getStatus()));
                    respDtoList.add(respDto);
                }
            }
            pageInfo.setList((List)respDtoList);
        }
        return pageInfo;
    }

    public DeliveryItemLogisticsRespDto queryDeliveryItemLogistics(String orderNo) {
        DeliveryItemLogisticsRespDto respDto = new DeliveryItemLogisticsRespDto();
        List respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.orderDeliveryQueryApi.queryPackageLog(orderNo));
        logger.info("\u8ba2\u8d27\u5355\u53f7[{}]\u67e5\u8be2\u5bf9\u5e94\u7684\u7269\u6d41\u4fe1\u606f[{}]", (Object)orderNo, (Object)JSONObject.toJSONString((Object)respDtoList));
        if (CollectionUtil.isNotEmpty((Collection)respDtoList) && respDtoList.size() > 0) {
            PackageShippingLogRespDto logRespDto = (PackageShippingLogRespDto)respDtoList.get(0);
            List traces = logRespDto.getTraces();
            respDto.setTraces(traces);
            PackageDto pack = logRespDto.getPack();
            BeanCopierUtils.copy((Object)pack, (Object)respDto);
            ShippingCompanyRespDto companyRespDto = (ShippingCompanyRespDto)RestResponseHelper.extractData((RestResponse)this.shippingQueryApi.queryCompanyById(pack.getShippingCompanyId(), ""));
            logger.info("\u8ba2\u8d27\u5355\u53f7[{}]\uff0c\u7269\u6d41\u516c\u53f8id[{}]\u67e5\u8be2\u5bf9\u5e94\u7684\u7269\u6d41\u516c\u53f8\u4fe1\u606f[{}]", new Object[]{orderNo, pack.getShippingCompanyId(), JSONObject.toJSONString((Object)companyRespDto)});
            if (ObjectUtil.isNotEmpty((Object)companyRespDto)) {
                respDto.setShippingCompanyName(companyRespDto.getName());
            }
        }
        return respDto;
    }

    public void checkAllowReject(Integer type, String no, Long orgId) {
        OrganizationDto organizationDto = (OrganizationDto)this.organizationQueryApi.queryById(orgId, "{}").getData();
        if (organizationDto == null) {
            throw new BizException("\u7ec4\u7ec7id\u4e3a\u7a7a");
        }
        if (type == 2) {
            SimpleRequestDto simpleRequestDto = new SimpleRequestDto();
            simpleRequestDto.setPreNo(no);
            simpleRequestDto.setCategory(String.valueOf(InOrderCategory.C_202.getCode()));
            List inDraOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.tcbjReciptApi.inOrderQuery(simpleRequestDto));
            Assert.isTrue((boolean)CollectionUtil.isEmpty((Collection)inDraOrderRespDtoList), (String)"check002", (String)"\u8be5\u9000\u5355\u6709\u6536\u8d27\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838!");
            FinanceAuditReqDto financeAuditReqDto = new FinanceAuditReqDto();
            financeAuditReqDto.setType(Integer.valueOf(2));
            financeAuditReqDto.setOrderNo(no);
            financeAuditReqDto.setOrgCode(organizationDto.getCode());
            RestResponseHelper.extractData((RestResponse)this.erpOrderApi.financeCancelAudit(financeAuditReqDto));
        } else {
            SimpleRequestDto simpleRequestDto = new SimpleRequestDto();
            simpleRequestDto.setPreNo(no);
            simpleRequestDto.setType("101");
            simpleRequestDto.setCategory(String.valueOf(InOrderCategory.C_102.getCode()));
            List inDraOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.tcbjReciptApi.inOrderQuery(simpleRequestDto));
            Assert.isTrue((boolean)CollectionUtil.isEmpty((Collection)inDraOrderRespDtoList), (String)"check001", (String)"\u8be5\u9500\u552e\u5355\u6709\u53d1\u8d27\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838!");
            FinanceAuditReqDto financeAuditReqDto = new FinanceAuditReqDto();
            financeAuditReqDto.setType(Integer.valueOf(1));
            financeAuditReqDto.setOrderNo(no);
            financeAuditReqDto.setOrgCode(organizationDto.getCode());
            RestResponseHelper.extractData((RestResponse)this.erpOrderApi.financeCancelAudit(financeAuditReqDto));
        }
    }

    private List<DeliveryItemRespDto> getDeliveryItemRespDtoList(long id) {
        List detailRespDtoList;
        ArrayList dtoList = Lists.newArrayList();
        StorageOrderCombineRespDto respDto = (StorageOrderCombineRespDto)RestResponseHelper.extractData((RestResponse)this.storageOrderQueryApi.queryById(Long.valueOf(id)));
        logger.info("\u51fa\u5e93\u5355\u53f7[{}]\u67e5\u8be2\u5bf9\u5e94\u7684\u53d1\u8d27\u5546\u54c1[{}]", (Object)id, (Object)JSONObject.toJSONString((Object)respDto));
        if (ObjectUtil.isNotEmpty((Object)respDto) && CollectionUtil.isNotEmpty((Collection)(detailRespDtoList = respDto.getDetailRespDtoList()))) {
            for (DeliveryItemRespDto dto : this.createTestData()) {
                DeliveryItemRespDto itemRespDto = new DeliveryItemRespDto();
                BeanCopierUtils.copy((Object)dto, (Object)itemRespDto);
                dtoList.add(itemRespDto);
            }
        }
        return dtoList;
    }

    private List<DeliveryItemRespDto> createTestData() {
        ArrayList dtoList = Lists.newArrayList();
        DeliveryItemRespDto detailRespDto = new DeliveryItemRespDto();
        detailRespDto.setName("\u591a\u7ef4\u5973\u58eb\u591a\u79cd\u7ef4\u751f\u7d20\u77ff\u7269\u8d28\u7247\u7ef4\u751f\u7d20C\u7247");
        detailRespDto.setCode("201324134143");
        detailRespDto.setSendOutNum(Long.valueOf(2323L));
        detailRespDto.setType("1");
        detailRespDto.setBatchNo("P1000323001");
        detailRespDto.setSpec("22.5g(0.5g/\u7c92\u00d745\u7c92)");
        detailRespDto.setOrderNum(Long.valueOf(2323L));
        dtoList.add(detailRespDto);
        DeliveryItemRespDto detailRespDto1 = new DeliveryItemRespDto();
        detailRespDto1.setName("\u591a\u7ef4\u7537\u58eb\u724c\u591a\u79cd\u7ef4\u751f\u7d20\u77ff\u7269\u8d28\u7247");
        detailRespDto1.setCode("hongmi001");
        detailRespDto1.setSendOutNum(Long.valueOf(181L));
        detailRespDto1.setType("2");
        detailRespDto1.setBatchNo("P1000323002");
        detailRespDto1.setSpec("450g/\u7f50");
        detailRespDto1.setOrderNum(Long.valueOf(181L));
        dtoList.add(detailRespDto1);
        DeliveryItemRespDto detailRespDto2 = new DeliveryItemRespDto();
        detailRespDto2.setName("\u82cf\u6469\u7259\u5237");
        detailRespDto2.setCode("201324134143");
        detailRespDto2.setSendOutNum(Long.valueOf(534L));
        detailRespDto2.setType("3");
        detailRespDto2.setBatchNo("P1000323003");
        detailRespDto2.setSpec("22.5g(0.5g/\u7c92\u00d745\u7c92)");
        detailRespDto2.setOrderNum(Long.valueOf(534L));
        dtoList.add(detailRespDto2);
        return dtoList;
    }
}

