/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.IBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.IGiftBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceRecordQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.module.trade.api.IRefundConfigService;
import com.dtyunxi.yundt.module.trade.api.IReturnOrderService;
import com.dtyunxi.yundt.module.trade.api.dto.ReturnGiftAmountReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.AddRefundConfigReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.RefundConfigRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReFundOrderDetailRespDto;
import com.dtyunxi.yundt.module.trade.biz.impl.HelpServiceImpl;
import com.yx.tcbj.center.rebate.api.IReturnsQuotaApi;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaAccountRespDto;
import com.yx.tcbj.center.rebate.api.query.IReturnsQuotaAccountQueryApi;
import com.yx.tcbj.center.trade.api.IRefundDisposeConfigApi;
import com.yx.tcbj.center.trade.api.constant.RefundChannelTypeEnum;
import com.yx.tcbj.center.trade.api.dto.request.RefundDisposeConfigReqDto;
import com.yx.tcbj.center.trade.api.dto.response.RefundDisposeConfigRespDto;
import com.yx.tcbj.center.trade.api.query.IRefundDisposeConfigQueryApi;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="refundConfigServiceImpl")
public class RefundConfigServiceImpl
implements IRefundConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpServiceImpl.class);
    @Resource
    private IReturnOrderService returnOrderService;
    @Resource
    private IReturnsQuotaAccountQueryApi returnsQuotaAccountQueryApi;
    @Resource
    private IRefundDisposeConfigQueryApi refundDisposeConfigQueryApi;
    @Resource
    private IRefundDisposeConfigApi refundDisposeConfigApi;
    @Resource
    private IReturnsQuotaApi returnsQuotaApi;
    @Resource
    private IBalanceApi balanceApi;
    @Resource
    private IGiftBalanceQueryApi giftBalanceQueryApi;
    @Resource
    private IGiftBalanceApi giftBalanceApi;
    @Resource
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private IGiftBalanceRecordQueryApi giftBalanceRecordQueryApi;
    private static final String TOOLTIP_ERROR_CODE = "500001";

    public RefundConfigRespDto query(String returnNo, Long customerId) {
        RestResponse accountRespDtoRestResponse;
        RestResponse refundDisposeConfigRespDtoRestResponse;
        RefundConfigRespDto respDto = new RefundConfigRespDto();
        if (StringUtils.isNotEmpty((CharSequence)returnNo) && ObjectUtil.isNotEmpty((Object)(refundDisposeConfigRespDtoRestResponse = this.refundDisposeConfigQueryApi.queryByNo(returnNo)).getData()) && ObjectUtil.isNotEmpty((Object)((RefundDisposeConfigRespDto)refundDisposeConfigRespDtoRestResponse.getData()).getId())) {
            respDto.setRefundDisposeConfigRespDto((RefundDisposeConfigRespDto)refundDisposeConfigRespDtoRestResponse.getData());
            return respDto;
        }
        RestResponse bigDecimalRestResponse = this.returnsQuotaAccountQueryApi.queryCustomerScale(customerId);
        if (ObjectUtil.isNotEmpty((Object)bigDecimalRestResponse.getData())) {
            respDto.setReturnsQuotaScale((BigDecimal)bigDecimalRestResponse.getData());
        }
        if (ObjectUtil.isNotEmpty((Object)(accountRespDtoRestResponse = this.returnsQuotaAccountQueryApi.queryByCustomerId(customerId)).getData())) {
            respDto.setUsableQuota(((ReturnsQuotaAccountRespDto)accountRespDtoRestResponse.getData()).getGeneralReturnsQuota().add(((ReturnsQuotaAccountRespDto)accountRespDtoRestResponse.getData()).getAdvanceQuota()));
        }
        BalanceQueryReqDto balanceQueryReqDto = new BalanceQueryReqDto();
        balanceQueryReqDto.setCustomerId(customerId);
        RestResponse balanceDetailRespDtoRestResponse = this.giftBalanceQueryApi.queryByCustomerId(balanceQueryReqDto);
        if (ObjectUtil.isNotEmpty((Object)balanceDetailRespDtoRestResponse.getData())) {
            respDto.setBalanceDetailRespDto((BalanceDetailRespDto)balanceDetailRespDtoRestResponse.getData());
        }
        return respDto;
    }

    public RestResponse<String> addConfig(AddRefundConfigReqDto configReqDto) {
        BigDecimal total;
        LOGGER.info("\u9000\u6b3e\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)configReqDto));
        configReqDto.getRefundDisposeConfigReqDto().setCustomerId(configReqDto.getCustomerId());
        RefundDisposeConfigReqDto reqDto = this.checkParams(configReqDto.getRefundDisposeConfigReqDto());
        reqDto.setCustomerId(configReqDto.getCustomerId());
        configReqDto.getRefundDisposeConfigReqDto().setOrderNo(configReqDto.getReturnNo());
        BigDecimal returnsBackAmount = BigDecimal.ZERO;
        if (ObjectUtil.isNotEmpty((Object)reqDto.getReturnsBackType()) && reqDto.getReturnsBackType() == 1 && ObjectUtil.isNotEmpty((Object)reqDto.getReturnsBackAmount())) {
            returnsBackAmount = reqDto.getReturnsBackAmount();
        }
        BigDecimal returnsDeductAmount = BigDecimal.ZERO;
        if (ObjectUtil.isNotEmpty((Object)reqDto.getReturnsQuotaType()) && reqDto.getReturnsQuotaType() == 1 && ObjectUtil.isNotEmpty((Object)reqDto.getReturnsQuotaAmount())) {
            returnsDeductAmount = reqDto.getReturnsQuotaAmount();
        }
        if ((total = returnsBackAmount.add(returnsDeductAmount)).compareTo(BigDecimal.ZERO) == 1 && (reqDto.getReturnsBackType() == 1 || reqDto.getReturnsQuotaType() == 1)) {
            RestResponse bigDecimalRestResponse = this.returnsQuotaAccountQueryApi.queryCustomerScale(configReqDto.getCustomerId());
            BigDecimal scale = ((BigDecimal)bigDecimalRestResponse.getData()).divide(new BigDecimal(100));
            RestResponse accountRespDtoRestResponse = this.returnsQuotaAccountQueryApi.queryByCustomerId(configReqDto.getCustomerId());
            if (ObjectUtil.isEmpty((Object)accountRespDtoRestResponse.getData())) {
                throw new BizException("\u8be5\u5ba2\u6237\u6ca1\u6709\u9000\u8d27\u989d\u5ea6\u8d26\u6237\uff1a" + configReqDto.getCustomerId());
            }
            BigDecimal usable = ((ReturnsQuotaAccountRespDto)accountRespDtoRestResponse.getData()).getAdvanceQuota().add(((ReturnsQuotaAccountRespDto)accountRespDtoRestResponse.getData()).getGeneralReturnsQuota());
            if (usable.compareTo(total) == -1) {
                throw new BizException(TOOLTIP_ERROR_CODE, this.lackDeductCueWords(usable, total, reqDto.getReturnsQuotaAmount()));
            }
        }
        RestResponse refundDisposeConfigRespDtoRestResponse = this.refundDisposeConfigQueryApi.queryByNo(configReqDto.getReturnNo());
        LOGGER.info("\u65b0\u589e/\u7f16\u8f91\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isEmpty((Object)refundDisposeConfigRespDtoRestResponse.getData()) || ObjectUtil.isEmpty((Object)((RefundDisposeConfigRespDto)refundDisposeConfigRespDtoRestResponse.getData()).getId())) {
            this.refundDisposeConfigApi.addRefundDisposeConfig(reqDto);
        } else {
            reqDto.setId(((RefundDisposeConfigRespDto)refundDisposeConfigRespDtoRestResponse.getData()).getId());
            this.refundDisposeConfigApi.modifyRefundDisposeConfig(reqDto);
        }
        return RestResponse.SUCCEED;
    }

    private BigDecimal calcGiftAmout(ReturnGiftAmountReqDto returnGiftAmountReqDto) {
        LOGGER.info("\u8ba1\u7b97\u6263\u51cf\u8d60\u54c1\u989d\u5ea6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)returnGiftAmountReqDto));
        BigDecimal returnGiftQuota = BigDecimal.ZERO;
        BalanceQueryReqDto balanceQueryReqDto = new BalanceQueryReqDto();
        balanceQueryReqDto.setCustomerId(returnGiftAmountReqDto.getCustomerId());
        BalanceDetailRespDto balanceDetailRespDto = (BalanceDetailRespDto)RestResponseHelper.extractData((RestResponse)this.giftBalanceQueryApi.queryByCustomerId(balanceQueryReqDto));
        LOGGER.info("\u5ba2\u6237\u8d26\u6237\u989d\u5ea6\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)balanceDetailRespDto));
        if (balanceDetailRespDto == null) {
            return returnGiftQuota;
        }
        if (GiveTypeEnum.AMOUNT_OF_MONEY.getCode().equals(balanceDetailRespDto.getGiveType())) {
            BigDecimal realRefundAmount = returnGiftAmountReqDto.getRealRefundAmount();
            returnGiftQuota = realRefundAmount.multiply(balanceDetailRespDto.getGiveProportion()).divide(new BigDecimal("100"), 2, 4);
        } else {
            if (BigDecimal.ZERO.compareTo(balanceDetailRespDto.getQuantityScaleSum()) >= 0 || BigDecimal.ZERO.compareTo(balanceDetailRespDto.getQuantityScaleAmount()) >= 0) {
                return returnGiftQuota;
            }
            ReFundOrderDetailRespDto reFundOrderDetailRespDto = this.returnOrderService.queryById(returnGiftAmountReqDto.getReturnNo());
            LOGGER.info("\u6309\u7167\u6570\u91cf\u8ba1\u7b97\uff0c\u67e5\u8be2\u9000\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reFundOrderDetailRespDto));
            if (reFundOrderDetailRespDto == null) {
                return returnGiftQuota;
            }
            Integer totalItemNum = 0;
            for (ReFundOrderDetailRespDto.ItemDetail itemDetail : reFundOrderDetailRespDto.getReturnItemDetail()) {
                totalItemNum = totalItemNum + itemDetail.getItemNum();
            }
            returnGiftQuota = new BigDecimal(totalItemNum).multiply(balanceDetailRespDto.getGiveProportion().divide(new BigDecimal("100"), 2, 4)).multiply(balanceDetailRespDto.getQuantityScaleAmount().divide(balanceDetailRespDto.getQuantityScaleSum()));
        }
        return returnGiftQuota;
    }

    private RefundDisposeConfigReqDto checkParams(RefundDisposeConfigReqDto reqDto) {
        if (ObjectUtil.isEmpty((Object)reqDto)) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getDiscountQuotaType()) && reqDto.getDiscountQuotaType() == -1) {
            reqDto.setDiscountQuota(BigDecimal.ZERO);
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getReturnsQuotaType()) && reqDto.getReturnsQuotaType() == -1) {
            reqDto.setReturnsQuotaAmount(BigDecimal.ZERO);
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getReturnsBackType()) && reqDto.getReturnsBackType() == -1) {
            reqDto.setReturnsBackAmount(BigDecimal.ZERO);
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getGiftQuotaType()) && reqDto.getGiftQuotaType() == -1) {
            reqDto.setGiftQuota(BigDecimal.ZERO);
        }
        if (ObjectUtil.isEmpty((Object)reqDto.getRefundChannelType()) || ObjectUtil.isEmpty((Object)RefundChannelTypeEnum.formCode((Integer)reqDto.getRefundChannelType()))) {
            throw new BizException("100030", "\u9000\u6b3e\u6e20\u9053\u9519\u8bef");
        }
        return reqDto;
    }

    private String lackDeductCueWords(BigDecimal use, BigDecimal total, BigDecimal deduct) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<p>\u9000\u8d27\u989d\u5ea6\u4e0d\u8db3\u3002\u5f53\u524d\u53ef\u7528\u9000\u8d27\u989d\u5ea6\uff1a${use}\u5143\uff0c\u672c\u6b21\u9700\u6263\u989d\u5ea6 ${total}\u5143\uff08\u6263\u56de\u5f53\u65f6\u53d1\u8d27\u83b7\u5f97\u7684\u989d\u5ea6${rebate}\u5143\uff0c\u6263\u51cf\u672c\u6b21\u9000\u8d27\u989d\u5ea6${deduct}\u5143\uff09</p>");
        stringBuffer.append("<p>\u9700\u8865\u8db3${remain}\u5143\u989d\u5ea6\uff0c\u53ef\u901a\u8fc7\u4ea7\u54c1\u4e0b\u5355\u53d1\u8d27\u6216\u9884\u652f\u989d\u5ea6\u83b7\u5f97\u989d\u5ea6\u3002</p>");
        String str = stringBuffer.toString();
        str = str.replace("${use}", Double.valueOf(use.doubleValue()).toString());
        str = str.replace("${total}", Double.valueOf(total.doubleValue()).toString());
        str = str.replace("${rebate}", Double.valueOf(total.subtract(deduct).setScale(2, 0).doubleValue()).toString());
        str = str.replace("${deduct}", Double.valueOf(deduct.doubleValue()).toString());
        str = str.replace("${remain}", Double.valueOf(total.subtract(use).setScale(2, 0).doubleValue()).toString());
        return str;
    }
}

