/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.yundt.cube.center.price.api.constants.LadderPriceCalcMethodEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.SimpleSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.biz.price.ItemPriceHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.PlaceOrderItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemPriceExtDto;
import com.dtyunxi.yundt.module.trade.biz.IPriceService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PriceServiceImpl
implements IPriceService {
    private static final Logger logger = LoggerFactory.getLogger(PriceServiceImpl.class);
    @Autowired
    private IBItemPriceService ibItemPriceService;
    @Resource
    private ItemPriceHelper itemPriceHelper;
    @Resource
    private IOrderService orderService;
    @Resource
    private IContext context;

    @Override
    public void replacePrice(List<? extends ItemPriceExtDto> priceExtDtos, Long customerId) {
        if (CollectionUtil.isNotEmpty(priceExtDtos)) {
            CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
            communalPriceQueryReqDto.setCustId(customerId);
            communalPriceQueryReqDto.setPolicyDate((Date)DateTime.now());
            ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto> skuList = new ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto>(priceExtDtos.size());
            for (ItemPriceExtDto itemPriceExtDto : priceExtDtos) {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                BeanUtil.copyProperties((Object)itemPriceExtDto, (Object)itemSkuPriceReqDto, (String[])new String[0]);
                itemSkuPriceReqDto.setSkuSellPrice(itemPriceExtDto.getRetailPrice());
                itemSkuPriceReqDto.setShopId(itemPriceExtDto.getSkuShopId());
                if (!ObjectUtil.isNotEmpty((Object)itemSkuPriceReqDto.getSkuId())) continue;
                skuList.add(itemSkuPriceReqDto);
            }
            communalPriceQueryReqDto.setSkuList(skuList);
            logger.info("\u5f00\u59cb\u67e5\u8be2\u5916\u90e8\u4ef7\u683c");
            List itemPriceEsDtos = (List)this.ibItemPriceService.getItemPrice(communalPriceQueryReqDto).getData();
            if (CollectionUtil.isNotEmpty((Collection)itemPriceEsDtos)) {
                for (ItemPolicyPriceRespDto itemPriceEsDto : itemPriceEsDtos) {
                    for (ItemPriceExtDto itemPriceExtDto : priceExtDtos) {
                        if (!itemPriceEsDto.getSkuId().equals(itemPriceExtDto.getSkuId())) continue;
                        if (itemPriceEsDto.getHasLadderPrice()) {
                            logger.info("itemId=[{}]skuId=[{}]itemName=[{}]\u914d\u7f6e\u4e86\u9636\u68af\u4ef7", new Object[]{itemPriceExtDto.getItemId(), itemPriceExtDto.getSkuId(), itemPriceExtDto.getItemName()});
                            itemPriceExtDto.setHasLadderPrice(true);
                            ArrayList<ItemPriceExtDto.LadderPrice> ladderPrices = new ArrayList<ItemPriceExtDto.LadderPrice>();
                            for (ItemPolicyPriceRespDto.LadderPrice ladderPrice : itemPriceEsDto.getLadderPrices()) {
                                ItemPriceExtDto.LadderPrice price = new ItemPriceExtDto.LadderPrice();
                                BeanUtil.copyProperties((Object)ladderPrice, (Object)price, (String[])new String[0]);
                                ladderPrices.add(price);
                            }
                            itemPriceExtDto.setLadderPrices(ladderPrices);
                            continue;
                        }
                        if (itemPriceEsDto.getHasDiscountPrice()) {
                            logger.info("itemId=[{}]skuId=[{}]itemName=[{}]\u914d\u7f6e\u4e86\u6298\u6263", new Object[]{itemPriceExtDto.getItemId(), itemPriceExtDto.getSkuId(), itemPriceExtDto.getItemName()});
                            itemPriceExtDto.setHasDiscountPrice(true);
                            itemPriceExtDto.setDiscountPrice(itemPriceEsDto.getDiscountPrice());
                            continue;
                        }
                        itemPriceExtDto.setRetailPrice(itemPriceEsDto.getPrice());
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public BigDecimal getOrderItemPolicyPrice(OrderItemInfoDto orderItem, Long customerId) {
        ItemPolicyPriceRespDto itemPolicyPriceRespDto;
        if (customerId == null) {
            return null;
        }
        CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
        communalPriceQueryReqDto.setCustId(customerId);
        communalPriceQueryReqDto.setPolicyDate((Date)DateTime.now());
        ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto> skuList = new ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto>();
        CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
        itemSkuPriceReqDto.setShopId(orderItem.getShopId());
        itemSkuPriceReqDto.setItemId(orderItem.getItemId());
        itemSkuPriceReqDto.setSkuId(orderItem.getSkuId());
        itemSkuPriceReqDto.setSkuSellPrice(orderItem.getSellPrice());
        skuList.add(itemSkuPriceReqDto);
        communalPriceQueryReqDto.setSkuList(skuList);
        List itemPriceEsDtos = (List)this.ibItemPriceService.getItemPrice(communalPriceQueryReqDto).getData();
        if (!CollectionUtils.isEmpty((Collection)itemPriceEsDtos) && (itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)itemPriceEsDtos.stream().filter(e -> e.getSkuId().equals(orderItem.getSkuId())).findFirst().orElse(null)) != null) {
            BigDecimal policyPrice = this.itemPriceHelper.getActualPolicyPrice(itemPolicyPriceRespDto, orderItem.getItemNum());
            return policyPrice;
        }
        return null;
    }

    @Override
    @Deprecated
    public BigDecimal getItemPrice(OrderItemInfoDto item, TradeItemReqDto tradeItem, Long customerId) {
        BigDecimal result = tradeItem.getItemPrice();
        ItemPriceExtDto itemPriceExtDto = new ItemPriceExtDto();
        itemPriceExtDto.setItemId(item.getItemId());
        itemPriceExtDto.setSkuId(item.getSkuId());
        itemPriceExtDto.setRetailPrice(tradeItem.getItemPrice());
        itemPriceExtDto.setSkuShopId(item.getShopId());
        ArrayList<ItemPriceExtDto> itemPriceExtDtos = new ArrayList<ItemPriceExtDto>();
        itemPriceExtDtos.add(itemPriceExtDto);
        this.replacePrice(itemPriceExtDtos, customerId);
        if (itemPriceExtDto.isHasLadderPrice()) {
            ItemPriceExtDto.LadderPrice ladderPrice = itemPriceExtDto.getLadderPrices().stream().filter(e -> e.getLower().compareTo(item.getItemNum()) <= 0 && (e.getUpper() == null || e.getUpper().compareTo(item.getItemNum()) >= 0)).findFirst().orElse(null);
            if (ladderPrice != null) {
                result = ladderPrice.getPrice();
            }
        } else {
            result = itemPriceExtDto.isHasDiscountPrice() ? itemPriceExtDto.getDiscountPrice() : itemPriceExtDto.getRetailPrice();
        }
        return result;
    }

    @Override
    public BigDecimal getItemDistributePrice(SimpleSkuPriceQueryReqDto reqDto) {
        ItemPolicyPriceRespDto itemPolicyPriceRespDto;
        Assert.notNull((Object)reqDto.getSkuId(), (String)"skuId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqDto.getShopId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqDto.getCustomerId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal policyPrice = null;
        Date queryDate = reqDto.getPolicyDate() == null ? new Date() : reqDto.getPolicyDate();
        CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
        communalPriceQueryReqDto.setCustId(reqDto.getCustomerId());
        communalPriceQueryReqDto.setPolicyDate(queryDate);
        ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto> skuList = new ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto>();
        CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
        itemSkuPriceReqDto.setShopId(reqDto.getShopId());
        itemSkuPriceReqDto.setItemId(reqDto.getItemId());
        itemSkuPriceReqDto.setSkuId(reqDto.getSkuId());
        itemSkuPriceReqDto.setSkuSellPrice(reqDto.getSellPrice());
        skuList.add(itemSkuPriceReqDto);
        communalPriceQueryReqDto.setSkuList(skuList);
        List itemPriceEsDtos = (List)this.ibItemPriceService.getItemPrice(communalPriceQueryReqDto).getData();
        if (!CollectionUtils.isEmpty((Collection)itemPriceEsDtos) && (itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)itemPriceEsDtos.stream().filter(e -> e.getSkuId().equals(reqDto.getSkuId())).findFirst().orElse(null)) != null) {
            LadderPriceCalcMethodEnum ladderPriceCalcMethodEnum = LadderPriceCalcMethodEnum.getByCode((Integer)reqDto.getLadderPriceCalcMethod());
            switch (ladderPriceCalcMethodEnum) {
                case QTY_ONE_LAADER: {
                    policyPrice = this.itemPriceHelper.getDefaultMatchPrice(itemPolicyPriceRespDto, reqDto.getBuyNum());
                    break;
                }
                case ACT_QTY_LAADER: {
                    policyPrice = this.itemPriceHelper.getActualPolicyPrice(itemPolicyPriceRespDto, reqDto.getBuyNum());
                    break;
                }
            }
        }
        return policyPrice;
    }

    @Override
    public ItemPolicyPriceRespDto getItemDistributePolicy(SimpleSkuPriceQueryReqDto reqDto) {
        Assert.notNull((Object)reqDto.getSkuId(), (String)"skuId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqDto.getShopId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqDto.getCustomerId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Date queryDate = reqDto.getPolicyDate() == null ? new Date() : reqDto.getPolicyDate();
        CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
        communalPriceQueryReqDto.setCustId(reqDto.getCustomerId());
        communalPriceQueryReqDto.setPolicyDate(queryDate);
        ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto> skuList = new ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto>();
        CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
        itemSkuPriceReqDto.setShopId(reqDto.getShopId());
        itemSkuPriceReqDto.setItemId(reqDto.getItemId());
        itemSkuPriceReqDto.setSkuId(reqDto.getSkuId());
        itemSkuPriceReqDto.setSkuSellPrice(reqDto.getSellPrice());
        skuList.add(itemSkuPriceReqDto);
        communalPriceQueryReqDto.setOnlyBestMatch(Integer.valueOf(1));
        communalPriceQueryReqDto.setSkuList(skuList);
        List itemPriceEsDtos = (List)this.ibItemPriceService.getItemPrice(communalPriceQueryReqDto).getData();
        ItemPolicyPriceRespDto resultDto = null;
        if (!CollectionUtils.isEmpty((Collection)itemPriceEsDtos)) {
            resultDto = (ItemPolicyPriceRespDto)itemPriceEsDtos.get(0);
        }
        return resultDto;
    }

    @Override
    public Map<Long, ItemPolicyPriceRespDto> getItemDistributePolicyMap(List<PlaceOrderItemReqDto> reqDtos, Long customerId, Date policyDate) {
        Collection itemPriceEsDtos = null;
        if (!CollectionUtils.isEmpty(reqDtos)) {
            ArrayList skuList = new ArrayList();
            reqDtos.stream().forEach(reqDto -> {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                itemSkuPriceReqDto.setShopId(reqDto.getShopId());
                itemSkuPriceReqDto.setItemId(reqDto.getItemId());
                itemSkuPriceReqDto.setSkuId(reqDto.getSkuId());
                itemSkuPriceReqDto.setSkuSellPrice(reqDto.getSellPrice());
                skuList.add(itemSkuPriceReqDto);
            });
            CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
            communalPriceQueryReqDto.setCustId(customerId);
            communalPriceQueryReqDto.setPolicyDate(policyDate);
            communalPriceQueryReqDto.setOnlyBestMatch(Integer.valueOf(1));
            communalPriceQueryReqDto.setSkuList(skuList);
            itemPriceEsDtos = (List)this.ibItemPriceService.getItemPrice(communalPriceQueryReqDto).getData();
        } else {
            logger.error("getItemDistributePolicyList reqDtos is NULL");
        }
        Map<Object, Object> retMap = null;
        retMap = !CollectionUtils.isEmpty(itemPriceEsDtos) ? itemPriceEsDtos.stream().collect(Collectors.toMap(ItemPolicyPriceRespDto::getSkuId, Function.identity(), (o1, o2) -> o1)) : Maps.newConcurrentMap();
        return retMap;
    }

    @Override
    public Map<Long, ItemPolicyPriceRespDto> getItemDistributePolicyMap2(List<OrderItemInfoDto> reqDtos, Long customerId, Date policyDate) {
        Collection itemPriceEsDtos = null;
        if (!CollectionUtils.isEmpty(reqDtos)) {
            ArrayList skuList = new ArrayList();
            reqDtos.stream().forEach(reqDto -> {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                itemSkuPriceReqDto.setShopId(reqDto.getShopId());
                itemSkuPriceReqDto.setItemId(reqDto.getItemId());
                itemSkuPriceReqDto.setSkuId(reqDto.getSkuId());
                itemSkuPriceReqDto.setSkuSellPrice(reqDto.getSellPrice());
                skuList.add(itemSkuPriceReqDto);
            });
            CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
            communalPriceQueryReqDto.setCustId(customerId);
            if (Objects.isNull(policyDate)) {
                policyDate = new Date();
            }
            communalPriceQueryReqDto.setPolicyDate(policyDate);
            communalPriceQueryReqDto.setOnlyBestMatch(Integer.valueOf(1));
            communalPriceQueryReqDto.setSkuList(skuList);
            itemPriceEsDtos = (List)this.ibItemPriceService.getItemPrice(communalPriceQueryReqDto).getData();
        } else {
            logger.error("getItemDistributePolicyList reqDtos is NULL");
        }
        Map<Object, Object> retMap = null;
        retMap = !CollectionUtils.isEmpty(itemPriceEsDtos) ? itemPriceEsDtos.stream().collect(Collectors.toMap(ItemPolicyPriceRespDto::getSkuId, Function.identity(), (o1, o2) -> o1)) : Maps.newConcurrentMap();
        return retMap;
    }
}

