/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ISeckillStockService;
import com.dtyunxi.yundt.module.trade.biz.mq.MqProducer;
import com.dtyunxi.yundt.module.trade.biz.util.KeyGenerator;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SeckillStockServiceImpl
implements ISeckillStockService {
    @Resource
    private ICacheService cacheService;
    @Resource
    private MqProducer mqProducer;
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${yundt.cube.center.promotion.api.name:}")
    private String promotionApplicationName;
    private static Logger logger = LoggerFactory.getLogger(SeckillStockServiceImpl.class);

    @Override
    public boolean increase(long acId, long id, Long shopId, int num, ActivityItemTypeEnum type, String msg) {
        String group;
        long result;
        String pfile;
        String string = pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        if (StrUtil.isBlank((CharSequence)this.promotionApplicationName)) {
            this.promotionApplicationName = "yundt-cube-center-promotion";
        }
        if ((result = this.cacheService.hincrBy(group = this.promotionApplicationName + "-" + pfile, KeyGenerator.itemRule(acId), KeyGenerator.item(id, shopId, type), num).longValue()) < 0L) {
            this.cacheService.hincrBy(group, KeyGenerator.itemRule(acId), KeyGenerator.item(id, shopId, type), -num);
            logger.error("\u5e93\u5b58\u6263\u51cf\u5931\u8d25\uff0c\u5927\u6982\u7387\u4e3a\u5e93\u5b58\u4e0d\u8db3");
            return false;
        }
        this.mqProducer.sendItemStockMessage(acId, id, num, type, msg);
        return true;
    }

    @Override
    public Long queryStock(long acId, long id, Long shopId, ActivityItemTypeEnum type) {
        String pfile;
        String string = pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        if (StrUtil.isBlank((CharSequence)this.promotionApplicationName)) {
            this.promotionApplicationName = "yundt-cube-center-promotion";
        }
        String group = this.promotionApplicationName + "-" + pfile;
        Long stock = (Long)this.cacheService.hget(group, KeyGenerator.joinNumRule(acId), KeyGenerator.item(id, shopId, type), Long.class);
        return stock;
    }

    @Override
    public void subStock(Long activityId, OrderItemInfoDto orderItemInfoDto) {
        boolean result = this.increase(activityId, orderItemInfoDto.getSkuId(), orderItemInfoDto.getShopId(), -orderItemInfoDto.getItemNum().intValue(), ActivityItemTypeEnum.ITEM, "\u6263\u51cf\u79d2\u6740\u5e93\u5b58");
        if (!result) {
            throw new BizException(TradeModuleExcpCode.ACTIVITY_ITEM_STOCK_LIMIT.getCode(), TradeModuleExcpCode.ACTIVITY_ITEM_STOCK_LIMIT.getMsg());
        }
    }
}

