/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.marketing.biz.activity.mq.vo.ItemStockMsg;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReFundOrderReceiveSaveToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderRespDto;
import com.dtyunxi.yundt.module.trade.api.vo.SeckillOrderMessageVo;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class MqProducer {
    private static final Logger logger = LoggerFactory.getLogger(MqProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderService orderService;
    @Resource
    private Environment environment;
    @Resource
    private IContext iContext;
    @Value(value="${imk.common.topic.activity.item:YUNDT_CUBE_CENTER_MARKETING_ITEM_RULE_TOPIC}")
    private String itemTopic;

    public void sendSeckillOrderMessage(SeckillOrderMessageVo seckillOrderMessageVo) {
        MessageVo messageVo = new MessageVo();
        seckillOrderMessageVo.setMessageSendTime(new Date());
        messageVo.setData((Object)JSON.toJSONString((Object)seckillOrderMessageVo));
        if (logger.isDebugEnabled()) {
            logger.debug("\u79d2\u6740\u4e0b\u5355\u6d88\u606f,\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)messageVo));
        }
        this.commonsMqService.sendSingleMessage("SECKILL_ORDER_TOPIC", "seckill_submit_order", (Object)messageVo);
    }

    public void sendItemStockMessage(long acId, long id, int num, ActivityItemTypeEnum type, String msg) {
        ItemStockMsg itemStockMsg = new ItemStockMsg(acId, id, type, num);
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(this.itemTopic, "MARKETING-GIFT-STOCK", (Object)itemStockMsg);
        logger.info("\u6d3b\u52a8\uff1a{}, \u5546\u54c1\uff1a{}, \u7c7b\u578b\uff1a{}, \u57fa\u4e8e\uff1a{}\u539f\u56e0\u3002\u8fdb\u884c\u5e93\u5b58\u65b0\u589e:{}\u4e2a.\u5bf9\u5e94msg\u6d88\u606f\uff1a{},\u81ea\u5b9a\u4e49\u6d88\u606fID\uff1a{}", new Object[]{acId, id, type, msg, num, messageResponse.getData(), itemStockMsg.getSerial()});
    }

    public void sendPlaceOrderMessage(String orderNo, Date auditPassTime) {
        OrderRespDto orderDto = this.orderService.getMgmtOrderDetail(orderNo);
        orderDto.setTenantId(this.iContext.tenantId());
        orderDto.setInstanceId(this.iContext.instanceId());
        String jsonMsg = JSON.toJSONString((Object)orderDto);
        logger.info("orderNo={},orderTradeStatus={}", (Object)orderDto.getOrderNo(), (Object)orderDto.getOrderTradeStatus());
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${icomb.common.topic.order.rebate:ORDER_REBATE_TOPIC}"), "btrade_order_rebate", (Object)jsonMsg);
    }

    public void sendReturnOrderMessage(ReFundOrderReceiveSaveToBReqDto reqDto) {
        logger.info("\u8ba2\u5355orderNo={},\u9000\u6b3e\u5355returnNo={}\uff0c\u91cd\u65b0\u8ba1\u7b97\u8fd4\u5229\u5dee\u989d", (Object)reqDto.getOrderNo(), (Object)reqDto.getReturnNo());
        reqDto.setTenantId(this.iContext.tenantId());
        reqDto.setInstanceId(this.iContext.instanceId());
        String jsonMsg = JSON.toJSONString((Object)reqDto);
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${icomb.common.topic.order.rebate:ORDER_REBATE_TOPIC}"), "btrade_order_return_rebate", (Object)jsonMsg);
    }
}

