/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.pay;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.trade.api.dto.request.OfflineAccountPayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.enums.PayMethodEnum;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountReqDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceFlowEnum;
import com.yx.tcbj.center.rebate.api.query.IOfflineBalanceAccountQueryApi;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="offlineAccountPayHelp")
public class OfflineAccountPayHelp
extends AbstractPayHelp {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOfflineBalanceAccountQueryApi offlineBalanceAccountQueryApi;

    @Override
    public SimplePayReqDto initParam(Object ... objects) {
        SimplePayReqDto basePayReqDto = new SimplePayReqDto();
        OfflineAccountPayReqDto offlineAccountPayReqDto = new OfflineAccountPayReqDto();
        for (Object object : objects) {
            CubeBeanUtils.copyProperties((Object)offlineAccountPayReqDto, (Object)object, (String[])new String[0]);
        }
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)basePayReqDto);
        }
        basePayReqDto.setOfflineAccountPayReqDto(offlineAccountPayReqDto);
        this.logger.info("\u521d\u59cb\u53c2\u6570[{}]", (Object)JSON.toJSONString((Object)basePayReqDto));
        return basePayReqDto;
    }

    @Override
    protected SimplePayReqDto buildResult(SimplePayReqDto request) {
        return null;
    }

    @Override
    public void errorCallBack(SimplePayReqDto simplePayReqDto) {
    }

    @Override
    public void successCallBackDefine(SimplePayReqDto simplePayReqDto) {
        simplePayReqDto.setPayAmount(simplePayReqDto.getOfflineAccountPayReqDto().getOfflineAmount());
        simplePayReqDto.setOrderNo(simplePayReqDto.getOfflineAccountPayReqDto().getOrderNo());
        simplePayReqDto.setPayMethod(PayMethodEnum.OFFLINE_ACCOUNT_PAY.getCode());
        super.addOrderPayRecord(simplePayReqDto);
    }

    @Override
    public boolean allowSubmitOrder(SimplePayReqDto request) {
        return false;
    }

    @Override
    public boolean isPrePayed(SimplePayReqDto simplePayReqDto) {
        return false;
    }

    @Override
    public void toPrePay(SimplePayReqDto request) {
    }

    @Override
    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
        if (simplePayReqDto.getRefundAmount() != null && BigDecimal.ZERO.compareTo(simplePayReqDto.getRefundAmount()) < 0) {
            OfflineBalanceAccountReqDto offlineReqDto = new OfflineBalanceAccountReqDto();
            offlineReqDto.setBalanceChange(simplePayReqDto.getRefundAmount());
            offlineReqDto.setChangeStatus("INCOME");
            offlineReqDto.setCustomerId(Long.valueOf(simplePayReqDto.getCustomerId()));
            offlineReqDto.setFlowTradeType(OfflineBalanceFlowEnum.ORDER_REFUND.getValue());
            offlineReqDto.setRelationNo(simplePayReqDto.getOrderNo());
            this.logger.info("\u901a\u77e5\u7ebf\u4e0b\u4f59\u989d\u8d26\u6237\u6263\u6b3e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)offlineReqDto));
            RestResponseHelper.extractData((RestResponse)this.offlineBalanceAccountQueryApi.offlineBalanceAccountChange(offlineReqDto));
        }
    }
}

