/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceAndNumLimitDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBeanReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.SubmitOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemPriceExtDto;
import com.dtyunxi.yundt.module.trade.biz.IPriceLimitService;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PriceLimitServiceImpl
implements IPriceLimitService {
    @Autowired
    private IBItemPriceService ibItemPriceService;

    @Override
    public PriceAddOrModifyRespDto checkPriceLimitByOrder(SubmitOrderReqDto submitOrderReqDto) {
        PriceBeanReqDto PriceBeanReqDto2 = new PriceBeanReqDto();
        CustomerConditionModifyReqDto customerConditionModifyReqDto = new CustomerConditionModifyReqDto();
        ArrayList<String> customerIds = new ArrayList<String>();
        customerIds.add(String.valueOf(submitOrderReqDto.getCustomerId()));
        customerConditionModifyReqDto.setCustomerIds(customerIds);
        PriceBeanReqDto2.setCustomerConditionReqDto(customerConditionModifyReqDto);
        ArrayList<PriceItemModifyReqDto> priceItemModifyReqDtos = new ArrayList<PriceItemModifyReqDto>();
        for (OrderItemInfoDto orderItemInfoDto : submitOrderReqDto.getItemList()) {
            PriceItemModifyReqDto priceItemModifyReqDto = new PriceItemModifyReqDto();
            CubeBeanUtils.copyProperties((Object)priceItemModifyReqDto, (Object)orderItemInfoDto, (String[])new String[0]);
            priceItemModifyReqDto.setItemPrice(orderItemInfoDto.getRetailPrice());
            if (CollectionUtil.isNotEmpty((Collection)orderItemInfoDto.getLadderPrices())) {
                ArrayList<PriceAndNumLimitDto> priceNumLimitList = new ArrayList<PriceAndNumLimitDto>();
                for (ItemPriceExtDto.LadderPrice price : orderItemInfoDto.getLadderPrices()) {
                    PriceAndNumLimitDto priceAndNumLimitDto = new PriceAndNumLimitDto();
                    priceAndNumLimitDto.setItemPrice(price.getPrice());
                    priceAndNumLimitDto.setLowerLimit(price.getLower());
                    priceAndNumLimitDto.setUpperLimit(price.getUpper());
                    priceNumLimitList.add(priceAndNumLimitDto);
                }
            }
            priceItemModifyReqDtos.add(priceItemModifyReqDto);
        }
        PriceBeanReqDto2.setPriceItemReqDtos(priceItemModifyReqDtos);
        PriceAddOrModifyRespDto priceAddOrModifyRespDto = (PriceAddOrModifyRespDto)RestResponseHelper.extractData((RestResponse)this.ibItemPriceService.queryPriceLimit(PriceBeanReqDto2));
        return priceAddOrModifyRespDto;
    }
}

