/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.IControlItemAreaApi;
import com.dtyunxi.tcbj.center.control.api.IControlItemCustomerApi;
import com.dtyunxi.tcbj.center.control.api.IControlItemOrderApi;
import com.dtyunxi.tcbj.center.control.api.IControlOptApi;
import com.dtyunxi.tcbj.center.control.api.dto.constant.ControlTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OrderAmountCalculateTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.SharePurchaseRestrictionEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.AmountControlReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizOrderItemReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemCustomerReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemOrderReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlBaseReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlInventoryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerGiftAmountReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlToCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountConfigRespDto;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlItemCustomerQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlItemQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlOrderQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlItemAmountConfigQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjAvilableReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjAvilableRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.module.trade.api.dto.request.GiftInfoReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.CancelOrderForControlReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderBaseReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderItemBaseReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.SubmitOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.enums.ControlTypeExcpCodeEnum;
import com.dtyunxi.yundt.module.trade.biz.IControlService;
import com.dtyunxi.yundt.module.trade.biz.impl.CommonServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ControlServiceImpl
implements IControlService {
    private static Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrderQueryApi orderQueryApi;
    @Resource
    private IControlOrderQueryApi controlOrderQueryApi;
    @Resource
    private IControlItemQueryApi controlItemQueryApi;
    @Resource
    private IControlItemCustomerQueryApi controlItemCustomerQueryApi;
    @Resource
    private IControlItemAreaApi controlItemAreaApi;
    @Resource
    private IControlItemCustomerApi controlItemCustomerApi;
    @Resource
    private IControlInventoryQueryApi controlInventoryQueryApi;
    @Resource
    private ITcbjInventoryApi inventoryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private IControlOptApi controlOptApi;
    @Resource
    private ITrControlItemAmountConfigQueryApi amountConfigQueryApi;
    @Resource
    private IControlItemOrderApi controlItemOrderApi;
    @Resource
    protected ICacheService cacheService;
    static String customerFirstPlaceTime = "customerFirstPlaceTime";
    static String commonGroup = "commonGroup:";

    private Date queryFirstPlaceOrderByCustomerIdCache(Long customerId) {
        Date firstPlaceTime = (Date)this.cacheService.getCache(commonGroup, customerFirstPlaceTime, Date.class);
        if (Objects.isNull(firstPlaceTime) && Objects.nonNull(firstPlaceTime = (Date)RestResponseHelper.extractData((RestResponse)this.orderQueryApi.getFirstPlaceOrderByCustomerId(customerId)))) {
            this.cacheService.setCache(commonGroup, customerFirstPlaceTime, (Object)firstPlaceTime);
        }
        return firstPlaceTime;
    }

    @Override
    public String checkControlRule(OrderBaseReqDto orderReqDto, Long orgId, boolean ignoreWarn, boolean placeOrder) {
        logger.info("\u63d0\u4ea4\u8ba2\u5355\uff0c\u7ba1\u63a7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)orderReqDto));
        if (ignoreWarn) {
            logger.info("\u8be5\u7ba1\u63a7\u89c4\u5219\u662f\u63d0\u9192\uff0c\u4e0d\u8fdb\u884c\u7ba1\u63a7");
            return null;
        }
        List<Long> customerIdList = Collections.singletonList(orderReqDto.getCustomerId());
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIdList));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            logger.info("\u8be5\u7ba1\u63a7\u89c4\u5219\u5ba2\u6237{}\u4e0d\u5b58\u5728", (Object)orderReqDto.getCustomerId());
            return null;
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        List regionCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(regionCodeList)) {
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes(regionCodeList);
            List<String> parentAreaCodeList = (List<String>)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto));
            if (CollectionUtils.isNotEmpty((Collection)parentAreaCodeList)) {
                parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
            }
            this.checkOrderControl(customerRespDto, orderReqDto, orgId, placeOrder, parentAreaCodeList);
            this.checkItemControl(customerRespDto, orderReqDto, orgId, placeOrder, parentAreaCodeList);
        }
        return null;
    }

    private boolean checkCustomerByFirstPlaceOrder(Long customerId) {
        Date firstPlaceTime = this.queryFirstPlaceOrderByCustomerIdCache(customerId);
        if (firstPlaceTime == null) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        if (calendar.getTime().compareTo(firstPlaceTime) < 0) {
            return true;
        }
        logger.info("\u5f53\u524d\u65f6\u95f4\u8ddd\u79bb\u9996\u8d2d\u65f6\u95f4\u8d85\u8fc73\u4e2a\u6708\uff0c\u8fdb\u884c\u7ba1\u63a7\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
        return false;
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        System.out.println(calendar.getTime());
    }

    @Override
    public String checkOrderControl(CustomerRespDto customerRespDto, OrderBaseReqDto orderReqDto, Long orgId, boolean placeOrder, List<String> areaCodeList) {
        logger.info("\u8ba2\u5355\u7ba1\u63a7\u5f00\u59cb========\u300b");
        CustomerControlBaseReqDto controlBaseReqDto = new CustomerControlBaseReqDto();
        controlBaseReqDto.setCustomerId(customerRespDto.getId());
        controlBaseReqDto.setOrgId(orgId);
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            controlBaseReqDto.setCustomerAreaCodeList(areaCodeList);
        }
        logger.info("\u8ba2\u5355\u7ba1\u63a7\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)controlBaseReqDto));
        ControlOrderRespDto controlOrderRespDto = (ControlOrderRespDto)RestResponseHelper.extractData((RestResponse)this.controlOrderQueryApi.queryRuleByCustomer(controlBaseReqDto));
        if (null != controlOrderRespDto) {
            if (placeOrder && ControlTypeEnum.CONTROL.getType().equals(controlOrderRespDto.getControlType())) {
                return null;
            }
            if (!placeOrder && ControlTypeEnum.WARNING.getType().equals(controlOrderRespDto.getControlType())) {
                return null;
            }
            if (OrderAmountCalculateTypeEnum.PAYMENT_AMOUNT.getType().equals(controlOrderRespDto.getCalculateType()) && orderReqDto.getPayAmount().subtract(orderReqDto.getDeductionAmount()).compareTo(controlOrderRespDto.getMinAmount()) < 0) {
                String exception = String.format("%.2f\u5143\u8d77\u8ba2\uff0c\u5f53\u524d\u91d1\u989d%.2f\u5143\uff0c\u8fd8\u5dee%.2f\u5143", controlOrderRespDto.getMinAmount(), orderReqDto.getPayAmount().subtract(orderReqDto.getDeductionAmount()), controlOrderRespDto.getMinAmount().subtract(orderReqDto.getPayAmount().subtract(orderReqDto.getDeductionAmount())));
                if (placeOrder) {
                    return exception;
                }
                throw new BizException(exception);
            }
            if (OrderAmountCalculateTypeEnum.SUPPLY_AMOUNT.getType().equals(controlOrderRespDto.getCalculateType()) && orderReqDto.getTotalAmount().add(orderReqDto.getTotalGiftOrigAmount()).compareTo(controlOrderRespDto.getMinAmount()) < 0) {
                String exception = String.format("%.2f\u5143\u8d77\u8ba2\uff0c\u5f53\u524d\u91d1\u989d%.2f\u5143\uff0c\u8fd8\u5dee%.2f\u5143", controlOrderRespDto.getMinAmount(), orderReqDto.getTotalAmount(), controlOrderRespDto.getMinAmount().subtract(orderReqDto.getTotalAmount().add(orderReqDto.getTotalGiftOrigAmount())));
                if (placeOrder) {
                    return exception;
                }
                throw new BizException(exception);
            }
        }
        logger.info("\u8ba2\u5355\u7ba1\u63a7\u7ed3\u675f========\u300b");
        return null;
    }

    @Override
    public RestResponse<Void> checkAmountAndGiftControl(Long orgId, SubmitOrderReqDto orderReqDto) {
        Long customerId = orderReqDto.getCustomerId();
        logger.info("\u83b7\u53d6\u5230\u7684\u5ba2\u6237orgId:{}", (Object)orgId);
        List<Long> customerIdList = Collections.singletonList(customerId);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIdList));
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        List regionCodeList = customerRespDto.getRegionCodeList();
        List<Object> parentAreaCodeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)regionCodeList) && CollectionUtils.isNotEmpty(regionCodeList = regionCodeList.stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList()))) {
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes(regionCodeList);
            parentAreaCodeList = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto));
            if (CollectionUtils.isNotEmpty((Collection)parentAreaCodeList)) {
                parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
            }
        }
        RestResponse<Void> restResponse = this.checkAmountControl(customerRespDto, orgId, orderReqDto);
        logger.info("\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u8fd4\u56de\u54cd\u5e94\u4fe1\u606f:{}", (Object)JSON.toJSONString(restResponse));
        if (restResponse != null && !"0".equals(restResponse.getResultCode())) {
            return restResponse;
        }
        restResponse = this.checkGiftControl(customerRespDto, orgId, orderReqDto, parentAreaCodeList);
        return restResponse;
    }

    @Override
    public void cancelOrder(CancelOrderForControlReqDto reqDto) {
        logger.info("\u3010\u7ba1\u63a7\u64cd\u4f5c\u3011\u5ba2\u6237({})\u8ba2\u5355({})\u53d6\u6d88\u8ba2\u5355\u64cd\u4f5c\uff01", (Object)reqDto.getCustomerId(), (Object)reqDto.getOrderNo());
        CustomerExtDetailRespDto customerRespDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(reqDto.getCustomerId()));
        AmountControlReqDto amountControlReqDto = new AmountControlReqDto();
        amountControlReqDto.setOrderNo(reqDto.getOrderNo());
        amountControlReqDto.setCustomerCode(customerRespDto.getCode());
        RestResponse restResponse = this.controlOptApi.cancelOrderOfControl(amountControlReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    @Override
    public void returnProduct(CancelOrderForControlReqDto reqDto) {
        logger.info("\u3010\u7ba1\u63a7\u64cd\u4f5c\u3011\u5ba2\u6237({})\u8ba2\u5355({})\u53d1\u8d77\u9000\u8d27\u64cd\u4f5c\uff01", (Object)reqDto.getCustomerId(), (Object)reqDto.getOrderNo());
        CustomerExtDetailRespDto customerRespDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(reqDto.getCustomerId()));
        AmountControlReqDto amountControlReqDto = new AmountControlReqDto();
        amountControlReqDto.setOrderNo(reqDto.getOrderNo());
        amountControlReqDto.setCustomerCode(customerRespDto.getCode());
        RestResponse restResponse = this.controlOptApi.returnProductOfControl(amountControlReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    @Override
    public void unfreezeAmountForGift(String orderNo) {
        logger.info("\u3010\u7ba1\u63a7\u64cd\u4f5c\u3011\u8ba2\u5355({})\u53d1\u8d27\uff0c\u89e3\u51bb\u91d1\u989d\uff01", (Object)orderNo);
        RestResponse restResponse = this.controlOptApi.unfreezeAmountForGift(orderNo);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    private RestResponse<Void> checkGiftControl(CustomerRespDto customerRespDto, Long orgId, SubmitOrderReqDto submitOrderReqDto, List<String> parentAreaCodeList) {
        OrderReqDto orderReqDto = Optional.ofNullable(submitOrderReqDto.getOrderReqDto()).orElse(new OrderReqDto());
        ArrayList itemReqDtos = Lists.newArrayList();
        ArrayList giftReqDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)orderReqDto.getOrderItems())) {
            for (TradeItemReqDto orderItemInfoDto : orderReqDto.getOrderItems()) {
                BizOrderItemReqDto bizOrderItemReqDto = new BizOrderItemReqDto();
                bizOrderItemReqDto.setItemNum(new BigDecimal(orderItemInfoDto.getItemNum()));
                bizOrderItemReqDto.setItemId(Long.valueOf(orderItemInfoDto.getItemSerial()));
                bizOrderItemReqDto.setItemCode(orderItemInfoDto.getItemCode());
                bizOrderItemReqDto.setItemName(orderItemInfoDto.getItemName());
                bizOrderItemReqDto.setOriginalPrice(orderItemInfoDto.getItemOrigPrice());
                bizOrderItemReqDto.setSubType(orderItemInfoDto.getSubType());
                if (orderItemInfoDto.getSubType() == 2) {
                    giftReqDtos.add(bizOrderItemReqDto);
                    continue;
                }
                itemReqDtos.add(bizOrderItemReqDto);
            }
        }
        CustomerGiftAmountReqDto customerGiftAmountReqDto = new CustomerGiftAmountReqDto();
        customerGiftAmountReqDto.setOrgId(orgId);
        customerGiftAmountReqDto.setCustomerCode(customerRespDto.getCode());
        customerGiftAmountReqDto.setCustomerName(customerRespDto.getName());
        customerGiftAmountReqDto.setAreaCodeList(parentAreaCodeList);
        customerGiftAmountReqDto.setItemList((List)itemReqDtos);
        customerGiftAmountReqDto.setGiftList((List)giftReqDtos);
        customerGiftAmountReqDto.setOrderNo(orderReqDto.getOrderNo());
        logger.info("\u63d0\u4ea4\u8ba2\u5355\u6821\u9a8c\u8d60\u54c1\u989d\u5ea6\u5165\u53c2==>checkGiftAmountControl:{}", (Object)JSON.toJSONString((Object)customerGiftAmountReqDto));
        RestResponse restResponse = this.controlOptApi.checkGiftAmountControl(customerGiftAmountReqDto);
        return restResponse;
    }

    private RestResponse<Void> checkAmountControl(CustomerRespDto customerRespDto, Long orgId, SubmitOrderReqDto submitOrderReqDto) {
        RestResponse respDtoRestResponse = this.amountConfigQueryApi.queryByOrgId(orgId);
        TrControlItemAmountConfigRespDto amountConfigRespDto = (TrControlItemAmountConfigRespDto)RestResponseHelper.extractData((RestResponse)respDtoRestResponse);
        if (amountConfigRespDto == null) {
            logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5ba2\u6237({})\u6240\u5c5e\u7ec4\u7ec7({})\u7684\u8ba2\u8d27\u989d\u5ea6\u89c4\u5219\u914d\u7f6e\u5c1a\u672a\u5f00\u542f", (Object)customerRespDto.getCode(), (Object)orgId);
            return RestResponse.VOID;
        }
        OrderReqDto orderReqDto = submitOrderReqDto.getOrderReqDto();
        GiftInfoReqDto giftInfoReqDto = submitOrderReqDto.getGiftInfoReqDto();
        String deductionScope = amountConfigRespDto.getOrderDeductionScope();
        List scopeList = JSON.parseArray((String)deductionScope, Integer.class);
        if (CollectionUtils.isEmpty((Collection)scopeList)) {
            logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5546\u54c1\u7ba1\u63a7\u8303\u56f4\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)orderReqDto.getOrderItems())) {
            logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u6ca1\u6709\u5546\u54c1\u88ab\u7ba1\u63a7\uff01");
            return RestResponse.VOID;
        }
        ArrayList controlItemList = Lists.newArrayList();
        List itemList = Optional.ofNullable(orderReqDto.getOrderItems()).orElseGet(Collections::emptyList).stream().filter(orderItem -> scopeList.contains(orderItem.getSubType())).collect(Collectors.toList());
        logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5546\u54c1\u4fe1\u606f\u5927\u5c0f:{}", (Object)itemList.size());
        if (CollectionUtils.isNotEmpty(itemList)) {
            controlItemList.addAll(itemList);
        }
        if (CollectionUtils.isEmpty((Collection)controlItemList)) {
            logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u6ca1\u6709\u5546\u54c1\u88ab\u7ba1\u63a7\uff01");
            return RestResponse.VOID;
        }
        boolean useRebateAmount = orderReqDto.getTotalRebateAmount() != null && BigDecimal.ZERO.compareTo(orderReqDto.getTotalRebateAmount()) < 0;
        BigDecimal deductionAmount = BigDecimal.ZERO;
        BigDecimal supplyTotalAmount = BigDecimal.ZERO;
        BigDecimal paymentAmount = BigDecimal.ZERO;
        logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011controlItemList=={}", (Object)JSON.toJSONString((Object)controlItemList));
        for (TradeItemReqDto orderItemInfoDto2 : controlItemList) {
            Object supplyAmount = orderItemInfoDto2.getItemOrigPrice().multiply(new BigDecimal(orderItemInfoDto2.getItemNum()));
            if (Objects.nonNull(orderItemInfoDto2.getItemMarketPrice())) {
                supplyAmount = orderItemInfoDto2.getItemMarketPrice().multiply(new BigDecimal(orderItemInfoDto2.getItemNum()));
            }
            logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5546\u54c1code[{}]\u4f9b\u8d27\u4ef7\u4e3a\uff1a{}", (Object)orderItemInfoDto2.getItemCode(), supplyAmount);
            supplyTotalAmount = supplyTotalAmount.add((BigDecimal)supplyAmount);
            if (orderItemInfoDto2.getGift() != 0) continue;
            paymentAmount = paymentAmount.add((BigDecimal)supplyAmount);
        }
        logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u603b\u7684\u4f9b\u8d27\u4ef7\u4e3a\uff1a{}", (Object)supplyTotalAmount);
        logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u603b\u7684\u652f\u4ed8\u4ef7\u4e3a\uff1a{}", (Object)paymentAmount);
        Map<Object, Object> giftItemMap = Maps.newHashMap();
        if (giftInfoReqDto != null) {
            giftItemMap = Optional.ofNullable(giftInfoReqDto.getList()).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(TradeItemRespDto::getItemCode, Function.identity(), (v1, v2) -> v2));
        }
        BigDecimal deductTotalAmount = BigDecimal.ZERO;
        for (TradeItemReqDto orderItemInfoDto3 : controlItemList) {
            TradeItemRespDto giftItemRespDto = (TradeItemRespDto)giftItemMap.get(orderItemInfoDto3.getItemCode());
            BigDecimal discountAmount = BigDecimal.ZERO;
            if (giftItemRespDto != null) {
                discountAmount = Optional.ofNullable(giftItemRespDto.getDiscountAmount()).orElse(BigDecimal.ZERO);
                logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u8d60\u54c1\u62b5\u6263\u989d\u5ea6\u91d1\u989d:{}", (Object)discountAmount);
            }
            BigDecimal rebateAmount = BigDecimal.ZERO;
            if (useRebateAmount) {
                rebateAmount = Optional.ofNullable(orderItemInfoDto3.getRebateAmount()).orElse(BigDecimal.ZERO);
                logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u62b5\u6263\u989d\u5ea6\u91d1\u989d:{}", (Object)rebateAmount);
            }
            BigDecimal discountTotalAmount = Optional.ofNullable(orderItemInfoDto3.getDiscountTotalAmount()).orElse(BigDecimal.ZERO);
            logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011discountTotalAmount:{}", (Object)discountTotalAmount);
            BigDecimal deductAmount = discountTotalAmount.add(rebateAmount).add(discountAmount);
            deductTotalAmount = deductTotalAmount.add(deductAmount);
            logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011deductTotalAmount:{}", (Object)deductTotalAmount);
        }
        deductTotalAmount = deductTotalAmount.add(deductionAmount);
        logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u603b\u7684\u62b5\u6263\u3001\u4f18\u60e0\u4ef7\u4e3a\uff1a{}", (Object)deductTotalAmount);
        List itemReqDtos = itemList.stream().map(orderItemInfoDto -> {
            BizOrderItemReqDto bizOrderItemReqDto = new BizOrderItemReqDto();
            bizOrderItemReqDto.setItemNum(new BigDecimal(orderItemInfoDto.getItemNum()));
            bizOrderItemReqDto.setItemId(Long.valueOf(orderItemInfoDto.getItemSerial()));
            bizOrderItemReqDto.setItemCode(orderItemInfoDto.getItemCode());
            bizOrderItemReqDto.setItemName(orderItemInfoDto.getItemName());
            bizOrderItemReqDto.setOriginalPrice(orderItemInfoDto.getItemOrigPrice());
            return bizOrderItemReqDto;
        }).collect(Collectors.toList());
        List giftReqDtos = itemList.stream().filter(e -> e.getSubType() == 2).map(orderItemInfoDto -> {
            BizOrderItemReqDto bizOrderItemReqDto = new BizOrderItemReqDto();
            bizOrderItemReqDto.setItemNum(new BigDecimal(orderItemInfoDto.getItemNum()));
            bizOrderItemReqDto.setItemId(Long.valueOf(orderItemInfoDto.getItemSerial()));
            bizOrderItemReqDto.setItemCode(orderItemInfoDto.getItemCode());
            bizOrderItemReqDto.setItemName(orderItemInfoDto.getItemName());
            bizOrderItemReqDto.setOriginalPrice(orderItemInfoDto.getItemOrigPrice());
            return bizOrderItemReqDto;
        }).collect(Collectors.toList());
        AmountControlReqDto amountControlReqDto = new AmountControlReqDto();
        amountControlReqDto.setCustomerCode(customerRespDto.getCode());
        amountControlReqDto.setCustomerName(customerRespDto.getName());
        amountControlReqDto.setOrderNo(orderReqDto.getOrderNo());
        amountControlReqDto.setOrgId(orgId);
        amountControlReqDto.setPaymentAmount(paymentAmount.subtract(deductTotalAmount));
        amountControlReqDto.setSupplyAmount(supplyTotalAmount);
        amountControlReqDto.setGiftList(giftReqDtos);
        amountControlReqDto.setItemList(itemReqDtos);
        RestResponse restResponse = this.controlOptApi.checkAmountControl(amountControlReqDto);
        return restResponse;
    }

    @Override
    public String checkItemControl(CustomerRespDto customerRespDto, OrderBaseReqDto orderReqDto, Long orgId, boolean placeOrder, List<String> areaCodeList) {
        logger.info("\u5355\u54c1\u7ba1\u63a7\u5f00\u59cb========\u300b");
        List<Long> itemIdList = orderReqDto.getItemList().stream().map(OrderItemBaseReqDto::getItemId).collect(Collectors.toList());
        Map<Long, OrderItemBaseReqDto> itemIdToMap = orderReqDto.getItemList().stream().collect(Collectors.toMap(OrderItemBaseReqDto::getItemId, Function.identity(), (old, now) -> {
            old.setItemNum(Integer.valueOf(old.getItemNum() + now.getItemNum()));
            return old;
        }));
        ArrayList verifyResult = Lists.newArrayList();
        CustomerControlBaseReqDto controlBaseReqDto = new CustomerControlBaseReqDto();
        controlBaseReqDto.setCustomerId(customerRespDto.getId());
        controlBaseReqDto.setOrgId(orgId);
        controlBaseReqDto.setItemIdList(itemIdList);
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            controlBaseReqDto.setCustomerAreaCodeList(areaCodeList);
        }
        logger.info("\u5355\u54c1\u7ba1\u63a7\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)controlBaseReqDto));
        ControlToCustomerRespDto controlItemRespDtos = (ControlToCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.controlItemQueryApi.queryRuleByCustomer(controlBaseReqDto));
        logger.info("\u5355\u54c1\u7ba1\u63a7\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)controlItemRespDtos));
        if (null != controlItemRespDtos && CollectionUtils.isNotEmpty((Collection)controlItemRespDtos.getControlToCustomerRules())) {
            for (ControlItemRespDto controlItemRespDto : controlItemRespDtos.getControlToCustomerRules()) {
                if (null == controlItemRespDto || !Objects.nonNull(controlItemRespDto.getId())) continue;
                if (CollectionUtils.isNotEmpty((Collection)controlItemRespDto.getAreaList())) {
                    verifyResult.add(this.verifyArea(controlItemRespDto, customerRespDto, orderReqDto, itemIdToMap, itemIdList));
                }
                if (!CollectionUtils.isNotEmpty((Collection)controlItemRespDto.getCustomerList())) continue;
                verifyResult.add(this.verifyCustomer(controlItemRespDto, customerRespDto, orderReqDto, itemIdToMap, itemIdList));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)verifyResult)) {
            Optional<String> verify = verifyResult.stream().filter(c -> StringUtils.isNotBlank((String)c)).findAny();
            return verify.isPresent() ? verify.get() : null;
        }
        logger.info("\u5355\u54c1\u7ba1\u63a7\u7ed3\u675f========\u300b");
        return null;
    }

    public String verifyArea(ControlItemRespDto controlItemRespDto, CustomerRespDto customerRespDto, OrderBaseReqDto orderReqDto, Map<Long, OrderItemBaseReqDto> itemIdToMap, List<Long> itemIdList) {
        logger.info("\u5355\u54c1\u533a\u57df\u7ba1\u63a7");
        boolean onFirstPlaceOrderTime = this.checkCustomerByFirstPlaceOrder(orderReqDto.getCustomerId());
        if (onFirstPlaceOrderTime) {
            logger.info("\u7528\u6237\u9996\u8d2d\u8ddd\u79bb\u5f53\u524d\u65f6\u95f4\u672a\u8d85\u8fc790\u5929\uff0c\u4e0d\u8fdb\u884c\u7ba1\u63a7\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
            return null;
        }
        List<Object> areaList = controlItemRespDto.getAreaList().stream().filter(controlArea -> customerRespDto.getRegionCodeList().contains(controlArea.getAreaCode()) && itemIdToMap.containsKey(controlArea.getItemId())).collect(Collectors.toList());
        Map<String, List<ControlItemAreaRespDto>> areaItemMap = controlItemRespDto.getAreaList().stream().collect(Collectors.groupingBy(ControlItemAreaRespDto::getAreaCode));
        logger.info("\u6307\u5b9a\u7684\u5ba2\u6237\u533a\u57df\u5546\u54c1\u7ba1\u63a7:{}", (Object)JSON.toJSONString(areaItemMap));
        String areaCode = "";
        if (CollectionUtils.isNotEmpty(areaList)) {
            areaCode = ((ControlItemAreaRespDto)areaList.get(0)).getAreaCode();
        } else {
            logger.error("\u6307\u5b9a\u5ba2\u6237\u533a\u57df-\u8be5\u5546\u54c1\u4e0d\u5b58\u5728\u6e05\u5355\u4e2d: {}", (Object)JSON.toJSONString((Object)customerRespDto.getRegionCodeList()));
            areaCode = ((ControlItemAreaRespDto)controlItemRespDto.getAreaList().get(0)).getAreaCode();
        }
        areaList = areaItemMap.get(areaCode);
        for (ControlItemAreaRespDto controlItemAreaRespDto : areaList) {
            OrderItemBaseReqDto tradeItemReqDto = itemIdToMap.get(controlItemAreaRespDto.getItemId());
            if (null == tradeItemReqDto) {
                logger.error("itemIdToMap: {}, \u6307\u5b9a\u533a\u57df\u5546\u54c1\u7ba1\u63a7\u89c4\u5219\u5f02\u5e38\u4e3a\u7a7a", (Object)JSON.toJSONString(itemIdToMap));
                continue;
            }
            Integer purchasedCount = controlItemAreaRespDto.getPurchasedCount() == null ? 0 : controlItemAreaRespDto.getPurchasedCount();
            if (controlItemAreaRespDto.getLimitCount().compareTo(tradeItemReqDto.getItemNum() + purchasedCount) >= 0) continue;
            String exception = String.format("\u8be5\u8ba2\u5355\u8d2d\u4e70\u7684\u5546\u54c1%s\u8d85\u8fc7\u5355\u54c1\u7ba1\u63a7\u7684\u9650\u8d2d\u91cf\uff0c\u9650\u8d2d\u91cf\u4e3a%d,\u5f53\u524d\u5df2\u7d2f\u8ba1\u8d2d\u4e70\u6570\u91cf%d,\u672c\u6b21\u8d2d\u4e70\u6570\u91cf%d", controlItemAreaRespDto.getItemCode(), controlItemAreaRespDto.getLimitCount(), purchasedCount, tradeItemReqDto.getItemNum());
            if (ControlTypeEnum.WARNING.getType().equals(controlItemRespDto.getControlType())) {
                logger.info("\u63d0\u9192\u5185\u5bb9:{}", (Object)exception);
                return exception;
            }
            throw new BizException(exception);
        }
        Map ControlItemAreaMapToItemId = areaList.stream().collect(Collectors.toMap(ControlItemAreaRespDto::getItemId, Function.identity(), (old, now) -> old));
        ArrayList<ControlItemAreaRespDto> arrayList = new ArrayList<ControlItemAreaRespDto>();
        ControlItemAreaMapToItemId.forEach((itemId, ControlItemAreaRespDto2) -> {
            if (itemIdList.contains(itemId)) {
                controlItemAreaRespDtos.add((ControlItemAreaRespDto)ControlItemAreaRespDto2);
            }
        });
        List itemIds = arrayList.stream().map(ControlItemAreaRespDto::getItemId).collect(Collectors.toList());
        if (SharePurchaseRestrictionEnum.NO_SHARE.getType().equals(controlItemRespDto.getSharePurchaseRestriction())) {
            logger.info("\u63d0\u4ea4\u8ba2\u5355\u66f4\u65b0\u5355\u54c1\u7ba1\u63a7\u533a\u57df\u975e\u5171\u4eab\u67e5\u8be2\u5165\u53c2:minimumAreaCode={},itemIds={}", (Object)areaCode, JSON.toJSON(itemIds));
            List controlItemCustomerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.controlItemCustomerQueryApi.queryItemCustomerByAreaAndItemIds(areaCode, itemIds, controlItemRespDto.getId()));
            logger.info("\u63d0\u4ea4\u8ba2\u5355\u66f4\u65b0\u5355\u54c1\u7ba1\u63a7\u533a\u57df\u975e\u5171\u4eab\u67e5\u8be2\u54cd\u5e94:{}", JSON.toJSON((Object)controlItemCustomerRespDtos));
            ArrayList<ControlItemCustomerReqDto> insertControlItemCustomerReqDtos = new ArrayList<ControlItemCustomerReqDto>();
            if (CollectionUtils.isEmpty((Collection)controlItemCustomerRespDtos)) {
                this.buildInsertItemCustomerReqDtos(itemIdToMap, orderReqDto.getCustomerId(), customerRespDto, arrayList, insertControlItemCustomerReqDtos, orderReqDto.getOrderNo());
            } else {
                List existItemIds = controlItemCustomerRespDtos.stream().map(ControlItemCustomerRespDto::getItemId).collect(Collectors.toList());
                itemIdList.forEach(itemId -> {
                    if (!existItemIds.contains(itemId)) {
                        this.buildInsertItemCustomerReqDtos(itemIdToMap, orderReqDto.getCustomerId(), customerRespDto, controlItemAreaRespDtos, insertControlItemCustomerReqDtos, orderReqDto.getOrderNo());
                    }
                });
                controlItemCustomerRespDtos.sort(Comparator.comparing(ControlItemCustomerRespDto::getId));
                logger.info("\u63d0\u4ea4\u8ba2\u5355\u66f4\u65b0\u5355\u54c1\u7ba1\u63a7\u533a\u57df\u975e\u5171\u4eab\u66f4\u65b0\u6307\u5b9a\u5ba2\u6237\u6570\u636e:{}");
                this.updateCustomerInventory(itemIdToMap, controlItemCustomerRespDtos, orderReqDto.getOrderNo());
            }
            if (CollectionUtils.isNotEmpty(insertControlItemCustomerReqDtos)) {
                logger.info("\u63d0\u4ea4\u8ba2\u5355\u66f4\u65b0\u5355\u54c1\u7ba1\u63a7\u533a\u57df\u975e\u5171\u4eab\u65b0\u589e\u6307\u5b9a\u5ba2\u6237\u6570\u636e:{}", (Object)JSON.toJSONString(insertControlItemCustomerReqDtos));
                RestResponseHelper.checkOrThrow((RestResponse)this.controlItemCustomerApi.insertBatch(insertControlItemCustomerReqDtos));
            }
        } else {
            arrayList.sort(Comparator.comparing(ControlItemAreaRespDto::getId));
            ArrayList controlItemOrderReqDtos = Lists.newArrayList();
            for (ControlItemAreaRespDto controlItemAreaRespDto : arrayList) {
                OrderItemBaseReqDto tradeItemReqDto = itemIdToMap.get(controlItemAreaRespDto.getItemId());
                logger.info("\u63d0\u4ea4\u8ba2\u5355\u66f4\u65b0\u5355\u54c1\u7ba1\u63a7\u533a\u57df\u5165\u53c2:itemNum={},id={}", (Object)tradeItemReqDto.getItemNum(), (Object)controlItemAreaRespDto.getId());
                Integer update = (Integer)RestResponseHelper.extractData((RestResponse)this.controlItemAreaApi.modifyPurchasedCount(tradeItemReqDto.getItemNum(), controlItemAreaRespDto.getId()));
                if (null == update) {
                    Integer purchasedCount = controlItemAreaRespDto.getPurchasedCount() == null ? 0 : controlItemAreaRespDto.getPurchasedCount();
                    String exception = String.format("\u8be5\u8ba2\u5355\u8d2d\u4e70\u7684\u5546\u54c1%s\u8d85\u8fc7\u5355\u54c1\u7ba1\u63a7\u7684\u9650\u8d2d\u91cf\uff0c\u9650\u8d2d\u91cf\u4e3a%d,\u5f53\u524d\u7d2f\u8ba1\u8d2d\u4e70\u6570\u91cf%d,\u5f53\u524d\u7d2f\u8ba1\u8d2d\u4e70\u6570\u91cf%d", tradeItemReqDto.getItemCode(), controlItemAreaRespDto.getLimitCount(), purchasedCount, tradeItemReqDto.getItemNum());
                    throw new BizException(exception);
                }
                ControlItemOrderReqDto addROrder = new ControlItemOrderReqDto();
                addROrder.setTradeNo(orderReqDto.getOrderNo());
                addROrder.setRuleItemId(controlItemAreaRespDto.getId());
                addROrder.setItemNum(new BigDecimal(tradeItemReqDto.getItemNum()));
                addROrder.setRuleRangeType("area");
                controlItemOrderReqDtos.add(addROrder);
            }
            this.controlItemOrderApi.addControlItemOrderBatch((List)controlItemOrderReqDtos);
        }
        return null;
    }

    public String verifyCustomer(ControlItemRespDto controlItemRespDto, CustomerRespDto customerRespDto, OrderBaseReqDto orderReqDto, Map<Long, OrderItemBaseReqDto> itemIdToMap, List<Long> itemIdList) {
        logger.info("\u5355\u54c1\u6307\u5b9a\u5ba2\u6237\u7ba1\u63a7");
        boolean onFirstPlaceOrderTime = this.checkCustomerByFirstPlaceOrder(orderReqDto.getCustomerId());
        for (ControlItemCustomerRespDto controlItemCustomerRespDto : controlItemRespDto.getCustomerList()) {
            if (Objects.equals(controlItemCustomerRespDto.getCalculateType(), 0)) {
                logger.info("\u6307\u5b9a\u5ba2\u6237\u56fa\u5b9a\u9650\u8d2d\u91cf\u4e0d\u9700\u8981\u9650\u523690\u5929\u4e0b\u5355");
            } else if (onFirstPlaceOrderTime) {
                logger.info("\u7528\u6237\u9996\u8d2d\u8ddd\u79bb\u5f53\u524d\u65f6\u95f4\u672a\u8d85\u8fc790\u5929\uff0c\u4e0d\u8fdb\u884c\u7ba1\u63a7\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
                return null;
            }
            OrderItemBaseReqDto tradeItemReqDto = itemIdToMap.get(controlItemCustomerRespDto.getItemId());
            if (null == tradeItemReqDto) {
                logger.error("itemIdToMap: {}, \u6307\u5b9a\u5ba2\u6237\u5546\u54c1\u7ba1\u63a7\u89c4\u5219\u5f02\u5e38\u4e3a\u7a7a", (Object)JSON.toJSONString(itemIdToMap));
                continue;
            }
            Integer purchasedCount = controlItemCustomerRespDto.getPurchasedCount() == null ? 0 : controlItemCustomerRespDto.getPurchasedCount();
            if (controlItemCustomerRespDto.getLimitCount().compareTo(tradeItemReqDto.getItemNum() + purchasedCount) >= 0) continue;
            String exception = String.format("\u8be5\u8ba2\u5355\u8d2d\u4e70\u7684\u5546\u54c1%s\u8d85\u8fc7\u5355\u54c1\u7ba1\u63a7\u7684\u9650\u8d2d\u91cf\uff0c\u9650\u8d2d\u91cf\u4e3a%d,\u5f53\u524d\u7d2f\u8ba1\u8d2d\u4e70\u6570\u91cf%d", controlItemCustomerRespDto.getItemCode(), controlItemCustomerRespDto.getLimitCount(), purchasedCount);
            if (ControlTypeEnum.WARNING.getType().equals(controlItemRespDto.getControlType())) {
                logger.info("\u63d0\u9192\u5185\u5bb9:{}", (Object)exception);
                return exception;
            }
            throw new BizException(exception);
        }
        List<ControlItemCustomerRespDto> controlItemCustomerRespDtos = controlItemRespDto.getCustomerList().stream().filter(customer -> itemIdList.contains(customer.getItemId())).collect(Collectors.toList());
        this.updateCustomerInventory(itemIdToMap, controlItemCustomerRespDtos, orderReqDto.getOrderNo());
        return null;
    }

    @Override
    public RestResponse<Void> checkInventoryControl(OrderReqDto orderReqDto, Long orgId) {
        Long customerId = ParamConverter.convertToLong((Object)orderReqDto.getCustomerId());
        List<Long> customerIdList = Collections.singletonList(customerId);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIdList));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            logger.info("\u8be5\u7ba1\u63a7\u89c4\u5219\u5ba2\u6237{}\u4e0d\u5b58\u5728", (Object)customerId);
            return RestResponse.VOID;
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        List itemIdList = orderReqDto.getOrderItems().stream().map(tradeItemReqDto -> ParamConverter.convertToLong((Object)tradeItemReqDto.getItemSerial())).collect(Collectors.toList());
        Map itemIdToMap = orderReqDto.getOrderItems().stream().collect(Collectors.toMap(tradeItemReqDto -> ParamConverter.convertToLong((Object)tradeItemReqDto.getItemSerial()), Function.identity(), (old, now) -> old));
        CustomerControlInventoryReqDto reqDto = new CustomerControlInventoryReqDto();
        reqDto.setCustomerId(ParamConverter.convertToLong((Object)orderReqDto.getCustomerId()));
        reqDto.setItemIdList(itemIdList);
        reqDto.setOrgId(orgId);
        List areaCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes(areaCodeList);
            List parentAreaCodeList = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto));
            if (CollectionUtils.isNotEmpty((Collection)parentAreaCodeList)) {
                parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
                reqDto.setCustomerAreaCodeList(parentAreaCodeList);
            }
        }
        logger.info("\u67e5\u8be2\u5ba2\u6237\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u89c4\u5219\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        List controlInventoryItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.controlInventoryQueryApi.queryRuleByCustomerNew(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)controlInventoryItemRespDtos)) {
            Map itemIdMap = controlInventoryItemRespDtos.stream().collect(Collectors.toMap(ControlInventoryItemRespDto::getItemId, Function.identity(), (old, now) -> old));
            for (Long itemId : itemIdList) {
                Double available;
                ControlInventoryItemRespDto controlInventoryItemRespDto = (ControlInventoryItemRespDto)itemIdMap.get(itemId);
                TradeItemReqDto tradeItemReqDto2 = (TradeItemReqDto)itemIdToMap.get(itemId);
                if (null == controlInventoryItemRespDto) continue;
                TcbjAvilableReqDto tcbjAvilableReqDto = new TcbjAvilableReqDto();
                tcbjAvilableReqDto.setWarehouseCode(orderReqDto.getWarehouseCode());
                tcbjAvilableReqDto.setCargoCode(tradeItemReqDto2.getSkuCode());
                TcbjAvilableReqDto sonTcbjAvilableReqDto = new TcbjAvilableReqDto();
                sonTcbjAvilableReqDto.setCargoCode(tradeItemReqDto2.getSkuCode());
                sonTcbjAvilableReqDto.setWarehouseCode(orderReqDto.getWarehouseCode());
                tcbjAvilableReqDto.setList(Collections.singletonList(sonTcbjAvilableReqDto));
                logger.info("\u7ec4\u88c5\u7684\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u7684\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)tcbjAvilableReqDto));
                List tcbjAvilableRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.inventoryApi.avilableYingXiaoYun(tcbjAvilableReqDto));
                logger.info("\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u7684\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)tcbjAvilableRespDtos));
                if (!CollectionUtils.isNotEmpty((Collection)tcbjAvilableRespDtos) || Double.valueOf((available = ((TcbjAvilableRespDto)tcbjAvilableRespDtos.get(0)).getAvailable()) - (double)controlInventoryItemRespDto.getFloorInventoryCount().intValue()).compareTo((double)tradeItemReqDto2.getItemNum()) >= 0) continue;
                return new RestResponse(ControlTypeExcpCodeEnum.CONTROL_STORAGE_FAIL.getErrorCode(), String.format("\u8be5\u8ba2\u5355\u8d2d\u4e70\u7684\u5546\u54c1%s\u53d7\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\uff0c\u7ba1\u63a7\u89c4\u5219id\u4e3a%d, \u53d7\u7ba1\u63a7\u5546\u54c1\u7f16\u7801\u4e3a%s, \u8be5\u5546\u54c1\u7684\u53ef\u7528\u5e93\u5b58\u4e3a%f, \u7ba1\u63a7\u89c4\u5219\u8bbe\u7f6e\u7684\u5b89\u5168\u5e93\u5b58\u4e3a%d, \u8d2d\u4e70\u7684\u5546\u54c1\u6570\u91cf\u4e3a%d", tradeItemReqDto2.getItemName(), controlInventoryItemRespDto.getRuleId(), controlInventoryItemRespDto.getItemCode(), available, controlInventoryItemRespDto.getFloorInventoryCount(), tradeItemReqDto2.getItemNum()));
            }
        }
        return RestResponse.VOID;
    }

    private void updateCustomerInventory(Map<Long, OrderItemBaseReqDto> itemIdToMap, List<ControlItemCustomerRespDto> controlItemCustomerRespDtos, String tradeNo) {
        ArrayList controlItemOrderReqDtos = Lists.newArrayList();
        controlItemCustomerRespDtos.forEach(controlItemCustomerRespDto -> {
            OrderItemBaseReqDto tradeItemReqDto = (OrderItemBaseReqDto)itemIdToMap.get(controlItemCustomerRespDto.getItemId());
            logger.info("\u63d0\u4ea4\u8ba2\u5355\u66f4\u65b0\u5355\u54c1\u7ba1\u63a7\u6307\u5b9a\u5ba2\u6237\u5165\u53c2:itemNum={},id={}", (Object)tradeItemReqDto.getItemNum(), (Object)controlItemCustomerRespDto.getId());
            Integer update = (Integer)RestResponseHelper.extractData((RestResponse)this.controlItemCustomerApi.modifyPurchasedCount(tradeItemReqDto.getItemNum(), controlItemCustomerRespDto.getId()));
            if (null == update) {
                Integer purchasedCount = controlItemCustomerRespDto.getPurchasedCount() == null ? 0 : controlItemCustomerRespDto.getPurchasedCount();
                throw new BizException(String.format("\u8be5\u8ba2\u5355\u8d2d\u4e70\u7684\u5546\u54c1%s\u8d85\u8fc7\u5355\u54c1\u7ba1\u63a7\u7684\u9650\u8d2d\u91cf\uff0c\u9650\u8d2d\u91cf\u4e3a%d,\u5f53\u524d\u7d2f\u8ba1\u8d2d\u4e70\u6570\u91cf%d,\u672c\u6b21\u8d2d\u4e70\u6570\u91cf%d", tradeItemReqDto.getItemCode(), controlItemCustomerRespDto.getLimitCount(), purchasedCount, tradeItemReqDto.getItemNum()));
            }
            ControlItemOrderReqDto addROrder = new ControlItemOrderReqDto();
            addROrder.setTradeNo(tradeNo);
            addROrder.setRuleItemId(controlItemCustomerRespDto.getId());
            addROrder.setItemNum(new BigDecimal(tradeItemReqDto.getItemNum()));
            addROrder.setRuleRangeType("appoint");
            controlItemOrderReqDtos.add(addROrder);
        });
        this.controlItemOrderApi.addControlItemOrderBatch((List)controlItemOrderReqDtos);
    }

    private void buildInsertItemCustomerReqDtos(Map<Long, OrderItemBaseReqDto> itemIdToMap, Long customerId, CustomerRespDto customerRespDto, List<ControlItemAreaRespDto> controlItemAreaRespDtos, List<ControlItemCustomerReqDto> insertControlItemCustomerReqDtos, String tradeNo) {
        insertControlItemCustomerReqDtos.addAll(controlItemAreaRespDtos.stream().map(controlItemAreaRespDto -> {
            OrderItemBaseReqDto tradeItemReqDto = (OrderItemBaseReqDto)itemIdToMap.get(controlItemAreaRespDto.getItemId());
            ControlItemCustomerReqDto controlItemCustomerReqDto = new ControlItemCustomerReqDto();
            controlItemCustomerReqDto.setItemId(controlItemAreaRespDto.getItemId());
            controlItemCustomerReqDto.setItemCode(controlItemAreaRespDto.getItemCode());
            controlItemCustomerReqDto.setItemName(controlItemAreaRespDto.getItemName());
            controlItemCustomerReqDto.setItemUnit(controlItemAreaRespDto.getItemUnit());
            controlItemCustomerReqDto.setSubType(controlItemAreaRespDto.getSubType());
            controlItemCustomerReqDto.setCustomerId(customerId);
            controlItemCustomerReqDto.setCustomerName(customerRespDto.getName());
            controlItemCustomerReqDto.setCustomerCode(customerRespDto.getCode());
            controlItemCustomerReqDto.setAreaCode(controlItemAreaRespDto.getAreaCode());
            controlItemCustomerReqDto.setCalculateType(controlItemAreaRespDto.getCalculateType());
            controlItemCustomerReqDto.setLimitContent(controlItemAreaRespDto.getLimitContent());
            controlItemCustomerReqDto.setEnableArea(YesNoEnum.YES.getValue());
            controlItemCustomerReqDto.setLimitCount(controlItemAreaRespDto.getLimitCount());
            controlItemCustomerReqDto.setPurchasedCount(tradeItemReqDto.getItemNum());
            controlItemCustomerReqDto.setRuleId(controlItemAreaRespDto.getRuleId());
            controlItemCustomerReqDto.setTradeNo(tradeNo);
            return controlItemCustomerReqDto;
        }).collect(Collectors.toList()));
    }
}

