/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.pay;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.ITransactionApi;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.tran.PayRespDto;
import com.dtyunxi.yundt.cube.center.account.api.exception.AccountExceptionCode;
import com.dtyunxi.yundt.cube.center.account.api.query.IAccountQueryApi;
import com.dtyunxi.yundt.cube.center.account.api.util.DateTimeUtils;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.dto.request.AccountPayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AddPayRecordReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.TradePayRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.PlaceTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ResultCodeEnum;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="accountPayPayHelp")
public class AccountPayPayHelp
extends AbstractPayHelp<TradePayRespDto> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ITransactionApi transactionApi;
    @Resource
    private IAccountQueryApi iAccountQueryApi;
    @Resource
    private ICacheService cacheService;
    @Autowired
    private IContext iContext;
    private static final String PAY_RECHARGEBACK = "PAY_RECHARGEBACK";
    private static final Integer LAST_PAY_NUM = 5;
    private static final Integer LIMIT_PAY_TIME = 10;
    private static final Integer CACHE_LIVE_SECOND = 600;
    private static final String PAY_NOTIFY = "\u652f\u4ed8\u5bc6\u7801\u9519\u8bef\u5df2\u8fbe%s\u6b21,\u8bf7\u70b9\u51fb\u5fd8\u8bb0\u5bc6\u7801\u6216%s\u5206\u949f\u540e\u91cd\u8bd5!";
    private static final String PAY_FAIL_PRE_NUM = "CUSTOMER_AMOUNT_PAY_NUM_FAIl";
    private static final String PAY_FAIL_WAIT_TIME = "CUSTOMER_AMOUNT_PAY_WAIT_TIME";
    private static final String PAY_METH = "PAY";
    private static final String REFUND_PAY_METH = "REFUND";
    private final TradePayRespDto tradePayRespDto = null;
    private boolean prePaySuccess = false;

    @Override
    protected SimplePayReqDto buildResult(SimplePayReqDto request) {
        return request;
    }

    @Override
    public void buildOrderRecord(SimplePayReqDto simplePayReqDto, AddPayRecordReqDto addPayRecordReqDto) {
        addPayRecordReqDto.setAccount("\u5e73\u53f0\u6536\u6b3e");
        addPayRecordReqDto.setStorePayAmount(addPayRecordReqDto.getPayAmount());
    }

    @Override
    public SimplePayReqDto map2Bean(Map<String, Object> request) {
        String re = JSON.toJSONString(request);
        SimplePayReqDto simplePayReqDto = (SimplePayReqDto)JSON.parseObject((String)re, SimplePayReqDto.class);
        AccountPayReqDto accountPayReqDto = (AccountPayReqDto)JSON.parseObject((String)re, AccountPayReqDto.class);
        simplePayReqDto.setAccountPayReqDto(accountPayReqDto);
        return simplePayReqDto;
    }

    @Override
    protected void error(Exception e) {
    }

    @Override
    public void customerCheck(SimplePayReqDto simplePayReqDto) {
        AccountPayReqDto request = simplePayReqDto.getAccountPayReqDto();
        TradePayRespDto tradePayRespDto = new TradePayRespDto();
        Long accountId = request.getAccountId();
        if (accountId == null) {
            tradePayRespDto.setResultCode(ResultCodeEnum.NOT_FOUND.getCode());
            tradePayRespDto.setResultMsg(ResultCodeEnum.NOT_FOUND.getName());
            throw new BizException(AccountExceptionCode.ACC_NOT_EXISTS.getCode(), AccountExceptionCode.ACC_NOT_EXISTS.getMsg());
        }
        boolean needCheckPassword = PlaceTypeEnum.CUSTOMER.getCode().equals(Integer.valueOf(request.getPlaceType()));
        Integer num = 0;
        Date date = new Date();
        if (needCheckPassword) {
            num = (Integer)this.cacheService.getCache(PAY_FAIL_PRE_NUM + accountId, Integer.class);
            Date waitTime = (Date)this.cacheService.getCache(PAY_FAIL_WAIT_TIME + accountId, Date.class);
            if (waitTime != null && waitTime.after(date)) {
                System.out.println("--------------------------------------" + DateTimeUtils.convertDateTimeToString((Date)date) + "\u60a8\u91cd\u8bd5\u6b21\u6570\u5df2\u8d85\u9650," + DateTimeUtils.convertDateTimeToString((Date)waitTime) + "\u5185\u7981\u6b62\u91cd\u8bd5,\u5df2\u91cd\u8bd5" + num + "\u6b21");
                tradePayRespDto.setResultCode(ResultCodeEnum.PASSWORD_SUBMIT.getCode());
                int dateDifference = DateTimeUtils.getDateDifference((Date)date, (Date)waitTime);
                tradePayRespDto.setResultMsg(String.format(PAY_NOTIFY, LAST_PAY_NUM, (int)Math.ceil((double)dateDifference / 60.0)));
                this.cacheService.setCache(PAY_FAIL_PRE_NUM + accountId, (Object)0, 600);
                throw new BizException(AccountExceptionCode.ACC_PWD_CHECK_ERROR.getCode(), AccountExceptionCode.ACC_PWD_CHECK_ERROR.getMsg());
            }
            RestResponse booleanRestResponse = this.iAccountQueryApi.checkPassword(accountId, request.getPassword());
            Boolean aBoolean = (Boolean)RestResponseHelper.extractData((RestResponse)booleanRestResponse);
            if (!aBoolean.booleanValue()) {
                tradePayRespDto.setResultCode(ResultCodeEnum.PASSWORD_ERROR.getCode());
                tradePayRespDto.setResultMsg(ResultCodeEnum.PASSWORD_ERROR.getName());
                boolean isFirst = num == null;
                num = isFirst ? 1 : num + 1;
                if (num >= LAST_PAY_NUM) {
                    Date limitTime = DateTimeUtils.addAndSubMin((Date)date, (int)LIMIT_PAY_TIME);
                    int dateDifference = DateTimeUtils.getDateDifference((Date)date, (Date)limitTime);
                    tradePayRespDto.setResultMsg(String.format(PAY_NOTIFY, LAST_PAY_NUM, (int)Math.ceil((double)dateDifference / 60.0)));
                    System.out.println("--------------------------------------" + DateTimeUtils.convertDateTimeToString((Date)date) + "\u91cd\u8bd5\u5931\u8d25\u5927\u4e8e\u7b49\u4e8e5\u6b21,\u6d4b\u8bd5\u8d85\u9650,\u4e0b\u6b21\u91cd\u8bd5\u65f6\u95f4\u4e3a" + LIMIT_PAY_TIME + "\u5206\u949f\u540e-" + DateTimeUtils.convertDateTimeToString((Date)limitTime));
                    this.cacheService.setCache(PAY_FAIL_WAIT_TIME + accountId, (Object)limitTime, CACHE_LIVE_SECOND.intValue());
                    this.cacheService.setCache(PAY_FAIL_PRE_NUM + accountId, (Object)0, CACHE_LIVE_SECOND.intValue());
                } else {
                    this.cacheService.setCache(PAY_FAIL_PRE_NUM + accountId, (Object)num, CACHE_LIVE_SECOND.intValue());
                    System.out.println("--------------------------------------" + DateTimeUtils.convertDateTimeToString((Date)date) + "\u5bc6\u7801\u9519\u8bef,\u5df2\u91cd\u8bd5" + num + "\u6b21");
                }
                throw new BizException(AccountExceptionCode.ACC_PWD_CHECK_ERROR.getCode(), AccountExceptionCode.ACC_PWD_CHECK_ERROR.getMsg());
            }
            this.cacheService.setCache(PAY_FAIL_PRE_NUM + accountId, (Object)0, CACHE_LIVE_SECOND.intValue());
        }
        request.setTradePayRespDto(tradePayRespDto);
    }

    @Override
    public SimplePayReqDto initParam(Object ... objects) {
        SimplePayReqDto basePayReqDto = new SimplePayReqDto();
        AccountPayReqDto accountPayReqDto = new AccountPayReqDto();
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)accountPayReqDto);
        }
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)basePayReqDto);
        }
        this.logger.info("\u521d\u59cb\u8d26\u53f7\u652f\u4ed8\u53c2\u6570[{}]", (Object)JSON.toJSONString((Object)accountPayReqDto));
        basePayReqDto.setAccountPayReqDto(accountPayReqDto);
        return basePayReqDto;
    }

    @Override
    public void errorCallBack(SimplePayReqDto simplePayReqDto) {
        if (!this.isPrePayed(simplePayReqDto)) {
            return;
        }
        AccountPayReqDto accountPayReqDto = simplePayReqDto.getAccountPayReqDto();
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("payType", PAY_RECHARGEBACK);
        request.put("tradeId", simplePayReqDto.getOrderNo());
        request.put("tranAmt", simplePayReqDto.getPayAmount());
        request.put("userId", simplePayReqDto.getCustomerId());
        request.put("instanceId", this.iContext.instanceId());
        request.put("tenantId", this.iContext.tenantId());
        request.put("accountId", accountPayReqDto.getAccountId());
        this.logger.info("\u8ba2\u5355[{}]\u8d26\u53f7\u652f\u4ed8\u5f02\u5e38,\u89e3\u9664\u51bb\u7ed3[{}]", (Object)simplePayReqDto.getOrderNo(), (Object)simplePayReqDto.getPayAmount());
        try {
            RestResponse baseTranRespDtoRestResponse = this.transactionApi.modifyTransaction(PAY_METH, request);
            RestResponseHelper.extractData((RestResponse)baseTranRespDtoRestResponse);
        }
        catch (Exception e) {
            this.logger.error("\u8d26\u53f7\u652f\u4ed8\u5145\u6b63\u5f02\u5e38,\u539f\u56e0[{}]", (Object)e.getMessage());
        }
    }

    @Override
    public void successCallBackDefine(SimplePayReqDto simplePayReqDto) {
        AccountPayReqDto accountPayReqDto = simplePayReqDto.getAccountPayReqDto();
        Map<String, Object> request = this.buildRequest(simplePayReqDto, PAY_METH);
        try {
            RestResponse pay = this.transactionApi.doTransaction(PAY_METH, request);
            RestResponseHelper.extractData((RestResponse)pay);
            this.logger.info("\u8ba2\u5355[{}]\u8d26\u53f7\u652f\u4ed8\u6210\u529f\u51bb\u7ed3[{}]", (Object)simplePayReqDto.getOrderNo(), (Object)simplePayReqDto.getPayAmount());
            this.prePaySuccess = true;
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355[{}]\u8d26\u53f7\u652f\u4ed8\u5f02\u5e38,\u539f\u56e0:[{}]", (Object)simplePayReqDto.getOrderNo(), (Object)e.getMessage());
            e.printStackTrace();
            throw new BizException("\u8d26\u53f7\u652f\u4ed8\u5f02\u5e38,\u539f\u56e0 " + e.getMessage());
        }
        if (!StringUtils.isEmpty((CharSequence)simplePayReqDto.getOrderNo())) {
            this.addOrderPayRecord(simplePayReqDto);
        }
        request.put("payType", PAY_METH);
        request.put("tradeId", simplePayReqDto.getOrderNo());
        request.put("tranAmt", simplePayReqDto.getPayAmount());
        request.put("userId", simplePayReqDto.getCustomerId());
        request.put("instanceId", this.iContext.instanceId());
        request.put("tenantId", this.iContext.tenantId());
        try {
            RestResponse baseTranRespDtoRestResponse = this.transactionApi.modifyTransaction(PAY_METH, request);
            RestResponseHelper.extractData((RestResponse)baseTranRespDtoRestResponse);
            this.logger.info("\u8ba2\u5355[{}]\u8d26\u53f7\u652f\u4ed8\u6210\u529f\u652f\u4ed8[{}]", (Object)simplePayReqDto.getOrderNo(), (Object)simplePayReqDto.getPayAmount());
        }
        catch (Exception e) {
            this.logger.error("\u8d26\u53f7\u652f\u4ed8\u4e8c\u6b21\u786e\u8ba4\u5f02\u5e38,\u539f\u56e0[{}]", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public boolean allowSubmitOrder(SimplePayReqDto request) {
        return true;
    }

    @Override
    public boolean isPrePayed(SimplePayReqDto simplePayReqDto) {
        return this.prePaySuccess;
    }

    @Override
    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
        this.logger.info("\u8ba2\u5355[{}]\u8d26\u53f7\u9000\u6b3e,\u9000\u6b3e\u91d1\u989d[{}]", (Object)simplePayReqDto.getOrderNo(), (Object)simplePayReqDto.getPayAmount());
        Map<String, Object> request = this.buildRequest(simplePayReqDto, REFUND_PAY_METH);
        request.put("tranAmt", simplePayReqDto.getRefundAmount());
        request.put("tradeId", StringUtils.isEmpty((CharSequence)simplePayReqDto.getRefundNo()) ? simplePayReqDto.getAccountPayReqDto().getId() : simplePayReqDto.getRefundNo());
        this.logger.info("\u8ba2\u5355\u9000\u6b3e-\u8d26\u6237\u9000\u6b3e,\u8d26\u6237\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570[{}]", (Object)JSON.toJSONString(request));
        try {
            RestResponse pay = this.transactionApi.doTransaction(REFUND_PAY_METH, request);
            PayRespDto payRespDto = (PayRespDto)RestResponseHelper.extractData((RestResponse)pay);
            this.logger.info("\u8ba2\u5355\u9000\u6b3e-\u8d26\u6237\u9000\u6b3e,orderNo:[{}]\u6210\u529f\u8fd4\u56depayRespDto[{}]", (Object)simplePayReqDto.getOrderNo(), (Object)payRespDto);
            this.prePaySuccess = true;
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u9000\u6b3e-\u8d26\u6237\u9000\u6b3e,orderNo:[{}]\u8d26\u6237\u4e2d\u5fc3\u5f02\u5e38,\u4f59\u989d\u9000\u6b3e\u6210\u529f,\u539f\u56e0:[{}]", (Object)simplePayReqDto.getOrderNo(), (Object)e.getMessage());
            e.printStackTrace();
            throw new BizException("\u4f59\u989d\u9000\u6b3e\u5f02\u5e38,\u539f\u56e0 " + e.getMessage());
        }
    }

    private Map<String, Object> buildRequest(SimplePayReqDto simplePayReqDto, String refundPayMeth) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("payType", refundPayMeth);
        request.put("tradeId", simplePayReqDto.getOrderNo());
        request.put("userId", simplePayReqDto.getCustomerId());
        request.put("instanceId", this.iContext.instanceId());
        request.put("tenantId", this.iContext.tenantId());
        AccountPayReqDto accountPayReqDto = simplePayReqDto.getAccountPayReqDto();
        request.put("accountId", accountPayReqDto.getAccountId());
        request.put("orderNo", simplePayReqDto.getOrderNo());
        request.put("userId", simplePayReqDto.getCustomerId());
        request.put("tenantId", this.iContext.tenantId());
        request.put("instanceId", this.iContext.instanceId());
        request.put("orderNo", simplePayReqDto.getOrderNo());
        return request;
    }
}

