/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemDetailReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemDetailInfoRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SkillOrderCacheReqDto;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ILocalCacheService;
import com.dtyunxi.yundt.module.trade.biz.util.KeyGenerator;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class LocalCacheServiceImpl
implements ILocalCacheService {
    private Cache<Object, Object> localCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;

    @Override
    public boolean isEmptyStock(Long activityId, Long skuId, Long shopId) {
        return this.get(this.getStockKey(activityId, skuId, shopId)) != null;
    }

    private void put(Object key, Object value) {
        this.localCache.put(key, value);
    }

    private void remove(Object key) {
        this.localCache.invalidate(key);
    }

    private <T> T get(Object key) {
        Object object = this.localCache.getIfPresent(key);
        if (object == null) {
            return null;
        }
        return (T)object;
    }

    private String getStockKey(Long activityId, Long skuId, Long shopId) {
        return KeyGenerator.getBySeparator("_", activityId, shopId, skuId);
    }

    private String getOrderItemKey(Long activityId, Long skuId) {
        return activityId + "_item:" + skuId;
    }

    private String getActivityPriceKey(Long activityId, Long skuId, Long shopId) {
        return activityId + "_price:" + skuId + "_" + shopId;
    }

    public void getItemSkuInfo() {
    }

    @Override
    public void setStockToEmpty(Long activityId, Long skuId, Long shopId) {
        this.put(this.getStockKey(activityId, skuId, shopId), "0");
    }

    @Override
    public void removeStockEmptyFlag(Long activityId, Long skuId, Long shopId) {
        this.remove(this.getStockKey(activityId, skuId, shopId));
    }

    @Override
    public void setActivityOrderItem(Long activityId, Long skuId, SkillOrderCacheReqDto tradeItemReqDto) {
        this.put(this.getOrderItemKey(activityId, skuId), tradeItemReqDto);
    }

    @Override
    public SkillOrderCacheReqDto getActivityOrderItem(Long activityId, Long skuId) {
        return (SkillOrderCacheReqDto)this.get(this.getOrderItemKey(activityId, skuId));
    }

    @Override
    public BigDecimal getActivityPrice(Long activityId, Long skuId, Long shopId) {
        return (BigDecimal)this.get(this.getActivityPriceKey(activityId, skuId, shopId));
    }

    @Override
    public void setActivityPrice(Long activityId, Long skuId, Long shopId, BigDecimal price) {
        this.put(this.getActivityPriceKey(activityId, skuId, shopId), price);
    }

    @Override
    public boolean isValid(Long activityId) {
        Boolean valid = (Boolean)this.get(activityId);
        return valid == null ? true : valid;
    }

    @Override
    public void invalid(Long activityId) {
        this.localCache.put((Object)activityId, (Object)new Boolean(false));
    }

    @Override
    public ItemRespDto getItemRespDto(Long itemId, Long skuId) {
        String cacheKey = this.getItemRespDtoKey(itemId, skuId);
        ItemRespDto itemRespDto = (ItemRespDto)this.get(cacheKey);
        if (itemRespDto == null && null != (itemRespDto = (ItemRespDto)this.itemQueryApi.queryItemAndSku(itemId, skuId).getData())) {
            this.put(cacheKey, itemRespDto);
        }
        return itemRespDto;
    }

    private String getItemRespDtoKey(Long itemId, Long skuId) {
        return itemId + skuId.toString();
    }

    @Override
    public void setItemRespDto(Long itemId, Long skuId, ItemRespDto item) {
        this.localCache.put((Object)this.getItemRespDtoKey(itemId, skuId), (Object)item);
    }

    @Override
    public void addItem(String cacheKey, ItemDetailInfoRespDto itemDetailInfoRespDto) {
        this.localCache.put((Object)cacheKey, (Object)itemDetailInfoRespDto);
    }

    @Override
    public ItemDetailInfoRespDto getItem(String cacheKey) {
        return (ItemDetailInfoRespDto)this.get(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShopDto getShopInfo(Long shopId) {
        String cacheKey = "shop_detail_local_cache" + shopId;
        ShopDto shopDto = null;
        shopDto = (ShopDto)this.get(cacheKey);
        if (null == shopDto) {
            String string = cacheKey;
            synchronized (string) {
                shopDto = (ShopDto)this.get(cacheKey);
                if (null == shopDto) {
                    shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
                    if (null == shopDto || null == shopDto.getId()) {
                        BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOP_NOT_EXIST);
                    }
                    this.put(cacheKey, shopDto);
                }
            }
        }
        return shopDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemDetailRespDto getItemDetailInfo(Long itemId) {
        String cacheKey = "item_local_cache" + itemId;
        ItemDetailRespDto data = null;
        data = (ItemDetailRespDto)this.get(cacheKey);
        if (null == data) {
            String string = cacheKey;
            synchronized (string) {
                data = (ItemDetailRespDto)this.get(cacheKey);
                if (null == data) {
                    data = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(itemId, "attributes,sku,medias", null).getData();
                    if (data == null) {
                        BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
                    }
                    this.put(cacheKey, data);
                }
            }
        }
        return data;
    }

    @Override
    public List<ItemDetailRespDto> getItemDetailInfos(List<Long> itemIds, Long shopId) {
        ArrayList itemDetailRespDtos = Lists.newArrayList();
        ArrayList cacheNonExists = Lists.newArrayList();
        for (Long itemId : itemIds) {
            String cacheKey = "item_local_cache" + itemId + shopId;
            ItemDetailRespDto data = (ItemDetailRespDto)this.get(cacheKey);
            if (null == data) {
                cacheNonExists.add(itemId);
                continue;
            }
            itemDetailRespDtos.add(data);
        }
        if (CollectionUtils.isNotEmpty((Collection)cacheNonExists)) {
            ItemDetailReqDto itemDetailReqDto = new ItemDetailReqDto();
            itemDetailReqDto.setItemIds(itemIds);
            itemDetailReqDto.setFields(Arrays.asList("attributes", "sku", "medias"));
            itemDetailReqDto.setShopId(shopId);
            List itemDetailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.listItemDetail(itemDetailReqDto));
            Map<Long, ItemDetailRespDto> detailRespDtoMap = itemDetailRespDtoList.stream().collect(Collectors.toMap(e -> e.getItem().getId(), e -> e, (e1, e2) -> e1));
            for (Long itemId : cacheNonExists) {
                String cacheKey = "item_local_cache" + itemId + shopId;
                ItemDetailRespDto itemDetailRespDto = detailRespDtoMap.get(itemId);
                if (itemDetailRespDto == null) {
                    BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
                }
                this.put(cacheKey, itemDetailRespDto);
                itemDetailRespDtos.add(itemDetailRespDto);
            }
        }
        return itemDetailRespDtos;
    }

    @Override
    public void invalidItem(Long itemId, Long skuId) {
        this.localCache.put((Object)this.getInvalidItemKey(itemId, skuId), (Object)true);
    }

    private String getInvalidItemKey(Long itemId, Long skuId) {
        return "invalid" + itemId + skuId;
    }

    @Override
    public boolean isValidItem(Long itemId, Long skuId) {
        Boolean valid = (Boolean)this.localCache.getIfPresent((Object)this.getInvalidItemKey(itemId, skuId));
        return valid == null ? true : valid;
    }
}

