/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.util;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedisLockUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedisLockUtil.class);
    @Resource
    private ICacheService cacheService;

    public String tryGetLock(String lockKey, int expireTime) {
        String lockValue = UUID.randomUUID().toString();
        logger.info("\u5c1d\u8bd5\u83b7\u53d6\u5206\u5e03\u5f0f\u9501 lockKey={}, lockValue={}, expireTime={}", new Object[]{lockKey, lockValue, expireTime});
        boolean success = this.cacheService.add(lockKey, (Object)lockValue, expireTime);
        if (success) {
            logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f lockKey={}, lockValue={}, expireTime={}", new Object[]{lockKey, lockValue, expireTime});
        } else {
            logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lockKey={}, lockValue={}, expireTime={}", new Object[]{lockKey, lockValue, expireTime});
            String lockValueOcc = (String)this.cacheService.getCache(lockKey, String.class);
            long expireTimeOcc = this.cacheService.getToLiveTime(lockKey);
            logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5df2\u88ab\u5360\u7528 lockKey={}, lockValue={}, expireTime={}", new Object[]{lockKey, lockValueOcc, expireTimeOcc});
        }
        return success ? lockValue : null;
    }

    public String tryGetLock(String lockKey) {
        return this.tryGetLock(lockKey, 60);
    }

    public boolean releaseLock(String lockKey, String lockValue) {
        try {
            logger.info("\u5c1d\u8bd5\u91ca\u653e\u5206\u5e03\u5f0f\u9501 lockKey={}, lockValue={}", (Object)lockKey, (Object)lockValue);
            String currentValue = (String)this.cacheService.getCache(lockKey, String.class);
            if (currentValue == null) {
                logger.info("\u5206\u5e03\u5f0f\u9501\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u91ca\u653e lockKey={}, lockValue={}", (Object)lockKey, (Object)lockValue);
                return true;
            }
            if (lockValue.equals(currentValue)) {
                this.cacheService.delCache(lockKey);
                logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u6210\u529f lockKey={}, lockValue={}, currentValue={}", new Object[]{lockKey, lockValue, currentValue});
                return true;
            }
            logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0clockValue\u4e0d\u5339\u914d lockKey={}, lockValue={}, currentValue={}", new Object[]{lockKey, lockValue, currentValue});
            return false;
        }
        catch (Exception e) {
            logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5f02\u5e38 lockKey={}, lockValue={}", (Object)lockKey, (Object)lockValue);
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        RedisLockUtil redisLockUtil = new RedisLockUtil();
        String lockKey = "order-audit:\u8ba2\u5355\u53f7";
        String lockValue = redisLockUtil.tryGetLock(lockKey, 60);
        if (lockValue == null) {
            throw new BizException("\u8ba2\u5355\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u9891\u7e41\u70b9\u51fb...");
        }
        redisLockUtil.releaseLock(lockKey, lockValue);
    }
}

